/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.stylex.BarChartStyleModel;
import oracle.mapviewer.share.stylex.CollectionStyleModel;
import oracle.mapviewer.share.stylex.PieChartStyleModel;
import oracle.mapviewer.share.stylex.VariablePieChartStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CasedLineHelper;
import oracle.sdovis.HeatMapRenderer;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.PDFTTFcache;
import oracle.sdovis.RSBundle;
import oracle.sdovis.Renderer;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.TextLabeler;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextStroke;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.BarChartStyle;
import oracle.sdovis.stylex.BarChartStyleModifiers;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.CollectionStyle;
import oracle.sdovis.stylex.ColorSchemeStyle;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.svg.SVGLabelHelper;
import oracle.sdovis.theme.ThemeUtils;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;
import oracle.sdovis.util.Util;
import oracle.xdo.generator.graphics2d.XDOGraphics2D;

public class VectorRenderer
implements Renderer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static double[] trys = new double[]{0.5, 0.33333, 0.66666, 0.18, 0.82};

    public void prepare(VisContext visContext) {
        Rectangle2D rectangle2D = visContext.getDeviceWindow();
        if (visContext.getCRArray() == null) {
            visContext.setCRArray(new RectArray(111));
        }
        if (visContext.getMarkerCRArray() == null) {
            visContext.setMarkerCRArray(new RectArray(111));
        }
        if (visContext.getRenderedMarkerCRArray() == null) {
            visContext.setRenderedMarkerCRArray(new RectArray(111));
        }
        if (visContext.renderRasterOnly() || !visContext.renderRasterBaseMapInSVG()) {
            visContext.getCRArray().freeAll();
            visContext.getMarkerCRArray().freeAll();
            visContext.getRenderedMarkerCRArray().freeAll();
        }
        if (visContext.getTextStroke() == null) {
            visContext.setTextStroke(new TextStroke(new Font("Serif", 0, 12), false, -1.0f, 0.2));
        }
        visContext.getTextStroke().setDeviceView(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void render(Graphics2D graphics2D, Theme theme, VisContext visContext) {
        if (visContext.isInterrupted()) {
            return;
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        boolean bl = visContext.getAntialiasing();
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        StyledFeatureI styledFeatureI = null;
        long l = System.currentTimeMillis();
        if (this.isHeatMapTheme(theme, visContext)) {
            HeatMapRenderer.renderHeatMap(graphics2D, theme, visContext);
        } else {
            visContext.enableMarkerSequence(theme.getDecorator().markerSequence);
            visContext.resetMarkerSequence();
            String string = theme.getDecorator().renderStyleName;
            Style style = null;
            if (string != null) {
                style = MapMaker.getStyleWithName(string, theme.getDataSourceName(), visContext);
            }
            NsDpHandler nsDpHandler = Theme.getNsdpHandler(visContext, theme.getDefinition().getName());
            for (int i = 0; i < theme.size(); ++i) {
                styledFeatureI = theme.getStyledFeature(i);
                if (styledFeatureI == null) continue;
                if (style != null) {
                    if (nsDpHandler == null) {
                        styledFeatureI.setFeatureStyle(style);
                    } else {
                        String string2 = styledFeatureI.getFeatureStyleName();
                        if (string2 == null || string.equalsIgnoreCase(string2)) {
                            styledFeatureI.setFeatureStyle(style);
                        }
                    }
                }
                if (!VectorRenderer.visible(styledFeatureI, visContext)) continue;
                if (!theme.getDecorator().isClickable()) {
                    VectorRenderer.renderStyledFeature(graphics2D, styledFeatureI, visContext);
                    continue;
                }
                try {
                    VectorRenderer.renderStyledFeature(null, styledFeatureI, visContext);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                visContext.addLiveFeature(styledFeatureI);
            }
        }
        long l2 = System.currentTimeMillis();
        log.finer("time to render theme " + theme.getName() + " with " + theme.size() + " styled features: " + (l2 - l) + "ms");
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void label(Graphics2D graphics2D, Theme theme, VisContext visContext) {
        if (visContext.isInterrupted()) {
            return;
        }
        if (theme.getDecorator().isClickable()) {
            return;
        }
        if (!theme.getDecorator().isRenderLabels()) {
            return;
        }
        if (this.isHeatMapTheme(theme, visContext)) {
            return;
        }
        visContext.setThemeWindowBuffer(theme.windowBuffer);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        boolean bl = visContext.getTextAntialiasing();
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        float[] fArray = new float[6];
        boolean bl2 = theme.getDecorator().noRepetitiveLabel;
        Hashtable<String, Integer> hashtable = null;
        Integer n = null;
        if (bl2) {
            hashtable = new Hashtable<String, Integer>();
            n = new Integer(1);
        }
        StyledFeatureI styledFeatureI = null;
        long l = System.currentTimeMillis();
        try {
            for (int i = 0; i < theme.size(); ++i) {
                int n2;
                String string;
                styledFeatureI = theme.getStyledFeature(i);
                if (styledFeatureI == null || (string = styledFeatureI.getLabel()) == null || string.length() == 0 || bl2 && hashtable.get(string) != null || !VectorRenderer.visible(styledFeatureI, visContext)) continue;
                for (n2 = 0; n2 < 6; ++n2) {
                    fArray[n2] = 0.0f;
                }
                try {
                    n2 = this.labelStyledFeature(graphics2D, styledFeatureI, fArray, theme.getDecorator().isLabelAlwaysOn(), bl2, theme.getDecorator().getUpsideDownLabels(), visContext) ? 1 : 0;
                    if (n2 == 0 || !bl2) continue;
                    hashtable.put(string, n);
                    continue;
                }
                catch (StyleNotApplicableException styleNotApplicableException) {
                    log.warning(styleNotApplicableException.getMessage());
                }
            }
            visContext.getCRArray().addAll(visContext.getRenderedMarkerCRArray());
            visContext.getRenderedMarkerCRArray().freeAll();
        }
        finally {
            if (bl2) {
                hashtable.clear();
                hashtable = null;
            }
        }
        long l2 = System.currentTimeMillis();
        log.finer("time to label theme " + theme.getName() + " with " + theme.size() + " styled features: " + (l2 - l) + "ms");
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public static boolean visible(StyledFeatureI styledFeatureI, VisContext visContext) {
        JSDOGeometry jSDOGeometry = styledFeatureI.getGeometry();
        if (jSDOGeometry == null) {
            return true;
        }
        Rectangle2D rectangle2D = visContext.getQueryWindow();
        if (rectangle2D == null) {
            return true;
        }
        double[] dArray = jSDOGeometry.getMBR();
        if (dArray == null) {
            return true;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (dArray.length == 4) {
            d = dArray[2] - dArray[0];
            d2 = dArray[3] - dArray[1];
        } else {
            d = dArray[3] - dArray[0];
            d2 = dArray[4] - dArray[1];
        }
        if (d == 0.0 || d2 == 0.0) {
            return true;
        }
        return rectangle2D.intersects(dArray[0], dArray[1], d, d2);
    }

    public static Point2D renderStyledFeature(Graphics2D graphics2D, StyledFeatureI styledFeatureI, VisContext visContext) {
        boolean bl;
        Point2D point2D = null;
        if (!styledFeatureI.hasRenderableShape()) {
            styledFeatureI.buildShapeFromGeometry(visContext.getAffineXF());
        }
        if (graphics2D == null) {
            return null;
        }
        Shape shape = null;
        Object var5_5 = null;
        Style style = null;
        int n = styledFeatureI.getGeomType();
        if (n == 1) {
            VectorRenderer.renderStyledPoint(graphics2D, styledFeatureI, visContext);
            return null;
        }
        shape = styledFeatureI.getShape();
        if (shape == null) {
            return null;
        }
        style = styledFeatureI.getFeatureStyle();
        if (style == null) {
            style = MapMaker.getStyleWithName(styledFeatureI.getFeatureStyleName(), styledFeatureI.getDataSource(), visContext);
        }
        if (style == null) {
            style = StyleFactory.getDefaultStyle(n);
        }
        if (!(bl = style.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles()))) {
            log.warning("cannot resolve referenced styles for style " + style.getModel().getName());
        }
        if (visContext.isPDFformatRequest()) {
            VectorRenderer.checkRegisterTTFforPDF(styledFeatureI.getFeatureStyleName(), style, styledFeatureI.getDataSource(), graphics2D);
        }
        if (n == 4) {
            VectorRenderer.renderStyledCollection(graphics2D, style, styledFeatureI, visContext);
        } else if (n == 5) {
            VectorRenderer.renderStyledMultiPoint(graphics2D, style, styledFeatureI, visContext);
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            double_.setFrame(visContext.getDeviceWindow().getMinX() - 10.0, visContext.getDeviceWindow().getMinY() - 10.0, visContext.getDeviceWindow().getWidth() + 20.0, visContext.getDeviceWindow().getHeight() + 20.0);
            if (n == 2 || n == 6) {
                if ((shape = ShapeUtil.clipLineString(double_, shape)) == null) {
                    return null;
                }
                if (!visContext.isTileRequest()) {
                    styledFeatureI.setShape(shape);
                }
            }
            if (n == 3 || n == 7) {
                // empty if block
            }
            try {
                if ((n == 2 || n == 6) && style instanceof StyleLine && ((StyleLine)style).supportCasedLine() && styledFeatureI.getRenderingRules() == null) {
                    CasedLineHelper casedLineHelper = visContext.getCasedLines();
                    casedLineHelper.addStyledFeature(styledFeatureI, shape, style);
                } else {
                    StyleModifiers styleModifiers = style.convertToPixelSize(visContext);
                    RenderingRule[] renderingRuleArray = styledFeatureI.getRenderingRules();
                    if ((visContext.isTileRequest() || visContext.isFOIRequest()) && (n == 3 || n == 7) && (style instanceof PieChartStyle || style instanceof BarChartStyle || style instanceof VariablePieChartStyle)) {
                        point2D = VectorRenderer.getChartPointForPolygon(style, visContext, styledFeatureI, shape);
                    }
                    if (renderingRuleArray == null) {
                        if (VectorRenderer.isNativeBucketStyle(style)) {
                            ((BucketStyle)style).applyDeferringCasedLines(graphics2D, shape, styledFeatureI.getGeomType(), null, null, visContext.getCRArray(), styledFeatureI.getRenderableAttributes(), styleModifiers, visContext, styledFeatureI);
                        } else {
                            style.apply(visContext, graphics2D, shape, styledFeatureI.getGeomType(), null, null, (ConflictResolver)visContext.getCRArray(), styledFeatureI.getRenderableAttributes(), styleModifiers);
                        }
                    } else {
                        VectorRenderer.applyFeatureRR(styledFeatureI, renderingRuleArray, shape, style, visContext, graphics2D, null, styleModifiers);
                    }
                }
            }
            catch (StyleNotApplicableException styleNotApplicableException) {
                log.warning(styleNotApplicableException.getMessage());
            }
        }
        if (visContext.isFOIRequest() && point2D != null) {
            try {
                point2D = visContext.getAffineXF().inverseTransform(point2D, null);
            }
            catch (Exception exception) {}
        } else {
            point2D = null;
        }
        return point2D;
    }

    private static void renderStyledCollection(Graphics2D graphics2D, Style style, StyledFeatureI styledFeatureI, VisContext visContext) {
        Cloneable cloneable;
        Point2D[] point2DArray;
        long l = System.currentTimeMillis();
        RenderingRule[] renderingRuleArray = styledFeatureI.getRenderingRules();
        try {
            if (style instanceof CollectionStyle) {
                if (renderingRuleArray != null) {
                    log.warning("Rendering rules are currently ignored for lines and polygons with collection style");
                }
                point2DArray = style.convertToPixelSize(visContext);
                GeneralPath generalPath = new GeneralPath();
                cloneable = new GeneralPath();
                ShapeUtil.extractLinesAndRings(styledFeatureI.getShape(), generalPath, (GeneralPath)cloneable);
                if (cloneable != null) {
                    style.apply(visContext, graphics2D, (Shape)((Object)cloneable), 3, null, null, null, styledFeatureI.getRenderableAttributes(), (StyleModifiers)point2DArray);
                }
                if (generalPath != null) {
                    style.apply(visContext, graphics2D, (Shape)generalPath, 2, null, null, null, styledFeatureI.getRenderableAttributes(), (StyleModifiers)point2DArray);
                }
            } else {
                point2DArray = style.convertToPixelSize(visContext);
                if (renderingRuleArray == null) {
                    style.apply(visContext, graphics2D, styledFeatureI.getShape(), styledFeatureI.getGeomType(), null, null, null, styledFeatureI.getRenderableAttributes(), (StyleModifiers)point2DArray);
                } else {
                    VectorRenderer.applyFeatureRR(styledFeatureI, renderingRuleArray, styledFeatureI.getShape(), style, visContext, graphics2D, null, (StyleModifiers)point2DArray);
                }
            }
        }
        catch (StyleNotApplicableException styleNotApplicableException) {
            log.warning(styleNotApplicableException.getMessage());
        }
        long l2 = System.currentTimeMillis();
        point2DArray = Util.getJavaPointsForGeometryCollection(styledFeatureI.getGeometry());
        if (point2DArray != null) {
            for (int i = 0; i < point2DArray.length; ++i) {
                cloneable = new StyledFeature();
                JSDOGeometry jSDOGeometry = new JSDOGeometry(point2DArray[i].getX(), point2DArray[i].getY(), 0);
                ((StyledFeature)cloneable).setGeometry(jSDOGeometry);
                ((StyledFeature)cloneable).setMarkerStyleOrientation(styledFeatureI.getMarkerStyleOrientation());
                ((StyledFeature)cloneable).setRenderableAttributes(styledFeatureI.getRenderableAttributes());
                ((StyledFeature)cloneable).setGeomType(1);
                ((StyledFeature)cloneable).setFeatureStyle(style);
                ((StyledFeature)cloneable).setRenderingRules(styledFeatureI.getRenderingRules());
                VectorRenderer.renderStyledPoint(graphics2D, (StyledFeatureI)((Object)cloneable), visContext);
            }
        }
        long l3 = System.currentTimeMillis();
        log.finer("non-point styled collection time: " + (l2 - l));
        log.finer("    point styled collection time: " + (l3 - l2));
    }

    private static void renderStyledMultiPoint(Graphics2D graphics2D, Style style, StyledFeatureI styledFeatureI, VisContext visContext) {
        int n;
        int[] nArray = styledFeatureI.getGeometry().getElemInfo();
        double[] dArray = styledFeatureI.getGeometry().getOrdinatesArray();
        float[] fArray = new float[6];
        PathIterator pathIterator = styledFeatureI.getShape().getPathIterator(null);
        int n2 = 0;
        Vector<Rectangle2D> vector = new Vector<Rectangle2D>();
        Vector<Boolean> vector2 = new Vector<Boolean>();
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            if (n3 == 0 || n3 == 1) {
                StyledFeature styledFeature = new StyledFeature();
                styledFeature.setPoint(new Point2D.Double(fArray[0], fArray[1]));
                styledFeature.setGeomType(1);
                styledFeature.setFeatureStyle(style);
                styledFeature.setFeatureStyleName(styledFeatureI.getFeatureStyleName());
                styledFeature.setMarkerStyleOrientation(styledFeatureI.getMarkerStyleOrientation());
                styledFeature.setRenderableAttributes(styledFeatureI.getRenderableAttributes());
                styledFeature.setRenderingRules(styledFeatureI.getRenderingRules());
                if (styledFeatureI.getGeometry().isOrientedMultiPoint()) {
                    n = nArray[n2 * 6 + 3] - 1;
                    double d = dArray[n];
                    double d2 = dArray[n + 1];
                    styledFeature.setMarkerStyleOrientation(Math.atan2(-d2, d));
                }
                VectorRenderer.renderStyledPoint(graphics2D, styledFeature, visContext);
                if (styledFeature.shpMBR != null) {
                    vector.add(styledFeature.shpMBR);
                    vector2.add(new Boolean(false));
                } else {
                    vector2.add(new Boolean(true));
                }
            }
            pathIterator.next();
            ++n2;
        }
        if (vector2.size() > 0) {
            Rectangle2D[] rectangle2DArray = new Rectangle2D[n2];
            int n4 = 0;
            for (n = 0; n < vector2.size(); ++n) {
                if (((Boolean)vector2.get(n)).booleanValue()) continue;
                rectangle2DArray[n] = (Rectangle2D)vector.get(n4);
                ++n4;
            }
            styledFeatureI.setMultiPointShapeMBRs(rectangle2DArray);
        }
    }

    public static Point2D getPointOfPointFeature(StyledFeatureI styledFeatureI, VisContext visContext) {
        Point2D point2D;
        if (!styledFeatureI.hasRenderableShape()) {
            styledFeatureI.buildShapeFromGeometry(visContext.getAffineXF());
        }
        if ((point2D = styledFeatureI.getPoint()) == null) {
            Shape shape = styledFeatureI.getShape();
            if (shape != null) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                point2D = new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
                styledFeatureI.setPoint(point2D);
                return point2D;
            }
            log.warning(RSBundle.getMsg("MAPVIEWER-01007"));
            return null;
        }
        return point2D;
    }

    private static void renderStyledPoint(Graphics2D graphics2D, StyledFeatureI styledFeatureI, VisContext visContext) {
        VectorRenderer.renderStyledPoint(graphics2D, styledFeatureI, visContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderStyledPoint(Graphics2D graphics2D, StyledFeatureI styledFeatureI, VisContext visContext, boolean bl) {
        int n;
        Point2D point2D = VectorRenderer.getPointOfPointFeature(styledFeatureI, visContext);
        if (point2D == null) {
            return;
        }
        Style style = null;
        if (graphics2D == null) {
            return;
        }
        style = styledFeatureI.getFeatureStyle();
        if (style == null) {
            style = MapMaker.getStyleWithName(styledFeatureI.getFeatureStyleName(), styledFeatureI.getDataSource(), visContext);
        }
        if (style == null) {
            style = StyleFactory.getDefaultStyle(1);
        }
        if (style != null) {
            n = style.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles()) ? 1 : 0;
            if (visContext.isPDFformatRequest()) {
                VectorRenderer.checkRegisterTTFforPDF(styledFeatureI.getFeatureStyleName(), style, styledFeatureI.getDataSource(), graphics2D);
            }
        }
        if (style instanceof CollectionStyle) {
            VectorRenderer.renderStyledPointWithCollectionStyle(graphics2D, styledFeatureI, visContext, style);
            return;
        }
        n = 9;
        int n2 = 9;
        try {
            StyleMarker styleMarker = (StyleMarker)style;
            VectorRenderer.drawMarkerOnPoint(graphics2D, styleMarker, styledFeatureI, point2D, visContext, n, n2, bl);
            if (styledFeatureI.getRadius() != null) {
                VectorRenderer.renderRadius(graphics2D, styledFeatureI, visContext);
            }
            return;
        }
        catch (ClassCastException classCastException) {
            try {
                StyleColor styleColor = (StyleColor)style;
                boolean bl2 = false;
                if (styleColor.getFillColor() != null && styleColor.getFillColor().getAlpha() != 0) {
                    bl2 = true;
                }
                if (styleColor.getStrokeColor() != null && styleColor.getStrokeColor().getAlpha() != 0) {
                    bl2 = true;
                }
                if (bl2) {
                    int n3 = (int)point2D.getX();
                    int n4 = (int)point2D.getY();
                    if (styleColor.getFillColor() != null) {
                        graphics2D.setColor(styleColor.getFillColor());
                    }
                    if (styleColor.getStrokeColor() != null) {
                        graphics2D.setColor(styleColor.getStrokeColor());
                    }
                    n = 6;
                    n2 = 6;
                    graphics2D.drawLine(n3 - 3, n4 - 3, n3 + 3, n4 + 3);
                    graphics2D.drawLine(n3 - 3, n4 + 3, n3 + 3, n4 - 3);
                    Rectangle2D.Float float_ = new Rectangle2D.Float(n3 - 3, n4 - 3, 6.0f, 6.0f);
                    visContext.getCRArray().insert(float_);
                    styledFeatureI.setShpMBR(float_);
                }
                if (styledFeatureI.getRadius() != null) {
                    VectorRenderer.renderRadius(graphics2D, styledFeatureI, visContext);
                }
                return;
            }
            catch (ClassCastException classCastException2) {
                try {
                    Cloneable cloneable;
                    block63: {
                        Object object;
                        Cloneable cloneable2;
                        Cloneable cloneable3;
                        BucketStyle bucketStyle = (BucketStyle)style;
                        int n5 = (int)point2D.getX();
                        int n6 = (int)point2D.getY();
                        StyleModifiers styleModifiers = bucketStyle.convertToPixelSize(visContext);
                        if (styledFeatureI.getMarkerStyleOrientation() != 0.0) {
                            boolean bl3 = false;
                            cloneable3 = bucketStyle.getDefaultStyle();
                            if (cloneable3 != null && cloneable3 instanceof StyleMarker) {
                                if (styleModifiers == null) {
                                    if (!bl3) {
                                        bucketStyle = (BucketStyle)bucketStyle.clone();
                                        bl3 = true;
                                        cloneable3 = bucketStyle.getDefaultStyle();
                                    }
                                    try {
                                        cloneable3 = (StyleMarker)((StyleMarker)cloneable3).clone();
                                        ((StyleMarker)cloneable3).setOrientation(styledFeatureI.getMarkerStyleOrientation());
                                        bucketStyle.setDefaultStyle((Style)cloneable3);
                                    }
                                    catch (Exception exception) {}
                                } else {
                                    StyleModifiers styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(bucketStyle.getDefaultStyleName().toUpperCase());
                                    if (styleModifiers2 != null && styleModifiers2 instanceof MarkerStyleModifiers) {
                                        ((MarkerStyleModifiers)styleModifiers2).setOrientationAngle(styledFeatureI.getMarkerStyleOrientation());
                                    }
                                }
                            }
                            int n7 = bucketStyle.getNumBuckets();
                            for (int i = 0; i < n7; ++i) {
                                cloneable2 = (Style)bucketStyle.getBucket(i).getRenderStyle();
                                if (cloneable2 == null || !(cloneable2 instanceof StyleMarker)) continue;
                                if (styleModifiers == null) {
                                    if (!bl3) {
                                        bucketStyle = (BucketStyle)bucketStyle.clone();
                                        bl3 = true;
                                        cloneable2 = (Style)bucketStyle.getBucket(i).getRenderStyle();
                                    }
                                    try {
                                        cloneable2 = (StyleMarker)((StyleMarker)cloneable2).clone();
                                    }
                                    catch (Exception exception) {
                                        continue;
                                    }
                                    ((StyleMarker)cloneable2).setOrientation(styledFeatureI.getMarkerStyleOrientation());
                                    bucketStyle.getBucket(i).setRenderStyle(cloneable2);
                                    continue;
                                }
                                object = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(bucketStyle.getBucket(i).getRenderStyleName().toUpperCase() + "_" + i);
                                if (object == null || !(object instanceof MarkerStyleModifiers)) continue;
                                ((MarkerStyleModifiers)object).setOrientationAngle(styledFeatureI.getMarkerStyleOrientation());
                            }
                        }
                        cloneable = new Rectangle2D.Float(n5 - 3, n6 - 3, 6.0f, 6.0f);
                        cloneable3 = new GeneralPath();
                        ((Path2D.Float)cloneable3).moveTo(n5 - 3, n6 - 3);
                        ((Path2D.Float)cloneable3).lineTo(n5 + 3, n6 + 3);
                        ((Path2D.Float)cloneable3).moveTo(n5 - 3, n6 + 3);
                        ((Path2D.Float)cloneable3).lineTo(n5 + 3, n6 - 3);
                        Point2D.Double double_ = null;
                        if (bucketStyle instanceof VariablePieChartStyle) {
                            double_ = new Point2D.Double(n5, n6);
                        }
                        try {
                            Object object2 = styledFeatureI.getRenderingRules();
                            if (object2 == null) {
                                bucketStyle.apply(visContext, graphics2D, (Shape)((Object)cloneable3), 2, null, (Point2D)double_, null, styledFeatureI.getRenderableAttributes(), styleModifiers);
                            } else {
                                VectorRenderer.applyFeatureRR(styledFeatureI, object2, (Shape)((Object)cloneable3), bucketStyle, visContext, graphics2D, double_, styleModifiers);
                            }
                            cloneable2 = VectorRenderer.getPointFeatureMbr(point2D, styledFeatureI, bucketStyle, object2, styleModifiers);
                            if (cloneable2 == null) break block63;
                            cloneable = cloneable2;
                        }
                        catch (Exception exception) {
                            log.warning(exception.getMessage());
                        }
                        finally {
                            Style style2 = bucketStyle.getDefaultStyle();
                            if (style2 != null && style2 instanceof StyleMarker) {
                                ((StyleMarker)style2).resetOrientation();
                            }
                            for (int i = 0; i < bucketStyle.getNumBuckets(); ++i) {
                                object = (Style)bucketStyle.getBucket(i).getRenderStyle();
                                if (object == null || !(object instanceof StyleMarker)) continue;
                                ((StyleMarker)object).resetOrientation();
                            }
                        }
                    }
                    visContext.getCRArray().insert((Rectangle2D)cloneable);
                    styledFeatureI.setShpMBR((Rectangle2D)cloneable);
                    return;
                }
                catch (ClassCastException classCastException3) {
                    Object object;
                    RenderingRule[] renderingRuleArray = styledFeatureI.getRenderingRules();
                    String[] stringArray = null;
                    if (renderingRuleArray != null) {
                        for (int i = 0; i < renderingRuleArray.length; ++i) {
                            object = renderingRuleArray[i].getStyleName();
                            if (object == null || !((String)object).equalsIgnoreCase(styledFeatureI.getFeatureStyleName())) continue;
                            stringArray = renderingRuleArray[i].getStyleColumns();
                            break;
                        }
                    }
                    try {
                        int n8;
                        PieChartStyle pieChartStyle = (PieChartStyle)style;
                        object = pieChartStyle.convertToPixelSize(visContext);
                        Point2D point2D2 = null;
                        point2D2 = styledFeatureI.getPoint();
                        try {
                            pieChartStyle.apply(visContext, graphics2D, styledFeatureI.getShape(), styledFeatureI.getGeomType(), null, point2D2, null, styledFeatureI.getRenderableAttributes(), stringArray, (StyleModifiers)object);
                        }
                        catch (Exception exception) {
                            log.warning(exception.getMessage());
                        }
                        int n9 = (int)point2D2.getX();
                        int n10 = (int)point2D2.getY();
                        int n11 = n8 = (int)((double)pieChartStyle.getPieRadius() * 2.5);
                        if (object != null && object instanceof PieChartStyleModifiers) {
                            n11 = n8 = (int)((double)((PieChartStyleModifiers)object).getPieRadius() * 2.5);
                        }
                        Rectangle2D.Float float_ = new Rectangle2D.Float(n9 - n8 / 2, n10 - n11 / 2, n8, n11);
                        visContext.getCRArray().insert(float_);
                        styledFeatureI.setShpMBR(float_);
                        return;
                    }
                    catch (ClassCastException classCastException4) {
                        try {
                            BarChartStyle barChartStyle = (BarChartStyle)style;
                            object = barChartStyle.convertToPixelSize(visContext);
                            Point2D point2D3 = null;
                            point2D3 = styledFeatureI.getPoint();
                            try {
                                barChartStyle.apply(visContext, graphics2D, styledFeatureI.getShape(), styledFeatureI.getGeomType(), null, point2D3, null, styledFeatureI.getRenderableAttributes(), stringArray, (StyleModifiers)object);
                            }
                            catch (Exception exception) {
                                log.warning(exception.getMessage());
                            }
                            int n12 = (int)point2D3.getX();
                            int n13 = (int)point2D3.getY();
                            int n14 = ((BarChartStyleModel)barChartStyle.getModel()).getWidth();
                            int n15 = ((BarChartStyleModel)barChartStyle.getModel()).getHeight();
                            if (object != null && object instanceof BarChartStyleModifiers) {
                                n14 = ((BarChartStyleModifiers)object).getBarWidth();
                                n15 = ((BarChartStyleModifiers)object).getBarHeight();
                            }
                            Rectangle2D.Float float_ = new Rectangle2D.Float(n12 - n14 / 2, n13 - n15 / 2, n14, n15);
                            visContext.getCRArray().insert(float_);
                            styledFeatureI.setShpMBR(float_);
                            return;
                        }
                        catch (ClassCastException classCastException5) {
                            block64: {
                                try {
                                    VariableMarkerStyle variableMarkerStyle = (VariableMarkerStyle)style;
                                    object = styledFeatureI.getShape();
                                    Point2D point2D4 = styledFeatureI.getPoint();
                                    Field[] fieldArray = styledFeatureI.getRenderableAttributes();
                                    StyleMarker styleMarker = (StyleMarker)variableMarkerStyle.chooseStyle(fieldArray[0]);
                                    if (styleMarker == null) {
                                        log.warning("cannot find a suitable variable marker style based on your values [" + fieldArray[0] + "].");
                                        break block64;
                                    }
                                    styleMarker.setOrientation(styledFeatureI.getMarkerStyleOrientation());
                                    try {
                                        variableMarkerStyle.apply(visContext, graphics2D, (Shape)object, styledFeatureI.getGeomType(), null, point2D4, null, styledFeatureI.getRenderableAttributes(), null);
                                    }
                                    catch (Exception exception) {
                                        log.warning(exception.getMessage());
                                    }
                                    finally {
                                        styleMarker.resetOrientation();
                                    }
                                    int n16 = styleMarker.getDesiredWidth();
                                    int n17 = styleMarker.getDesiredHeight();
                                    int n18 = (int)point2D4.getX();
                                    int n19 = (int)point2D4.getY();
                                    visContext.getCRArray().insert(n18 - n16 / 2, n19 - n17 / 2, n16, n17);
                                }
                                catch (ClassCastException classCastException6) {
                                    log.severe(RSBundle.getMsg("MAPVIEWER-01006"));
                                }
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    static void drawMarkerOnPoint(Graphics2D graphics2D, StyleMarker styleMarker, StyledFeatureI styledFeatureI, Point2D point2D, VisContext visContext, int n, int n2) {
        VectorRenderer.drawMarkerOnPoint(graphics2D, styleMarker, styledFeatureI, point2D, visContext, n, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void drawMarkerOnPoint(Graphics2D graphics2D, StyleMarker styleMarker, StyledFeatureI styledFeatureI, Point2D point2D, VisContext visContext, int n, int n2, boolean bl) {
        Rectangle2D.Float float_;
        double d;
        double d2;
        int n3;
        block23: {
            MarkerStyleModifiers markerStyleModifiers = (MarkerStyleModifiers)styleMarker.convertToPixelSize(visContext);
            if (markerStyleModifiers != null) {
                markerStyleModifiers.setOrientationAngle(styledFeatureI.getMarkerStyleOrientation());
            }
            if (styledFeatureI.getMarkerStyleOrientation() != 0.0) {
                styleMarker = (StyleMarker)styleMarker.clone();
                styleMarker.setOrientation(styledFeatureI.getMarkerStyleOrientation());
            }
            n3 = styledFeatureI.getMarkerStyleSize();
            d2 = 0.0;
            d = 0.0;
            if (n3 > 0) {
                d2 = styleMarker.getDoubleDesiredWidth();
                d = styleMarker.getDoubleDesiredHeight();
                styleMarker.setDesiredWidth(n3);
                styleMarker.setDesiredHeight(n3);
                if (markerStyleModifiers != null) {
                    markerStyleModifiers.setWidth(n3);
                    markerStyleModifiers.setHeight(n3);
                }
            }
            if (markerStyleModifiers == null) {
                if (styleMarker.getDesiredWidth() > 0) {
                    n = styleMarker.getDesiredWidth();
                }
                if (styleMarker.getDesiredHeight() > 0) {
                    n2 = styleMarker.getDesiredHeight();
                }
            } else {
                if (markerStyleModifiers.getWidth() < 1 || markerStyleModifiers.getHeight() < 1) {
                    if (n3 > 0) {
                        styleMarker.setDesiredWidth(d2);
                        styleMarker.setDesiredHeight(d);
                    }
                    return;
                }
                n = markerStyleModifiers.getWidth();
                n2 = markerStyleModifiers.getHeight();
            }
            float_ = new Rectangle2D.Float((float)(point2D.getX() - (double)(n / 2)), (float)(point2D.getY() - (double)(n2 / 2)), n, n2);
            try {
                if (!styledFeatureI.isAllowNakedPoints() && styledFeatureI.getLabel() != null && (styledFeatureI.getLabelStyleName() != null || styledFeatureI.getLabelStyle() != null)) break block23;
                if (visContext.getRenderedMarkerCRArray() != null) {
                    visContext.getRenderedMarkerCRArray().insert(float_);
                }
                if (visContext.shouldRenderMarkerSequence()) {
                    if (visContext.getDeviceWindow().contains(point2D)) {
                        String string = visContext.getNextMarkerSequence();
                        if (string != null) {
                            styleMarker.apply(visContext, graphics2D, (Shape)float_, 1, string, null, null, null, (StyleModifiers)markerStyleModifiers);
                        } else {
                            styleMarker.apply(visContext, graphics2D, (Rectangle2D)float_, (StyleModifiers)markerStyleModifiers);
                        }
                    } else {
                        styleMarker.apply(visContext, graphics2D, (Rectangle2D)float_, (StyleModifiers)markerStyleModifiers);
                    }
                    break block23;
                }
                if (bl) {
                    styleMarker.apply(visContext, graphics2D, (Shape)float_, 1, styledFeatureI.getLabel(), null, null, null, (StyleModifiers)markerStyleModifiers);
                    break block23;
                }
                styleMarker.apply(visContext, graphics2D, (Rectangle2D)float_, (StyleModifiers)markerStyleModifiers);
            }
            catch (StyleNotApplicableException styleNotApplicableException) {
                log.warning(styleNotApplicableException.getMessage());
            }
        }
        if (visContext.getMarkerCRArray() != null) {
            visContext.getMarkerCRArray().insert(float_);
        }
        styledFeatureI.setShpMBR(float_);
        if (n3 > 0) {
            styleMarker.setDesiredWidth(d2);
            styleMarker.setDesiredHeight(d);
        }
    }

    private static void renderStyledPointWithCollectionStyle(Graphics2D graphics2D, StyledFeatureI styledFeatureI, VisContext visContext, Style style) {
        if (style == null || styledFeatureI == null || !(style instanceof CollectionStyle)) {
            return;
        }
        StyledFeature styledFeature = new StyledFeature();
        styledFeature.setShape(styledFeatureI.getShape());
        styledFeature.setPoint(styledFeatureI.getPoint());
        styledFeature.setGeometry(styledFeatureI.getGeometry());
        styledFeature.setGeomType(1);
        styledFeature.setMarkerStyleOrientation(styledFeatureI.getMarkerStyleOrientation());
        styledFeature.setRenderableAttributes(styledFeatureI.getRenderableAttributes());
        styledFeature.setRenderingRules(styledFeatureI.getRenderingRules());
        CollectionStyleModel collectionStyleModel = (CollectionStyleModel)style.getModel();
        for (int i = 0; i < collectionStyleModel.getNumberOfStyles(); ++i) {
            Style style2 = (Style)collectionStyleModel.getStyle(i);
            styledFeature.setFeatureStyle(style2);
            styledFeature.setFeatureStyleName(collectionStyleModel.getStyleName(i));
            String string = collectionStyleModel.getStyleShape(i);
            if (string != null && (string == null || !string.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE))) continue;
            VectorRenderer.renderStyledPoint(graphics2D, styledFeature, visContext);
        }
    }

    private static void renderRadius(Graphics2D graphics2D, StyledFeatureI styledFeatureI, VisContext visContext) {
        Point2D point2D = styledFeatureI.getPoint();
        if (point2D != null) {
            StyleColor styleColor = new StyleColor(null, Color.red);
            StyledFeature styledFeature = new StyledFeature();
            double[] dArray = styledFeatureI.getGeometry().getMBR();
            double[] dArray2 = new double[4];
            double[] dArray3 = styledFeatureI.getRadius();
            for (int i = 0; i < dArray3.length; ++i) {
                double d = dArray3[i];
                dArray2[0] = dArray[0] - d;
                dArray2[1] = dArray[1] - d;
                dArray2[2] = dArray[0] + d;
                dArray2[3] = dArray[1] + d;
                visContext.getAffineXF().transform(dArray2, 0, dArray2, 0, 2);
                Ellipse2D.Double double_ = new Ellipse2D.Double(Math.min(dArray2[0], dArray2[2]), Math.min(dArray2[1], dArray2[3]), Math.abs(dArray2[2] - dArray2[0]), Math.abs(dArray2[3] - dArray2[1]));
                styledFeature.setShape(double_);
                styledFeature.setFeatureStyle(styleColor);
                styledFeature.setGeomType(2);
                VectorRenderer.renderStyledFeature(graphics2D, styledFeature, visContext);
            }
        }
    }

    public boolean labelStyledFeature(Graphics2D graphics2D, StyledFeatureI styledFeatureI, float[] fArray, boolean bl, boolean bl2, boolean bl3, VisContext visContext) throws StyleNotApplicableException {
        String string = styledFeatureI.getTranslatedLabel();
        if (string == null) {
            string = styledFeatureI.getLabel();
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        Style style = null;
        Shape shape = null;
        boolean bl4 = false;
        boolean bl5 = false;
        style = styledFeatureI.getLabelStyle();
        if (style == null) {
            style = MapMaker.getStyleWithName(styledFeatureI.getLabelStyleName(), styledFeatureI.getDataSource(), visContext);
        }
        if (style == null) {
            style = StyleFactory.getDefaultTextStyle();
        }
        switch (style.getModel().getType()) {
            case 5: {
                StyleText styleText = (StyleText)style;
                style.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                if (visContext.isPDFformatRequest()) {
                    VectorRenderer.checkRegisterTTFforPDF(styledFeatureI.getFeatureStyleName(), style, styledFeatureI.getDataSource(), graphics2D);
                }
                return TextLabeler.applyTextLabel(graphics2D, styledFeatureI, styleText, string, bl, bl2, bl3, visContext);
            }
            case 2: {
                StyleMarker styleMarker = (StyleMarker)style;
                if (!this.labelFeatureWithMarker(graphics2D, styleMarker, styledFeatureI, visContext, fArray, bl)) break;
                return true;
            }
            case 9: {
                if (style instanceof PieChartStyle || style instanceof BarChartStyle) {
                    Object object;
                    Point2D point2D = null;
                    shape = styledFeatureI.getShape();
                    point2D = styledFeatureI.getPoint();
                    if (point2D == null && shape != null) {
                        if (styledFeatureI.getGeomType() == 3 || styledFeatureI.getGeomType() == 7) {
                            point2D = null;
                        } else if (styledFeatureI.getGeomType() == 2 || styledFeatureI.getGeomType() == 6) {
                            if (this.findLabelPointOnLinearFeature(shape, fArray, 5, 5, true, visContext) != null) {
                                point2D = new Point2D.Double(fArray[0], fArray[1]);
                            }
                        } else {
                            object = shape.getBounds();
                            point2D = new Point2D.Double(((RectangularShape)object).getCenterX(), ((RectangularShape)object).getCenterY());
                        }
                    }
                    object = style.convertToPixelSize(visContext);
                    style.apply(visContext, graphics2D, shape, styledFeatureI.getGeomType(), null, point2D, (ConflictResolver)visContext.getCRArray(), styledFeatureI.getRenderableAttributes(), (StyleModifiers)object);
                    return true;
                }
                if (style instanceof VariableMarkerStyle || style instanceof VariablePieChartStyle) {
                    Object object;
                    style.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                    if (visContext.isPDFformatRequest()) {
                        VectorRenderer.checkRegisterTTFforPDF(styledFeatureI.getFeatureStyleName(), style, styledFeatureI.getDataSource(), graphics2D);
                    }
                    Point2D point2D = null;
                    shape = styledFeatureI.getShape();
                    point2D = styledFeatureI.getPoint();
                    if (point2D == null && shape != null) {
                        if (styledFeatureI.getGeomType() == 3 || styledFeatureI.getGeomType() == 7) {
                            object = LabelHelper.findLoc4RectInPolygon(shape, 5.0, 5.0, visContext.getCRArray(), true, !visContext.isTileRequest(), visContext.isTileRequest() ? visContext.deviceWindow : null);
                            if (object != null) {
                                point2D = new Point2D.Double((double)object[0] + 2.5, (double)object[1] - 2.5);
                            }
                        } else if (styledFeatureI.getGeomType() == 2 || styledFeatureI.getGeomType() == 6) {
                            if (this.findLabelPointOnLinearFeature(shape, fArray, 5, 5, true, visContext) != null) {
                                point2D = new Point2D.Double(fArray[0], fArray[1]);
                            }
                        } else {
                            object = shape.getBounds();
                            point2D = new Point2D.Double(((RectangularShape)object).getCenterX(), ((RectangularShape)object).getCenterY());
                        }
                    }
                    if (point2D != null) {
                        if (style instanceof VariableMarkerStyle) {
                            object = (VariableMarkerStyle)style;
                            StyleModifiers styleModifiers = ((BucketStyle)object).convertToPixelSize(visContext);
                            Field[] fieldArray = styledFeatureI.getRenderableAttributes();
                            BucketStyle.BucketDescription bucketDescription = ((BucketStyle)object).chooseRenderStyle(fieldArray[0], styleModifiers);
                            StyleMarker styleMarker = (StyleMarker)bucketDescription.style;
                            if (styleMarker == null) {
                                log.warning("cannot find a suitable variable marker style based on your values [" + fieldArray[0] + "].");
                                return false;
                            }
                            ((VariableMarkerStyle)object).apply(visContext, graphics2D, shape, styledFeatureI.getGeomType(), null, point2D, null, styledFeatureI.getRenderableAttributes(), styleModifiers);
                            int n = styleMarker.getDesiredWidth();
                            int n2 = styleMarker.getDesiredHeight();
                            if (bucketDescription.styleMods != null && bucketDescription.styleMods instanceof MarkerStyleModifiers) {
                                n = ((MarkerStyleModifiers)bucketDescription.styleMods).getWidth();
                                n2 = ((MarkerStyleModifiers)bucketDescription.styleMods).getHeight();
                            }
                            int n3 = (int)point2D.getX();
                            int n4 = (int)point2D.getY();
                            visContext.getCRArray().insert(n3 - n / 2, n4 - n2 / 2, n, n2);
                            return true;
                        }
                        object = (VariablePieChartStyle)style;
                        StyleModifiers styleModifiers = ((BucketStyle)object).convertToPixelSize(visContext);
                        Field[] fieldArray = styledFeatureI.getRenderableAttributes();
                        double d = 0.0;
                        for (int i = 0; i < fieldArray.length; ++i) {
                            if (fieldArray[i].getShortJavaTypeName().equalsIgnoreCase("string")) {
                                try {
                                    d += Double.parseDouble(fieldArray[i].getString());
                                }
                                catch (Exception exception) {
                                    log.warning("Attribute for VariablePieChartStyle is not numeric.");
                                }
                                continue;
                            }
                            d += fieldArray[i].getDouble();
                        }
                        Field field = new Field(d);
                        BucketStyle.BucketDescription bucketDescription = ((BucketStyle)object).chooseRenderStyle(field, styleModifiers);
                        PieChartStyle pieChartStyle = (PieChartStyle)bucketDescription.style;
                        if (pieChartStyle == null) {
                            log.warning("cannot find a suitable variable pie chart style based on your value [" + field + "].");
                            return false;
                        }
                        pieChartStyle.apply(visContext, graphics2D, shape, styledFeatureI.getGeomType(), null, point2D, null, styledFeatureI.getRenderableAttributes(), bucketDescription.styleMods);
                        int n = pieChartStyle.getPieRadius() * 2;
                        int n5 = pieChartStyle.getPieRadius() * 2;
                        int n6 = (int)point2D.getX();
                        int n7 = (int)point2D.getY();
                        visContext.getCRArray().insert(n6 - n / 2, n7 - n5 / 2, n, n5);
                        return true;
                    }
                    log.warning("cannot find a suitable place to draw variable marker.");
                    return false;
                }
                if (!(style instanceof BucketStyle)) break;
                BucketStyle bucketStyle = (BucketStyle)style;
                Field[] fieldArray = styledFeatureI.getRenderableAttributes();
                if (fieldArray == null) break;
                Style style2 = bucketStyle.chooseLabelStyle(fieldArray[0]);
                if (style2 != null && style2 instanceof StyleText) {
                    return TextLabeler.applyTextLabel(graphics2D, styledFeatureI, (StyleText)style2, string, bl, bl2, bl3, visContext);
                }
                if (style2 != null && style2 instanceof StyleMarker) {
                    return this.labelFeatureWithMarker(graphics2D, (StyleMarker)style2, styledFeatureI, visContext, fArray, bl);
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private boolean labelFeatureWithMarker(Graphics2D graphics2D, StyleMarker styleMarker, StyledFeatureI styledFeatureI, VisContext visContext, float[] fArray, boolean bl) {
        Cloneable cloneable;
        Shape shape = null;
        if (styleMarker == null || styledFeatureI == null) {
            return false;
        }
        int n = styleMarker.getDesiredWidth();
        int n2 = styleMarker.getDesiredHeight();
        MarkerStyleModifiers markerStyleModifiers = (MarkerStyleModifiers)styleMarker.convertToPixelSize(visContext);
        if (markerStyleModifiers != null) {
            n = markerStyleModifiers.getWidth();
            n2 = markerStyleModifiers.getHeight();
        }
        if (styledFeatureI.getGeomType() == 1) {
            cloneable = styledFeatureI.getPoint();
            if (cloneable == null) {
                shape = styledFeatureI.getShape();
                if (shape != null) {
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    cloneable = new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
                    styledFeatureI.setPoint((Point2D)cloneable);
                } else {
                    log.warning(RSBundle.getMsg("MAPVIEWER-01007"));
                    return false;
                }
            }
            fArray[0] = (float)cloneable.getX();
            fArray[1] = (float)cloneable.getY();
        } else {
            shape = styledFeatureI.getShape();
            if (this.findLabelPointOnLinearFeature(shape, fArray, n, n2, bl || styledFeatureI.getForceLabel(), visContext) == null) {
                return false;
            }
        }
        if (VectorRenderer.contains(visContext, fArray[0], fArray[1], n, n2)) {
            cloneable = new Rectangle2D.Float(fArray[0] - (float)(n / 2), fArray[1] - (float)(n2 / 2), n, n2);
            try {
                styleMarker.apply(visContext, graphics2D, (Shape)((Object)cloneable), 3, styledFeatureI.getLabel(), null, null, styledFeatureI.getRenderableAttributes(), (StyleModifiers)markerStyleModifiers);
                visContext.getCRArray().insert((Rectangle2D)cloneable);
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
                return false;
            }
        }
        return true;
    }

    private float[] findLabelPointOnLinearFeature(Shape shape, float[] fArray, int n, int n2, boolean bl, VisContext visContext) {
        if (shape == null) {
            return null;
        }
        double d = ShapeUtil.lengthOf(shape);
        if ((d < (double)n || d < (double)n2) && !bl) {
            return null;
        }
        shape = ShapeUtil.clipLineString(visContext.getDeviceWindow(), shape);
        if (shape == null || shape.getBounds().getWidth() == 0.0) {
            return null;
        }
        double d2 = 0.75;
        double d3 = 0.098;
        for (int i = 0; i <= 5; ++i) {
            double d4 = d2 + d3 * (double)i;
            ShapeUtil.lrPoint(shape, d4, fArray);
            if (visContext.getDeviceWindow().contains(fArray[0], fArray[1]) && (bl || !visContext.getCRArray().conflicts((int)(fArray[0] - (float)(n / 2)), (int)(fArray[1] - (float)(n2 / 2)), n, n2) && !visContext.getMarkerCRArray().conflicts((int)(fArray[0] - (float)(n / 2)), (int)(fArray[1] - (float)(n2 / 2)), n, n2))) {
                return fArray;
            }
            if (i == 0) continue;
            d4 = d2 - d3 * (double)i;
            ShapeUtil.lrPoint(shape, d4, fArray);
            if (!visContext.getDeviceWindow().contains(fArray[0], fArray[1]) || !bl && (visContext.getCRArray().conflicts((int)(fArray[0] - (float)(n / 2)), (int)(fArray[1] - (float)(n2 / 2)), n, n2) || visContext.getMarkerCRArray().conflicts((int)(fArray[0] - (float)(n / 2)), (int)(fArray[1] - (float)(n2 / 2)), n, n2))) continue;
            return fArray;
        }
        if (bl) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            if (rectangle2D == null) {
                return null;
            }
            fArray[0] = (float)rectangle2D.getCenterX();
            fArray[1] = (float)rectangle2D.getCenterY();
            return fArray;
        }
        return null;
    }

    private float[] findTextLabelPointOnAreaFeature(StyledFeatureI styledFeatureI, float[] fArray, StyleText styleText, String string, boolean bl, VisContext visContext) {
        float f;
        Shape shape = styledFeatureI.getShape();
        if (shape == null) {
            return null;
        }
        float f2 = 5.0f;
        Rectangle2D rectangle2D = styleText.getVisualBounds(string, null);
        Rectangle rectangle = shape.getBounds();
        float f3 = (float)rectangle2D.getMinX();
        float f4 = (float)rectangle2D.getMinY();
        float f5 = (float)rectangle2D.getWidth();
        float[] fArray2 = LabelHelper.findLoc4RectInPolygon(shape, (int)f5, (int)(f = (float)rectangle2D.getHeight()), visContext.getCRArray(), bl, !visContext.isTileRequest(), visContext.isTileRequest() ? visContext.deviceWindow : null);
        if (fArray2 != null) {
            fArray[2] = fArray2[2];
            if (fArray2[2] == 0.0f) {
                fArray[0] = fArray2[0] + f3;
                fArray[1] = fArray2[1];
            } else if ((double)fArray2[2] == -1.5707963267948966) {
                fArray[0] = fArray2[0];
                fArray[1] = fArray2[1] + f3;
            } else {
                fArray[0] = fArray2[0];
                fArray[1] = fArray2[1];
            }
            return fArray;
        }
        return null;
    }

    public void drawLimits(Graphics2D graphics2D, VisContext visContext) {
        graphics2D.setColor(Color.red);
        graphics2D.setStroke(new BasicStroke());
        for (int i = 0; i < visContext.getCRArray().size(); ++i) {
            Rectangle2D rectangle2D = visContext.getCRArray().elementAt(i);
            graphics2D.draw(rectangle2D);
        }
    }

    public void renderThemeIntoSVG(SVGMap sVGMap, Theme theme, VisContext visContext) {
        StyledFeatureI styledFeatureI = null;
        sVGMap.addTheme(theme.getName(), theme.getDecorator());
        for (int i = 0; i < theme.size(); ++i) {
            styledFeatureI = theme.getStyledFeature(i);
            if (styledFeatureI == null) continue;
            this.renderStyledFeatureToSVG(sVGMap, styledFeatureI, theme.getDecorator().getMinDistBetweenPoints(), theme instanceof LocalTheme ? false : theme.getDecorator().isSelectableInSVG(), visContext);
        }
        sVGMap.closeTheme();
    }

    private void renderStyledFeatureToSVG(SVGMap sVGMap, StyledFeatureI styledFeatureI, double d, boolean bl, VisContext visContext) {
        if (styledFeatureI.selectableInSVG()) {
            bl = true;
        }
        if (styledFeatureI.getOnClick() != null) {
            sVGMap.setOnClick(styledFeatureI.getOnClick());
        }
        if (styledFeatureI.getOnMouseMove() != null) {
            sVGMap.setOnMouseMove(styledFeatureI.getOnMouseMove());
        }
        if (styledFeatureI.getOnMouseOver() != null) {
            sVGMap.setOnMouseOver(styledFeatureI.getOnMouseOver());
        }
        if (styledFeatureI.getOnMouseOut() != null) {
            sVGMap.setOnMouseOut(styledFeatureI.getOnMouseOut());
        }
        if (!styledFeatureI.hasRenderableShape()) {
            if (visContext.renderSVGInDevCoordSys()) {
                styledFeatureI.buildShapeFromGeometry(visContext.getAffineXF());
            } else {
                styledFeatureI.buildDoubleShapeFromGeometry(null);
            }
        }
        Shape shape = null;
        Object var8_7 = null;
        Object object = null;
        int n = styledFeatureI.getGeomType();
        if (n == 1) {
            this.renderStyledPointToSVG(sVGMap, styledFeatureI, d, bl, visContext);
        } else {
            shape = styledFeatureI.getShape();
            if (styledFeatureI.getShape() != null) {
                object = styledFeatureI.getFeatureStyle();
                if (object == null) {
                    object = MapMaker.getStyleWithName(styledFeatureI.getFeatureStyleName(), styledFeatureI.getDataSource(), visContext);
                }
                if (object == null) {
                    object = StyleFactory.getDefaultStyle(n);
                }
                if (object != null) {
                    boolean bl2 = object.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                }
                String string = "";
                if (styledFeatureI.getLabel() != null && styledFeatureI.getLabel().length() > 0) {
                    string = styledFeatureI.getLabel();
                }
                Style style = null;
                style = styledFeatureI.getLabelStyle();
                if (style == null) {
                    style = MapMaker.getStyleWithName(styledFeatureI.getLabelStyleName(), styledFeatureI.getDataSource(), visContext);
                }
                if (style == null) {
                    style = StyleFactory.getDefaultTextStyle();
                }
                if (n == 4) {
                    this.renderStyledCollectionToSVG(sVGMap, (Style)object, styledFeatureI, d, bl, visContext);
                } else if (n == 5) {
                    this.renderStyledMultiPointToSVG(sVGMap, (Style)object, styledFeatureI, d, bl, visContext);
                } else {
                    Object object2;
                    Object object3;
                    Object object4;
                    if (n == 2 || n == 6) {
                        if (!visContext.renderSVGLayersOnly() && visContext.renderSVGInDevCoordSys()) {
                            shape = ShapeUtil.clipLineString(visContext.getDeviceWindow(), shape);
                        }
                        if (shape == null) {
                            return;
                        }
                        if (object instanceof StyleColor) {
                            object4 = (StyleColor)object;
                            object3 = ((StyleColor)object4).getStrokeColor();
                            if (object3 == null) {
                                object3 = ((StyleColor)object4).getFillColor();
                            }
                            object2 = new StyleLine();
                            ((StyleLine)object2).setOverallStyle((Color)object3, ((StyleColor)object4).getStrokeWidth(), 0, 0);
                            object = object2;
                        }
                    }
                    object4 = styledFeatureI.getID();
                    try {
                        object3 = style.convertToPixelSize(visContext);
                        object2 = styledFeatureI.getRenderingRules();
                        if (object2 == null) {
                            styledFeatureI.setSVGId(object.applyToSVG(null, sVGMap, shape, styledFeatureI.getGeomType(), styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), string, style, sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, object4 == null ? null : object4.toString(), (StyleModifiers)object3));
                        } else {
                            Style style2;
                            String string2;
                            int n2;
                            boolean bl3 = false;
                            for (n2 = 0; n2 < ((RenderingRule[])object2).length; ++n2) {
                                string2 = object2[n2].getStyleName();
                                if (string2 == null || !string2.equalsIgnoreCase(styledFeatureI.getFeatureStyleName())) continue;
                                style2 = null;
                                if (((RenderingRule)object2[n2]).getSubStyleName() != null) {
                                    style2 = MapMaker.getStyleWithName(((RenderingRule)object2[n2]).getSubStyleName(), styledFeatureI.getDataSource(), visContext);
                                    style2.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                                }
                                styledFeatureI.setSVGId(object.applyToSVG(null, sVGMap, shape, styledFeatureI.getGeomType(), styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), string, style, sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, object4 == null ? null : object4.toString(), ((RenderingRule)object2[n2]).getStyleColumns(), style2, ((RenderingRule)object2[n2]).getSubStyleColumns(), ((RenderingRule)object2[n2]).getSubStyleChangeProperty(), null));
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                styledFeatureI.setSVGId(object.applyToSVG(null, sVGMap, shape, styledFeatureI.getGeomType(), styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), string, style, sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, object4 == null ? null : object4.toString(), null));
                            }
                            for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                                string2 = ((RenderingRule)object2[n2]).getStyleName();
                                if (string2 != null && string2.equalsIgnoreCase(styledFeatureI.getFeatureStyleName()) || (style2 = MapMaker.getStyleWithName(string2, styledFeatureI.getDataSource(), visContext)) == null) continue;
                                style2.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                                Style style3 = null;
                                if (((RenderingRule)object2[n2]).getSubStyleName() != null) {
                                    style3 = MapMaker.getStyleWithName(((RenderingRule)object2[n2]).getSubStyleName(), styledFeatureI.getDataSource(), visContext);
                                    style3.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                                }
                                styledFeatureI.setSVGId(style2.applyToSVG(null, sVGMap, shape, styledFeatureI.getGeomType(), styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), string, style, sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, object4 == null ? null : object4.toString(), ((RenderingRule)object2[n2]).getStyleColumns(), style3, ((RenderingRule)object2[n2]).getSubStyleColumns(), ((RenderingRule)object2[n2]).getSubStyleChangeProperty(), null));
                            }
                        }
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                }
            }
        }
        if (styledFeatureI.getOnClick() != null) {
            sVGMap.setOnClick(null);
        }
        if (styledFeatureI.getOnMouseMove() != null) {
            sVGMap.setOnMouseMove(null);
        }
        if (styledFeatureI.getOnMouseOver() != null) {
            sVGMap.setOnMouseOver(null);
        }
        if (styledFeatureI.getOnMouseOut() != null) {
            sVGMap.setOnMouseOut(null);
        }
    }

    private void renderStyledCollectionToSVG(SVGMap sVGMap, Style style, StyledFeatureI styledFeatureI, double d, boolean bl, VisContext visContext) {
        Object object;
        Cloneable cloneable;
        Point2D[] point2DArray;
        long l = System.currentTimeMillis();
        RenderingRule[] renderingRuleArray = styledFeatureI.getRenderingRules();
        try {
            if (style instanceof CollectionStyle) {
                if (renderingRuleArray != null) {
                    log.warning("Rendering rules are currently ignored for lines and polygons with collection style");
                }
                point2DArray = style.convertToPixelSize(visContext);
                GeneralPath generalPath = new GeneralPath();
                cloneable = new GeneralPath();
                ShapeUtil.extractLinesAndRings(styledFeatureI.getShape(), generalPath, (GeneralPath)cloneable);
                if (cloneable != null) {
                    style.applyToSVG(null, sVGMap, (Shape)((Object)cloneable), 3, styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), styledFeatureI.getLabel(), styledFeatureI.getLabelStyle(), sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, styledFeatureI.getID() == null ? null : styledFeatureI.getID().toString(), (StyleModifiers)point2DArray);
                }
                if (generalPath != null) {
                    style.applyToSVG(null, sVGMap, generalPath, 2, styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), styledFeatureI.getLabel(), styledFeatureI.getLabelStyle(), sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, styledFeatureI.getID() == null ? null : styledFeatureI.getID().toString(), (StyleModifiers)point2DArray);
                }
            } else {
                point2DArray = style.convertToPixelSize(visContext);
                if (renderingRuleArray == null) {
                    style.applyToSVG(null, sVGMap, styledFeatureI.getShape(), styledFeatureI.getGeomType(), styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), styledFeatureI.getLabel(), styledFeatureI.getLabelStyle(), sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, styledFeatureI.getID() == null ? null : styledFeatureI.getID().toString(), null);
                } else {
                    Style style2;
                    int n;
                    boolean bl2 = false;
                    for (n = 0; n < renderingRuleArray.length; ++n) {
                        object = renderingRuleArray[n].getStyleName();
                        if (object == null || !((String)object).equalsIgnoreCase(styledFeatureI.getFeatureStyleName())) continue;
                        style2 = null;
                        if (renderingRuleArray[n].getSubStyleName() != null) {
                            style2 = MapMaker.getStyleWithName(renderingRuleArray[n].getSubStyleName(), styledFeatureI.getDataSource(), visContext);
                            style2.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                        }
                        style.applyToSVG(null, sVGMap, styledFeatureI.getShape(), styledFeatureI.getGeomType(), styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), styledFeatureI.getLabel(), styledFeatureI.getLabelStyle(), sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, styledFeatureI.getID() == null ? null : styledFeatureI.getID().toString(), renderingRuleArray[n].getStyleColumns(), style2, renderingRuleArray[n].getSubStyleColumns(), renderingRuleArray[n].getSubStyleChangeProperty(), null);
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        style.applyToSVG(null, sVGMap, styledFeatureI.getShape(), styledFeatureI.getGeomType(), styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), styledFeatureI.getLabel(), styledFeatureI.getLabelStyle(), sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, styledFeatureI.getID() == null ? null : styledFeatureI.getID().toString(), null);
                    }
                    for (n = 0; n < renderingRuleArray.length; ++n) {
                        object = renderingRuleArray[n].getStyleName();
                        if (object != null && ((String)object).equalsIgnoreCase(styledFeatureI.getFeatureStyleName()) || (style2 = MapMaker.getStyleWithName((String)object, styledFeatureI.getDataSource(), visContext)) == null) continue;
                        style2.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                        Style style3 = null;
                        if (renderingRuleArray[n].getSubStyleName() != null) {
                            style3 = MapMaker.getStyleWithName(renderingRuleArray[n].getSubStyleName(), styledFeatureI.getDataSource(), visContext);
                            style3.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                        }
                        style2.applyToSVG(null, sVGMap, styledFeatureI.getShape(), styledFeatureI.getGeomType(), styledFeatureI.getRenderableAttributes(), visContext.getDeviceWindow(), styledFeatureI.getLabel(), styledFeatureI.getLabelStyle(), sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, styledFeatureI.getID() == null ? null : styledFeatureI.getID().toString(), renderingRuleArray[n].getStyleColumns(), style3, renderingRuleArray[n].getSubStyleColumns(), renderingRuleArray[n].getSubStyleChangeProperty(), null);
                    }
                }
            }
        }
        catch (StyleNotApplicableException styleNotApplicableException) {
            log.warning(styleNotApplicableException.getMessage());
        }
        long l2 = System.currentTimeMillis();
        point2DArray = Util.getJavaPointsForGeometryCollection(styledFeatureI.getGeometry());
        if (point2DArray != null) {
            for (int i = 0; i < point2DArray.length; ++i) {
                cloneable = new StyledFeature();
                object = new JSDOGeometry(point2DArray[i].getX(), point2DArray[i].getY(), 0);
                ((StyledFeature)cloneable).setGeometry((JSDOGeometry)object);
                ((StyledFeature)cloneable).setMarkerStyleOrientation(styledFeatureI.getMarkerStyleOrientation());
                ((StyledFeature)cloneable).setRenderableAttributes(styledFeatureI.getRenderableAttributes());
                ((StyledFeature)cloneable).setRenderingRules(styledFeatureI.getRenderingRules());
                ((StyledFeature)cloneable).setGeomType(1);
                ((StyledFeature)cloneable).setFeatureStyle(style);
                this.renderStyledPointToSVG(sVGMap, (StyledFeatureI)((Object)cloneable), d, bl, visContext);
            }
        }
        long l3 = System.currentTimeMillis();
        log.finer("non-point styled collection time: " + (l2 - l));
        log.finer("    point styled collection time: " + (l3 - l2));
    }

    private void renderStyledPointToSVGWithCollectionStyle(SVGMap sVGMap, StyledFeatureI styledFeatureI, double d, boolean bl, VisContext visContext, Style style) {
        if (style == null || styledFeatureI == null || !(style instanceof CollectionStyle)) {
            return;
        }
        StyledFeature styledFeature = new StyledFeature();
        styledFeature.setGeometry(styledFeatureI.getGeometry());
        styledFeature.setGeomType(1);
        styledFeature.setMarkerStyleOrientation(styledFeatureI.getMarkerStyleOrientation());
        styledFeature.setRenderableAttributes(styledFeatureI.getRenderableAttributes());
        styledFeature.setRenderingRules(styledFeatureI.getRenderingRules());
        CollectionStyleModel collectionStyleModel = (CollectionStyleModel)style.getModel();
        for (int i = 0; i < collectionStyleModel.getNumberOfStyles(); ++i) {
            Style style2 = (Style)collectionStyleModel.getStyle(i);
            styledFeature.setFeatureStyle(style2);
            styledFeature.setFeatureStyleName(collectionStyleModel.getStyleName(i));
            String string = collectionStyleModel.getStyleShape(i);
            if (string != null && (string == null || !string.equalsIgnoreCase(CollectionStyleModel.POINT_SHAPE))) continue;
            this.renderStyledPointToSVG(sVGMap, styledFeature, d, bl, visContext);
        }
    }

    private void renderStyledMultiPointToSVG(SVGMap sVGMap, Style style, StyledFeatureI styledFeatureI, double d, boolean bl, VisContext visContext) {
        float[] fArray = new float[6];
        PathIterator pathIterator = styledFeatureI.getShape().getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (n == 0 || n == 1) {
                StyledFeature styledFeature = new StyledFeature();
                styledFeature.setPoint(new Point2D.Double(fArray[0], fArray[1]));
                styledFeature.setGeomType(1);
                styledFeature.setFeatureStyle(style);
                styledFeature.setFeatureStyleName(styledFeatureI.getFeatureStyleName());
                styledFeature.setMarkerStyleOrientation(styledFeatureI.getMarkerStyleOrientation());
                styledFeature.setRenderableAttributes(styledFeatureI.getRenderableAttributes());
                styledFeature.setRenderingRules(styledFeatureI.getRenderingRules());
                this.renderStyledPointToSVG(sVGMap, styledFeature, d, bl, visContext);
            }
            pathIterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderStyledPointToSVG(SVGMap sVGMap, StyledFeatureI styledFeatureI, double d, boolean bl, VisContext visContext) {
        int n;
        Cloneable cloneable;
        Shape shape;
        if (!styledFeatureI.hasRenderableShape()) {
            styledFeatureI.buildShapeFromGeometry(visContext.getAffineXF());
        }
        Point2D point2D = styledFeatureI.getPoint();
        Style style = null;
        if (point2D == null) {
            shape = styledFeatureI.getShape();
            if (shape != null) {
                cloneable = shape.getBounds2D();
                point2D = new Point2D.Double(((RectangularShape)cloneable).getCenterX(), ((RectangularShape)cloneable).getCenterY());
                styledFeatureI.setPoint(point2D);
            } else {
                log.warning("No geometric data found for point feature.");
                return;
            }
        }
        Shape shape2 = shape = styledFeatureI.getID() == null ? null : styledFeatureI.getID().toString();
        if (sVGMap.getLayersOnly() && !sVGMap.getDeviceCoordinateSys()) {
            sVGMap.drawPoint(point2D, styledFeatureI.getFeatureStyleName(), sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, (String)((Object)shape));
            return;
        }
        cloneable = (Point2D.Double)point2D;
        style = styledFeatureI.getFeatureStyle();
        if (style == null) {
            style = MapMaker.getStyleWithName(styledFeatureI.getFeatureStyleName(), styledFeatureI.getDataSource(), visContext);
        }
        if (style == null) {
            style = StyleFactory.getDefaultStyle(1);
        }
        if (style != null) {
            n = style.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles()) ? 1 : 0;
        }
        if (style instanceof CollectionStyle) {
            this.renderStyledPointToSVGWithCollectionStyle(sVGMap, styledFeatureI, d, bl, visContext, style);
            return;
        }
        n = 9;
        int n2 = 9;
        String string = null;
        if (styledFeatureI.getLabel() != null && styledFeatureI.getLabel().length() > 0) {
            string = styledFeatureI.getLabel();
        }
        if (style instanceof StyleMarker) {
            StyleMarker styleMarker = (StyleMarker)style;
            MarkerStyleModifiers markerStyleModifiers = (MarkerStyleModifiers)styleMarker.convertToPixelSize(visContext);
            if (markerStyleModifiers != null) {
                markerStyleModifiers.setOrientationAngle(styledFeatureI.getMarkerStyleOrientation());
            } else if (styledFeatureI.getMarkerStyleOrientation() != 0.0) {
                styleMarker = (StyleMarker)styleMarker.clone();
                styleMarker.setOrientation(styledFeatureI.getMarkerStyleOrientation());
            }
            int n3 = styledFeatureI.getMarkerStyleSize();
            double d2 = 0.0;
            double d3 = 0.0;
            if (n3 > 0) {
                d2 = styleMarker.getDoubleDesiredWidth();
                d3 = styleMarker.getDoubleDesiredHeight();
                styleMarker.setDesiredWidth(n3);
                styleMarker.setDesiredHeight(n3);
                if (markerStyleModifiers != null) {
                    markerStyleModifiers.setWidth(n3);
                    markerStyleModifiers.setHeight(n3);
                }
            }
            if (markerStyleModifiers == null) {
                if (styleMarker.getDesiredWidth() > 0) {
                    n = styleMarker.getDesiredWidth();
                }
                if (styleMarker.getDesiredHeight() > 0) {
                    n2 = styleMarker.getDesiredHeight();
                }
            } else {
                if (markerStyleModifiers.getWidth() < 1 || markerStyleModifiers.getHeight() < 1) {
                    if (n3 > 0) {
                        styleMarker.setDesiredWidth(d2);
                        styleMarker.setDesiredHeight(d3);
                    }
                    return;
                }
                n = markerStyleModifiers.getWidth();
                n2 = markerStyleModifiers.getHeight();
            }
            Rectangle2D.Float float_ = new Rectangle2D.Float((float)(((Point2D.Double)cloneable).getX() - (double)(n / 2)), (float)(((Point2D.Double)cloneable).getY() - (double)(n2 / 2)), n, n2);
            try {
                styleMarker.applyToSVG(sVGMap, float_, styledFeatureI.getLabel(), visContext.getDeviceWindow(), sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, (String)((Object)shape), markerStyleModifiers);
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            visContext.getCRArray().insert(float_);
            styledFeatureI.setShpMBR(float_);
            if (n3 > 0) {
                styleMarker.setDesiredWidth(d2);
                styleMarker.setDesiredHeight(d3);
            }
            if (styledFeatureI.getRadius() != null) {
                this.renderRadiusToSVG(sVGMap, styledFeatureI, d, visContext);
            }
            return;
        }
        if (style instanceof StyleColor) {
            StyleColor styleColor = (StyleColor)style;
            Color color = null;
            int n4 = (int)((Point2D.Double)cloneable).getX();
            int n5 = (int)((Point2D.Double)cloneable).getY();
            if (styleColor.getFillColor() != null) {
                color = styleColor.getFillColor();
            }
            if (styleColor.getStrokeColor() != null) {
                color = styleColor.getStrokeColor();
            }
            if (color == null) {
                color = Color.black;
            }
            try {
                sVGMap.drawLine(n4 - 3, n5 - 3, n4 + 3, n5 + 3, color, 1.0f, null);
                sVGMap.drawLine(n4 - 3, n5 + 3, n4 + 3, n5 - 3, color, 1.0f, null);
                if (styledFeatureI.getRadius() != null) {
                    this.renderRadiusToSVG(sVGMap, styledFeatureI, d, visContext);
                }
                Rectangle2D.Float float_ = new Rectangle2D.Float(n4 - 3, n5 - 3, 6.0f, 6.0f);
                visContext.getCRArray().insert(float_);
                styledFeatureI.setShpMBR(float_);
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            return;
        }
        try {
            Rectangle2D.Float float_;
            block74: {
                Object object;
                Object object2;
                int n6;
                int n7;
                Object object3;
                BucketStyle bucketStyle = (BucketStyle)style;
                int n8 = (int)((Point2D.Double)cloneable).getX();
                int n9 = (int)((Point2D.Double)cloneable).getY();
                StyleModifiers styleModifiers = bucketStyle.convertToPixelSize(visContext);
                if (styledFeatureI.getMarkerStyleOrientation() != 0.0) {
                    boolean bl2 = false;
                    object3 = bucketStyle.getDefaultStyle();
                    if (object3 != null && object3 instanceof StyleMarker) {
                        if (styleModifiers == null) {
                            if (!bl2) {
                                bucketStyle = (BucketStyle)bucketStyle.clone();
                                bl2 = true;
                                object3 = bucketStyle.getDefaultStyle();
                            }
                            try {
                                object3 = (StyleMarker)((StyleMarker)object3).clone();
                                ((StyleMarker)object3).setOrientation(styledFeatureI.getMarkerStyleOrientation());
                            }
                            catch (Exception exception) {}
                        } else {
                            StyleModifiers styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(bucketStyle.getDefaultStyleName().toUpperCase());
                            if (styleModifiers2 != null && styleModifiers2 instanceof MarkerStyleModifiers) {
                                ((MarkerStyleModifiers)styleModifiers2).setOrientationAngle(styledFeatureI.getMarkerStyleOrientation());
                            }
                        }
                    }
                    n7 = bucketStyle.getNumBuckets();
                    for (n6 = 0; n6 < n7; ++n6) {
                        object2 = (Style)bucketStyle.getBucket(n6).getRenderStyle();
                        if (object2 == null || !(object2 instanceof StyleMarker)) continue;
                        if (styleModifiers == null) {
                            if (!bl2) {
                                bucketStyle = (BucketStyle)bucketStyle.clone();
                                bl2 = true;
                                object2 = (Style)bucketStyle.getBucket(n6).getRenderStyle();
                            }
                            try {
                                object2 = (StyleMarker)((StyleMarker)object2).clone();
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            ((StyleMarker)object2).setOrientation(styledFeatureI.getMarkerStyleOrientation());
                            bucketStyle.getBucket(n6).setRenderStyle(object2);
                            continue;
                        }
                        object = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers(bucketStyle.getBucket(n6).getRenderStyleName().toUpperCase() + "_" + n6);
                        if (object == null || !(object instanceof MarkerStyleModifiers)) continue;
                        ((MarkerStyleModifiers)object).setOrientationAngle(styledFeatureI.getMarkerStyleOrientation());
                    }
                }
                float_ = new Rectangle2D.Float(n8 - 4, n9 - 4, 9.0f, 9.0f);
                try {
                    object3 = styledFeatureI.getRenderingRules();
                    if (object3 == null) {
                        bucketStyle.applyToSVG(null, sVGMap, float_, 3, styledFeatureI.getRenderableAttributes(), null, string, null, sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, (String)((Object)shape), styleModifiers);
                        break block74;
                    }
                    n7 = 0;
                    for (n6 = 0; n6 < ((RenderingRule[])object3).length; ++n6) {
                        object2 = object3[n6].getStyleName();
                        if (object2 == null || !((String)object2).equalsIgnoreCase(styledFeatureI.getFeatureStyleName())) continue;
                        object = null;
                        if (object3[n6].getSubStyleName() != null) {
                            object = MapMaker.getStyleWithName(object3[n6].getSubStyleName(), styledFeatureI.getDataSource(), visContext);
                            object.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                        }
                        bucketStyle.applyToSVG(null, sVGMap, float_, 3, styledFeatureI.getRenderableAttributes(), null, string, null, sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, (String)((Object)shape), object3[n6].getStyleColumns(), (Style)object, object3[n6].getSubStyleColumns(), object3[n6].getSubStyleChangeProperty(), null);
                        n7 = 1;
                        break;
                    }
                    if (n7 != 0) break block74;
                    bucketStyle.applyToSVG(null, sVGMap, float_, 3, styledFeatureI.getRenderableAttributes(), null, string, null, sVGMap.renderLayersOnly() ? styledFeatureI.getAttributeListStr() : styledFeatureI.getInfoStr(), d, bl, (String)((Object)shape), null);
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                finally {
                    Style style2 = bucketStyle.getDefaultStyle();
                    if (style2 != null && style2 instanceof StyleMarker) {
                        ((StyleMarker)style2).resetOrientation();
                    }
                    for (n7 = 0; n7 < bucketStyle.getNumBuckets(); ++n7) {
                        Style style3 = (Style)bucketStyle.getBucket(n7).getRenderStyle();
                        if (style3 == null || !(style3 instanceof StyleMarker)) continue;
                        ((StyleMarker)style3).resetOrientation();
                    }
                }
            }
            visContext.getCRArray().insert(float_);
            styledFeatureI.setShpMBR(float_);
            return;
        }
        catch (ClassCastException classCastException) {
            Object object;
            RenderingRule[] renderingRuleArray = styledFeatureI.getRenderingRules();
            String[] stringArray = null;
            if (renderingRuleArray != null) {
                for (int i = 0; i < renderingRuleArray.length; ++i) {
                    object = renderingRuleArray[i].getStyleName();
                    if (object == null || !((String)object).equalsIgnoreCase(styledFeatureI.getFeatureStyleName())) continue;
                    stringArray = renderingRuleArray[i].getStyleColumns();
                    break;
                }
            }
            try {
                int n10;
                PieChartStyle pieChartStyle = (PieChartStyle)style;
                object = styledFeatureI.getShape();
                Point2D point2D2 = null;
                point2D2 = styledFeatureI.getPoint();
                try {
                    pieChartStyle.apply(visContext, sVGMap, null, 0, string, point2D2, null, styledFeatureI.getRenderableAttributes(), stringArray, null);
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                int n11 = (int)point2D2.getX();
                int n12 = (int)point2D2.getY();
                int n13 = n10 = (int)((double)pieChartStyle.getPieRadius() * 2.5);
                visContext.getCRArray().insert(n11 - n10 / 2, n12 - n13 / 2, n10, n13);
                return;
            }
            catch (ClassCastException classCastException2) {
                block75: {
                    try {
                        VariableMarkerStyle variableMarkerStyle = (VariableMarkerStyle)style;
                        object = styledFeatureI.getShape();
                        Point2D point2D3 = null;
                        point2D3 = styledFeatureI.getPoint();
                        Field[] fieldArray = styledFeatureI.getRenderableAttributes();
                        StyleMarker styleMarker = (StyleMarker)variableMarkerStyle.chooseStyle(fieldArray[0]);
                        if (styleMarker == null) {
                            log.warning("cannot find a suitable variable marker style based on your values [" + fieldArray[0] + "].");
                            break block75;
                        }
                        styleMarker.setOrientation(styledFeatureI.getMarkerStyleOrientation());
                        try {
                            variableMarkerStyle.apply(visContext, sVGMap, null, 0, string, point2D3, null, styledFeatureI.getRenderableAttributes(), null);
                        }
                        catch (Exception exception) {
                            log.warning(exception.getMessage());
                        }
                        finally {
                            styleMarker.resetOrientation();
                        }
                        int n14 = styleMarker.getDesiredWidth();
                        int n15 = styleMarker.getDesiredHeight();
                        int n16 = (int)point2D3.getX();
                        int n17 = (int)point2D3.getY();
                        visContext.getCRArray().insert(n16 - n14 / 2, n17 - n15 / 2, n14, n15);
                    }
                    catch (ClassCastException classCastException3) {
                        log.severe(RSBundle.getMsg("MAPVIEWER-01006"));
                    }
                }
                return;
            }
        }
    }

    private void renderRadiusToSVG(SVGMap sVGMap, StyledFeatureI styledFeatureI, double d, VisContext visContext) {
        Point2D point2D = styledFeatureI.getPoint();
        if (point2D != null) {
            StyleColor styleColor = new StyleColor(null, Color.red);
            StyledFeature styledFeature = new StyledFeature();
            double[] dArray = styledFeatureI.getGeometry().getMBR();
            double[] dArray2 = new double[4];
            double[] dArray3 = styledFeatureI.getRadius();
            for (int i = 0; i < dArray3.length; ++i) {
                double d2 = dArray3[i];
                dArray2[0] = dArray[0] - d2;
                dArray2[1] = dArray[1] - d2;
                dArray2[2] = dArray[0] + d2;
                dArray2[3] = dArray[1] + d2;
                visContext.getAffineXF().transform(dArray2, 0, dArray2, 0, 2);
                Ellipse2D.Double double_ = new Ellipse2D.Double(Math.min(dArray2[0], dArray2[2]), Math.min(dArray2[1], dArray2[3]), Math.abs(dArray2[2] - dArray2[0]), Math.abs(dArray2[3] - dArray2[1]));
                styledFeature.setShape(double_);
                styledFeature.setFeatureStyle(styleColor);
                styledFeature.setGeomType(2);
                this.renderStyledFeatureToSVG(sVGMap, styledFeature, d, false, visContext);
            }
        }
    }

    public void label(SVGMap sVGMap, Theme theme, VisContext visContext) {
        if (!visContext.renderSVGLabels()) {
            return;
        }
        if (theme.getDecorator().isClickable()) {
            return;
        }
        if (!theme.getDecorator().isRenderLabels()) {
            return;
        }
        float[] fArray = new float[6];
        StyledFeatureI styledFeatureI = null;
        long l = System.currentTimeMillis();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < theme.size(); ++i) {
            styledFeatureI = theme.getStyledFeature(i);
            if (styledFeatureI == null) continue;
            for (int j = 0; j < 6; ++j) {
                fArray[j] = 0.0f;
            }
            if (styledFeatureI.getLabel() != null) {
                Style style = styledFeatureI.getLabelStyle();
                if (style == null) {
                    style = MapMaker.getStyleWithName(styledFeatureI.getLabelStyleName(), styledFeatureI.getDataSource(), visContext);
                }
                if (style == null) {
                    style = StyleFactory.getDefaultTextStyle();
                }
                if (style.getModel().getType() == 5) {
                    StyleText styleText = (StyleText)style;
                    if (!(bl2 || styledFeatureI.getGeomType() != 2 && styledFeatureI.getGeomType() != 6)) {
                        string = sVGMap.addLineLabelGroupForTheme(styleText, theme.getDecorator().isFixedSVGLabel());
                        bl2 = true;
                    } else if (!bl3) {
                        string = sVGMap.addLabelGroupForTheme(styleText, theme.getName());
                        bl3 = true;
                    }
                } else if (!bl3) {
                    string = sVGMap.addLabelGroupForTheme(null, theme.getName());
                    bl3 = true;
                }
            }
            if (styledFeatureI.getLabel() == null || styledFeatureI.getLabel().length() <= 0) continue;
            this.labelStyledFeature(sVGMap, styledFeatureI, fArray, theme.getDecorator().isLabelAlwaysOn(), theme.getDecorator().isFixedSVGLabel(), visContext);
        }
        if (string != null) {
            if (bl2) {
                sVGMap.closeLineLabelGroup();
            }
            if (bl3) {
                sVGMap.closeLabelGroup();
            }
        }
        long l2 = System.currentTimeMillis();
        log.finer("time to label theme " + theme.getName() + " with " + theme.size() + " styled features: " + (l2 - l) + "ms");
    }

    private void labelStyledFeature(SVGMap sVGMap, StyledFeatureI styledFeatureI, float[] fArray, boolean bl, boolean bl2, VisContext visContext) {
        Style style = null;
        style = styledFeatureI.getLabelStyle();
        if (style == null) {
            style = MapMaker.getStyleWithName(styledFeatureI.getLabelStyleName(), styledFeatureI.getDataSource(), visContext);
        }
        if (style == null) {
            style = StyleFactory.getDefaultTextStyle();
        }
        SVGLabelHelper.labelStyledFeature(sVGMap, styledFeatureI, style, fArray, bl, bl2, visContext.getDeviceWindow());
    }

    private static boolean contains(VisContext visContext, double d, double d2, int n, int n2) {
        double d3 = d - (double)(n / 2) - 1.0;
        double d4 = d2 - (double)(n2 / 2) - 1.0;
        return visContext.getDeviceWindow().contains(d3, d4, n += 2, n2 += 2);
    }

    public static void applyFeatureRR(StyledFeatureI styledFeatureI, RenderingRule[] renderingRuleArray, Shape shape, Style style, VisContext visContext, Graphics2D graphics2D, Point2D point2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Object object;
        Style style2;
        String string;
        int n;
        if (renderingRuleArray == null || renderingRuleArray.length == 0) {
            return;
        }
        Point2D point2D2 = null;
        if (style instanceof VariablePieChartStyle) {
            point2D2 = point2D;
        }
        boolean bl = false;
        for (n = 0; n < renderingRuleArray.length; ++n) {
            string = renderingRuleArray[n].getStyleName();
            if (string == null || !string.equalsIgnoreCase(styledFeatureI.getFeatureStyleName())) continue;
            style2 = null;
            if (renderingRuleArray[n].getSubStyleName() != null) {
                style2 = MapMaker.getStyleWithName(renderingRuleArray[n].getSubStyleName(), styledFeatureI.getDataSource(), visContext);
                style2.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                if (visContext.isPDFformatRequest()) {
                    VectorRenderer.checkRegisterTTFforPDF(renderingRuleArray[n].getSubStyleName(), style2, styledFeatureI.getDataSource(), graphics2D);
                }
            }
            if ((styledFeatureI.getGeomType() == 2 || styledFeatureI.getGeomType() == 6) && style instanceof StyleLine && ((StyleLine)style).supportCasedLine()) {
                object = visContext.getCasedLines();
                ((CasedLineHelper)object).addStyledFeature(styledFeatureI, shape, style);
            } else if (VectorRenderer.isNativeBucketStyle(style)) {
                ((BucketStyle)style).applyDeferringCasedLines(graphics2D, shape, styledFeatureI.getGeomType(), null, point2D2, visContext.getCRArray(), styledFeatureI.getRenderableAttributes(), renderingRuleArray[n].getStyleColumns(), style2, renderingRuleArray[n].getSubStyleColumns(), renderingRuleArray[n].getSubStyleChangeProperty(), styleModifiers, visContext, styledFeatureI);
            } else {
                style.apply(visContext, graphics2D, shape, styledFeatureI.getGeomType(), null, point2D2, visContext.getCRArray(), styledFeatureI.getRenderableAttributes(), renderingRuleArray[n].getStyleColumns(), style2, renderingRuleArray[n].getSubStyleColumns(), renderingRuleArray[n].getSubStyleChangeProperty(), styleModifiers);
            }
            bl = true;
            break;
        }
        if (!bl) {
            if ((styledFeatureI.getGeomType() == 2 || styledFeatureI.getGeomType() == 6) && style instanceof StyleLine && ((StyleLine)style).supportCasedLine()) {
                CasedLineHelper casedLineHelper = visContext.getCasedLines();
                casedLineHelper.addStyledFeature(styledFeatureI, shape, style);
            } else if (VectorRenderer.isNativeBucketStyle(style)) {
                ((BucketStyle)style).applyDeferringCasedLines(graphics2D, shape, styledFeatureI.getGeomType(), null, point2D2, visContext.getCRArray(), styledFeatureI.getRenderableAttributes(), styleModifiers, visContext, styledFeatureI);
            } else {
                style.apply(visContext, graphics2D, shape, styledFeatureI.getGeomType(), null, point2D2, (ConflictResolver)visContext.getCRArray(), styledFeatureI.getRenderableAttributes(), styleModifiers);
            }
        }
        for (n = 0; n < renderingRuleArray.length; ++n) {
            string = renderingRuleArray[n].getStyleName();
            if (string != null && string.equalsIgnoreCase(styledFeatureI.getFeatureStyleName()) || (style2 = MapMaker.getStyleWithName(string, styledFeatureI.getDataSource(), visContext)) == null) continue;
            style2.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
            if (visContext.isPDFformatRequest()) {
                VectorRenderer.checkRegisterTTFforPDF(string, style2, styledFeatureI.getDataSource(), graphics2D);
            }
            object = null;
            if (renderingRuleArray[n].getSubStyleName() != null) {
                object = MapMaker.getStyleWithName(renderingRuleArray[n].getSubStyleName(), styledFeatureI.getDataSource(), visContext);
                object.resolveStyles(DSManager.getStyleCache(styledFeatureI.getDataSource()), visContext.getDynamicStyles());
                if (visContext.isPDFformatRequest()) {
                    VectorRenderer.checkRegisterTTFforPDF(renderingRuleArray[n].getSubStyleName(), (Style)object, styledFeatureI.getDataSource(), graphics2D);
                }
            }
            StyleModifiers styleModifiers2 = style2.convertToPixelSize(visContext);
            point2D2 = null;
            if (style2 instanceof VariablePieChartStyle) {
                point2D2 = point2D;
            }
            if ((styledFeatureI.getGeomType() == 2 || styledFeatureI.getGeomType() == 6) && style2 instanceof StyleLine && ((StyleLine)style2).supportCasedLine()) {
                CasedLineHelper casedLineHelper = visContext.getCasedLines();
                casedLineHelper.addStyledFeature(styledFeatureI, shape, style2);
                continue;
            }
            if (VectorRenderer.isNativeBucketStyle(style2)) {
                ((BucketStyle)style2).applyDeferringCasedLines(graphics2D, shape, styledFeatureI.getGeomType(), null, point2D2, visContext.getCRArray(), styledFeatureI.getRenderableAttributes(), renderingRuleArray[n].getStyleColumns(), (Style)object, renderingRuleArray[n].getSubStyleColumns(), renderingRuleArray[n].getSubStyleChangeProperty(), styleModifiers2, visContext, styledFeatureI);
                continue;
            }
            style2.apply(visContext, graphics2D, shape, styledFeatureI.getGeomType(), null, point2D2, visContext.getCRArray(), styledFeatureI.getRenderableAttributes(), renderingRuleArray[n].getStyleColumns(), (Style)object, renderingRuleArray[n].getSubStyleColumns(), renderingRuleArray[n].getSubStyleChangeProperty(), styleModifiers2);
        }
    }

    private static boolean isNativeBucketStyle(Style style) {
        if (style == null) {
            return false;
        }
        return style instanceof BucketStyle && !(style instanceof ColorSchemeStyle) && !(style instanceof VariableMarkerStyle) && !(style instanceof VariablePieChartStyle);
    }

    private static Rectangle2D getPointFeatureMbr(Point2D point2D, StyledFeatureI styledFeatureI, BucketStyle bucketStyle, RenderingRule[] renderingRuleArray, StyleModifiers styleModifiers) {
        if (point2D == null || bucketStyle == null) {
            return null;
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        Rectangle2D.Float float_ = null;
        if (!(bucketStyle instanceof ColorSchemeStyle) && !(bucketStyle instanceof VariablePieChartStyle) && styledFeatureI.getRenderableAttributes() != null && styledFeatureI.getRenderableAttributes().length > 0) {
            Object object;
            String[] stringArray = null;
            if (renderingRuleArray != null && renderingRuleArray.length > 0) {
                for (int i = 0; i < renderingRuleArray.length; ++i) {
                    object = renderingRuleArray[i].getStyleName();
                    if (object == null || !((String)object).equalsIgnoreCase(styledFeatureI.getFeatureStyleName())) continue;
                    stringArray = renderingRuleArray[i].getStyleColumns();
                    break;
                }
            }
            BucketStyle.BucketDescription bucketDescription = null;
            if (stringArray == null) {
                bucketDescription = bucketStyle.chooseRenderStyle(styledFeatureI.getRenderableAttributes()[0], styleModifiers);
            } else {
                object = new Field[]{null};
                void var13_18 = stringArray[0];
                object[0] = Util.getField((String)var13_18, styledFeatureI.getRenderableAttributes());
                if (object[0] != null) {
                    bucketDescription = bucketStyle.chooseRenderStyle((Field)object[0], styleModifiers);
                }
            }
            if (bucketDescription != null && bucketDescription.style != null && bucketDescription.style instanceof StyleMarker) {
                double d3 = ((StyleMarker)bucketDescription.style).getDoubleDesiredWidth();
                double d4 = ((StyleMarker)bucketDescription.style).getDoubleDesiredHeight();
                if (bucketDescription.styleMods != null && bucketDescription.styleMods instanceof MarkerStyleModifiers) {
                    d3 = ((MarkerStyleModifiers)bucketDescription.styleMods).getWidth();
                    d4 = ((MarkerStyleModifiers)bucketDescription.styleMods).getHeight();
                }
                if (d3 > 0.0 && d4 > 0.0) {
                    float_ = new Rectangle2D.Float((float)(d - d3 / 2.0), (float)(d2 - d4 / 2.0), (float)d3, (float)d4);
                }
            }
        } else if (bucketStyle instanceof VariablePieChartStyle && styledFeatureI.getRenderableAttributes() != null && styledFeatureI.getRenderableAttributes().length > 0) {
            Object object;
            int n;
            Field[] fieldArray = styledFeatureI.getRenderableAttributes();
            String[] stringArray = null;
            if (renderingRuleArray != null && renderingRuleArray.length > 0) {
                for (int i = 0; i < renderingRuleArray.length; ++i) {
                    String string = renderingRuleArray[i].getStyleName();
                    if (string == null || !string.equalsIgnoreCase(styledFeatureI.getFeatureStyleName())) continue;
                    stringArray = renderingRuleArray[i].getStyleColumns();
                    break;
                }
            }
            if (stringArray != null) {
                Field[] fieldArray2 = null;
                int n2 = ((VariablePieChartStyleModel)bucketStyle.getModel()).getNumSlices();
                if (stringArray.length < n2) {
                    log.warning("Not enough style columns for VariablePieChartStyle to compute point feature mbr.");
                } else {
                    fieldArray2 = new Field[n2];
                    for (n = 0; n < stringArray.length; ++n) {
                        fieldArray2[n] = null;
                        object = stringArray[n];
                        fieldArray2[n] = Util.getField((String)object, fieldArray);
                        if (fieldArray2[n] != null) continue;
                        log.warning("Unable to find attribute " + (String)object + " for VariablePieChartStyle while computing point feature mbr.");
                        fieldArray2 = null;
                        break;
                    }
                }
                fieldArray = fieldArray2;
            }
            if (fieldArray != null) {
                double d5 = 0.0;
                for (n = 0; n < fieldArray.length; ++n) {
                    if (fieldArray[n].getShortJavaTypeName().equalsIgnoreCase("string")) {
                        try {
                            d5 += Double.parseDouble(fieldArray[n].getString());
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    d5 += fieldArray[n].getDouble();
                }
                Field field = new Field(d5);
                object = bucketStyle.chooseRenderStyle(field, styleModifiers);
                if (object != null && ((BucketStyle.BucketDescription)object).style != null && ((BucketStyle.BucketDescription)object).style instanceof PieChartStyle) {
                    double d6;
                    double d7 = d6 = (double)((PieChartStyle)((BucketStyle.BucketDescription)object).style).getPieRadius() * 2.5;
                    if (((BucketStyle.BucketDescription)object).styleMods != null && ((BucketStyle.BucketDescription)object).styleMods instanceof PieChartStyleModifiers) {
                        d7 = d6 = (double)((PieChartStyleModifiers)((BucketStyle.BucketDescription)object).styleMods).getPieRadius() * 2.5;
                    }
                    if (d6 > 0.0 && d7 > 0.0) {
                        float_ = new Rectangle2D.Float((float)(d - d6 / 2.0), (float)(d2 - d7 / 2.0), (float)d6, (float)d7);
                    }
                }
            }
        }
        return float_;
    }

    private static Point2D getChartPointForPolygon(Style style, VisContext visContext, StyledFeatureI styledFeatureI, Shape shape) {
        float[] fArray = null;
        Point2D.Double double_ = new Point2D.Double(-999.0, -999.0);
        int n = 5;
        int n2 = 5;
        Rectangle2D rectangle2D = visContext.getDeviceWindow();
        if (style instanceof BarChartStyle || style instanceof PieChartStyle) {
            fArray = LabelHelper.findLoc4RectInPolygon(shape, 5.0, 5.0, visContext.getCRArray(), true, false, null);
            if (style instanceof BarChartStyle) {
                n = ((BarChartStyleModel)style.getModel()).getHeight();
                n2 = ((BarChartStyleModel)style.getModel()).getWidth();
            }
            if (style instanceof PieChartStyle) {
                n2 = n = 2 * ((PieChartStyleModel)style.getModel()).getPieRadius();
            }
        } else if (style instanceof VariablePieChartStyle) {
            Field[] fieldArray = styledFeatureI.getAttributes();
            if (fieldArray == null) {
                return null;
            }
            double d = 0.0;
            for (int i = 0; i < fieldArray.length; ++i) {
                if (fieldArray[i].getShortJavaTypeName().equalsIgnoreCase("string")) {
                    try {
                        d += Double.parseDouble(fieldArray[i].getString());
                        continue;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                d += fieldArray[i].getDouble();
            }
            Field field = new Field(d);
            Style style2 = ((BucketStyle)style).chooseStyle(field);
            if (style == null) {
                return null;
            }
            n2 = n = 2 * ((PieChartStyleModel)style2.getModel()).getPieRadius();
        }
        if ((double)fArray[0] <= rectangle2D.getMinX() || (double)fArray[0] > rectangle2D.getMaxX() || (double)fArray[1] <= rectangle2D.getMinY() || (double)fArray[1] > rectangle2D.getMaxY()) {
            return double_;
        }
        if ((double)(fArray[0] - (float)(n2 / 2)) <= rectangle2D.getMinX()) {
            fArray[0] = (float)(rectangle2D.getMinX() + (double)(n2 / 2) + 1.0);
        }
        if ((double)(fArray[1] - (float)(n / 2)) <= rectangle2D.getMinY()) {
            fArray[1] = (float)(rectangle2D.getMinY() + (double)(n / 2) + 1.0);
        }
        if ((double)(fArray[0] + (float)(n2 / 2)) >= rectangle2D.getMaxX()) {
            fArray[0] = (float)(rectangle2D.getMaxX() - (double)(n2 / 2) - 1.0);
        }
        if ((double)(fArray[1] + (float)(n / 2)) >= rectangle2D.getMaxY()) {
            fArray[1] = (float)(rectangle2D.getMaxY() - (double)(n / 2) - 1.0);
        }
        return new Point2D.Double(fArray[0], fArray[1]);
    }

    public boolean isHeatMapTheme(Theme theme, VisContext visContext) {
        return ThemeUtils.isHeatMapTheme(theme.getDefinition(), visContext);
    }

    public static void checkRegisterTTFforPDF(String string, Style style, String string2, Graphics2D graphics2D) {
        String string3 = PDFTTFcache.getTemporaryDirectory();
        if (style == null || string2 == null || string3 == null) {
            return;
        }
        if (graphics2D != null && graphics2D instanceof XDOGraphics2D && string != null) {
            DataSourceI dataSourceI = DSManager.get(string2);
            if (dataSourceI == null) {
                return;
            }
            if (style instanceof StyleMarker || style instanceof StyleText) {
                String string4 = dataSourceI.getOwner();
                String string5 = string;
                if (string.indexOf(58) > 0) {
                    int n = string.indexOf(58);
                    string4 = string.substring(0, n);
                    string5 = string.substring(n + 1, string.length());
                }
                VectorRenderer.registerTTFforPDF(style, string2, string4, graphics2D);
            }
        }
    }

    private static void registerTTFforPDF(Style style, String string, String string2, Graphics2D graphics2D) {
        Object object;
        String string3 = PDFTTFcache.getTemporaryDirectory();
        if (style == null || graphics2D == null || string3 == null || string == null || string2 == null) {
            return;
        }
        if (!(graphics2D instanceof XDOGraphics2D)) {
            return;
        }
        Font font = null;
        if (style instanceof StyleMarker) {
            object = (StyleMarker)style;
            if (((MarkerStyleModel)((StyleMarker)object).getModel()).getMarkerType() == 6) {
                font = ((MarkerStyleModel)((StyleMarker)object).getModel()).getTruetypeFont().getFont();
            }
        } else if (style instanceof StyleText && ((TextStyleModel)((StyleText)(object = (StyleText)style)).getModel()).getEmbeddedTTFont() != null) {
            font = ((TextStyleModel)((StyleText)object).getModel()).getFont();
        }
        if (font == null) {
            return;
        }
        object = font.getFontName();
        if (object == null) {
            return;
        }
        String string4 = PDFTTFcache.getFilePathForTTF((String)object);
        String string5 = string + "_" + string2 + "_-_";
        String string6 = ((String)object).replaceAll(" ", "-_-");
        string5 = string5.toLowerCase() + string6 + ".ttf";
        if (string4 == null || !string4.equalsIgnoreCase(string3 + string5)) {
            PDFTTFcache.registerTTF((String)object, string5, (XDOGraphics2D)graphics2D);
        }
    }
}

