/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.cache;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import oracle.sdovis.cache.MVHashMap;

class MVLinkedHashMap
extends MVHashMap {
    private transient Entry header;
    private final boolean accessOrder;

    public MVLinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
    }

    public MVLinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
    }

    public MVLinkedHashMap() {
        this.accessOrder = false;
    }

    public MVLinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
    }

    void init() {
        this.header.before = this.header.after = (this.header = new Entry(-1, null, null, null, 0));
    }

    void transfer(MVHashMap.Entry[] entryArray) {
        int n = entryArray.length;
        Entry entry = this.header.after;
        while (entry != this.header) {
            int n2 = MVLinkedHashMap.indexFor(entry.hash, n);
            entry.next = entryArray[n2];
            entryArray[n2] = entry;
            entry = entry.after;
        }
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.after;
            }
        } else {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.after;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Entry entry = (Entry)this.getEntry(object);
        if (entry == null) {
            return null;
        }
        entry.recordAccess(this);
        return entry.value;
    }

    public void clear() {
        super.clear();
        this.header.before = this.header.after = this.header;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    void addEntry(int n, Object object, Object object2, int n2, int n3) {
        this.createEntry(n, object, object2, n2, n3);
        Entry entry = this.header.after;
        if (this.removeEldestEntry(entry)) {
            this.removeEntryForKey(entry.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, Object object, Object object2, int n2, int n3) {
        Entry entry = new Entry(n, object, object2, this.table[n2], n3);
        this.table[n2] = entry;
        entry.addBefore(this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry entry) {
        return false;
    }

    private class EntryIterator
    extends LinkedHashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends LinkedHashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIterator
    implements Iterator {
        Entry nextEntry;
        Entry lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((MVLinkedHashMap)MVLinkedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = MVLinkedHashMap.this.modCount;
        }

        public boolean hasNext() {
            return this.nextEntry != MVLinkedHashMap.this.header;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (MVLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            MVLinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = MVLinkedHashMap.this.modCount;
        }

        Entry nextEntry() {
            if (MVLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == MVLinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            Entry entry = this.lastReturned = this.nextEntry;
            this.nextEntry = entry.after;
            return entry;
        }
    }

    public static class Entry
    extends MVHashMap.Entry {
        Entry before;
        Entry after;

        Entry(int n, Object object, Object object2, MVHashMap.Entry entry, int n2) {
            super(n, object, object2, entry, n2);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry entry) {
            this.after = entry;
            this.before = entry.before;
            this.before.after = this;
            this.after.before = this;
        }

        void recordAccess(MVHashMap mVHashMap) {
            MVLinkedHashMap mVLinkedHashMap = (MVLinkedHashMap)mVHashMap;
            if (mVLinkedHashMap.accessOrder) {
                ++mVLinkedHashMap.modCount;
                this.remove();
                this.addBefore(mVLinkedHashMap.header);
            }
        }

        void recordRemoval(MVHashMap mVHashMap) {
            this.remove();
        }
    }
}

