/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.cache;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.cache.MVHashMap;
import oracle.sdovis.cache.PermCacheGroup;

public class SubRegion
extends MVHashMap {
    private String name;
    private Hashtable groups;
    long memSize;

    public SubRegion(String string) {
        this.name = string;
        this.groups = new Hashtable(37, 0.85f);
    }

    public CacheGroup createNewGroup(String string, int n, boolean bl) {
        CacheGroup cacheGroup = null;
        n = n <= 0 ? 256 : n;
        cacheGroup = bl ? new PermCacheGroup(string, n, 0.95f) : new CacheGroup(string, n, 0.95f);
        this.groups.put(string, cacheGroup);
        return cacheGroup;
    }

    public void removeGroup(String string) {
        if (string == null) {
            return;
        }
        CacheGroup cacheGroup = (CacheGroup)this.groups.get(string);
        if (cacheGroup != null) {
            cacheGroup.clear();
        }
        this.groups.remove(string);
    }

    public CacheGroup getGroup(String string) {
        if (string == null) {
            return null;
        }
        return (CacheGroup)this.groups.get(string);
    }

    public void clear() {
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            CacheGroup cacheGroup = (CacheGroup)enumeration.nextElement();
            cacheGroup.clear();
        }
        this.groups.clear();
    }

    public void invalidate() {
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            CacheGroup cacheGroup = (CacheGroup)enumeration.nextElement();
            cacheGroup.clear();
        }
    }

    public boolean groupExists(String string) {
        return string == null ? false : this.groups.containsKey(string);
    }

    public long getMemorySize() {
        long l = 0L;
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            CacheGroup cacheGroup = (CacheGroup)enumeration.nextElement();
            if (cacheGroup == null) continue;
            l += cacheGroup.getMemorySize();
        }
        return l;
    }

    public String report(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string + "SubRegion " + this.name + ":\n");
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            CacheGroup cacheGroup = (CacheGroup)enumeration.nextElement();
            stringBuffer.append(cacheGroup.report(n + 1));
        }
        return stringBuffer.toString();
    }
}

