/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts.legend;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.Map;
import java.util.Vector;
import oracle.sdovis.charts.internal.Button;
import oracle.sdovis.charts.internal.Errorfcn;
import oracle.sdovis.charts.internal.LineMarker;
import oracle.sdovis.charts.internal.MsgUtil;
import oracle.sdovis.charts.types.ButtonDesc;
import oracle.sdovis.charts.types.ChartException;
import oracle.sdovis.charts.types.LegendDesc;

public class Legend2
extends Component {
    int yBaseline = 0;
    boolean drawLegendInternal = true;
    int maxLabelWidth = 0;
    int labelHeight = 0;
    LineMarker LM = new LineMarker();
    BasicStroke DefaultStroke = new BasicStroke(1.0f, 0, 2);
    int maxHeight = -1;
    private LegendDesc LDesc = new LegendDesc();
    int subchartHeight = -1;
    int Width = 0;
    int Height = 0;
    int BorderRight = 0;
    int BorderLeft = 0;
    int BorderTop = 0;
    int BorderBottom = 0;
    boolean UseReducedStrings = false;
    boolean isPieChart = false;
    Vector items = new Vector();
    Vector drawableItems = new Vector();
    private boolean legendOrderReverse = false;
    private boolean fontMetricsGot = false;
    private FontMetrics fontmet;
    int originX = 0;
    int originY = 0;
    int originX_setLocation = 0;
    int originY_setLocation = 0;
    int x_length = 15;
    int columns = 1;

    public void setYBaseline(int n) {
        this.yBaseline = n;
    }

    public void setSubchartHeight(int n) {
        this.subchartHeight = n;
    }

    public void setLegendDesc(LegendDesc legendDesc) {
        this.LDesc = legendDesc;
    }

    public LegendDesc getLegendDesc() {
        return this.LDesc;
    }

    public void setMaximumSize(int n, int n2) {
        this.Width = n;
        this.Height = n2;
    }

    public void setBorders(int n, int n2, int n3, int n4) {
        this.BorderLeft = n;
        this.BorderRight = n2;
        this.BorderTop = n3;
        this.BorderBottom = n4;
    }

    public void setPieChartType(boolean bl) {
        this.isPieChart = bl;
    }

    private void computeLabelHeight(Graphics2D graphics2D) {
        this.getLegendLabelHeight(graphics2D);
    }

    public int getLegendLabelHeight(Graphics2D graphics2D) {
        if (this.LDesc.getLegendTextAttributes() == null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.LDesc.getLegendFont());
            this.labelHeight = fontMetrics.getHeight();
        } else {
            AttributedString attributedString = new AttributedString("Temp", this.LDesc.getLegendTextAttributes());
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
            this.labelHeight = Math.round(textLayout.getAscent() + textLayout.getDescent());
        }
        return this.labelHeight;
    }

    public void setLegendOrderReverse() {
        this.legendOrderReverse = true;
    }

    public void setFontMetrics(Graphics2D graphics2D) {
        if (this.fontMetricsGot) {
            return;
        }
        this.fontmet = graphics2D.getFontMetrics(this.LDesc.getLegendFont());
        this.fontMetricsGot = true;
    }

    protected FontMetrics getFontMetrics() {
        return this.fontmet;
    }

    public void clearLegend() {
        this.UseReducedStrings = false;
        this.items.clear();
        this.drawableItems.clear();
    }

    public void setLegendDisableInternal() {
        this.drawLegendInternal = false;
    }

    public boolean getLegendDisableInternal() {
        return !this.drawLegendInternal;
    }

    public void setLegendEnableInternal() {
        this.drawLegendInternal = true;
    }

    public void setLegendMaxHeight(int n) {
        if (n > 0) {
            this.maxHeight = n;
        }
    }

    public void resetLegendAlignment() throws ChartException {
        this.setConfigureLegendAlignment(this.LDesc.getLegendAlignment());
    }

    public void resetLegendAlignment(Graphics2D graphics2D) throws ChartException {
        this.setConfigureLegendAlignment(graphics2D, this.LDesc.getLegendAlignment());
    }

    public void setLegendLocation(int n, int n2) {
        this.originX = n;
        this.originY = n2;
        this.originX_setLocation = n;
        this.originY_setLocation = n2;
    }

    public int getLegendX() {
        return this.originX;
    }

    public int getLegendY() {
        return this.originY;
    }

    public void setConfigureLegendAlignment(int n) throws ChartException {
        String string = "setConfigureLegendAlignment";
        if (this.isPieChart) {
            switch (n) {
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-300"));
                    break;
                }
            }
        } else if (!this.LDesc.getLegendInside()) {
            switch (n) {
                case 3: 
                case 4: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-301"));
                    break;
                }
            }
        } else {
            switch (n) {
                case -1: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-302"));
                }
            }
        }
        switch (n) {
            case 8: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.Width - this.getLegendWidth() - this.BorderRight + this.LDesc.getLegendOffsetX();
                this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                break;
            }
            case 9: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                    this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                    break;
                }
                this.originX = this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY();
                break;
            }
            case 7: {
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth()) / 2;
                this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                break;
            }
            case 5: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.Width - this.getLegendWidth() - this.BorderRight + this.LDesc.getLegendOffsetX();
                    this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                    break;
                }
                this.originX = this.Width - this.getLegendWidth() + this.LDesc.getLegendOffsetX();
                this.originY = this.Height - this.getLegendHeight() + this.LDesc.getLegendOffsetY();
                break;
            }
            case 11: {
                break;
            }
            case 10: {
                System.out.println("EASTBASELINE");
                this.originX = this.Width - this.getLegendWidth() + this.LDesc.getLegendOffsetX();
                if (this.Height - this.getLegendHeight() >= this.BorderBottom) {
                    this.originY = this.LDesc.getLegendOffsetY() + this.Height - this.getLegendHeight() - this.BorderBottom;
                    break;
                }
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 3: {
                System.out.println("EAST");
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.Width - this.getLegendWidth() - this.BorderRight + this.LDesc.getLegendOffsetX();
                    this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                    break;
                }
                this.originX = this.Width - this.getLegendWidth() + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 6: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                break;
            }
            case 4: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth()) / 2;
                    this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                    break;
                }
                int n2 = this.Width - this.BorderRight - this.BorderLeft;
                if (this.getLegendWidth() > n2) {
                    this.originX = (this.Width - this.getLegendWidth()) / 2;
                    if (this.originX < 0) {
                        this.originX = 0;
                    }
                } else {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth()) / 2;
                }
                this.originY = this.Height - this.getLegendHeight() + this.LDesc.getLegendOffsetY();
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("improper alignment: " + n);
            }
        }
    }

    public void setConfigureLegendAlignment(Graphics2D graphics2D, int n) throws ChartException {
        String string = "setConfigureLegendAlignmentg2 ";
        if (this.isPieChart) {
            switch (n) {
                case -1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-300"));
                    break;
                }
            }
        } else if (!this.LDesc.getLegendInside()) {
            switch (n) {
                case 3: 
                case 4: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-301"));
                    break;
                }
            }
        } else {
            switch (n) {
                case -1: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    Errorfcn.chartError("setAlignment()", MsgUtil.getMsg("CHT-302"));
                }
            }
        }
        switch (n) {
            case 8: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.Width - this.getLegendWidth(graphics2D) - this.BorderRight + this.LDesc.getLegendOffsetX();
                this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                break;
            }
            case 9: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                    this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                    break;
                }
                this.originX = this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY();
                break;
            }
            case 7: {
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth(graphics2D)) / 2;
                this.originY = this.BorderTop + this.LDesc.getLegendOffsetY();
                break;
            }
            case 5: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.Width - this.getLegendWidth(graphics2D) - this.BorderRight + this.LDesc.getLegendOffsetX();
                    this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                    break;
                }
                this.originX = this.Width - this.getLegendWidth(graphics2D) + this.LDesc.getLegendOffsetX();
                this.originY = this.Height - this.getLegendHeight() + this.LDesc.getLegendOffsetY();
                break;
            }
            case 11: {
                if (this.subchartHeight <= 0) break;
                this.originY = this.originY_setLocation + (this.subchartHeight - this.getLegendHeight()) / 2;
                break;
            }
            case 10: {
                this.originX = this.Width - this.getLegendWidth(graphics2D) + this.LDesc.getLegendOffsetX();
                if (this.Height - this.getLegendHeight() >= this.BorderBottom) {
                    this.originY = this.LDesc.getLegendOffsetY() + this.Height - this.getLegendHeight() - this.BorderBottom;
                    break;
                }
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 3: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.Width - this.getLegendWidth(graphics2D) - this.BorderRight + this.LDesc.getLegendOffsetX();
                    this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                    break;
                }
                this.originX = this.Width - this.getLegendWidth(graphics2D) + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case 6: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                break;
            }
            case 4: {
                if (this.LDesc.getLegendInside()) {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth(graphics2D)) / 2;
                    this.originY = this.Height - this.getLegendHeight() - this.BorderBottom + this.LDesc.getLegendOffsetY();
                    break;
                }
                int n2 = this.Width - this.BorderRight - this.BorderLeft;
                if (this.getLegendWidth(graphics2D) > n2) {
                    this.originX = (this.Width - this.getLegendWidth(graphics2D)) / 2;
                    if (this.originX < 0) {
                        this.originX = 0;
                    }
                } else {
                    this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX() + (this.Width - this.BorderLeft - this.BorderRight - this.getLegendWidth(graphics2D)) / 2;
                }
                this.originY = this.Height - this.getLegendHeight() + this.LDesc.getLegendOffsetY();
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                if (!this.LDesc.getLegendInside()) break;
                this.originX = this.BorderLeft + this.LDesc.getLegendOffsetX();
                this.originY = this.LDesc.getLegendOffsetY() + (this.Height - this.getLegendHeight()) / 2;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("improper alignment: " + n);
            }
        }
    }

    public void setAddLegendItem(String string, Color color) {
        this.items.addElement(new LegendElement(string, color));
    }

    public void setAddLegendItem(String string, Color color, int n, Color color2, BasicStroke basicStroke) {
        this.items.addElement(new LegendElement(string, color, n, color2, basicStroke));
    }

    public void setDeleteLegendItem(String string) {
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            String string2 = legendElement.label;
            if (!string2.equals(string)) continue;
            this.items.removeElement(legendElement);
        }
    }

    public void setUpdateLegendItemXLink(String string, String string2) {
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            String string3 = legendElement.label;
            if (!string3.equals(string)) continue;
            legendElement.svgXLink = string2;
        }
    }

    private void copyDrawable() {
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            if (!legendElement.drawElement) continue;
            this.drawableItems.addElement(legendElement);
        }
    }

    public void setLegendItemColor(String string, Color color) {
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            String string2 = legendElement.label;
            if (!string2.equals(string)) continue;
            legendElement.color = color;
        }
    }

    public void setLegendSVGScript(String string, String string2) {
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            String string3 = legendElement.label;
            if (!string3.equals(string)) continue;
            legendElement.userSVGScript = string2;
        }
    }

    public void setLegendLabelColor(String string, Color color) {
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            String string2 = legendElement.label;
            if (!string2.equals(string)) continue;
            legendElement.labelColor = color;
        }
    }

    public void setLegendItemMarker(String string, Color color, int n, Color color2, BasicStroke basicStroke) {
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            String string2 = legendElement.label;
            if (!string2.equals(string)) continue;
            legendElement.color = color;
            legendElement.markerType = n;
            legendElement.markerColor = color2;
            legendElement.lineStroke = basicStroke;
        }
    }

    public boolean setLegendReduceWidth(int n) {
        int n2 = this.getLegendWidthNoText();
        if (n <= n2) {
            return false;
        }
        int n3 = n - n2;
        this.maxLabelWidth = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.LDesc.getLegendFont());
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            if (!legendElement.drawElement) continue;
            if (fontMetrics.stringWidth(legendElement.label) > n3) {
                int n4;
                int n5;
                this.UseReducedStrings = true;
                String string = "";
                for (n5 = legendElement.label.length() - 1; n5 >= 0 && (n4 = fontMetrics.stringWidth(string = legendElement.label.substring(0, n5 - 1))) > n3; --n5) {
                }
                if (n5 == 0) {
                    legendElement.labelReduced = "";
                    continue;
                }
                legendElement.labelReduced = string;
                continue;
            }
            legendElement.labelReduced = legendElement.label;
        }
        return true;
    }

    private void getMaxLabelWidth() {
        this.maxLabelWidth = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.LDesc.getLegendFont());
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            if (!legendElement.drawElement) continue;
            if (!this.UseReducedStrings) {
                if (this.maxLabelWidth >= fontMetrics.stringWidth(legendElement.label)) continue;
                this.maxLabelWidth = fontMetrics.stringWidth(legendElement.label);
                continue;
            }
            if (legendElement.labelReduced == null || this.maxLabelWidth >= fontMetrics.stringWidth(legendElement.labelReduced)) continue;
            this.maxLabelWidth = fontMetrics.stringWidth(legendElement.labelReduced);
        }
    }

    public void setLegendOffsetYInternal(int n) {
        this.LDesc.setLegendOffsetYInternal(n);
    }

    public void setLegendOffsetXInternal(int n) {
        this.LDesc.setLegendOffsetXInternal(n);
    }

    private int getXLeftOffset() {
        return this.labelHeight / 3;
    }

    private int getXRightOffset() {
        return this.labelHeight / 3;
    }

    private int getXTextEndOffset() {
        return this.labelHeight / 3;
    }

    private int getLegendWidthNoText() {
        return this.x_length + this.getXLeftOffset() + this.getXRightOffset() + this.getXTextEndOffset();
    }

    public int getLegendWidth() {
        if (!this.drawLegendInternal || this.LDesc.getLegendDisable()) {
            return 0;
        }
        this.getMaxLabelWidth();
        int n = this.columns * (this.getLegendWidthNoText() + this.maxLabelWidth);
        return n;
    }

    public int getLegendWidth(Graphics2D graphics2D) {
        if (!this.drawLegendInternal || this.LDesc.getLegendDisable()) {
            return 0;
        }
        this.getMaxLabelWidth();
        int n = this.columns * (this.getLegendWidthNoText() + this.maxLabelWidth);
        if (this.getButtonBarWidth(graphics2D) > n) {
            n = this.getButtonBarWidth(graphics2D);
        }
        return n;
    }

    public int getLegendColumnWidth() {
        this.getMaxLabelWidth();
        return this.getLegendWidthNoText() + this.maxLabelWidth;
    }

    public int getLegendNumItems() {
        return this.items.size();
    }

    private int getLegendNumItems2() {
        int n = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            if (!legendElement.drawElement) continue;
            ++n;
        }
        return n;
    }

    private int getRowCeil() {
        int n = this.getLegendNumItems2();
        if (this.columns == 1) {
            return n;
        }
        int n2 = n / this.columns;
        if (n % this.columns != 0) {
            ++n2;
        }
        return n2;
    }

    public int getRowCeilProjected(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return this.items.size();
        }
        int n2 = this.items.size() / n;
        if (this.items.size() % n != 0) {
            ++n2;
        }
        return n2;
    }

    private int getTitleHeight(int n) {
        if (this.LDesc.getLegendTitle() == null) {
            return 0;
        }
        if (this.LDesc.getLegendTitle() == "") {
            return 0;
        }
        return 1 * n;
    }

    public int getLegendHeight() {
        if (!this.drawLegendInternal || this.LDesc.getLegendDisable()) {
            return 0;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.LDesc.getLegendFont());
        this.labelHeight = fontMetrics.getHeight();
        int n = this.getTitleHeight(this.labelHeight);
        int n2 = this.getRowCeil();
        int n3 = n2 * this.labelHeight + this.labelHeight / 2;
        return n + n3;
    }

    public boolean reduceLegendElements() {
        if (this.maxHeight == -1) {
            return false;
        }
        int n = this.getLegendHeight();
        int n2 = this.items.size() - 1;
        if (n > this.maxHeight) {
            LegendElement legendElement;
            for (n2 = this.items.size() - 1; n2 >= 0; --n2) {
                legendElement = (LegendElement)this.items.elementAt(n2);
                if (legendElement.drawElement) break;
            }
            while (n > this.maxHeight && n2 >= 0) {
                legendElement = (LegendElement)this.items.elementAt(n2);
                legendElement.drawElement = false;
                n = this.getLegendHeight();
                --n2;
            }
            return n2 < this.items.size() - 1;
        }
        return false;
    }

    public void resetLegendReduce() {
        this.UseReducedStrings = false;
        for (int i = this.items.size() - 1; i >= 0; --i) {
            LegendElement legendElement = (LegendElement)this.items.elementAt(i);
            legendElement.drawElement = true;
        }
    }

    public int getLegendHeightProjected(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.LDesc.getLegendFont());
        int n2 = this.getRowCeilProjected(n);
        int n3 = n2 * this.labelHeight + this.labelHeight / 2;
        int n4 = this.getTitleHeight(this.labelHeight);
        return n3 + n4;
    }

    public Dimension getLegendSize() {
        return new Dimension(this.getLegendWidth(), this.getLegendHeight());
    }

    public void setLegendColumns(int n) {
        if (n > 0) {
            this.columns = n;
        }
    }

    public void drawLegendBuffer(Graphics2D graphics2D, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.copyDrawable();
        if (this.LDesc.getLegendDisable()) {
            return;
        }
        graphics2D.setFont(this.LDesc.getLegendFont());
        FontMetrics fontMetrics = this.getFontMetrics(this.LDesc.getLegendFont());
        this.computeLabelHeight(graphics2D);
        int n6 = this.originX + this.getXLeftOffset();
        int n7 = n6 + this.x_length;
        int n8 = this.getTitleHeight(this.labelHeight);
        int n9 = this.originY + 2 * this.labelHeight / 3 + n8;
        int n10 = this.getLegendHeight();
        int n11 = this.getLegendWidth(graphics2D);
        if (this.LDesc.getLegendInside() || this.LDesc.getLegendBackgroundEnabled()) {
            graphics2D.setColor(this.LDesc.getLegendBackground());
            graphics2D.fillRect(this.originX, this.originY, n11, n10);
        }
        if (this.LDesc.getLegendInside() && !this.LDesc.getLegendDisable()) {
            graphics2D.setColor(this.LDesc.getLegendEdgeColor());
            graphics2D.drawRect(this.originX, this.originY, n11, n10);
        } else if (!this.LDesc.getLegendInside() && this.LDesc.isEdgeColorSet()) {
            graphics2D.setColor(this.LDesc.getLegendEdgeColor());
            graphics2D.drawRect(this.originX, this.originY, n11, n10);
        }
        int n12 = this.labelHeight;
        int n13 = n7 - n6;
        int n14 = 2;
        int n15 = n14 / 2;
        int n16 = this.getLegendColumnWidth();
        int n17 = this.getRowCeil();
        int n18 = 0;
        this.LDesc.imageMapCoords = new int[this.drawableItems.size()][0];
        if (n8 > 0) {
            n5 = n6;
            n4 = this.originY + n8;
            graphics2D.drawString(this.LDesc.getLegendTitle(), n5, n4);
        }
        for (n5 = 0; n5 < this.getRowCeil(); ++n5) {
            for (n4 = 0; n4 < this.columns; ++n4) {
                Object object4;
                n18 = n17 > this.columns ? n4 * n17 + n5 : n5 * this.columns + n4;
                if (n18 >= this.drawableItems.size()) continue;
                LegendElement legendElement = this.legendOrderReverse ? (LegendElement)this.drawableItems.elementAt(this.drawableItems.size() - n18 - 1) : (LegendElement)this.drawableItems.elementAt(n18);
                int n19 = n6 + n4 * n16;
                n3 = n9 + n5 * n12 - n12 / 2;
                graphics2D.setColor(Color.green);
                if (legendElement.markerType == -1 || legendElement.markerType == 0) {
                    graphics2D.setColor(legendElement.color);
                    graphics2D.fillRect(n6 + n14 + n4 * n16, n9 + n5 * n12 - n12 / 2 + n14, n13 - 2 * n14, n12 - 2 * n14);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRect(n6 + n14 + n4 * n16, n9 + n5 * n12 - n12 / 2 + n14, n13 - 2 * n14, n12 - 2 * n14);
                } else {
                    graphics2D.setStroke(legendElement.lineStroke);
                    graphics2D.setColor(legendElement.color);
                    n2 = n9 + n5 * n12 + n15;
                    n = n6 + n14 + n4 * n16 + n13 / 2 - n14;
                    object3 = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    ((RenderingHints)object3).put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    object4 = graphics2D.getRenderingHints();
                    graphics2D.setRenderingHints((Map<?, ?>)object3);
                    graphics2D.drawLine(n6 + n14 + n4 * n16, n2, n6 + n14 + n4 * n16 + n13 - 2 * n14, n2);
                    graphics2D.setStroke(this.LM.getLineMarkerStroke(legendElement.markerType));
                    graphics2D.setColor(legendElement.markerColor);
                    this.LM.drawMarker(graphics2D, legendElement.markerType, 1.0, n, n2);
                    graphics2D.setStroke(this.DefaultStroke);
                    graphics2D.setRenderingHints((Map<?, ?>)object4);
                }
                n2 = n7 + this.getXRightOffset() + n4 * n16;
                n = n9 + n5 * n12 + n12 / 3;
                object3 = null;
                object4 = legendElement.label;
                if (this.UseReducedStrings) {
                    object4 = legendElement.labelReduced;
                }
                if (this.LDesc.getLegendTextAttributes() != null) {
                    object3 = new AttributedString((String)object4, this.LDesc.getLegendTextAttributes());
                    object2 = new TextLayout(((AttributedString)object3).getIterator(), graphics2D.getFontRenderContext());
                    object = ((TextLayout)object2).toString();
                    ((TextLayout)object2).draw(graphics2D, n2, n);
                } else {
                    if (legendElement.labelColor != null) {
                        graphics2D.setColor(legendElement.labelColor);
                    } else {
                        graphics2D.setColor(this.LDesc.getLegendForeground());
                    }
                    graphics2D.drawString((String)object4, n2, n);
                }
                if (!bl) continue;
                int n20 = this.legendOrderReverse ? this.drawableItems.size() - n18 - 1 : n18;
                n19 = n6 + n4 * n16;
                int n21 = n19 + n16 - 2 * n14;
                n3 = n9 + n5 * n12 - n12 / 2;
                int n22 = n3 + n12;
                this.LDesc.imageMapCoords[n20] = new int[4];
                this.LDesc.imageMapCoords[n20][0] = n19;
                this.LDesc.imageMapCoords[n20][1] = n3;
                this.LDesc.imageMapCoords[n20][2] = n21;
                this.LDesc.imageMapCoords[n20][3] = n22;
            }
        }
        if (this.LDesc.getLegendButtons() != null && !this.LDesc.getLegendInside()) {
            switch (this.LDesc.getLegendAlignment()) {
                case 3: 
                case 10: 
                case 11: {
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    RenderingHints renderingHints2 = graphics2D.getRenderingHints();
                    graphics2D.setRenderingHints(renderingHints);
                    ButtonDesc[] buttonDescArray = this.LDesc.getLegendButtons();
                    n3 = 3;
                    n2 = 0;
                    for (n = 0; n < buttonDescArray.length; ++n) {
                        object3 = Button.getButtonDimensions(graphics2D, buttonDescArray[n]);
                        n2 = (int)((double)n2 + ((Dimension)object3).getWidth());
                    }
                    n = 0;
                    int n23 = n6;
                    if ((n2 += (buttonDescArray.length - 1) * n3) < n11) {
                        n = (n11 - n2) / 2;
                        n23 += n;
                    }
                    this.LDesc.imageMapCoordsButton = new int[buttonDescArray.length][0];
                    for (int i = 0; i < buttonDescArray.length; ++i) {
                        object2 = buttonDescArray[i].getLabelDesc();
                        object = Button.drawButton(graphics2D, n23, this.yBaseline, buttonDescArray[i]);
                        if (bl) {
                            this.LDesc.imageMapCoordsButton[i] = new int[4];
                            this.LDesc.imageMapCoordsButton[i][0] = n23;
                            this.LDesc.imageMapCoordsButton[i][1] = this.yBaseline;
                            this.LDesc.imageMapCoordsButton[i][2] = n23 + (int)((Dimension)object).getWidth();
                            this.LDesc.imageMapCoordsButton[i][3] = this.yBaseline + (int)((Dimension)object).getHeight();
                        }
                        n23 = (int)((double)n23 + (((Dimension)object).getWidth() + (double)n3));
                    }
                    graphics2D.setRenderingHints(renderingHints2);
                }
            }
        }
    }

    private int getButtonBarWidth(Graphics2D graphics2D) {
        int n = 13;
        if (this.LDesc.getLegendButtons() != null && !this.LDesc.getLegendInside()) {
            switch (this.LDesc.getLegendAlignment()) {
                case 3: 
                case 10: 
                case 11: {
                    ButtonDesc[] buttonDescArray = this.LDesc.getLegendButtons();
                    int n2 = 3;
                    int n3 = 0;
                    for (int i = 0; i < buttonDescArray.length; ++i) {
                        Dimension dimension = Button.getButtonDimensions(graphics2D, buttonDescArray[i]);
                        n3 = (int)((double)n3 + dimension.getWidth());
                    }
                    n3 += buttonDescArray.length * n2;
                    return n3 += n;
                }
            }
        }
        return 0;
    }

    protected class LegendElement {
        String label;
        public String userSVGScript;
        String labelReduced;
        Color color;
        Color labelColor = null;
        int markerType;
        Color markerColor;
        BasicStroke lineStroke;
        String svgXLink = null;
        boolean drawElement = true;

        public LegendElement(String string, Color color) {
            this.label = string;
            this.color = color;
            this.markerType = -1;
        }

        public LegendElement(String string, Color color, int n, Color color2) {
            this.label = string;
            this.color = color;
            this.markerType = n;
            this.markerColor = color2;
        }

        public LegendElement(String string, Color color, int n, Color color2, BasicStroke basicStroke) {
            this.label = string;
            this.color = color;
            this.markerType = n;
            this.markerColor = color2;
            this.lineStroke = basicStroke;
        }
    }
}

