/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BasemapCache;
import oracle.sdovis.BasemapStore;
import oracle.sdovis.DBSRSStore;
import oracle.sdovis.FileBasemapStore;
import oracle.sdovis.FileSRSStore;
import oracle.sdovis.FileStyleStore;
import oracle.sdovis.FileThemeStore;
import oracle.sdovis.MapTable;
import oracle.sdovis.SRSCache;
import oracle.sdovis.SRSStore;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyleStore;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.ThemeStore;
import oracle.sdovis.ThemeTable;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.ds.FileDataSource;
import oracle.sdovis.ds.NativeOracleDataSource;
import oracle.sdovis.ds.OracleDBDataSource;
import oracle.sdovis.style.AllStyleTable;
import oracle.sdovis.util.DBTable;

public class DSManager {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static int connectionWaitTimeout = 120;
    static Hashtable visList = new Hashtable(13);

    public static void registerContainerDS(String string, String string2) throws Exception {
        DSManager.ensureUnique(string);
        OracleDBDataSource oracleDBDataSource = new OracleDBDataSource(string, string2);
        DSManager.enlist_(oracleDBDataSource);
    }

    public static void registerOracleJdbcDS(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n) throws Exception {
        DSManager.ensureUnique(string);
        NativeOracleDataSource nativeOracleDataSource = new NativeOracleDataSource(string, null, string2, string3, string4, string5, string6, string7, n);
        DSManager.enlist_(nativeOracleDataSource);
    }

    public static void registerOracleJdbcDS(String string, String string2, String string3, String string4, String string5, int n) throws Exception {
        DSManager.ensureUnique(string);
        NativeOracleDataSource nativeOracleDataSource = new NativeOracleDataSource(string, string2, null, null, null, string3, string4, string5, n);
        DSManager.enlist_(nativeOracleDataSource);
    }

    public static void registerFileDataSource(String string, String string2) throws Exception {
        DSManager.ensureUnique(string);
        FileDataSource fileDataSource = new FileDataSource(string, string2);
        DSManager.enlist_(fileDataSource);
    }

    public static void enlist(DataSourceI dataSourceI) throws Exception {
        DSManager.ensureUnique(dataSourceI.getName());
        DSManager.enlist_(dataSourceI);
    }

    private static void enlist_(DataSourceI dataSourceI) {
        if (dataSourceI == null) {
            return;
        }
        String string = dataSourceI.getName().toUpperCase();
        Object v = visList.get(string);
        if (v != null) {
            ((DataSourceI)v).close();
            visList.remove(string);
        }
        visList.put(string, dataSourceI);
        if (dataSourceI instanceof AbstractDBDataSource) {
            DSManager.postRegistration((AbstractDBDataSource)dataSourceI);
        } else if (dataSourceI instanceof FileDataSource) {
            DSManager.postRegistration((FileDataSource)dataSourceI);
        }
    }

    public static void delist(DataSourceI dataSourceI) {
        if (dataSourceI == null) {
            return;
        }
        String string = dataSourceI.getName().toUpperCase();
        visList.remove(string);
    }

    public static void delist(String string) {
        visList.remove(string.toUpperCase());
    }

    public static void remove(String string) {
        DataSourceI dataSourceI = (DataSourceI)visList.get(string = string.toUpperCase());
        if (dataSourceI != null) {
            dataSourceI.close();
            visList.remove(string);
        }
    }

    public static DataSourceI get(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return (DataSourceI)visList.get(string.toUpperCase());
    }

    public static String[] getAllNames() {
        if (visList == null || visList.size() == 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = visList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.add(string);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static void closeAll() {
        DataSourceI dataSourceI = null;
        Enumeration enumeration = visList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            dataSourceI = (DataSourceI)visList.get(string);
            if (dataSourceI.isClosed()) continue;
            dataSourceI.close();
        }
        visList.clear();
    }

    public static String findOracleJdbcDS(String string, String string2, String string3, String string4, String string5, String string6) {
        Enumeration enumeration = visList.elements();
        while (enumeration.hasMoreElements()) {
            NativeOracleDataSource nativeOracleDataSource;
            DataSourceI dataSourceI = (DataSourceI)enumeration.nextElement();
            if (!(dataSourceI instanceof NativeOracleDataSource) || !(nativeOracleDataSource = (NativeOracleDataSource)dataSourceI).matches(string, string2, string3, string4, string5, string6)) continue;
            return nativeOracleDataSource.getName();
        }
        return null;
    }

    public static boolean isRegistered(String string) {
        Enumeration enumeration = visList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private static void postRegistration(AbstractDBDataSource abstractDBDataSource) {
        Object object;
        DBTable dBTable;
        StyleCache styleCache = new StyleCache(abstractDBDataSource.getName(), 200);
        try {
            dBTable = new AllStyleTable(abstractDBDataSource.getName(), "ALL_SDO_STYLES");
            styleCache.setStyleStore((StyleStore)((Object)dBTable));
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw new IllegalArgumentException("cannot create a style table.");
        }
        dBTable = new ThemeTable(abstractDBDataSource.getName(), "USER_SDO_THEMES");
        ThemeCache themeCache = new ThemeCache(abstractDBDataSource.getName(), 9999, (ThemeStore)((Object)dBTable));
        BasemapCache basemapCache = null;
        try {
            object = new MapTable(abstractDBDataSource.getName(), "USER_SDO_MAPS");
            basemapCache = new BasemapCache(abstractDBDataSource.getName(), (BasemapStore)object);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            throw new IllegalArgumentException("cannot create a basemap table.");
        }
        object = new DBSRSStore(abstractDBDataSource.getName());
        SRSCache sRSCache = new SRSCache(abstractDBDataSource.getName(), (SRSStore)object);
        abstractDBDataSource.setStyleCache(styleCache);
        abstractDBDataSource.setThemeCache(themeCache);
        abstractDBDataSource.setBasemapCache(basemapCache);
        abstractDBDataSource.setSRSCache(sRSCache);
    }

    private static void postRegistration(FileDataSource fileDataSource) {
        Object object;
        StyleCache styleCache = new StyleCache(fileDataSource.getName(), 200);
        try {
            object = new FileStyleStore(fileDataSource.getName());
            styleCache.setStyleStore((StyleStore)object);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Cannot create file style store.", exception);
        }
        fileDataSource.setStyleCache(styleCache);
        object = new FileThemeStore(fileDataSource.getName());
        ThemeCache themeCache = new ThemeCache(fileDataSource.getName(), 9999, (ThemeStore)object);
        fileDataSource.setThemeCache(themeCache);
        FileBasemapStore fileBasemapStore = new FileBasemapStore(fileDataSource.getName());
        BasemapCache basemapCache = new BasemapCache(fileDataSource.getName(), fileBasemapStore);
        fileDataSource.setBasemapCache(basemapCache);
        FileSRSStore fileSRSStore = new FileSRSStore(fileDataSource.getName());
        SRSCache sRSCache = new SRSCache(fileDataSource.getName(), fileSRSStore);
        fileDataSource.setSRSCache(sRSCache);
    }

    private static void ensureUnique(String string) throws Exception {
        Enumeration enumeration = visList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            throw new Exception("Data source with the same name already exists.");
        }
    }

    public static StyleCache getStyleCache(String string) {
        DataSourceI dataSourceI = DSManager.get(string);
        return dataSourceI == null ? null : dataSourceI.getStyleCache();
    }

    public static SRSCache getSRSCache(String string) {
        DataSourceI dataSourceI = DSManager.get(string);
        return dataSourceI == null ? null : dataSourceI.getSRSCache();
    }

    public static void setConnectionWaitTimeout(int n) {
        connectionWaitTimeout = n;
    }

    public static int getConnectionWaitTimeout() {
        return connectionWaitTimeout;
    }
}

