/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.util.Util;

public class OracleDBDataSource
extends AbstractDBDataSource {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private DataSource ds;
    private String jndiLocation;

    public OracleDBDataSource(String string, String string2) {
        try {
            InitialContext initialContext = new InitialContext();
            this.ds = (DataSource)initialContext.lookup(string2);
            this.name = string;
            this.jndiLocation = string2;
            this.closed = false;
            Connection connection = this.ds.getConnection();
            this.dbProductVersion = Util.getDBVersion(connection);
            this.is9i = Util.is9i(connection);
            this.pre9i = Util.isPre9i(connection);
            this.tenG = Util.is10g(connection);
            DSUtil.createArrayTypes(connection, string);
            connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new IllegalArgumentException("Invalid JNDI location encountered when creating NativeOracleDataSource.");
        }
    }

    public OracleDBDataSource(String string, DataSource dataSource) {
        try {
            this.name = string;
            this.ds = dataSource;
            this.closed = false;
            Connection connection = this.ds.getConnection();
            this.pre9i = Util.isPre9i(connection);
            this.tenG = Util.is10g(connection);
            connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new IllegalArgumentException("Invalid existing DataSource instance.");
        }
    }

    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.ds.getConnection(string, string2);
    }

    public Connection getProxyConnection(String string, Properties properties) throws SQLException {
        OracleConnection oracleConnection = (OracleConnection)this.ds.getConnection();
        int n = 1;
        if ("DISTINGUISHED_NAME".equals(string)) {
            n = 2;
        }
        oracleConnection.openProxySession(n, properties);
        return oracleConnection;
    }

    public void close() {
    }

    public boolean supportOLS() {
        return false;
    }

    public DataSource getUnwrappedDataSource() {
        return this.ds;
    }

    public String getJNDILocation() {
        return this.jndiLocation;
    }

    public String getUserInfoPackageName() {
        return this.userInfoPackageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserInfoPackageName(String string) {
        this.userInfoPackageName = string;
        Connection connection = null;
        try {
            connection = this.getConnection();
            boolean bl = DSUtil.validPLSQLPackage(connection, string);
            this.setUserIfnoPackageValid(bl);
            if (!bl) {
                log.warning("PL/SQL package " + string + " will be ignored.");
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error validating pl/sql package " + string + ".", exception);
            this.setUserIfnoPackageValid(false);
            log.warning("PL/SQL package " + string + " will be ignored.");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUser() {
        if (this.ds == null) {
            return null;
        }
        Connection connection = null;
        try {
            connection = this.ds.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getUserName().toUpperCase();
            return string;
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

