/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.georss;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.georss.AtomParser;
import oracle.sdovis.georss.GMLParser;
import oracle.sdovis.georss.RssParser;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WorldMercatorUtil;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.geometry.JGeometry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class GeoFeedParser {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public abstract StyledFeatureI[] parse(Document var1) throws Exception;

    public static StyledFeatureI[] loadFeatures(String string, String string2, int n) throws Exception {
        byte[] byArray = Util.readBinaryFromURL(string);
        if (byArray == null) {
            throw new Exception("Unable to read data from URL: " + string);
        }
        if (byArray.length < 10) {
            return new StyledFeature[0];
        }
        log.finest("GeoRss feed:" + new String(byArray, 0, byArray.length > 80 ? 80 : byArray.length));
        String string3 = new String(byArray);
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        boolean bl = xMLDOMParser.parse(string3);
        if (!bl) {
            throw new Exception("cannot parse a GeoRss feed.");
        }
        StyledFeatureI[] styledFeatureIArray = null;
        Document document = xMLDOMParser.getDocument();
        boolean bl2 = GeoFeedParser.nodeExists(document, "rdf:RDF");
        boolean bl3 = GeoFeedParser.nodeExists(document, "rss");
        if (bl2 || bl3) {
            RssParser rssParser = new RssParser(string2);
            styledFeatureIArray = rssParser.parse(document);
        } else if (GeoFeedParser.nodeExists(document, "feed")) {
            AtomParser atomParser = new AtomParser(string2);
            styledFeatureIArray = atomParser.parse(document);
        }
        if (styledFeatureIArray == null || styledFeatureIArray.length == 0) {
            log.warning("Not a recognized GeoRss feed or the feed is empty.");
            return new StyledFeature[0];
        }
        if (n != 0 && n != 8307 && n != 8265) {
            GeoFeedParser.transformFeatures(styledFeatureIArray, n, string2);
        }
        return styledFeatureIArray;
    }

    public static JSDOGeometry extractLocation(Node node) {
        JSDOGeometry jSDOGeometry = null;
        double[] dArray = new double[]{-9999.0, -9999.0};
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if ((string2.startsWith("georss:") || string2.startsWith("gml:")) && (jSDOGeometry = GeoFeedParser.parseGeoRSS(node2)) != null) {
                return jSDOGeometry;
            }
            if (string2.startsWith("geo:lat")) {
                string = XMLDOMParser.getElementValue(node2);
                dArray[1] = Double.parseDouble(string);
            }
            if (!string2.startsWith("geo:long")) continue;
            string = XMLDOMParser.getElementValue(node2);
            dArray[0] = Double.parseDouble(string);
        }
        if (dArray[0] == -9999.0 || dArray[1] == -9999.0) {
            return null;
        }
        return JSDOGeometry.recast(JSDOGeometry.createPoint((double[])dArray, (int)2, (int)8307));
    }

    public static JSDOGeometry parseGeoRSS(Node node) {
        String string = node.getNodeName();
        if ("georss:where".equals(string = string.toLowerCase(Locale.ENGLISH))) {
            Node node2 = XMLDOMParser.getFirstRealChildNode(node);
            return GeoFeedParser.parseGeoRSS(node2);
        }
        if ("georss:point".equals(string)) {
            String string2 = XMLDOMParser.getElementValue(node);
            ArrayList arrayList = Util.splitBy(string2, " ");
            double[] dArray = new double[2];
            dArray[1] = Double.parseDouble((String)arrayList.get(0));
            dArray[0] = Double.parseDouble((String)arrayList.get(1));
            return JSDOGeometry.recast(JSDOGeometry.createPoint((double[])dArray, (int)2, (int)8307));
        }
        if ("georss:line".equals(string)) {
            String string3 = XMLDOMParser.getElementValue(node);
            ArrayList arrayList = Util.splitBy(string3, " ");
            double[] dArray = new double[arrayList.size()];
            for (int i = 0; i < arrayList.size() / 2; ++i) {
                dArray[i * 2] = Double.parseDouble((String)arrayList.get(i * 2 + 1));
                dArray[i * 2 + 1] = Double.parseDouble((String)arrayList.get(i * 2));
            }
            return JSDOGeometry.recast(JSDOGeometry.createLinearLineString((double[])dArray, (int)2, (int)8307));
        }
        if ("georss:polygon".equals(string)) {
            String string4 = XMLDOMParser.getElementValue(node);
            ArrayList arrayList = Util.splitBy(string4, " ");
            double[] dArray = new double[arrayList.size()];
            for (int i = 0; i < arrayList.size() / 2; ++i) {
                dArray[i * 2] = Double.parseDouble((String)arrayList.get(i * 2 + 1));
                dArray[i * 2 + 1] = Double.parseDouble((String)arrayList.get(i * 2));
            }
            return JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)8307));
        }
        if ("georss:box".equals(string)) {
            String string5 = XMLDOMParser.getElementValue(node);
            ArrayList arrayList = Util.splitBy(string5, " ");
            double d = Double.parseDouble((String)arrayList.get(1));
            double d2 = Double.parseDouble((String)arrayList.get(0));
            double d3 = Double.parseDouble((String)arrayList.get(3));
            double d4 = Double.parseDouble((String)arrayList.get(2));
            JSDOGeometry jSDOGeometry = new JSDOGeometry(Math.min(d, d3), Math.min(d2, d4), Math.max(d, d3), Math.max(d2, d4), 8307);
            return JSDOGeometry.recast(jSDOGeometry);
        }
        if (string.startsWith("gml:")) {
            JGeometry jGeometry = GMLParser.getGeometry(node);
            return jGeometry != null ? JSDOGeometry.recast(jGeometry) : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transformFeatures(StyledFeatureI[] styledFeatureIArray, int n, String string) {
        Connection connection = null;
        JSDOGeometry jSDOGeometry = null;
        JSDOGeometry jSDOGeometry2 = null;
        try {
            long l = System.currentTimeMillis();
            int n2 = 0;
            int n3 = 0;
            for (n3 = 0; n3 < styledFeatureIArray.length; ++n3) {
                StyledFeatureI styledFeatureI = styledFeatureIArray[n3];
                jSDOGeometry = styledFeatureI.getGeometry();
                if (jSDOGeometry == null) continue;
                n2 = jSDOGeometry.getSRID();
                if (n2 == 8307 && n == 54004) {
                    jSDOGeometry2 = WorldMercatorUtil.geodeticToMercator(jSDOGeometry);
                } else if (n2 == 54004 && n == 8307) {
                    jSDOGeometry2 = WorldMercatorUtil.mercatorToGeodetic(jSDOGeometry);
                } else {
                    if (connection == null && (connection = DSUtil.getDBConnection(string, null)) == null) {
                        log.severe("Cannot obtain connection from data source " + string + ".");
                        return;
                    }
                    jSDOGeometry2 = Util.transform(connection, jSDOGeometry, n2, n);
                }
                if (jSDOGeometry2 == null) continue;
                styledFeatureI.setGeometry(jSDOGeometry2);
            }
            long l2 = System.currentTimeMillis();
            log.finest("Time transforming " + n3 + " features from " + n2 + " to " + n + ": " + (l2 - l) + "ms.");
        }
        catch (Exception exception) {
            log.warning("Error transforming geometry:\n" + exception.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        String string = new String(Util.readFile("/tmp/rss.xml"));
        boolean bl = xMLDOMParser.parse(string);
        if (!bl) {
            throw new Exception("cannot parse a GeoRss feed.");
        }
        Document document = xMLDOMParser.getDocument();
        RssParser rssParser = new RssParser("mvdemo");
        StyledFeatureI[] styledFeatureIArray = rssParser.parse(document);
        xMLDOMParser = new XMLDOMParser();
        string = new String(Util.readFile("/tmp/atom.xml"));
        bl = xMLDOMParser.parse(string);
        if (!bl) {
            throw new Exception("cannot parse a GeoRss feed.");
        }
        document = xMLDOMParser.getDocument();
        AtomParser atomParser = new AtomParser("mvdemo");
        styledFeatureIArray = atomParser.parse(document);
    }

    private static boolean nodeExists(Document document, String string) {
        if (document == null) {
            return false;
        }
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return true;
        }
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!string.equals(node.getNodeName())) continue;
            return true;
        }
        return false;
    }
}

