/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.georss;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.mapviewer.share.Field;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.georss.GeoFeedParser;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RssParser
extends GeoFeedParser {
    private Document doc;
    private Hashtable groups;
    private String dataSrc;

    public RssParser(String string) {
        this.dataSrc = string;
    }

    public StyledFeatureI[] parse(Document document) throws Exception {
        this.doc = document;
        ArrayList<StyledFeatureI> arrayList = new ArrayList<StyledFeatureI>();
        this.parseRoot(arrayList);
        this.parseGroups();
        NodeList nodeList = this.doc.getElementsByTagName("item");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            StyledFeatureI styledFeatureI = this.extractFeature(node);
            if (styledFeatureI == null) continue;
            arrayList.add(styledFeatureI);
        }
        return arrayList.toArray(new StyledFeatureI[arrayList.size()]);
    }

    protected void parseRoot(List list) {
    }

    protected void parseGroups() {
        NodeList nodeList = this.doc.getElementsByTagName("omv:group");
        if (nodeList == null || nodeList.getLength() == 0) {
            nodeList = this.doc.getElementsByTagName("group");
        }
        if (nodeList == null || nodeList.getLength() == 0) {
            return;
        }
        this.groups = new Hashtable();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Group group = new Group();
            String string = XMLDOMParser.getAttribute(node, "name");
            if (string != null) {
                group.setName(string);
            }
            if ((string = XMLDOMParser.getAttribute(node, "title")) != null) {
                group.setTitle(string);
            }
            if ((string = XMLDOMParser.getAttribute(node, "description")) != null) {
                group.setDefaultIcon(string);
            }
            if ((string = XMLDOMParser.getAttribute(node, "default-style")) != null) {
                group.setDefaultStyle(string);
            }
            this.groups.put(group.getName(), group);
        }
    }

    protected StyledFeatureI extractFeature(Node node) {
        Object object;
        JSDOGeometry jSDOGeometry;
        StyledFeature styledFeature = null;
        String string = null;
        Node node2 = XMLDOMParser.getSubElement(node, "title");
        if (node2 != null) {
            string = XMLDOMParser.getElementValue(node2);
        }
        String string2 = null;
        Node node3 = XMLDOMParser.getSubElement(node, "link");
        if (node3 != null) {
            string2 = XMLDOMParser.getElementValue(node3);
        }
        String string3 = null;
        Node node4 = XMLDOMParser.getSubElement(node, "description");
        if (node4 != null) {
            string3 = XMLDOMParser.getElementValue(node4);
        }
        String string4 = null;
        Node node5 = XMLDOMParser.getSubElement(node, "omv:group-name");
        if (node5 != null) {
            string4 = XMLDOMParser.getElementValue(node5);
        }
        if ((jSDOGeometry = RssParser.extractLocation(node)) == null) {
            System.out.println("geom is Null!");
            return null;
        }
        Object object2 = jSDOGeometry.getMBR();
        styledFeature = new StyledFeature();
        styledFeature.setLabel(string);
        object2 = new ArrayList(5);
        if (string != null) {
            object = new Field(string);
            ((Field)object).setNameAndKey("Title", false, "Title");
            object2.add(object);
        }
        if (string2 != null) {
            object = new Field(string2);
            ((Field)object).setNameAndKey("Link", false, "Link");
            object2.add(object);
        }
        if (string3 != null) {
            object = new Field(string3);
            ((Field)object).setNameAndKey("Description", false, "Description");
            object2.add(object);
        }
        styledFeature.setDataSource(this.dataSrc);
        styledFeature.setGeometry(jSDOGeometry);
        styledFeature.setIdentifiableAttributes(object2.toArray(new Field[object2.size()]));
        if (string4 != null && this.groups != null && (object = (Group)this.groups.get(string4)) != null) {
            styledFeature.setFeatureStyleName(((Group)object).getDefaultStyle());
        }
        return styledFeature;
    }

    public static class Group {
        String defaultIcon;
        String defaultStyle;
        String description;
        String name;
        String title;

        public void setDefaultIcon(String string) {
            this.defaultIcon = string;
        }

        public String getDefaultIcon() {
            return this.defaultIcon;
        }

        public void setDefaultStyle(String string) {
            this.defaultStyle = string;
        }

        public String getDefaultStyle() {
            return this.defaultStyle;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

