/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.query;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sdovis.MapMaker;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class SDOBoxFilter
implements SpatialOp {
    public static String TRUE4EVER = "'s'='s'";
    protected String dataSource;
    protected String targetGeometryColumn;
    protected int srid = -9999;
    protected double minx = Double.NaN;
    protected double miny = Double.NaN;
    protected double maxx = Double.NaN;
    protected double maxy = Double.NaN;
    protected double minResolution = Double.NaN;
    protected double maxResolution = Double.NaN;

    public SDOBoxFilter(String string, String string2) {
        this.dataSource = string;
        this.targetGeometryColumn = string2;
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMinY() {
        return this.miny;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public static String getGenericFilterPredicate(String string, int n, boolean bl, String string2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        boolean bl2 = Util.isGeodetic(n);
        if (string2 == null) {
            string2 = "'querytype=WINDOW'";
        }
        if (bl && bl2) {
            stringBuffer.append("MDSYS.SDO_FILTER(" + string + ", ");
            stringBuffer.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            stringBuffer.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(:mvqboxxl, :mvqboxyl, :mvqboxxh, :mvqboxyh)), " + n + " ), " + string2 + ") = 'TRUE'");
            return stringBuffer.toString();
        }
        stringBuffer.append("MDSYS.SDO_FILTER(" + string + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(:mvqboxxl, :mvqboxyl, :mvqboxxh, :mvqboxyh)), " + string2 + ") = 'TRUE'");
        return stringBuffer.toString();
    }

    public String getFilterPredicate(String string, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(256);
        boolean bl2 = Util.isGeodetic(n);
        String string2 = "'querytype=WINDOW";
        if (bl && bl2) {
            string2 = string2 + "'";
        } else if (Double.isNaN(this.minResolution) && Double.isNaN(this.maxResolution)) {
            string2 = string2 + "'";
        } else {
            if (!Double.isNaN(this.minResolution)) {
                string2 = string2 + " min_resolution=" + this.minResolution;
            }
            if (!Double.isNaN(this.maxResolution)) {
                string2 = string2 + " max_resolution=" + this.maxResolution;
            }
            string2 = string2 + "'";
        }
        return SDOBoxFilter.getGenericFilterPredicate(string, n, bl, string2);
    }

    public String getSpatialPredicate() {
        if (this.srid == -9999) {
            throw new IllegalArgumentException("Box srid must be set before calling getSpatialPredicate.");
        }
        if (MapMaker.isSpecial(this.minx, this.miny, this.maxx, this.maxy)) {
            return TRUE4EVER;
        }
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (abstractDBDataSource == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        boolean bl = abstractDBDataSource.is9i();
        return this.getFilterPredicate(this.targetGeometryColumn, this.srid, bl);
    }

    public void prepare(PreparedStatement preparedStatement) throws SQLException {
        if (MapMaker.isSpecial(this.minx, this.miny, this.maxx, this.maxy)) {
            return;
        }
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
        oraclePreparedStatement.setDoubleAtName("mvqboxxl", this.minx);
        oraclePreparedStatement.setDoubleAtName("mvqboxyl", this.miny);
        oraclePreparedStatement.setDoubleAtName("mvqboxxh", this.maxx);
        oraclePreparedStatement.setDoubleAtName("mvqboxyh", this.maxy);
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setTargetGeometryColumn(String string) {
        this.targetGeometryColumn = string;
    }

    public String getTargetGeometryColumn() {
        return this.targetGeometryColumn;
    }

    public void setMinResoultion(double d) {
        this.minResolution = d;
    }

    public double getMinResoultion() {
        return this.minResolution;
    }

    public void setMaxResoultion(double d) {
        this.maxResolution = d;
    }

    public double getMaxResoultion() {
        return this.maxResolution;
    }

    public void setFilterBox(double d, double d2, double d3, double d4, int n) {
        this.minx = d;
        this.miny = d2;
        this.maxx = d3;
        this.maxy = d4;
        this.srid = n;
    }

    public int getNumBindingVariables() {
        if (MapMaker.isSpecial(this.minx, this.miny, this.maxx, this.maxy)) {
            return 0;
        }
        return 4;
    }

    public void setOperationGeometry(JGeometry jGeometry) {
        if (jGeometry == null) {
            throw new IllegalArgumentException("null geometry argument.");
        }
        if (jGeometry.isRectangle()) {
            double[] dArray = jGeometry.getOrdinatesArray();
            int n = jGeometry.getDimensions();
            this.minx = dArray[0];
            this.miny = dArray[1];
            this.maxx = dArray[n];
            this.maxy = dArray[n + 1];
            this.srid = jGeometry.getSRID();
        } else {
            double[] dArray = jGeometry.getMBR();
            this.minx = dArray[0];
            this.miny = dArray[1];
            this.maxx = dArray[2];
            this.maxy = dArray[3];
            this.srid = jGeometry.getSRID();
        }
    }

    public JGeometry getOperationGeometry() {
        return new JGeometry(2003, this.srid, new int[]{1, 1003, 3}, new double[]{this.minx, this.miny, this.maxx, this.maxy});
    }

    public int getSrid() {
        return this.srid;
    }
}

