/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.query.SDOFilter;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class SDORelate
implements SpatialOp {
    protected String dataSource;
    protected String targetGeometryColumn;
    protected JGeometry filterGeometry;
    double minResolution = Double.NaN;
    double maxResolution = Double.NaN;
    protected String mask;
    protected static String[] MASKS = new String[]{"anyinteract", "touch", "overlapbdyintersect", "equal", "inside", "coveredby", "contains", "covers", "on", "overlapbdydisjoint"};

    public SDORelate(String string, String string2, String string3) {
        this.dataSource = string;
        this.targetGeometryColumn = string2;
        if (string3 == null) {
            string3 = "anyinteract";
        } else {
            this.setMask(string3);
        }
    }

    public void setOperationGeometry(JGeometry jGeometry) {
        this.filterGeometry = jGeometry;
    }

    public JGeometry getOperationGeometry() {
        return this.filterGeometry;
    }

    public int getSrid() {
        return this.filterGeometry != null ? this.filterGeometry.getSRID() : 0;
    }

    public void prepare(PreparedStatement preparedStatement) throws SQLException {
        STRUCT sTRUCT = null;
        Connection connection = preparedStatement.getConnection();
        Object[] objectArray = Util.createDBGeomDescriptors(connection);
        sTRUCT = JGeometry.store((JGeometry)this.filterGeometry, (Connection)connection, (Object[])objectArray);
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
        oraclePreparedStatement.setObjectAtName("svqfilterg", (Object)sTRUCT);
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (abstractDBDataSource == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        if (!abstractDBDataSource.is9i() && !abstractDBDataSource.isPre9i()) {
            if (!Double.isNaN(this.minResolution)) {
                oraclePreparedStatement.setDoubleAtName("svqminres", this.minResolution);
            }
            if (!Double.isNaN(this.maxResolution)) {
                oraclePreparedStatement.setDoubleAtName("svqmaxres", this.maxResolution);
            }
        }
    }

    public String getSpatialPredicate() {
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (abstractDBDataSource == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        if (abstractDBDataSource.is9i() || abstractDBDataSource.isPre9i()) {
            stringBuffer.append("MDSYS.SDO_RELATE(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + "'mask=" + this.mask + "'" + ") = 'TRUE'");
        } else if (Double.isNaN(this.minResolution) && Double.isNaN(this.maxResolution)) {
            stringBuffer.append("MDSYS.SDO_RELATE(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + "'mask=" + this.mask + "'" + ") = 'TRUE'");
        } else {
            String string = Double.isNaN(this.minResolution) ? "" : " min_resolution=:svqminres";
            String string2 = Double.isNaN(this.maxResolution) ? "" : " max_resolution=:svqmaxres";
            String string3 = "'mask=" + this.mask + string + string2 + "'";
            stringBuffer.append("MDSYS.SDO_RELATE(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + string3 + ") = 'TRUE'");
        }
        return stringBuffer.toString();
    }

    public void setMask(String string) {
        boolean bl = false;
        if (string != null) {
            string = string.toLowerCase();
            for (int i = 0; i < MASKS.length; ++i) {
                if (!MASKS[i].equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (string == null || !bl) {
            throw new IllegalArgumentException("Invalid mask for sdo_relate:" + string + ".");
        }
        this.mask = string;
    }

    public String getMask() {
        return this.mask;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setMinResoultion(double d) {
        this.minResolution = d;
    }

    public double getMinResoultion() {
        return this.minResolution;
    }

    public void setMaxResoultion(double d) {
        this.maxResolution = d;
    }

    public double getMaxResoultion() {
        return this.maxResolution;
    }

    public int getNumBindingVariables() {
        return SDOFilter.getNumBindingVariables(this.dataSource, this.minResolution, this.maxResolution);
    }
}

