/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class SDOWithinDistance
implements SpatialOp {
    protected double distance;
    protected String dataSource;
    protected String targetGeometryColumn;
    protected JGeometry opGeometry;
    protected boolean primaryFilterOnly = false;

    public SDOWithinDistance(String string, String string2, double d) {
        this.dataSource = string;
        this.targetGeometryColumn = string2;
        this.distance = d;
    }

    public void setOperationGeometry(JGeometry jGeometry) {
        this.opGeometry = jGeometry;
    }

    public JGeometry getOperationGeometry() {
        return this.opGeometry;
    }

    public String getSpatialPredicate() {
        if (this.opGeometry == null) {
            throw new IllegalArgumentException("Operation geometry must be set!");
        }
        int n = this.opGeometry.getSRID();
        String string = "" + this.distance;
        String string2 = this.primaryFilterOnly ? " querytype=FILTER" : "";
        String string3 = "SDO_WITHIN_DISTANCE(" + this.targetGeometryColumn + ", :svqwdistg, " + "'distance = " + string + " unit=meter" + string2 + "') = 'TRUE'";
        return string3;
    }

    public void prepare(PreparedStatement preparedStatement) throws SQLException {
        STRUCT sTRUCT = null;
        Connection connection = preparedStatement.getConnection();
        Object[] objectArray = Util.createDBGeomDescriptors(connection);
        sTRUCT = JGeometry.store((JGeometry)this.opGeometry, (Connection)connection, (Object[])objectArray);
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
        oraclePreparedStatement.setObjectAtName("svqwdistg", (Object)sTRUCT);
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public int getNumBindingVariables() {
        return 1;
    }

    public int getSrid() {
        return this.opGeometry != null ? this.opGeometry.getSRID() : 0;
    }

    public void setPrimaryFilterOnly(boolean bl) {
        this.primaryFilterOnly = bl;
    }

    public boolean isPrimaryFilterOnly() {
        return this.primaryFilterOnly;
    }
}

