/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.Group;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.LightSource;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.PhongMaterial;
import oracle.sdovis.raytracing.RTRenderer;
import oracle.sdovis.raytracing.Ray;
import oracle.sdovis.raytracing.Render3DException;

public class DEMTracer {
    static double EPSILON = 5.0E-4;
    LightSource[] light;
    Camera cam;
    double reflection_coefficient;
    double transmission_coefficient;
    double[] r0;
    double[] rd;
    Vector3d ambient_light;
    Vector3d background_color;
    Material[] mat;
    Material cur_mat;
    Group grp;
    int bounces;
    double minweight;

    public DEMTracer(RTRenderer rTRenderer, int n, int n2) {
        this.grp = rTRenderer.getGroup();
        this.cam = rTRenderer.getCamera();
        this.light = rTRenderer.getLights();
        this.ambient_light = rTRenderer.getAmbientLight();
        this.background_color = rTRenderer.getBackgroundColor();
        this.mat = rTRenderer.getMaterials();
        this.bounces = n;
        this.minweight = n2;
    }

    public static Vector3d mirrorDirection(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = vector3d2;
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = vector3d;
        vector3d5.scale(vector3d2.dot(vector3d) * 2.0);
        vector3d4.sub((Tuple3d)vector3d3, (Tuple3d)vector3d5);
        return vector3d4;
    }

    public static boolean transmittedDirection(Vector3d vector3d, Vector3d vector3d2, double d, double d2, Vector3d vector3d3) {
        Vector3d vector3d4 = vector3d2;
        vector3d4.negate();
        vector3d4.normalize();
        Vector3d vector3d5 = vector3d;
        vector3d5.normalize();
        double d3 = d / d2;
        double d4 = 1.0 - Math.pow(d3, 2.0) * (1.0 - Math.pow(vector3d5.dot(vector3d4), 2.0));
        if (d4 < 0.0) {
            return false;
        }
        vector3d3 = vector3d5;
        vector3d3.scale(d3 * vector3d5.dot(vector3d4) - Math.sqrt(d4));
        vector3d4.scale(d3);
        vector3d3.sub((Tuple3d)vector3d4);
        vector3d3.normalize();
        return true;
    }

    public Vector3d traceRay(Ray ray, double d, int n, double d2, double d3, Hit hit) {
        Vector3d vector3d = this.background_color;
        Vector3d vector3d2 = new Vector3d();
        PhongMaterial phongMaterial = new PhongMaterial(vector3d, vector3d2, 1.0, vector3d2, vector3d2, 1.0);
        boolean bl = this.grp.intersect(ray, hit, d);
        Vector3d vector3d3 = new Vector3d();
        if (bl) {
            if (hit.getMaterial() == null) {
                vector3d3 = phongMaterial.getDiffuseColor();
            } else {
                vector3d3 = DEMTracer.mulVectors(hit.getMaterial().getDiffuseColor(), this.ambient_light);
                for (int i = 0; i < this.light.length; ++i) {
                    Ray ray2;
                    Vector3d vector3d4;
                    Object object;
                    Hit hit2;
                    Ray ray3;
                    Vector3d vector3d5;
                    Vector3d vector3d6 = new Vector3d();
                    vector3d6.scale(hit.getT(), (Tuple3d)ray.getDirection());
                    vector3d6.add((Tuple3d)ray.getOrigin());
                    Vector3d vector3d7 = new Vector3d();
                    Vector3d vector3d8 = new Vector3d();
                    Vector3d vector3d9 = new Vector3d();
                    LightSource lightSource = this.light[i];
                    Vector vector = lightSource.getIllumination(vector3d6);
                    vector3d7 = (Vector3d)vector.elementAt(0);
                    vector3d8 = (Vector3d)vector.elementAt(1);
                    double d4 = (Double)vector.elementAt(2);
                    vector3d7.normalize();
                    Ray ray4 = new Ray(vector3d7, vector3d6);
                    Hit hit3 = new Hit(Double.POSITIVE_INFINITY, null);
                    boolean bl2 = this.grp.intersect(ray4, hit3, EPSILON);
                    if (bl2) {
                        if (hit3.getT() < d4) {
                            vector3d3.add((Tuple3d)vector3d2);
                        } else {
                            vector3d3.add((Tuple3d)hit.getMaterial().shade(ray, hit, vector3d7, vector3d8));
                        }
                    } else {
                        vector3d3.add((Tuple3d)hit.getMaterial().shade(ray, hit, vector3d7, vector3d8));
                    }
                    Vector3d vector3d10 = hit.getMaterial().getReflectiveColor();
                    if ((vector3d10.x > 0.0 || vector3d10.y > 0.0 || vector3d10.z > 0.0) && n > 0) {
                        vector3d5 = DEMTracer.mirrorDirection(hit.getNormal(), ray.getDirection());
                        ray3 = new Ray(vector3d5, vector3d6);
                        hit2 = new Hit(Double.POSITIVE_INFINITY, null);
                        object = hit.getMaterial().getReflectiveColor();
                        vector3d4 = this.traceRay(ray3, EPSILON, n - 1, d2 * (object.x + object.y + object.z) / 3.0, d3, hit2);
                        vector3d3.add((Tuple3d)DEMTracer.mulVectors(object, vector3d4));
                    }
                    vector3d5 = hit.getMaterial().getTransparencyColor();
                    if (!(vector3d5.x > 0.0) && !(vector3d5.y > 0.0) && !(vector3d5.z > 0.0)) continue;
                    ray3 = new Vector3d();
                    hit2 = new Hit(Double.POSITIVE_INFINITY, null);
                    if (ray.getDirection().dot(hit.getNormal()) < 0.0) {
                        if (!DEMTracer.transmittedDirection(hit.getNormal(), ray.getDirection(), d3, hit.getMaterial().getIndexOfRefraction(), (Vector3d)ray3) || n <= 0) continue;
                        object = new Ray((Vector3d)ray3, vector3d6);
                        vector3d4 = hit.getMaterial().getTransparencyColor();
                        ray2 = this.traceRay((Ray)object, EPSILON, n - 1, d2 * (vector3d4.x + vector3d4.y + vector3d4.z) / 3.0, d3, hit2);
                        vector3d3.add((Tuple3d)DEMTracer.mulVectors(vector3d4, (Vector3d)ray2));
                        continue;
                    }
                    object = hit.getNormal();
                    vector3d4 = new Vector3d();
                    object.negate();
                    if (!DEMTracer.transmittedDirection(object, ray.getDirection(), hit.getMaterial().getIndexOfRefraction(), d3, vector3d4) || n <= 0) continue;
                    ray2 = new Ray(vector3d4, vector3d6);
                    Vector3d vector3d11 = hit.getMaterial().getTransparencyColor();
                    Vector3d vector3d12 = this.traceRay(ray2, EPSILON, n - 1, d2 * (vector3d11.x + vector3d11.y + vector3d11.z) / 3.0, hit.getMaterial().getIndexOfRefraction(), hit2);
                    vector3d3.add((Tuple3d)DEMTracer.mulVectors(vector3d11, vector3d12));
                }
            }
        } else {
            vector3d3 = phongMaterial.getDiffuseColor();
        }
        vector3d3 = new Vector3d(Math.min(vector3d3.x, 1.0), Math.min(vector3d3.y, 1.0), Math.min(vector3d3.z, 1.0));
        return vector3d3;
    }

    public static Vector3d mulVectors(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d(vector3d.x * vector3d2.x, vector3d.y * vector3d2.y, vector3d.z * vector3d2.z);
        return vector3d3;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public Vector3d getBackgroundColor() {
        return this.background_color;
    }

    public void setBackgroundColor(Vector3d vector3d) {
        this.background_color = vector3d;
    }

    public Vector3d getAmbientLight() {
        return this.ambient_light;
    }

    public int getNumLights() {
        return this.light.length;
    }

    public LightSource getLight(int n) throws Render3DException {
        if (n < 0 || n >= this.light.length) {
            throw new Render3DException("Error parsing light sources.");
        }
        return this.light[n];
    }

    public int getNumMaterials() {
        return this.mat.length;
    }

    public Material getMaterial(int n) throws Render3DException {
        if (n < 0 || n >= this.mat.length) {
            throw new Render3DException("Error parsing materials.");
        }
        return this.mat[n];
    }
}

