/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.Object3d;
import oracle.sdovis.raytracing.Ray;

public class Plane
extends Object3d {
    double offset;
    Vector3d up;
    int width;
    int height;
    Camera cam;

    public Plane(Vector3d vector3d, double d, Material material, Camera camera) {
        super(material, vector3d);
        this.cam = camera;
        this.offset = d;
        double d2 = this.normal.x * this.normal.x + this.normal.y * this.normal.y + this.normal.z * this.normal.z;
        this.origin = new Vector3d(this.offset / d2 * this.normal.x, this.offset / d2 * this.normal.y, this.offset / d2 * this.normal.z);
    }

    public void setWindow(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Vector3d getTextureCoordinates(Hit hit, Ray ray) {
        Vector3d vector3d = ray.getOrigin();
        Vector3d vector3d2 = ray.getDirection();
        double d = vector3d.x + vector3d2.x * hit.getT();
        double d2 = vector3d.y + vector3d2.y * hit.getT();
        double d3 = vector3d.z + vector3d2.z * hit.getT();
        Vector3d vector3d3 = new Vector3d(d, d2, d3);
        Vector3d vector3d4 = hit.getNormal();
        double d4 = vector3d4.length();
        Vector3d vector3d5 = new Vector3d();
        vector3d5.cross(vector3d4, new Vector3d(1.0, 0.0, 0.0));
        if (vector3d5.length() < 1.0E-5 || vector3d5.length() >= Double.POSITIVE_INFINITY || vector3d5.length() <= Double.NEGATIVE_INFINITY) {
            vector3d5 = new Vector3d();
            vector3d5.cross(vector3d4, new Vector3d(0.0, 1.0, 0.0));
        }
        vector3d5.normalize();
        Vector3d vector3d6 = new Vector3d();
        vector3d6.cross(vector3d4, vector3d5);
        vector3d6.normalize();
        Matrix3d matrix3d = new Matrix3d(vector3d5.x, vector3d6.x, vector3d4.x, vector3d5.y, vector3d6.y, vector3d4.y, vector3d5.z, vector3d6.z, vector3d4.z);
        Matrix3d matrix3d2 = new Matrix3d();
        matrix3d2.invert(matrix3d);
        Vector3d vector3d7 = new Vector3d();
        matrix3d2.transform((Tuple3d)vector3d3, (Tuple3d)vector3d7);
        Vector3d vector3d8 = new Vector3d();
        matrix3d2.transform((Tuple3d)this.origin, (Tuple3d)vector3d8);
        Vector3d vector3d9 = new Vector3d();
        vector3d9.sub((Tuple3d)vector3d7, (Tuple3d)vector3d8);
        Vector3d vector3d10 = new Vector3d();
        Matrix3d matrix3d3 = new Matrix3d(1.0 / (double)this.width, 0.0, 0.0, 0.0, 1.0 / (double)this.height, 0.0, 0.0, 0.0, 1.0);
        Vector3d vector3d11 = new Vector3d();
        Matrix3d matrix3d4 = new Matrix3d(1.0, 0.0, -0.5, 0.0, 1.0, -0.5, 0.0, 0.0, 1.0);
        matrix3d3.transform((Tuple3d)vector3d7, (Tuple3d)vector3d11);
        matrix3d4.transform((Tuple3d)vector3d11, (Tuple3d)vector3d10);
        if (vector3d10.x < 0.0 || vector3d10.x > 1.0) {
            return null;
        }
        if (vector3d10.y < 0.0 || vector3d10.y > 1.0) {
            return null;
        }
        return vector3d10;
    }

    public boolean intersect(Ray ray, Hit hit, double d) {
        double d2 = this.normal.dot(ray.getDirection());
        if (d2 == 0.0) {
            return false;
        }
        double d3 = -(this.normal.dot(ray.getOrigin()) - this.offset) / d2;
        if (d3 < 0.0 || d3 < d) {
            return false;
        }
        double d4 = hit.getT();
        if (d3 < d4) {
            hit.set(d3, this.getMaterial(), this.calcNormal());
        }
        return true;
    }

    public Vector3d calcNormal() {
        return this.normal;
    }
}

