/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stream;

import java.awt.geom.Rectangle2D;
import java.util.Random;
import oracle.mapviewer.share.BasicFeatureType;
import oracle.mapviewer.share.FeatureGroup;
import oracle.mapviewer.share.FeatureType;
import oracle.mapviewer.share.SimpleFeature;
import oracle.mapviewer.share.SimpleGeometry;
import oracle.sdovis.CustomGeomTheme;
import oracle.sdovis.DynamicGeometryTheme;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.spatial.geometry.JGeometry;

public class GeometryFeaturePump {
    Theme theme;
    static Random random = new Random(System.currentTimeMillis());

    public GeometryFeaturePump(Theme theme) {
        if (!(theme instanceof PredefinedGeometryTheme || theme instanceof DynamicGeometryTheme || theme instanceof CustomGeomTheme)) {
            throw new IllegalArgumentException("Only geometry themes are supported.");
        }
        this.theme = theme;
    }

    public FeatureGroup getFeatures(VisContext visContext, Rectangle2D rectangle2D) {
        ThemeDataProducer themeDataProducer = this.theme.getProducer();
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        try {
            themeDataProducer.prepareData(rectangle2D, visContext);
        }
        catch (Exception exception) {
            return null;
        }
        StyledFeatureI[] styledFeatureIArray = themeDataProducer.getStyledFeatures();
        return this.toFeatureGroup(styledFeatureIArray);
    }

    public SimpleFeature[] getFeatures(JGeometry jGeometry, String string) {
        System.out.println("getFeatures(filter, mask) not implemented.");
        return new SimpleFeature[0];
    }

    public final FeatureGroup toFeatureGroup(StyledFeatureI[] styledFeatureIArray) {
        if (styledFeatureIArray == null || styledFeatureIArray.length == 0) {
            return new FeatureGroup(0);
        }
        FeatureType featureType = this.createFeatureType(styledFeatureIArray);
        FeatureGroup featureGroup = new FeatureGroup(styledFeatureIArray.length);
        featureGroup.setType(featureType);
        for (int i = 0; i < styledFeatureIArray.length; ++i) {
            StyledFeatureI styledFeatureI = styledFeatureIArray[i];
            SimpleFeature simpleFeature = this.toSimpleFeature(styledFeatureI);
            featureGroup.addFeature(simpleFeature);
        }
        System.out.println("Streaming geometry features: " + styledFeatureIArray.length + ".");
        return featureGroup;
    }

    public SimpleFeature toSimpleFeature(StyledFeatureI styledFeatureI) {
        if (styledFeatureI == null) {
            return null;
        }
        SimpleFeature simpleFeature = new SimpleFeature();
        simpleFeature.geometry = GeometryFeaturePump.toSimpleGeometry(styledFeatureI.getGeometry());
        return simpleFeature;
    }

    public static final SimpleGeometry toSimpleGeometry(JSDOGeometry jSDOGeometry) {
        SimpleGeometry simpleGeometry = new SimpleGeometry();
        simpleGeometry.dim = jSDOGeometry.getDimensions();
        simpleGeometry.setGtype(jSDOGeometry.getType());
        simpleGeometry.setSrid(jSDOGeometry.getSRID());
        simpleGeometry.setElemInfo(jSDOGeometry.getElemInfo());
        simpleGeometry.setOrdinates(jSDOGeometry.getOrdinatesArray());
        double[] dArray = jSDOGeometry.getLabelPointXYZ();
        if (dArray != null) {
            simpleGeometry.setX(dArray[0]);
            simpleGeometry.setY(dArray[1]);
            if (dArray.length > 2) {
                simpleGeometry.setZ(dArray[2]);
            }
        }
        simpleGeometry.setLinfo(jSDOGeometry.getLRMDimension());
        simpleGeometry.setMbr(jSDOGeometry.getMBR());
        return simpleGeometry;
    }

    FeatureType createFeatureType(StyledFeatureI[] styledFeatureIArray) {
        BasicFeatureType basicFeatureType = new BasicFeatureType();
        return basicFeatureType;
    }
}

