/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stream;

import java.awt.geom.Rectangle2D;
import oracle.mapviewer.share.FeatureGroup;
import oracle.sdovis.CustomGeomTheme;
import oracle.sdovis.PredefinedGeometryTheme;
import oracle.sdovis.RSBundle;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.stream.GeometryFeaturePump;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;

public class GeometryGateway {
    public static FeatureGroup getFeatureFromPT(String string, String string2, int n) throws Exception {
        return GeometryGateway.getFeatureFromPT(string, string2, n, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static FeatureGroup getFeatureFromPT(String string, String string2, int n, double d, double d2, double d3, double d4) throws Exception {
        Theme theme = GeometryGateway.getPredefinedTheme(string, string2);
        GeometryFeaturePump geometryFeaturePump = new GeometryFeaturePump(theme);
        VisContext visContext = new VisContext();
        visContext.setMasterDataSourceName(string2);
        if (n <= 0) {
            n = 8307;
        }
        visContext.setMasterSRID(n);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        visContext.setQueryWindow(double_);
        return geometryFeaturePump.getFeatures(visContext, double_);
    }

    static Theme getPredefinedTheme(String string, String string2) throws Exception {
        Theme theme = null;
        ThemeDefinition themeDefinition = null;
        ThemeCache themeCache = null;
        DataSourceI dataSourceI = DSManager.get(string2);
        themeCache = dataSourceI.getThemeCache();
        themeDefinition = themeCache.getOrLoadThemeDefinition(string);
        if (themeDefinition == null) {
            throw new Exception(RSBundle.getMsg("MAPVIEWER-01002") + " [" + string + "]");
        }
        String string3 = themeDefinition.getThemeType();
        if ("GEOM_PREDEFINED".equals(string3)) {
            PredGeomThemeDefinition predGeomThemeDefinition = (PredGeomThemeDefinition)themeDefinition;
            theme = new PredefinedGeometryTheme(string, predGeomThemeDefinition, null);
            return theme;
        }
        if ("GEOM_CUSTOM".equals(string3)) {
            CustomGeomThemeDefinition customGeomThemeDefinition = (CustomGeomThemeDefinition)themeDefinition;
            theme = new CustomGeomTheme(customGeomThemeDefinition);
            return theme;
        }
        throw new Exception("Theme is not a supported geometry theme.");
    }
}

