/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.ColorStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.ShapeUtil;
import oracle.sdovis.util.XMLDOMParser;

public class StyleColor
implements Style {
    static final long serialVersionUID = -7634361956221034855L;
    ColorStyleModel bean;
    transient Stroke basicStroke = new BasicStroke(1.0f, 0, 2);

    public StyleColor() {
        this.bean = new ColorStyleModel();
    }

    public StyleColor(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public StyleColor(Color color) {
        this.bean = new ColorStyleModel();
        this.bean.setFillColor(color);
    }

    public StyleColor(Color color, Color color2) {
        this.bean = new ColorStyleModel();
        this.bean.setFillColor(color);
        this.bean.setStrokeColor(color2);
    }

    public StyleColor(String string) throws StyleException {
        this.bean = new ColorStyleModel();
        this.parseStyleColor(string);
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof ColorStyleModel)) {
            throw new IllegalArgumentException("Not a ColorStyleModel instance.");
        }
        this.bean = (ColorStyleModel)styleModel;
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    private void parseStyleColor(String string) throws StyleException {
        XMLDOMParser xMLDOMParser;
        if (this.basicStroke == null) {
            this.basicStroke = new BasicStroke(1.0f, 0, 2);
        }
        if (!(xMLDOMParser = new XMLDOMParser()).parse(string)) {
            throw new StyleException("Invalid color style definition.");
        }
        String string2 = xMLDOMParser.getAttribute("g", "class");
        if (string2 == null) {
            throw new StyleException("Invalid color style definition (expecting COLOR).");
        }
        String string3 = xMLDOMParser.getAttribute("g", "style");
        if (string3 == null) {
            throw new StyleException("Invalid color style definition (no color attribute).");
        }
        this.bean.setFillColor(StyleUtils.getColor("fill", string3));
        this.bean.setStrokeColor(StyleUtils.getColor("stroke", string3));
        float f = StyleUtils.getStrokeWidth(string3);
        if (f > 0.0f) {
            float f2 = f;
            this.basicStroke = new BasicStroke(f2, 0, 2);
            this.bean.setStrokeWidth(f2);
        }
    }

    private static StyleColor getDefault() {
        return new StyleColor(null, Color.black);
    }

    public void setStrokeWidth(float f) {
        if (f < 0.0f) {
            return;
        }
        this.bean.setStrokeWidth(f);
        this.basicStroke = new BasicStroke(f, 0, 2);
    }

    public float getStrokeWidth() {
        return this.bean.getStrokeWidth();
    }

    public Object clone() {
        try {
            StyleColor styleColor = (StyleColor)super.clone();
            styleColor.setModel((StyleModel)this.bean.clone());
            return styleColor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public Color getFillColor() {
        return this.bean.getFillColor();
    }

    public void setFillColor(Color color) {
        this.bean.setFillColor(color);
    }

    public Color getStrokeColor() {
        return this.bean.getStrokeColor();
    }

    public void setStrokeColor(Color color) {
        this.bean.setStrokeColor(color);
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        return true;
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Color color = this.bean.getFillColor();
        Color color2 = this.bean.getStrokeColor();
        if (color != null) {
            graphics2D.setColor(color);
        }
        if (color2 != null) {
            graphics2D.setColor(color2);
        }
        graphics2D.drawLine((int)(f - 3.0f), (int)(f2 - 3.0f), (int)(f + 3.0f), (int)(f2 + 3.0f));
        graphics2D.drawLine((int)(f - 3.0f), (int)(f2 + 3.0f), (int)(f + 3.0f), (int)(f2 - 3.0f));
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Color color = this.bean.getFillColor();
        Color color2 = this.bean.getStrokeColor();
        if (color != null) {
            graphics2D.setPaint(color);
            graphics2D.fill(rectangle2D);
        }
        if (color2 != null) {
            graphics2D.setStroke(this.basicStroke);
            graphics2D.setPaint(color2);
            graphics2D.draw(rectangle2D);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Color color = this.bean.getFillColor();
        if (n == 2 || n == 6 || n == 4 && ShapeUtil.numCloseSegments(shape) == 0) {
            Color color2 = this.bean.getStrokeColor();
            if (color != null) {
                graphics2D.setPaint(color);
            }
            if (color2 != null) {
                graphics2D.setPaint(color2);
            }
            graphics2D.setStroke(this.basicStroke);
            graphics2D.draw(shape);
        } else if (n == 4) {
            this.applyToCollectionWithRing(graphics2D, shape);
        } else {
            this.apply(graphics2D, shape);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, styleModifiers);
    }

    protected void apply(Graphics2D graphics2D, Shape shape) {
        Color color = this.bean.getFillColor();
        Color color2 = this.bean.getStrokeColor();
        if (color != null) {
            graphics2D.setPaint(color);
            graphics2D.fill(shape);
        }
        if (color2 != null) {
            graphics2D.setStroke(this.basicStroke);
            graphics2D.setPaint(color2);
            graphics2D.draw(shape);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    protected void applyToCollectionWithRing(Graphics2D graphics2D, Shape shape) {
        int n;
        PathIterator pathIterator = shape.getPathIterator(null);
        Path2D path2D = null;
        GeneralPath generalPath = null;
        GeneralPath generalPath2 = null;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (path2D != null) {
                        n = ShapeUtil.numCloseSegments(path2D);
                        if (n == 0) {
                            if (generalPath == null) {
                                generalPath = new GeneralPath();
                            }
                            generalPath.append(path2D, false);
                        } else {
                            if (generalPath2 == null) {
                                generalPath2 = new GeneralPath();
                            }
                            generalPath2.append(path2D, false);
                        }
                    }
                    path2D = new GeneralPath();
                    ((Path2D.Float)path2D).moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    ((Path2D.Float)path2D).lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    path2D.closePath();
                    break;
                }
                case 3: {
                    ((Path2D.Float)path2D).curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 2: {
                    ((Path2D.Float)path2D).quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
            }
            pathIterator.next();
        }
        if (path2D != null) {
            n = ShapeUtil.numCloseSegments(path2D);
            if (n == 0) {
                if (generalPath == null) {
                    generalPath = new GeneralPath();
                }
                generalPath.append(path2D, false);
            } else {
                if (generalPath2 == null) {
                    generalPath2 = new GeneralPath();
                }
                generalPath2.append(path2D, false);
            }
        }
        if (generalPath != null) {
            this.applyToCollectionElement(graphics2D, generalPath, false);
        }
        if (generalPath2 != null) {
            this.applyToCollectionElement(graphics2D, generalPath2, true);
        }
    }

    private void applyToCollectionElement(Graphics2D graphics2D, GeneralPath generalPath, boolean bl) {
        Color color = this.bean.getFillColor();
        Color color2 = this.bean.getStrokeColor();
        if (bl) {
            this.apply(graphics2D, generalPath);
        } else {
            if (color != null) {
                graphics2D.setPaint(color);
            }
            if (color2 != null) {
                graphics2D.setPaint(color2);
            }
            graphics2D.setStroke(this.basicStroke);
            graphics2D.draw(generalPath);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("svg color point not supported.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) {
        sVGMap.drawRectangle(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight(), this.bean.getStrokeColor(), this.bean.getFillColor());
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        sVGMap.drawShape(shape, this.bean.getStrokeColor(), this.bean.getStrokeWidth(), this.bean.getFillColor(), string, null, null, 0.0, false, null);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        String string4 = sVGMap.drawShape(shape, this.bean.getStrokeColor(), this.bean.getStrokeWidth(), this.bean.getFillColor(), string, string2, rectangle2D, d, bl, string3);
        return string4;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.basicStroke == null) {
            this.basicStroke = new BasicStroke(this.bean.getStrokeWidth(), 0, 2);
        }
    }

    public Object getPropertyValue(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("FILL_COLOR")) {
            return this.bean.getFillColor();
        }
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        return null;
    }
}

