/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.Util;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class StyleTable
extends DBTable {
    String mName = null;
    int mType = 0;
    String mDescription = null;
    StringBuffer mSVGData = null;
    byte[] mImageData = null;
    JSDOGeometry mGeometry = null;
    private CLOB mCLOBSVG;
    private BLOB mBLOBImage;

    public int getType() {
        return this.mType;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getName() {
        return this.mName;
    }

    public StringBuffer getDefinition() {
        return this.mSVGData;
    }

    public byte[] getImageData() {
        return this.mImageData;
    }

    public JSDOGeometry getGeometry() {
        return this.mGeometry;
    }

    public StyleTable(String string, String string2) {
        super(string, string2);
    }

    public int update() throws SQLException {
        String string = this.mName;
        int n = this.mType;
        String string2 = this.mDescription;
        StringBuffer stringBuffer = this.mSVGData;
        byte[] byArray = this.mImageData;
        JSDOGeometry jSDOGeometry = this.mGeometry;
        this.delete();
        this.mName = string;
        this.mType = n;
        this.mDescription = string2;
        this.mSVGData = stringBuffer;
        this.mImageData = byArray;
        this.mGeometry = jSDOGeometry;
        int n2 = this.insert();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert() throws SQLException {
        Object var2_1 = null;
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean bl = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initInsertStatement();
        this.mInsertStatement.setString(1, this.mName.toUpperCase());
        this.mInsertStatement.setString(2, StyleUtils.getTypeNameFromCode(this.mType));
        this.mInsertStatement.setString(3, this.mDescription);
        int n = this.mInsertStatement.executeUpdate();
        this.mConnection.commit();
        this.mConnection.setAutoCommit(false);
        Statement statement = ((OracleConnection)this.mConnection).createStatement();
        String string = "SELECT definition, image FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' FOR UPDATE";
        this.mResultSet = statement.executeQuery(string);
        if (!this.mResultSet.next()) {
            System.err.println("Query: " + string);
            System.err.println("Cannot query " + this.mTableName + "! The inserted row is deleted.");
            n = this.delete();
            return n;
        }
        this.mCLOBSVG = ((OracleResultSet)this.mResultSet).getCLOB("DEFINITION");
        this.mBLOBImage = ((OracleResultSet)this.mResultSet).getBLOB("IMAGE");
        try {
            Util.putClobContents((Clob)this.mCLOBSVG, this.mSVGData.toString());
            if (this.mImageData != null) {
                Util.putBlobContents((Blob)this.mBLOBImage, this.mImageData);
            }
            this.mConnection.commit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            this.close();
        }
        return n;
    }

    public int delete() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        this.initDeleteStatement();
        this.mDeleteStatement.setString(1, this.mName.toUpperCase());
        int n = this.mDeleteStatement.executeUpdate();
        this.mConnection.commit();
        this.close();
        this.mSVGData = null;
        this.mImageData = null;
        this.mName = null;
        this.mType = 0;
        this.mDescription = null;
        this.mCLOBSVG = null;
        this.mBLOBImage = null;
        this.mGeometry = null;
        if (this.mConnection != null) {
            this.mConnection.close();
        }
        return n;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public void setType(int n) {
        this.mType = n;
    }

    public void setType(String string) {
        this.mType = StyleUtils.getTypeCodeFromName(string);
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    public void setDefinition(StringBuffer stringBuffer) {
        this.mSVGData = stringBuffer;
    }

    public void setImage(String string) {
        if (string == null || string.length() < 2) {
            return;
        }
        try {
            this.mImageData = Util.readFile(string);
        }
        catch (IOException iOException) {
            this.mImageData = null;
        }
    }

    public void setImage(byte[] byArray) {
        this.mImageData = byArray;
    }

    public void setGeometry(JSDOGeometry jSDOGeometry) {
        this.mGeometry = jSDOGeometry;
    }

    public Style getStyleObject(String string) throws DataException {
        if (string == null) {
            return null;
        }
        if (string.indexOf(58) > 0 || string.indexOf(47) > 0) {
            int n = string.indexOf(58);
            if (n < 0) {
                n = string.indexOf(47);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            return this.getStyleObject(string3, string2);
        }
        try {
            this.query("select *from " + this.mTableName + " where name='" + string.toUpperCase() + "'");
            if (!this.next()) {
                Style style = null;
                return style;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new DataException(sQLException);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException sQLException) {}
        }
        String string4 = this.mDescription;
        Style style = StyleFactory.createStyleObject(this.mType, this.getDefinition().toString(), this.mImageData);
        if (style != null) {
            style.getModel().setDescription(string4);
        }
        return style;
    }

    public TruetypeFont getTTFont(String string) throws DataException {
        if (string == null) {
            return null;
        }
        Font font = null;
        if (string.indexOf(58) > 0) {
            int n = string.indexOf(58);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            return this.getTTFont(string3, string2);
        }
        try {
            this.query("select * from " + this.mTableName + " where name='" + string.toUpperCase() + "' and type='TTF' and owner='" + this.mUser + "'");
            if (!this.next()) {
                TruetypeFont truetypeFont = null;
                return truetypeFont;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            throw new DataException(sQLException);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException sQLException) {}
        }
        TruetypeFont truetypeFont = new TruetypeFont();
        truetypeFont.setName(this.mName);
        truetypeFont.setDescription(this.mDescription);
        truetypeFont.setFontData(this.mImageData);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mImageData);
            font = Font.createFont(0, byteArrayInputStream);
            truetypeFont.setFont(font);
            return truetypeFont;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DataException(exception.getCause());
        }
    }

    public Style getStyleObject(String string, String string2) throws DataException {
        if (string == null) {
            return null;
        }
        try {
            this.query("select * from " + this.mTableName + " where name='" + string.toUpperCase() + "' and owner='" + string2.toUpperCase() + "'");
            if (!this.next()) {
                Style style = null;
                return style;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new DataException(sQLException);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(System.err);
            }
        }
        String string3 = this.mDescription;
        Style style = StyleFactory.createStyleObject(this.mType, this.getDefinition().toString(), this.mImageData);
        if (style != null) {
            style.getModel().setDescription(string3);
        }
        return style;
    }

    public TruetypeFont getTTFont(String string, String string2) throws DataException {
        if (string == null) {
            return null;
        }
        try {
            this.query("select * from " + this.mTableName + " where name='" + string.toUpperCase() + "' and owner='" + string2.toUpperCase() + "' and type='TTF'");
            if (!this.next()) {
                TruetypeFont truetypeFont = null;
                return truetypeFont;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new DataException(sQLException);
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException sQLException) {}
        }
        TruetypeFont truetypeFont = new TruetypeFont();
        truetypeFont.setName(this.mName);
        truetypeFont.setDescription(this.mDescription);
        truetypeFont.setFontData(this.mImageData);
        Font font = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mImageData);
            font = Font.createFont(0, byteArrayInputStream);
            truetypeFont.setFont(font);
            return truetypeFont;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DataException(exception.getCause());
        }
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void initDeleteStatement() throws SQLException {
        if (this.mDeleteStatement == null) {
            this.mDeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + this.mTableName + " WHERE name = ?");
        }
    }

    protected void initInsertStatement() throws SQLException {
        if (this.mInsertStatement == null) {
            this.mInsertStatement = this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + "(name,type,description,definition,image)" + " VALUES(?, ?, ?, empty_clob(), empty_blob())");
        }
    }

    protected void initUpdateStatement() throws SQLException {
    }

    protected void updateLocalData() throws SQLException {
        String string = null;
        Object var2_2 = null;
        String string2 = null;
        this.mName = this.mResultSet.getString("NAME");
        if (this.mTableName.equals("ALL_SDO_STYLES")) {
            string2 = this.mResultSet.getString("OWNER");
            this.mName = new String(string2 + ":" + this.mName);
        }
        string = this.mResultSet.getString("TYPE");
        this.mType = StyleUtils.getTypeCodeFromName(string);
        this.mDescription = this.mResultSet.getString("DESCRIPTION");
        this.mCLOBSVG = (CLOB)this.mResultSet.getObject("DEFINITION");
        this.mBLOBImage = (BLOB)this.mResultSet.getObject("IMAGE");
        try {
            this.mSVGData = new StringBuffer(this.mCLOBSVG.getSubString(1L, (int)this.mCLOBSVG.length()));
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.mSVGData = null;
        }
        if (this.mBLOBImage == null) {
            this.mImageData = null;
            return;
        }
        try {
            if (this.mBLOBImage.length() < 5L) {
                this.mImageData = null;
                return;
            }
            this.mImageData = this.mBLOBImage.getBytes(1L, (int)this.mBLOBImage.length());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.mImageData = null;
        }
    }
}

