/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.Bidi;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.SRS;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.TextPlacementInfo;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLabeler;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.TextStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;

public class StyleText
implements Style,
StyleLabeler {
    static final long serialVersionUID = 6356666330058786798L;
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static FontRenderContext frc = new FontRenderContext(null, true, false);
    transient AffineTransform at = new AffineTransform();
    transient Properties fontProperties;
    TextStyleModel bean;
    double visualWidthOfA = 0.0;
    transient BasicStroke floatingStroke = null;
    private TruetypeFont ttFont = null;

    public StyleText() {
        this.bean = new TextStyleModel();
    }

    public StyleText(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public StyleText(Font font, Color color, float f) {
        this(font, color);
        this.bean.setHaloWidth(f);
    }

    public StyleText(String string) throws StyleException {
        this.bean = new TextStyleModel();
        if (!this.parseTextStyle(string)) {
            throw new StyleException("Invalid text style definition.");
        }
    }

    public StyleText(Font font, Color color) {
        this.bean = new TextStyleModel();
        this.bean.setFont(font);
        this.bean.setColor(color);
        Rectangle2D rectangle2D = this.getVisualBounds("A", null);
        if (rectangle2D != null) {
            this.visualWidthOfA = rectangle2D.getWidth();
        }
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof TextStyleModel)) {
            throw new IllegalArgumentException("Not a TextStyleModel instance.");
        }
        this.bean = (TextStyleModel)styleModel;
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public Font getFont() {
        return this.bean.getFont();
    }

    public Color getColor() {
        return this.bean.getColor();
    }

    public void setFontProperties(Properties properties) {
        this.fontProperties = properties;
        this.bean.setFont(this.createFont(properties));
    }

    public Properties getFontProperties() {
        return this.fontProperties;
    }

    public Object clone() {
        try {
            StyleText styleText = (StyleText)super.clone();
            styleText.setModel((StyleModel)this.bean.clone());
            return styleText;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public double getCoarseVisualLength(String string) {
        if (!this.bean.getFontSize().isPixelUnit()) {
            return 0.0;
        }
        return this.visualWidthOfA > 0.0 ? (double)string.length() * this.visualWidthOfA : 0.0;
    }

    public Rectangle2D getVisualBounds(String string, StyleModifiers styleModifiers) {
        if (this.bean.getFont() == null || frc == null) {
            System.err.println("no font specified.");
            return null;
        }
        if (string == null) {
            return null;
        }
        Shape shape = StyleText.getStringOutline(string, this.bean, styleModifiers);
        return shape == null ? null : shape.getBounds();
    }

    public static Shape getStringOutline(String string, TextStyleModel textStyleModel, StyleModifiers styleModifiers) {
        if (!(textStyleModel.isAutoTextWrap() || textStyleModel.isHonorNewline() && StyleText.hasLF(string))) {
            return StyleText.getSimpleStringOutline(string, textStyleModel, styleModifiers);
        }
        return StyleText.getStringOutline2(string, textStyleModel, styleModifiers);
    }

    protected static Shape getStringOutline2(String string, TextStyleModel textStyleModel, StyleModifiers styleModifiers) {
        String[] stringArray = StyleText.breakAtLF(string, textStyleModel);
        GeneralPath generalPath = new GeneralPath();
        float[] fArray = new float[1];
        float f = 0.0f;
        for (int i = 0; i < stringArray.length; ++i) {
            Shape shape = StyleText.getWrappedOutline(stringArray[i], textStyleModel, fArray, styleModifiers);
            if (shape == null) continue;
            if (i > 0) {
                shape = AffineTransform.getTranslateInstance(0.0, f).createTransformedShape(shape);
            }
            generalPath.append(shape, false);
            f += fArray[0];
        }
        return generalPath;
    }

    protected static Shape getWrappedOutline(String string, TextStyleModel textStyleModel, float[] fArray, StyleModifiers styleModifiers) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Font font = textStyleModel.getFont();
        if (textStyleModel.getFont() != null && styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
            font = textStyleModel.deriveFont(((TextStyleModifiers)styleModifiers).getFontSize());
        }
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, font, 0, string.length());
        float f = textStyleModel.isAutoTextWrap() ? (float)textStyleModel.getWrappingWidth() : 25000.0f;
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, frc);
        GeneralPath generalPath = new GeneralPath();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while ((n = lineBreakMeasurer.getPosition()) < string.length()) {
            double d;
            Rectangle2D rectangle2D;
            TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
            Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance((double)bl, n2));
            Object object = textStyleModel.getLabelingHint(LabelingHints.KEY_MULTILINE_TEXT_ALIGN);
            if (LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER == object) {
                rectangle2D = shape.getBounds2D();
                d = (double)(f / 2.0f) - rectangle2D.getCenterX();
                shape = AffineTransform.getTranslateInstance(d, 0.0).createTransformedShape(shape);
            } else if (LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_RIGHT == object) {
                rectangle2D = shape.getBounds2D();
                d = (double)f - rectangle2D.getMaxX();
                shape = AffineTransform.getTranslateInstance(d, 0.0).createTransformedShape(shape);
            }
            generalPath.append(shape, false);
            n2 = (int)((float)n2 + textLayout.getAscent());
            if ((double)textStyleModel.getMultilineSpacing() <= 0.0) {
                n2 = (int)((float)n2 + (textLayout.getDescent() + textLayout.getLeading()));
                continue;
            }
            n2 = (int)((float)n2 + (textLayout.getDescent() + textStyleModel.getMultilineSpacing()));
        }
        fArray[0] = n2;
        return generalPath;
    }

    protected static boolean hasLF(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray == null) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            return true;
        }
        return false;
    }

    protected static String[] breakAtLF(String string, TextStyleModel textStyleModel) {
        if (!textStyleModel.isHonorNewline()) {
            return new String[]{string};
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            ++n;
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            stringArray[n3++] = string.substring(n2, i);
            n2 = i + 1;
        }
        stringArray[n3] = string.substring(n2);
        return stringArray;
    }

    protected static Shape getSimpleStringOutline(String string, TextStyleModel textStyleModel, StyleModifiers styleModifiers) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Shape shape = null;
        Font font = textStyleModel.getFont();
        if (textStyleModel.getFont() != null && styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
            font = textStyleModel.deriveFont(((TextStyleModifiers)styleModifiers).getFontSize());
        }
        try {
            char[] cArray = string.toCharArray();
            if (!Bidi.requiresBidi(cArray, 0, cArray.length)) {
                GlyphVector glyphVector = null;
                glyphVector = font == null ? TextStyleModel.getDefaultFont().createGlyphVector(frc, string) : font.createGlyphVector(frc, string);
                if (textStyleModel.getLetterSpacing() > 0.0f) {
                    glyphVector = StyleText.applySpacing(glyphVector, textStyleModel.getLetterSpacing());
                }
                shape = glyphVector.getOutline();
            } else {
                TextLayout textLayout = new TextLayout(string, font == null ? TextStyleModel.getDefaultFont() : font, frc);
                shape = textLayout.getOutline(null);
            }
            return shape;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    public static Shape getLayout(Graphics2D graphics2D, String string, float f, float f2, Object object, double d, int n, TextStyleModel textStyleModel, StyleModifiers styleModifiers) {
        Shape shape = null;
        if (object != LabelingHints.VALUE_OPOINT_HALIGN_START && object != LabelingHints.VALUE_OPOINT_HALIGN_CENTER && object != LabelingHints.VALUE_OPOINT_HALIGN_END) {
            object = LabelingHints.VALUE_OPOINT_HALIGN_START;
        }
        if ((shape = StyleText.getStringOutline(string, textStyleModel, styleModifiers)) == null) {
            return null;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d2 = rectangle2D.getWidth();
        double d3 = (double)f - rectangle2D.getCenterX();
        double d4 = (double)f2 - rectangle2D.getCenterY();
        AffineTransform affineTransform = new AffineTransform();
        if (d != 0.0) {
            affineTransform.setToRotation(d, f, f2);
        }
        if (object == LabelingHints.VALUE_OPOINT_HALIGN_START) {
            affineTransform.translate(d3 + d2 / 2.0 + (double)n, d4);
        } else if (object == LabelingHints.VALUE_OPOINT_HALIGN_CENTER) {
            affineTransform.translate(d3, d4 + (double)n);
        } else {
            affineTransform.translate(d3 - d2 / 2.0 - (double)n, d4);
        }
        return affineTransform.createTransformedShape(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _drawString(Graphics2D graphics2D, float f, float f2, String string, StyleModifiers styleModifiers) {
        Shape shape = StyleText.getStringOutline(string, this.bean, styleModifiers);
        if (shape == null) {
            return;
        }
        graphics2D.translate(f, f2);
        Stroke stroke = graphics2D.getStroke();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.bean.haloEnabled()) {
                this.applyHalo(graphics2D, shape, styleModifiers);
            }
            graphics2D.setPaint(this.bean.getColor());
            graphics2D.fill(shape);
            this.drawTextDecoration(graphics2D, shape.getBounds2D(), null, styleModifiers);
        }
        finally {
            graphics2D.translate(-f, -f2);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, object2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public void applyHalo(Graphics2D graphics2D, Shape shape, StyleModifiers styleModifiers) {
        if (styleModifiers != null && styleModifiers instanceof TextStyleModifiers && ((TextStyleModifiers)styleModifiers).getHaloWidth() < 1.5f) {
            return;
        }
        Stroke stroke = this.initFloatingStroke(styleModifiers);
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(this.bean.getHaloColor());
        graphics2D.draw(shape);
        graphics2D.setStroke(stroke2);
    }

    private boolean parseTextStyle(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Object object6;
        String string7;
        Object object7;
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        if (!xMLDOMParser.parse(string)) {
            return false;
        }
        String string8 = xMLDOMParser.getAttribute("g", "class");
        if (string8 == null || !string8.toUpperCase().equals("TEXT")) {
            return false;
        }
        String string9 = xMLDOMParser.getAttribute("g", "float-width");
        if (string9 != null && string9.length() > 0) {
            object7 = SizeDefinition.parse(string9);
            if (object7 != null) {
                this.bean.setHaloWidth((float)((SizeDefinition)object7).getValue());
                this.bean.setHaloWidthUnit(((SizeDefinition)object7).getUnit());
            } else {
                this.bean.setHaloWidth(-1.0f);
                this.bean.setHaloWidthUnit(null);
            }
        }
        if ((object7 = xMLDOMParser.getAttribute("g", "float-color")) != null && ((String)object7).length() > 0) {
            try {
                this.bean.setHaloColor(StyleUtils.getColor("float-color", "float-color:" + (String)object7));
                string7 = xMLDOMParser.getAttribute("g", "float-color-opacity");
                if (string7 != null && string7.trim().length() > 0) {
                    int n = Integer.parseInt(string7.trim());
                    object6 = this.bean.getHaloColor();
                    if (object6 != null) {
                        this.bean.setHaloColor(new Color(((Color)object6).getRed(), ((Color)object6).getGreen(), ((Color)object6).getBlue(), n));
                    }
                }
            }
            catch (Exception exception) {
                log.warning("error parsing float-color attr.");
            }
        }
        this.bean.setSticky(false);
        string7 = xMLDOMParser.getAttribute("g", "sticky");
        if (string7 != null && string7.length() > 0) {
            this.bean.setSticky("true".equalsIgnoreCase(string7));
        }
        this.bean.setEmbeddedTTFont(null);
        String string10 = xMLDOMParser.getAttribute("g", "embedded-ttf");
        if (string10 != null && string10.length() > 0) {
            if (!"true".equalsIgnoreCase(string10)) {
                string10 = "false";
            }
        } else {
            string10 = "false";
        }
        if ((object6 = xMLDOMParser.getAttribute("g", "auto-wrap")) != null && ((String)object6).length() > 0) {
            this.bean.setAutoTextWrap("true".equalsIgnoreCase((String)object6));
            string6 = xMLDOMParser.getAttribute("g", "wrapping-width");
            if (string6 != null && string6.length() > 0) {
                this.bean.setWrappingWidth((int)Double.parseDouble(string6));
            }
        }
        if ((string6 = xMLDOMParser.getAttribute("g", "honor-newline")) != null && string6.length() > 0) {
            this.bean.setHonorNewline("true".equalsIgnoreCase(string6));
        }
        if ((string5 = xMLDOMParser.getAttribute("g", "letter-spacing")) != null && string5.length() > 0) {
            try {
                this.bean.setLetterSpacing(Float.parseFloat(string5));
            }
            catch (Exception exception) {
                log.warning("invalid letter-spacing value.");
            }
        }
        if ((string4 = xMLDOMParser.getAttribute("g", "multiline-spacing")) != null && string4.length() > 0) {
            try {
                this.bean.setMultilineSpacing(Float.parseFloat(string4));
            }
            catch (Exception exception) {
                log.warning("invalid multiline-spacing value.");
            }
        }
        if ((string3 = xMLDOMParser.getAttribute("g", "style")) == null) {
            return false;
        }
        String string11 = StyleUtils.getNamedString(string3, "font-family");
        String string12 = StyleUtils.getNamedString(string3, "font-size");
        String string13 = StyleUtils.getNamedString(string3, "font-weight");
        String string14 = StyleUtils.getNamedString(string3, "font-style");
        String string15 = StyleUtils.getNamedString(string3, "fill");
        String string16 = StyleUtils.getNamedString(string3, "text-align");
        if (string16 != null && string16.length() > 0) {
            if ("left".equalsIgnoreCase(string16)) {
                this.bean.setLabelingHint(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_LEFT);
            } else if ("right".equalsIgnoreCase(string16)) {
                this.bean.setLabelingHint(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_RIGHT);
            } else {
                this.bean.setLabelingHint(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER);
            }
        }
        if ((string2 = StyleUtils.getNamedString(string3, "text-decoration")) != null && string2.length() > 0) {
            this.bean.setTextDecoration(string2);
        }
        this.fontProperties = new Properties();
        this.fontProperties.put("font-family", string11 != null ? string11 : "");
        this.fontProperties.put("font-size", string12 != null ? string12 : "");
        this.fontProperties.put("font-weight", string13 != null ? string13 : "");
        this.fontProperties.put("font-style", string14 != null ? string14 : "");
        this.fontProperties.put("font-fill", string15 != null ? string15 : "");
        if (string15 != null) {
            this.bean.setColor(StyleUtils.getColor("fill", string3));
        }
        int n = 0;
        if (string14 != null && string14.toUpperCase().equals("ITALIC")) {
            n = 2;
        }
        if (string13 != null && string13.toUpperCase().equals("BOLD")) {
            n = n == 2 ? (n |= 1) : 1;
        }
        int n2 = 12;
        if (string12 != null) {
            object5 = SizeDefinition.parse(string12);
            if (object5 != null) {
                n2 = (int)((SizeDefinition)object5).getValue();
                this.bean.setFontSize((float)((SizeDefinition)object5).getValue(), ((SizeDefinition)object5).getUnit());
            } else {
                this.bean.setFontSize(12.0f, null);
            }
        }
        if ("false".equalsIgnoreCase(string10)) {
            this.bean.setFont(new Font(string11, n, n2));
        } else {
            StyleText styleText = this;
            this.bean.setFont(new Font(styleText.bean.getDefaultFont().getFamily(), n, n2));
            this.bean.setEmbeddedTTFont(string11);
        }
        object5 = xMLDOMParser.getElementNode("opoint");
        if (object5 != null) {
            object4 = XMLDOMParser.getAttribute((Node)object5, "halign");
            object3 = XMLDOMParser.getAttribute((Node)object5, "valign");
            if (object4 == null || ((String)object4).length() == 0) {
                object4 = "center";
            }
            if (object3 == null || ((String)object3).length() == 0) {
                object3 = "middle";
            }
            object4 = ((String)object4).toLowerCase();
            object3 = ((String)object3).toLowerCase();
            object2 = null;
            object = null;
            object2 = "center".equals(object4) ? LabelingHints.VALUE_OPOINT_HALIGN_CENTER : ("start".equals(object4) ? LabelingHints.VALUE_OPOINT_HALIGN_START : ("end".equals(object4) ? LabelingHints.VALUE_OPOINT_HALIGN_END : LabelingHints.VALUE_OPOINT_HALIGN_CENTER));
            object = "middle".equals(object3) ? LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE : ("top".equals(object3) ? LabelingHints.VALUE_OPOINT_VALIGN_TOP : ("bottom".equals(object3) ? LabelingHints.VALUE_OPOINT_VALIGN_BOTTOM : ("baseline".equals(object3) ? LabelingHints.VALUE_OPOINT_VALIGN_BASELINE : LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE)));
            this.bean.setLabelingHint(LabelingHints.KEY_OPOINT_HALIGN, object2);
            this.bean.setLabelingHint(LabelingHints.KEY_OPOINT_VALIGN, object);
        }
        if ((object4 = xMLDOMParser.getElementNode("text-along-path")) != null) {
            object3 = XMLDOMParser.getAttribute((Node)object4, "valign");
            if (object3 == null || ((String)object3).length() == 0) {
                object3 = "middle";
            }
            object3 = ((String)object3).toLowerCase();
            object2 = null;
            object2 = "middle".equals(object3) ? LabelingHints.VALUE_LINE_VALIGN_MIDDLE : ("top".equals(object3) ? LabelingHints.VALUE_LINE_VALIGN_TOP : ("bottom".equals(object3) ? LabelingHints.VALUE_LINE_VALIGN_BOTTOM : ("baseline".equals(object3) ? LabelingHints.VALUE_LINE_VALIGN_BASELINE : LabelingHints.VALUE_LINE_VALIGN_MIDDLE)));
            this.bean.setLabelingHint(LabelingHints.KEY_LINE_VALIGN, object2);
            object = XMLDOMParser.getAttribute((Node)object4, "smart-path-following");
            if (object != null && "true".equalsIgnoreCase((String)object)) {
                this.bean.setSmartPathFollowing(true);
            } else {
                this.bean.setSmartPathFollowing(false);
            }
            String string17 = XMLDOMParser.getAttribute((Node)object4, "straight-line-labeling");
            if (string17 != null && "true".equalsIgnoreCase(string17)) {
                this.bean.setStraightLineLabeling(true);
            } else {
                this.bean.setStraightLineLabeling(false);
            }
        }
        if (this.bean.getFontSize().isPixelUnit() && (object3 = this.getVisualBounds("A", null)) != null) {
            this.visualWidthOfA = ((RectangularShape)object3).getWidth();
        }
        return true;
    }

    private Font createFont(Properties properties) {
        Serializable serializable;
        String string = properties.getProperty("font-family");
        String string2 = properties.getProperty("font-size");
        String string3 = properties.getProperty("font-weight");
        String string4 = properties.getProperty("font-style");
        String string5 = properties.getProperty("font-fill");
        if (string5 != null && string5.length() > 0) {
            this.bean.setColor(StyleUtils.getColor("fill", string5));
        }
        int n = 0;
        if (string4 != null && string4.toUpperCase().equals("ITALIC")) {
            n = 2;
        }
        if (string3 != null && string3.toUpperCase().equals("BOLD")) {
            n = n == 2 ? (n |= 1) : 1;
        }
        int n2 = 12;
        if (string2 != null && string2.length() > 0) {
            serializable = SizeDefinition.parse(string2);
            if (serializable != null) {
                n2 = (int)((SizeDefinition)serializable).getValue();
                this.bean.setFontSize((float)((SizeDefinition)serializable).getValue(), ((SizeDefinition)serializable).getUnit());
            } else {
                this.bean.setFontSize(12.0f, null);
            }
        }
        serializable = new Font(string, n, n2);
        return serializable;
    }

    private Stroke initFloatingStroke(StyleModifiers styleModifiers) {
        if (styleModifiers != null) {
            return this.createFloatingStroke(styleModifiers);
        }
        if (this.floatingStroke == null) {
            this.floatingStroke = (BasicStroke)this.createFloatingStroke(null);
            return this.floatingStroke;
        }
        return this.floatingStroke;
    }

    public Stroke createFloatingStroke(StyleModifiers styleModifiers) {
        float f = this.bean.getHaloWidth();
        if (styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
            f = ((TextStyleModifiers)styleModifiers).getHaloWidth();
        }
        return new BasicStroke(f, 0, 2);
    }

    public void applyToCenter(SVGMap sVGMap, int n, int n2, String string, StyleModifiers styleModifiers) {
        Rectangle2D rectangle2D = this.getVisualBounds(string, styleModifiers);
        if (rectangle2D == null) {
            return;
        }
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = (double)n - rectangle2D.getWidth() / 2.0;
        double d4 = (double)n2 - rectangle2D.getHeight() / 2.0;
        d3 -= d;
        d4 -= d2;
        Font font = this.bean.getFont();
        if (this.bean.getFont() != null && styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
            font = this.bean.deriveFont(((TextStyleModifiers)styleModifiers).getFontSize());
        }
        sVGMap.drawText(string, (int)d3, (int)d4, 0.0, font, this.bean.getColor());
    }

    public void revealSelf(SVGMap sVGMap, double d, double d2, double d3, double d4, StyleModifiers styleModifiers) {
        Font font = this.bean.getFont();
        if (this.bean.getFont() != null && styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
            font = this.bean.deriveFont(((TextStyleModifiers)styleModifiers).getFontSize());
        }
        sVGMap.drawText("Hello World", d - 10.0, d2, 0.0, font, this.bean.getColor());
    }

    public void applyToSVG(SVGMap sVGMap, double d, double d2, double d3, String string, int n, StyleModifiers styleModifiers) {
        Font font = this.bean.getFont();
        if (this.bean.getFont() != null && styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
            font = this.bean.deriveFont(((TextStyleModifiers)styleModifiers).getFontSize());
        }
        sVGMap.drawText(string, d, d2, d3, font, this.bean.getColor(), n);
    }

    public void applyToSVG(SVGMap sVGMap, double d, double d2, double d3, String string, StyleModifiers styleModifiers) {
        Font font = this.bean.getFont();
        if (this.bean.getFont() != null && styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
            font = this.bean.deriveFont(((TextStyleModifiers)styleModifiers).getFontSize());
        }
        sVGMap.drawText(string, d, d2, d3, font, this.bean.getColor());
    }

    public void applyToSVG(SVGMap sVGMap, double d, double d2, double d3, Object object, int n, String string, StyleModifiers styleModifiers) {
        Font font = this.bean.getFont();
        if (this.bean.getFont() != null && styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
            font = this.bean.deriveFont(((TextStyleModifiers)styleModifiers).getFontSize());
        }
        Point2D point2D = this.getAnchorForSVG(sVGMap, d, d2, d3, object, n, string, 0, styleModifiers);
        sVGMap.drawText(string, point2D.getX(), point2D.getY(), d3, font, this.bean.getColor());
    }

    public void applyToSVG(SVGMap sVGMap, double d, double d2, double d3, Object object, int n, String string, int n2, StyleModifiers styleModifiers) {
        Font font = this.bean.getFont();
        if (this.bean.getFont() != null && styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
            font = this.bean.deriveFont(((TextStyleModifiers)styleModifiers).getFontSize());
        }
        Point2D point2D = this.getAnchorForSVG(sVGMap, d, d2, d3, object, n, string, n2, styleModifiers);
        sVGMap.drawText(string, point2D.getX(), point2D.getY(), d3, font, this.bean.getColor(), n2);
    }

    private Point2D getAnchorForSVG(SVGMap sVGMap, double d, double d2, double d3, Object object, int n, String string, int n2, StyleModifiers styleModifiers) {
        char[] cArray = string.toCharArray();
        Rectangle2D rectangle2D = null;
        if (!Bidi.requiresBidi(cArray, 0, cArray.length)) {
            rectangle2D = this.getVisualBounds(string, styleModifiers);
        } else {
            Font font = this.bean.getFont();
            if (this.bean.getFont() != null && styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
                font = this.bean.deriveFont(((TextStyleModifiers)styleModifiers).getFontSize());
            }
            TextLayout textLayout = new TextLayout(string, this.bean.getFont() == null ? TextStyleModel.getDefaultFont() : font, frc);
            Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(d, d2));
            rectangle2D = shape.getBounds2D();
        }
        int n3 = (int)(Math.cos(d3) * rectangle2D.getWidth() / 2.0);
        int n4 = (int)(Math.sin(d3) * rectangle2D.getWidth() / 2.0);
        double d4 = sVGMap.getScale(n2);
        if (LabelingHints.VALUE_OPOINT_HALIGN_START == object) {
            d += (double)n;
        } else if (LabelingHints.VALUE_OPOINT_HALIGN_CENTER == object) {
            d -= (double)n3 / d4;
            d2 -= (double)n4 / d4;
        } else if (LabelingHints.VALUE_OPOINT_HALIGN_END == object) {
            d = d - (double)(n3 * 2) / d4 - (double)n;
            d2 -= (double)(n4 * 2) / d4;
        }
        return new Point2D.Double(d, d2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        if (this.bean.getEmbeddedTTFont() != null) {
            if (this.ttFont == null || !this.bean.getEmbeddedTTFont().equalsIgnoreCase(this.ttFont.getName())) {
                this.ttFont = styleCache.getFont(this.bean.getEmbeddedTTFont());
                if (this.ttFont != null && this.ttFont.getFont() != null) {
                    this.bean.setFont(this.ttFont.getFont().deriveFont(this.bean.getFont().getStyle(), this.bean.getFontSizeValue()));
                } else {
                    StyleText styleText = this;
                    this.bean.setFont(styleText.bean.getDefaultFont());
                    this.ttFont = null;
                }
            }
        } else {
            this.ttFont = null;
        }
        return true;
    }

    public void drawString(Graphics2D graphics2D, float f, float f2, double d, String string, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (d == 0.0) {
            graphics2D.setFont(this.bean.getFont());
            Rectangle2D rectangle2D = this.getVisualBounds(string, styleModifiers);
            this._drawString(graphics2D, f, f2, string, styleModifiers);
        } else {
            Shape shape = StyleText.getStringOutline(string, this.bean, styleModifiers);
            Shape shape2 = null;
            Shape shape3 = null;
            if (shape == null) {
                return;
            }
            Rectangle2D rectangle2D = shape.getBounds2D();
            this.at.setToRotation(d);
            shape2 = this.at.createTransformedShape(shape);
            rectangle2D = shape2.getBounds2D();
            this.at.setToTranslation(f, f2);
            shape3 = this.at.createTransformedShape(shape2);
            rectangle2D = shape3.getBounds2D();
            if (this.bean.haloEnabled()) {
                this.applyHalo(graphics2D, shape3, styleModifiers);
            }
            if (this.bean.getColor() != null) {
                graphics2D.setColor(this.bean.getColor());
            }
            graphics2D.fill(shape3);
            this.drawTextDecoration(graphics2D, rectangle2D, this.at, styleModifiers);
        }
    }

    public void apply(Graphics2D graphics2D, float f, float f2, String string, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(graphics2D, f, f2, LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0.0, 0, string, styleModifiers);
    }

    public void apply(Graphics2D graphics2D, Rectangle2D rectangle2D, String string, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Shape shape = StyleText.getStringOutline(string, this.bean, styleModifiers);
        if (shape == null) {
            return;
        }
        Shape shape2 = null;
        Object var7_7 = null;
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        this.at.setToTranslation(rectangle2D.getCenterX() - rectangle2D2.getCenterX(), rectangle2D.getCenterY() - rectangle2D2.getCenterY());
        shape2 = this.at.createTransformedShape(shape);
        if (this.bean.haloEnabled()) {
            this.applyHalo(graphics2D, shape2, styleModifiers);
        }
        if (this.bean.getColor() != null) {
            graphics2D.setColor(this.bean.getColor());
        }
        graphics2D.fill(shape2);
        this.drawTextDecoration(graphics2D, rectangle2D2, this.at, styleModifiers);
    }

    public void apply(Graphics2D graphics2D, float f, float f2, Object object, double d, int n, String string, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Shape shape = StyleText.getLayout(graphics2D, string, f, f2, object, d, n, this.bean, styleModifiers);
        if (shape == null) {
            return;
        }
        this.drawOutline(graphics2D, shape, styleModifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOutline(Graphics2D graphics2D, Shape shape, StyleModifiers styleModifiers) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.bean.haloEnabled()) {
                this.applyHalo(graphics2D, shape, styleModifiers);
            }
            if (this.bean.getColor() != null) {
                graphics2D.setColor(this.bean.getColor());
            }
            graphics2D.fill(shape);
        }
        finally {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, object2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    private void drawTextDecoration(Graphics2D graphics2D, Rectangle2D rectangle2D, AffineTransform affineTransform, StyleModifiers styleModifiers) {
        if (graphics2D == null || rectangle2D == null) {
            return;
        }
        String string = this.bean.getTextDecoration();
        if (string.equalsIgnoreCase(TextStyleModel.TEXT_DECORATION_NONE)) {
            return;
        }
        double d = rectangle2D.getBounds().x;
        double d2 = rectangle2D.getBounds().y;
        double d3 = rectangle2D.getBounds().width;
        double d4 = rectangle2D.getBounds().height;
        if (this.bean.haloEnabled()) {
            float f = this.bean.getHaloWidth();
            if (styleModifiers != null && styleModifiers instanceof TextStyleModifiers) {
                f = ((TextStyleModifiers)styleModifiers).getHaloWidth();
            }
            d -= (double)f / 2.0;
            d2 -= (double)f / 2.0;
            d3 += (double)f;
            d4 += (double)f;
        }
        Line2D.Double double_ = new Line2D.Double();
        if (string.equalsIgnoreCase(TextStyleModel.TEXT_DECORATION_UNDERLINE)) {
            double_.setLine(d, d2 + d4, d + d3, d2 + d4);
        } else if (string.equalsIgnoreCase(TextStyleModel.TEXT_DECORATION_LINETHROUGH)) {
            double_.setLine(d, d2 + (double)((int)(0.5 * d4)), d + d3, d2 + (double)((int)(0.5 * d4)));
        } else if (string.equalsIgnoreCase(TextStyleModel.TEXT_DECORATION_OVERLINE)) {
            double_.setLine(d, d2, d + d3, d2);
        } else {
            return;
        }
        Shape shape = double_;
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(double_);
        }
        graphics2D.draw(shape);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(graphics2D, rectangle2D, "123 Main St", styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(Graphics2D graphics2D, TextPlacementInfo textPlacementInfo, VisContext visContext, StyleModifiers styleModifiers) {
        Shape shape = textPlacementInfo.getTextShape();
        Rectangle2D rectangle2D = textPlacementInfo.getTextShapeMBR();
        AffineTransform affineTransform = new AffineTransform();
        double d = textPlacementInfo.getRotation();
        if (d != 0.0) {
            affineTransform.setToRotation(d, textPlacementInfo.getRotationAnchorX(), textPlacementInfo.getRotationAnchorY());
        }
        float f = (float)((double)textPlacementInfo.getTextCenterX() - rectangle2D.getCenterX());
        float f2 = (float)((double)textPlacementInfo.getTextCenterY() - rectangle2D.getCenterY());
        if (f != 0.0f || f2 != 0.0f) {
            affineTransform.translate(f, f2);
        }
        shape = affineTransform.createTransformedShape(shape);
        this.drawOutline(graphics2D, shape, styleModifiers);
        this.drawTextDecoration(graphics2D, rectangle2D, affineTransform, styleModifiers);
        if (visContext != null) {
            visContext.getCRArray().insert(shape.getBounds2D());
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Invalid style application.");
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    protected static GlyphVector applySpacing(GlyphVector glyphVector, float f) {
        if (f <= 5.0f) {
            return glyphVector;
        }
        int n = glyphVector.getNumGlyphs();
        double d = glyphVector.getLogicalBounds().getWidth() / (double)n;
        double d2 = d * (double)f / 100.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            Point2D point2D = glyphVector.getGlyphPosition(i);
            Point2D.Double double_ = new Point2D.Double(point2D.getX() + d3, point2D.getY());
            glyphVector.setGlyphPosition(i, double_);
            d3 += d2;
        }
        return glyphVector;
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        if (this.bean.getFontSize().isPixelUnit() && this.bean.getHaloSize().isPixelUnit()) {
            return null;
        }
        TextStyleModifiers textStyleModifiers = new TextStyleModifiers();
        if (visContext == null || Util.isFullExtent(visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMaxX(), visContext.getQueryWindow().getMaxY()) || visContext.getQueryWindow().getWidth() == 0.0 && visContext.getQueryWindow().getHeight() == 0.0) {
            SizeDefinition sizeDefinition;
            SizeDefinition sizeDefinition2 = this.bean.getFontSize();
            if (sizeDefinition2.isPixelUnit()) {
                textStyleModifiers.setFontSize((int)sizeDefinition2.getValue());
            }
            if ((sizeDefinition = this.bean.getHaloSize()).isPixelUnit()) {
                textStyleModifiers.setHaloWidth((int)sizeDefinition.getValue());
            }
        } else {
            double d;
            Rectangle2D rectangle2D = visContext.getDeviceWindow();
            Rectangle2D rectangle2D2 = visContext.getQueryWindow();
            double d2 = rectangle2D2.getWidth() / rectangle2D.getWidth();
            d2 = d = rectangle2D2.getHeight() / rectangle2D.getHeight();
            double d3 = this.getPixelValue(this.bean.getFontSize(), d, visContext);
            if (d3 > 0.0) {
                textStyleModifiers.setFontSize((int)d3);
            }
            if ((d3 = this.getPixelValue(this.bean.getHaloSize(), d2, visContext)) > 0.0) {
                textStyleModifiers.setHaloWidth((int)d3);
            }
        }
        return textStyleModifiers;
    }

    private double getPixelValue(SizeDefinition sizeDefinition, double d, VisContext visContext) {
        Double d2 = null;
        if (sizeDefinition.getUnit() != null) {
            d2 = SRS.getDistanceConversionFactor(sizeDefinition.getUnit());
        }
        if (sizeDefinition.isPixelUnit()) {
            return sizeDefinition.getValue();
        }
        if (d2 != null) {
            double d3 = sizeDefinition.getValue() * d2;
            if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                double d4 = SphereCG.convertRadius(0.0, 0.0, d3);
                return d4 / d + 0.5;
            }
            return d3 / d + 0.5;
        }
        return 0.0;
    }
}

