/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;

public class TextStroke
implements Stroke {
    static final String ERROR_INVALID_TEXT_ARGUMENT = "Error : bad text";
    static final FontRenderContext frc = new FontRenderContext(null, true, true);
    static final int FLATTENESS = 1;
    private Area glyphMBRs;
    private GlyphVector glyphVector;
    private float ascent;
    private int nGlyphs;
    private boolean cycle;
    private float cycleGap;
    private String text;
    private Font font;
    float[] seg = new float[6];
    SegmentControl ctl = new SegmentControl();
    Rectangle2D deviceView = null;
    private double startOffset;
    AffineTransform glyphTransform = new AffineTransform();
    AffineTransform at = new AffineTransform();

    public TextStroke(Font font, boolean bl, float f, double d) {
        if (font == null) {
            throw new NullPointerException();
        }
        this.setFont(font);
        this.cycle = bl;
        this.cycleGap = f;
        if (f < 0.0f) {
            this.cycleGap = font.getSize();
        }
        this.startOffset = d;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new NullPointerException();
        }
        if (this.font == null || !this.font.equals(font)) {
            this.font = font;
            LineMetrics lineMetrics = this.font.getLineMetrics("ljqLJQ", frc);
            this.ascent = lineMetrics.getAscent();
        }
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setDeviceView(double d, double d2, double d3, double d4) {
        this.deviceView = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
    }

    public Shape createStrokedShape(Shape shape) {
        return this.createStrokedShape(shape, 0, null, false);
    }

    public Shape createStrokedShape(Shape shape, int n, RectArray rectArray, boolean bl) {
        int n2 = 0;
        int n3 = ShapeUtil.numLineSegments(shape, this.seg);
        if (this.text == null || this.text.trim().length() == 0) {
            throw new IllegalArgumentException(ERROR_INVALID_TEXT_ARGUMENT);
        }
        this.glyphVector = this.font.createGlyphVector(frc, this.text);
        this.glyphVector.performDefaultLayout();
        this.nGlyphs = this.glyphVector.getNumGlyphs();
        PathIterator pathIterator = shape.getPathIterator(null);
        int n4 = 0;
        this.ctl.reset();
        boolean bl2 = false;
        while (!pathIterator.isDone()) {
            n4 = pathIterator.currentSegment(this.seg);
            switch (n4) {
                case 0: {
                    if (!this.ctl.fits) {
                        this.ctl.reset();
                    }
                    this.ctl.x = this.seg[0];
                    this.ctl.y = this.seg[1];
                    this.ctl.mx = this.ctl.x;
                    this.ctl.my = this.ctl.y;
                    this.ctl.start = true;
                    break;
                }
                case 1: {
                    this.ctl.dx = this.seg[0];
                    this.ctl.dy = this.seg[1];
                    this.ctl.start = false;
                    bl2 = this.processSegment(this.ctl, rectArray, ++n2 >= n3, bl);
                    break;
                }
                case 4: {
                    this.ctl.dx = this.ctl.mx;
                    this.ctl.dy = this.ctl.my;
                    this.ctl.start = false;
                    bl2 = this.processSegment(this.ctl, rectArray, n2 >= n3, bl);
                    break;
                }
                default: {
                    throw new Error("Illegal seg type : " + n4);
                }
            }
            pathIterator.next();
            if (this.ctl.abort) {
                return null;
            }
            if (!bl2) continue;
        }
        if (rectArray != null) {
            rectArray.addAll(this.ctl.mbrs);
        }
        if (this.ctl.glyphIndex < this.nGlyphs - 1) {
            return null;
        }
        return this.ctl.s;
    }

    private boolean processSegment(SegmentControl segmentControl, RectArray rectArray, boolean bl, boolean bl2) {
        float f;
        boolean bl3 = false;
        float f2 = (float)Point2D.distance(segmentControl.x, segmentControl.y, segmentControl.dx, segmentControl.dy);
        float f3 = (segmentControl.dx - segmentControl.x) / f2;
        float f4 = (segmentControl.dy - segmentControl.y) / f2;
        if (segmentControl.firstTime) {
            segmentControl.startCredit = (float)((double)(-f2) * this.startOffset);
            segmentControl.firstTime = false;
        }
        segmentControl.x -= f3 * segmentControl.startCredit;
        segmentControl.y -= f4 * segmentControl.startCredit;
        float f5 = segmentControl.ngx - segmentControl.d;
        float f6 = segmentControl.x + f5 * f3;
        float f7 = segmentControl.y + f5 * f4;
        float f8 = (float)Math.atan2(segmentControl.dy - segmentControl.y, segmentControl.dx - segmentControl.x);
        float f9 = 0.0f;
        if (!segmentControl.start) {
            f = f8 - segmentControl.previousAngle;
            if ((double)f < -Math.PI) {
                f += (float)Math.PI * 2;
            }
            if ((double)f > Math.PI) {
                f -= (float)Math.PI * 2;
            }
            if (f < 0.0f) {
                f9 = Math.abs(this.ascent * (float)Math.tan(f / 2.0f));
                f2 -= f9;
                f6 += f9 * f3;
                f7 += f9 * f4;
            }
        }
        if (segmentControl.d + segmentControl.startCredit + f2 > segmentControl.ngx + (float)segmentControl.glyphWidth) {
            segmentControl.previousAngle = f8;
            this.at.setToIdentity();
            this.at.translate(f6 - segmentControl.ngx, f7 - segmentControl.ngy);
            this.at.rotate(f8, segmentControl.ngx, segmentControl.ngy);
            this.at.concatenate(segmentControl.defaultTransform);
            if (this.deviceView != null && !this.deviceView.contains(f6, f7)) {
                segmentControl.abort = true;
                bl3 = true;
                return bl3;
            }
            f = f2 + segmentControl.startCredit;
            segmentControl.fits = true;
            while (segmentControl.fits) {
                Point2D point2D = this.glyphVector.getGlyphPosition(segmentControl.glyphIndex);
                this.glyphTransform.setToIdentity();
                this.glyphTransform.concatenate(this.at);
                Shape shape = this.glyphVector.getGlyphOutline(segmentControl.glyphIndex);
                Rectangle2D rectangle2D = shape.getBounds2D();
                Shape shape2 = null;
                if (rectangle2D.getMinX() < 1.0) {
                    this.glyphTransform.translate(point2D.getX(), point2D.getY());
                }
                shape2 = this.glyphTransform.createTransformedShape(shape);
                rectangle2D = shape2.getBounds2D();
                segmentControl.mbrs.addElement(rectangle2D);
                if (rectArray != null && !bl2 && rectArray.conflicts(rectangle2D)) {
                    segmentControl.abort = true;
                    bl3 = true;
                    break;
                }
                segmentControl.s.append(shape2, false);
                float f10 = (float)segmentControl.defaultTransform.getTranslateX() + (float)point2D.getX() + (float)segmentControl.glyphWidth;
                f -= f10 - segmentControl.d;
                segmentControl.d = f10;
                segmentControl.x += (float)segmentControl.glyphWidth * f3;
                segmentControl.y += (float)segmentControl.glyphWidth * f4;
                ++segmentControl.glyphIndex;
                if (segmentControl.glyphIndex >= this.nGlyphs) {
                    if (!this.cycle) {
                        bl3 = true;
                        segmentControl.fits = false;
                    } else {
                        segmentControl.defaultTransform.translate((float)this.glyphVector.getVisualBounds().getWidth() + this.cycleGap, 0.0);
                        this.at.translate((float)this.glyphVector.getVisualBounds().getWidth() + this.cycleGap, 0.0);
                    }
                }
                if (bl3) continue;
                segmentControl.glyphIndex %= this.nGlyphs;
                segmentControl.ngx = (float)segmentControl.defaultTransform.getTranslateX() + (float)this.glyphVector.getGlyphPosition(segmentControl.glyphIndex).getX();
                segmentControl.ngy = (float)this.glyphVector.getGlyphPosition(segmentControl.glyphIndex).getY();
                segmentControl.glyphWidth = this.glyphVector.getGlyphLogicalBounds((int)segmentControl.glyphIndex).getBounds().width;
                boolean bl4 = segmentControl.fits = segmentControl.d + f > segmentControl.ngx + (float)segmentControl.glyphWidth;
                if (segmentControl.fits || !bl) continue;
                bl3 = true;
                segmentControl.abort = true;
                break;
            }
            segmentControl.x = segmentControl.dx;
            segmentControl.y = segmentControl.dy;
            segmentControl.startCredit = f;
        }
        return bl3;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public float getCycleGap() {
        return this.cycleGap;
    }

    class SegmentControl {
        boolean abort = false;
        boolean fits = true;
        boolean done = false;
        float x;
        float y;
        float mx;
        float my;
        float dx;
        float dy;
        float startCredit;
        float d;
        float ngx;
        float ngy;
        int glyphWidth;
        int glyphIndex;
        boolean start;
        boolean firstTime = true;
        float previousAngle;
        Vector mbrs = new Vector(48);
        GeneralPath s = new GeneralPath();
        AffineTransform defaultTransform = new AffineTransform();

        public void reset() {
            this.done = false;
            this.firstTime = true;
            this.mbrs.removeAllElements();
            this.s.reset();
            this.defaultTransform.setToIdentity();
            this.abort = false;
            this.glyphIndex = 0;
            this.fits = true;
            this.ngx = 0.0f;
            this.ngy = 0.0f;
            this.glyphWidth = ((TextStroke)TextStroke.this).glyphVector.getGlyphOutline((int)0).getBounds().width;
            this.previousAngle = 0.0f;
            this.d = 0.0f;
            this.startCredit = 0.0f;
        }
    }
}

