/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.ColorSchemeStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ColorSchemeStyle
extends BucketStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public ColorSchemeStyle() {
        this.bean = new ColorSchemeStyleModel();
    }

    public ColorSchemeStyle(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public ColorSchemeStyle(Document document) throws StyleException {
        this.bean = new ColorSchemeStyleModel();
        try {
            String string;
            Color color;
            int n;
            String string2;
            Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
            Node node2 = XMLDOMParser.getSubElement(node, "ColorSchemeStyle");
            node = XMLDOMParser.getSubElement(node2, "Buckets");
            BucketStyle.fetchBuckets(node, this.bean.getBucketSeries());
            Color color2 = StyleUtils.getColor(XMLDOMParser.getAttribute(node2, "basecolor"));
            if (color2 != null) {
                ((ColorSchemeStyleModel)this.bean).setBaseColor(color2);
            }
            if (XMLDOMParser.getAttribute(node2, "strokecolor").length() > 0) {
                ((ColorSchemeStyleModel)this.bean).setStrokeColor(StyleUtils.getColor(XMLDOMParser.getAttribute(node2, "strokecolor")));
            }
            if ((string2 = XMLDOMParser.getAttribute(node2, "basecolor_opacity")) != null && string2.trim().length() > 0) {
                try {
                    n = Integer.parseInt(string2.trim());
                    if (n >= 0 && n <= 255 && (color = ((ColorSchemeStyleModel)this.bean).getBaseColor()) != null) {
                        ((ColorSchemeStyleModel)this.bean).setBaseColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string2 = XMLDOMParser.getAttribute(node2, "strokecolor_opacity")) != null && string2.trim().length() > 0) {
                try {
                    n = Integer.parseInt(string2.trim());
                    if (n >= 0 && n <= 255 && (color = ((ColorSchemeStyleModel)this.bean).getStrokeColor()) != null) {
                        ((ColorSchemeStyleModel)this.bean).setStrokeColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLDOMParser.getAttribute(node2, "strokewidth")) != null && string.trim().length() > 0) {
                try {
                    Color color3;
                    float f = Float.parseFloat(string.trim());
                    if (f < 1.0f) {
                        f = 1.0f;
                    }
                    if ((color3 = ((ColorSchemeStyleModel)this.bean).getStrokeColor()) != null) {
                        ((ColorSchemeStyleModel)this.bean).setStrokeWidth(f);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.reset();
        }
        catch (Exception exception) {
            throw new StyleException("Invalid ColorScheme style definition.");
        }
    }

    public ColorSchemeStyle(BucketSeries bucketSeries, Color color, Color color2) {
        this.bean = new ColorSchemeStyleModel(bucketSeries);
        ((ColorSchemeStyleModel)this.bean).setBaseColor(color);
        ((ColorSchemeStyleModel)this.bean).setStrokeColor(color2);
        this.reset();
    }

    public ColorSchemeStyle(BucketSeries bucketSeries, Color color, Color color2, float f) {
        this.bean = new ColorSchemeStyleModel(bucketSeries);
        ((ColorSchemeStyleModel)this.bean).setBaseColor(color);
        ((ColorSchemeStyleModel)this.bean).setStrokeColor(color2);
        ((ColorSchemeStyleModel)this.bean).setStrokeWidth(f);
        this.reset();
    }

    public Object clone() {
        ColorSchemeStyle colorSchemeStyle = (ColorSchemeStyle)super.clone();
        colorSchemeStyle.setModel((StyleModel)this.bean.clone());
        return colorSchemeStyle;
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public Color getBaseColor() {
        return ((ColorSchemeStyleModel)this.bean).getBaseColor();
    }

    public void setBaseColor(Color color) {
        ((ColorSchemeStyleModel)this.bean).setBaseColor(color);
        this.reset();
    }

    public Color getStrokeColor() {
        return ((ColorSchemeStyleModel)this.bean).getStrokeColor();
    }

    public void setStrokeColor(Color color) {
        ((ColorSchemeStyleModel)this.bean).setStrokeColor(color);
        this.reset();
    }

    public void reset() {
        Color color = ((ColorSchemeStyleModel)this.bean).getBaseColor();
        Color color2 = ((ColorSchemeStyleModel)this.bean).getStrokeColor();
        float f = ((ColorSchemeStyleModel)this.bean).getStrokeWidth();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        float[] fArray = new float[3];
        Color.RGBtoHSB(n, n2, n3, fArray);
        BucketSeries bucketSeries = this.bean.getBucketSeries();
        int n5 = bucketSeries.size();
        float f2 = 1.0f / (float)n5;
        for (int i = 0; i < n5; ++i) {
            Bucket bucket = bucketSeries.getBucket(i);
            if (bucket.getRenderStyle() != null || bucket.getRenderStyleName() != null) {
                log.finest("using user specified style.");
                continue;
            }
            float f3 = fArray[2] - fArray[2] * (f2 * (float)i);
            Color color3 = new Color(Color.HSBtoRGB(fArray[0], fArray[1], f3));
            Color color4 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue(), n4);
            StyleColor styleColor = new StyleColor(color4, color2);
            if (color2 != null) {
                styleColor.setStrokeWidth(f);
            }
            bucket.setRenderStyle(styleColor);
        }
    }

    public int getMaxLegendWidth(Graphics2D graphics2D, int n) {
        return super.getMaxLegendWidth(graphics2D, n);
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        if (this.bean == null) {
            return true;
        }
        String string = this.bean.getBucketSeries().getDefaultRenderStyleName();
        Style style = (Style)this.bean.getBucketSeries().getDefaultRenderStyle();
        if (string != null && style == null) {
            style = Util.getStyle(string, styleCache, hashtable);
            this.bean.getBucketSeries().setDefaultRenderStyle(style);
        }
        if (style != null && !(style instanceof AdvancedStyle)) {
            style.resolveStyles(styleCache, hashtable);
        }
        return true;
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof ColorSchemeStyleModel)) {
            throw new IllegalArgumentException("Not a ColorSchemeStyleModel instance.");
        }
        this.bean = (ColorSchemeStyleModel)styleModel;
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply ColorSchemeStyle to a point.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        BucketSeries bucketSeries = this.bean.getBucketSeries();
        int n = bucketSeries.size();
        double d = (rectangle2D.getHeight() - 4.0) / (double)n;
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        for (int i = 0; i < n; ++i) {
            Bucket bucket = bucketSeries.getBucket(i);
            double d2 = rectangle2D.getMinY() + d * (double)i;
            ((Rectangle2D)float_).setRect(rectangle2D.getMinX(), d2, rectangle2D.getWidth(), d);
            this.drawBucketWithLabel(graphics2D, bucket, float_, 0.2f, 0.8f, null);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (!(shape instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("ColorSchemeStyle not applicable without an attr value.");
        }
        this.apply(null, graphics2D, (Rectangle2D)shape, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Style style = this.chooseStyle(fieldArray[0]);
        if (style != null) {
            style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, null);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        super.apply(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        super.apply(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, style, stringArray2, string2, styleModifiers);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply ColorSchemeStyle to a point without attribute.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        int n = (int)rectangle2D.getCenterX();
        int n2 = (int)rectangle2D.getCenterY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        int n5 = this.bean.getBucketSeries().size();
        try {
            int n6;
            int n7 = n - n3 / 2;
            int n8 = n6 = n2 - n4 / 2;
            int n9 = n4 / n5;
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            for (int i = 0; i < n5; ++i) {
                Bucket bucket = this.bean.getBucketSeries().getBucket(i);
                Style style = (Style)bucket.getRenderStyle();
                int n10 = (int)((double)n3 * 0.2);
                int n11 = n9;
                ((Rectangle2D)float_).setRect(n7, n6 + i * n9, n10, n11);
                int n12 = (int)((double)n7 + (double)n3 * 0.1);
                n8 = n6 + i * n9 + n9 / 2;
                style.apply(null, sVGMap, (Rectangle2D)float_, null);
                String string = bucket.getBucketLabel();
                if (string == null) continue;
                Font font = new Font("Dialog", 0, 10);
                int n13 = n6 + n9 * i + n9 - 3;
                sVGMap.drawText(string, (int)((double)n7 + (double)n3 * 0.2 + 3.0), n13, 0.0, font, Color.black);
            }
        }
        catch (Exception exception) {
            sVGMap.drawText(" * bad style *", 10.0, 10.0, 0.0, new Font("Dialog", 0, 10), Color.black);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Style style = this.chooseStyle(fieldArray[0]);
        if (style == null) {
            log.warning("cannot find a suitable style based on your values [" + fieldArray[0] + "].");
            return;
        }
        style.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, null);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        super.apply(visContext, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Style style2 = this.chooseStyle(fieldArray[0]);
        if (style2 != null) {
            return style2.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, null);
        }
        log.warning("cannot find a suitable style based on your values [" + fieldArray[0] + "].");
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return super.applyToSVG(visContext, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, stringArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return super.applyToSVG(visContext, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, stringArray, style2, stringArray2, string4, styleModifiers);
    }

    public Object getPropertyValue(String string) {
        return null;
    }
}

