/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.stylex.DotDensityStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.SRS;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.DotDensityStyleModifiers;
import oracle.sdovis.stylex.DotDistributor;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DotDensityStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private DotDensityStyleModel bean;
    transient StyleMarker markerStyle = null;

    public DotDensityStyle() {
        this.bean = new DotDensityStyleModel();
    }

    public DotDensityStyle(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public DotDensityStyle(int n, int n2, String string) {
        this.bean = new DotDensityStyleModel();
        this.bean.setDotWidth(n);
        this.bean.setDotHeight(n2);
        this.bean.setMarkerStyleName(string);
    }

    public DotDensityStyle(Document document) throws StyleException {
        this.bean = new DotDensityStyleModel();
        try {
            Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
            Node node2 = XMLDOMParser.getSubElement(node, "DotDensityStyle");
            String string = XMLDOMParser.getAttribute(node2, "DotWidth");
            String string2 = XMLDOMParser.getAttribute(node2, "DotHeight");
            SizeDefinition2D sizeDefinition2D = SizeDefinition2D.parse(string, string2);
            if (sizeDefinition2D == null) {
                throw new StyleException("Invalid dot size in DotDensityStyle definition.");
            }
            this.bean.setDotWidth(sizeDefinition2D.getWidth());
            this.bean.setDotHeight(sizeDefinition2D.getHeight());
            this.bean.setDotUnit(sizeDefinition2D.getUnit());
            this.bean.setMarkerStyleName(XMLDOMParser.getAttribute(node2, "MarkerStyle"));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            throw new StyleException("Invalid DotDensity style definition.");
        }
    }

    public Object clone() {
        try {
            DotDensityStyle dotDensityStyle = (DotDensityStyle)super.clone();
            dotDensityStyle.setModel((StyleModel)this.bean.clone());
            return dotDensityStyle;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    void applyToShape(Graphics2D graphics2D, Shape shape, Field[] fieldArray, StyleModifiers styleModifiers) {
        double d = fieldArray[0].getDouble();
        int n = (int)d;
        if (n <= 0) {
            return;
        }
        DotDensityStyle dotDensityStyle = this;
        if (n > dotDensityStyle.bean.getMaxDots()) {
            log.warning("count value is too big for Dot-Density style.");
            DotDensityStyle dotDensityStyle2 = this;
            log.warning("changing count to maxium allowed number (" + dotDensityStyle2.bean.getMaxDots() + ").");
            DotDensityStyle dotDensityStyle3 = this;
            n = dotDensityStyle3.bean.getMaxDots() - 1;
        }
        DotDistributor dotDistributor = new DotDistributor(shape, n);
        dotDistributor.checkDots();
        JSDOGeometry jSDOGeometry = dotDistributor.getDots();
        this.drawMarkers(graphics2D, jSDOGeometry, styleModifiers);
    }

    public void drawMarkers(Graphics2D graphics2D, JSDOGeometry jSDOGeometry, StyleModifiers styleModifiers) {
        if (jSDOGeometry == null) {
            return;
        }
        double[] dArray = jSDOGeometry.getOrdinatesArray();
        if (dArray == null) {
            return;
        }
        int n = this.bean.getDotWidth();
        int n2 = this.bean.getDotHeight();
        if (styleModifiers != null && styleModifiers instanceof DotDensityStyleModifiers) {
            n = ((DotDensityStyleModifiers)styleModifiers).getDotWidth();
            n2 = ((DotDensityStyleModifiers)styleModifiers).getDotHeight();
        }
        if (this.markerStyle != null) {
            double d = this.markerStyle.getDoubleDesiredWidth();
            double d2 = this.markerStyle.getDoubleDesiredHeight();
            this.markerStyle.setDesiredWidth(n);
            this.markerStyle.setDesiredHeight(n2);
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            for (int i = 0; i < dArray.length; i += 2) {
                ((Rectangle2D)float_).setRect(dArray[i] - (double)(n / 2), dArray[i + 1] - (double)(n2 / 2), n, n2);
                try {
                    this.markerStyle.apply(null, graphics2D, (Rectangle2D)float_, null);
                    continue;
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, exception.getMessage(), exception);
                }
            }
            this.markerStyle.setDesiredWidth(d);
            this.markerStyle.setDesiredHeight(d2);
        } else {
            graphics2D.setColor(Color.black.brighter());
            for (int i = 0; i < dArray.length; i += 2) {
                graphics2D.fillOval((int)(dArray[i] - (double)(n / 2)), (int)(dArray[i + 1] - (double)(n2 / 2)), n, n2);
            }
        }
    }

    public int getMaxLegendWidth(Graphics2D graphics2D, int n) {
        return 0;
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        String string = this.bean.getMarkerStyleName();
        if (string == null || this.markerStyle != null) {
            return true;
        }
        this.markerStyle = (StyleMarker)Util.getStyle(string, styleCache, hashtable);
        return this.markerStyle != null;
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof DotDensityStyleModel)) {
            throw new IllegalArgumentException("Not a DotDensityStyleModel instance.");
        }
        this.bean = (DotDensityStyleModel)styleModel;
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("DotDensityStyle not applicable to points.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.applyToShape(graphics2D, rectangle2D, new Field[]{new Field(13)}, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (!(shape instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("cannot apply DotDensityStyle without attributes.");
        }
        this.apply(null, graphics2D, (Rectangle2D)shape, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (n != 3 && n != 7) {
            log.warning("Cannot apply dot density style to non-polygon features.");
            return;
        }
        this.applyToShape(graphics2D, shape, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Field[] fieldArray2 = this.pickValues(fieldArray, stringArray);
        if (fieldArray2 != null) {
            fieldArray = fieldArray2;
        }
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Field[] fieldArray2 = this.pickValues(fieldArray, stringArray);
        if (fieldArray2 != null) {
            fieldArray = fieldArray2;
        }
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    private Field[] pickValues(Field[] fieldArray, String[] stringArray) {
        if (fieldArray != null && stringArray != null) {
            Field field = null;
            String string = stringArray[0];
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!fieldArray[i].getName().equalsIgnoreCase(string)) continue;
                field = fieldArray[i];
                break;
            }
            if (field != null) {
                fieldArray = new Field[]{field};
                return fieldArray;
            }
            return null;
        }
        return null;
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("DotDensityStyle not applicable to points.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        if (this.bean.getDotSize().isPixelUnit()) {
            return null;
        }
        DotDensityStyleModifiers dotDensityStyleModifiers = new DotDensityStyleModifiers();
        if (visContext == null || Util.isFullExtent(visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMaxX(), visContext.getQueryWindow().getMaxY()) || visContext.getQueryWindow().getWidth() == 0.0 && visContext.getQueryWindow().getHeight() == 0.0) {
            if (this.bean.getDotSize().isPixelUnit()) {
                dotDensityStyleModifiers.setDotWidth(this.bean.getDotWidth());
                dotDensityStyleModifiers.setDotHeight(this.bean.getDotHeight());
            }
        } else {
            Rectangle2D rectangle2D = visContext.getDeviceWindow();
            Rectangle2D rectangle2D2 = visContext.getQueryWindow();
            double d = rectangle2D2.getWidth() / rectangle2D.getWidth();
            double d2 = rectangle2D2.getHeight() / rectangle2D.getHeight();
            double d3 = Math.max(d, d2);
            Double d4 = null;
            if (this.bean.getDotUnit() != null) {
                d4 = SRS.getDistanceConversionFactor(this.bean.getDotUnit());
            }
            if (this.bean.getDotSize().isPixelUnit()) {
                dotDensityStyleModifiers.setDotWidth(this.bean.getDotWidth());
                dotDensityStyleModifiers.setDotHeight(this.bean.getDotHeight());
            } else if (d4 != null) {
                double d5;
                double d6 = this.bean.getDoubleDotWidth() * d4;
                if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                    d5 = SphereCG.convertRadius(0.0, 0.0, d6);
                    dotDensityStyleModifiers.setDotWidth((int)(d5 / d3 + 0.5));
                } else {
                    dotDensityStyleModifiers.setDotWidth((int)(d6 / d3 + 0.5));
                }
                d5 = this.bean.getDoubleDotHeight() * d4;
                if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                    double d7 = SphereCG.convertRadius(0.0, 0.0, d5);
                    dotDensityStyleModifiers.setDotHeight((int)(d7 / d3 + 0.5));
                } else {
                    dotDensityStyleModifiers.setDotHeight((int)(d5 / d3 + 0.5));
                }
            }
        }
        return dotDensityStyleModifiers;
    }
}

