/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.stylex.Dot;

class DotDistributor {
    private Area area;
    private int numofpoints;
    private Dot dots;
    private double density;

    public DotDistributor() {
    }

    public DotDistributor(Shape shape, int n) {
        this.area = new Area(shape);
        this.numofpoints = n;
        this.density = this.getDensity(this.getAreaSize(null));
        Rectangle2D rectangle2D = this.area.getBounds2D();
        double d = Math.ceil(Math.sqrt(this.numofpoints));
        d = Math.pow(d, 2.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        d = this.extendMBR(rectangle2D, (long)d, this.density, double_);
        this.dots = new Dot((long)d, this.area, double_);
    }

    public DotDistributor(JSDOGeometry jSDOGeometry, int n) {
        this(jSDOGeometry.createShape(), n);
    }

    private double getDensity(double d) {
        return d / (double)this.numofpoints;
    }

    public double getAreaSize(AffineTransform affineTransform) {
        double d = 0.0;
        double[] dArray = new double[6];
        double[] dArray2 = new double[2];
        PathIterator pathIterator = this.area.getPathIterator(affineTransform);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 1: {
                    d += (dArray2[0] + dArray[0]) * (dArray[1] - dArray2[1]);
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                default: {
                    System.out.println("Error: cannot calculate area of polygon with curve/cubic edge");
                    System.exit(1);
                }
            }
            pathIterator.next();
        }
        return (d /= 2.0) > 0.0 ? d : -1.0 * d;
    }

    private long extendMBR(Rectangle2D rectangle2D, long l, double d, Rectangle2D.Double double_) {
        Rectangle2D.Double double_2 = new Rectangle2D.Double();
        boolean bl = false;
        double d2 = rectangle2D.getWidth() > rectangle2D.getHeight() ? rectangle2D.getWidth() : rectangle2D.getHeight();
        long l2 = (long)Math.sqrt(l);
        double d3 = (double)l2 * Math.sqrt(d);
        while (d3 < d2) {
            d3 += Math.sqrt(d);
            ++l2;
        }
        l = l2 * l2;
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getY();
        double_2.setRect(d4, d5, d3, d3);
        double_.setRect(double_2);
        return l;
    }

    public void checkDots() {
        for (int i = 0; i < this.numofpoints; ++i) {
            this.dots.arrangeDot(i);
        }
    }

    public JSDOGeometry getDots() {
        double[][] dArray = new double[this.numofpoints][2];
        for (int i = 0; i < this.numofpoints; ++i) {
            Point2D.Double double_ = this.dots.getDot(i);
            dArray[i][0] = double_.getX();
            dArray[i][1] = double_.getY();
        }
        return JSDOGeometry.recast(JSDOGeometry.createMultiPoint((Object[])dArray, (int)2, (int)8265));
    }
}

