/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

class Grid
implements Comparable {
    private Rectangle2D.Double grid;
    private long index;
    private Area intersection;
    private double intersectionSize;
    private boolean contained;

    public Grid(long l, long l2, Area area, Rectangle2D.Double double_) {
        this.index = l;
        long l3 = (long)Math.sqrt(l2);
        double d = double_.getWidth() / (double)l3;
        double d2 = double_.getX() + (double)(l % l3) * d;
        double d3 = double_.getY() + (double)(l / l3) * d;
        this.grid = new Rectangle2D.Double(d2, d3, d, d);
        this.contained = area.contains(this.grid);
        this.intersection = (Area)area.clone();
        this.setIntersection(this.intersection);
        this.intersectionSize = this.getAreaSize(this.intersection, null);
    }

    private void setIntersection(Area area) {
        area.intersect(new Area(this.grid));
    }

    public Area getIntersection() {
        return this.intersection;
    }

    public Rectangle2D.Double getGrid() {
        return this.grid;
    }

    public boolean isContained() {
        return this.contained;
    }

    private double getAreaSize(Area area, AffineTransform affineTransform) {
        double d = 0.0;
        double[] dArray = new double[6];
        double[] dArray2 = new double[2];
        PathIterator pathIterator = area.getPathIterator(affineTransform);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 1: {
                    d += (dArray2[0] + dArray[0]) * (dArray[1] - dArray2[1]);
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                default: {
                    System.out.println("Error: cannot calculate area of polygon with curve/cubic edge");
                    System.exit(1);
                }
            }
            pathIterator.next();
        }
        return (d /= 2.0) > 0.0 ? d : -1.0 * d;
    }

    public double getSize() {
        return this.getAreaSize(new Area(this.grid), null);
    }

    public double getWidth() {
        return this.grid.getWidth();
    }

    public double getX() {
        return this.grid.getX();
    }

    public double getY() {
        return this.grid.getY();
    }

    public double getIntersectionSize() {
        return this.intersectionSize;
    }

    public int compareTo(Object object) {
        double d = ((Grid)object).getIntersectionSize() - this.intersectionSize;
        if (d > 0.0) {
            return 1;
        }
        if (d == 0.0) {
            return 0;
        }
        return -1;
    }
}

