/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.PieChartStyleModel;
import oracle.mapviewer.share.stylex.PieSliceInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.SRS;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.charts.piechart.PieChart;
import oracle.sdovis.charts.types.PieSliceDesc;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PieChartStyle
implements AdvancedStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private PieChartStyleModel bean;
    private boolean ignoreSliceDescName = false;

    public PieChartStyle() {
        this.bean = new PieChartStyleModel();
    }

    public PieChartStyle(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public PieChartStyle(int n, PieSliceInfo[] pieSliceInfoArray) {
        this.bean = new PieChartStyleModel(n, pieSliceInfoArray);
    }

    public PieChartStyle(Document document) throws StyleException {
        this.bean = new PieChartStyleModel();
        try {
            Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
            node = XMLDOMParser.getSubElement(node, "PieChartStyle");
            String string = XMLDOMParser.getAttribute(node, "pieradius");
            SizeDefinition sizeDefinition = SizeDefinition.parse(string);
            if (sizeDefinition == null) {
                throw new StyleException("Invalid pie radius size in PieChartStyle definition.");
            }
            this.bean.setPieRadiusSize(sizeDefinition);
            this.bean.setPieRadiusUnit(sizeDefinition.getUnit());
            ArrayList arrayList = XMLDOMParser.getSubElements(node, "PieSlice");
            this.bean.setNumSlices(arrayList.size());
            PieSliceInfo[] pieSliceInfoArray = new PieSliceInfo[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                Node node2 = (Node)arrayList.get(i);
                PieSliceInfo pieSliceInfo = new PieSliceInfo();
                pieSliceInfo.setName(XMLDOMParser.getAttribute(node2, "name"));
                try {
                    pieSliceInfo.setColor(StyleUtils.getColor(XMLDOMParser.getAttribute(node2, "color")));
                }
                catch (Exception exception) {
                    pieSliceInfo.setColor(null);
                }
                pieSliceInfoArray[i] = pieSliceInfo;
            }
            this.bean.setPieSlices(pieSliceInfoArray);
        }
        catch (Exception exception) {
            throw new StyleException("Invalid PieChartStyle definition.");
        }
    }

    public Object clone() {
        try {
            PieChartStyle pieChartStyle = (PieChartStyle)super.clone();
            pieChartStyle.setModel((StyleModel)this.bean.clone());
            return pieChartStyle;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public int getPieRadius() {
        return this.bean.getPieRadius();
    }

    public double getDoublePieRadius() {
        return this.bean.getDoublePieRadius();
    }

    public void setPieRadius(int n) {
        this.bean.setPieRadius(n);
    }

    public void setPieRadius(double d) {
        this.bean.setPieRadius(d);
    }

    public void setPieRadiusUnit(String string) {
        this.bean.setPieRadiusUnit(string);
    }

    public String getPieRadiusUnit() {
        return this.bean.getPieRadiusUnit();
    }

    public int getNumSlices() {
        return this.bean.getNumSlices();
    }

    public void setNumSlices(int n) {
        this.bean.setNumSlices(n);
    }

    public int getMaxLegendWidth(Graphics2D graphics2D, int n) {
        int n2 = 0;
        int n3 = 0;
        Font font = new Font("Serif", 0, n);
        String string = null;
        PieSliceInfo[] pieSliceInfoArray = this.bean.getPieSlices();
        FontRenderContext fontRenderContext = graphics2D == null ? new FontRenderContext(null, true, false) : graphics2D.getFontRenderContext();
        for (int i = 0; i < this.getNumSlices(); ++i) {
            string = pieSliceInfoArray[i].getName();
            if (string == null || string.length() == 0 || (n2 = (int)font.getStringBounds(string, fontRenderContext).getWidth()) <= n3) continue;
            n3 = n2;
        }
        return n3;
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        return true;
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof PieChartStyleModel)) {
            throw new IllegalArgumentException("Not a PieChartStyleModel instance.");
        }
        this.bean = (PieChartStyleModel)styleModel;
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("PieChartStyle not applicable to a point.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        AffineTransform affineTransform = graphics2D.getTransform();
        try {
            int n = (int)rectangle2D.getMinX();
            int n2 = (int)rectangle2D.getMinY();
            int n3 = this.bean.getNumSlices();
            PieSliceInfo[] pieSliceInfoArray = this.bean.getPieSlices();
            PieSliceDesc[] pieSliceDescArray = new PieSliceDesc[n3];
            for (int i = 0; i < n3; ++i) {
                pieSliceDescArray[i] = !this.ignoreSliceDescName ? new PieSliceDesc(pieSliceInfoArray[i].getName(), 25.0) : new PieSliceDesc(null, 25.0);
                pieSliceDescArray[i].setBackground(pieSliceInfoArray[i].getColor());
            }
            PieChart pieChart = new PieChart();
            pieChart.setSize((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            pieChart.setBackground(null);
            pieChart.setBackgroundRectOff();
            pieChart.setSeries(pieSliceDescArray);
            if (!this.ignoreSliceDescName) {
                pieChart.setLastWordNewline();
            }
            pieChart.setBorderLeft(0);
            pieChart.setBorderRight(0);
            pieChart.setBorderTop(0);
            pieChart.setBorderBottom(0);
            graphics2D.translate(n, n2);
            pieChart.drawBuffer(graphics2D);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage(), exception);
        }
        graphics2D.setTransform(affineTransform);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (!(shape instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("PieChartStyle not applicable without values.");
        }
        this.apply(null, graphics2D, (Rectangle2D)shape, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        int n2;
        int n3 = this.bean.getPieRadius() * 2;
        if (styleModifiers != null && styleModifiers instanceof PieChartStyleModifiers) {
            n3 = ((PieChartStyleModifiers)styleModifiers).getPieRadius() * 2;
        }
        if (n3 < 1) {
            return;
        }
        int n4 = n3;
        if (point2D == null) {
            if (n == 3 || n == 7) {
                float[] fArray = LabelHelper.findLoc4RectInPolygon(shape, 5.0, 5.0, (RectArray)conflictResolver, true, false, null);
                if (fArray != null) {
                    point2D = new Point2D.Float(fArray[0], fArray[1]);
                }
            } else {
                return;
            }
        }
        if (point2D != null && conflictResolver != null) {
            conflictResolver.insert(point2D.getX() - (double)(n3 / 2), point2D.getY() - (double)(n4 / 2), (double)n3, (double)n4);
        }
        int n5 = this.bean.getNumSlices();
        if (fieldArray == null || fieldArray.length < n5) {
            log.warning("Insufficient attribute fields for the given pie chart style.");
            return;
        }
        double[] dArray = new double[n5];
        try {
            for (n2 = 0; n2 < n5; ++n2) {
                dArray[n2] = fieldArray[n2].getShortJavaTypeName().equalsIgnoreCase("string") ? Double.parseDouble(fieldArray[n2].getString()) : fieldArray[n2].getDouble();
            }
        }
        catch (Exception exception) {
            log.warning("invalid (type of) values for PieChartStyle.");
            return;
        }
        n2 = (int)point2D.getX();
        int n6 = (int)point2D.getY();
        PieSliceInfo[] pieSliceInfoArray = this.bean.getPieSlices();
        PieSliceDesc[] pieSliceDescArray = new PieSliceDesc[n5];
        for (int i = 0; i < n5; ++i) {
            pieSliceDescArray[i] = new PieSliceDesc(null, dArray[i]);
            pieSliceDescArray[i].setBackground(pieSliceInfoArray[i].getColor());
        }
        PieChart pieChart = new PieChart();
        n3 = (int)((double)this.bean.getPieRadius() * 2.0);
        if (styleModifiers != null && styleModifiers instanceof PieChartStyleModifiers) {
            n3 = ((PieChartStyleModifiers)styleModifiers).getPieRadius() * 2;
        }
        n4 = n3;
        pieChart.setSize(n3, n4);
        pieChart.setBackground(null);
        pieChart.setBackgroundRectOff();
        pieChart.setBorderLeft(0);
        pieChart.setBorderRight(0);
        pieChart.setBorderTop(0);
        pieChart.setBorderBottom(0);
        AffineTransform affineTransform = graphics2D.getTransform();
        try {
            pieChart.setSeries(pieSliceDescArray);
            graphics2D.translate(n2 - n3 / 2, n6 - n4 / 2);
            pieChart.drawBuffer(graphics2D);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        graphics2D.setTransform(affineTransform);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("PieChartStyle not applicable without attribute values.");
        }
        int n2 = this.bean.getNumSlices();
        if (stringArray == null) {
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            if (n2 < 1) {
                throw new StyleNotApplicableException("PieChartStyle must have at least one slice.");
            }
            if (stringArray.length < n2) {
                throw new StyleNotApplicableException("Not enough style columns for PieChartStyle.");
            }
            Field[] fieldArray2 = new Field[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                fieldArray2[i] = null;
                String string2 = stringArray[i];
                fieldArray2[i] = Util.getField(string2, fieldArray);
                if (fieldArray2[i] != null) continue;
                throw new StyleNotApplicableException("Unable to find attribute " + string2 + " for PieChartStyle.");
            }
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray2, styleModifiers);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (stringArray == null) {
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, styleModifiers);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        try {
            int n = (int)rectangle2D.getMinX();
            int n2 = (int)rectangle2D.getMinY();
            int n3 = this.bean.getNumSlices();
            int n4 = (int)rectangle2D.getWidth();
            int n5 = (int)rectangle2D.getHeight();
            int n6 = n2;
            int n7 = n5 / n3;
            PieSliceInfo[] pieSliceInfoArray = this.bean.getPieSlices();
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            for (int i = 0; i < n3; ++i) {
                Color color = pieSliceInfoArray[i].getColor();
                StyleColor styleColor = new StyleColor(color, Color.BLACK);
                int n8 = (int)((double)n4 * 0.2);
                int n9 = n7;
                int n10 = (int)((double)n + (double)n4 * 0.1);
                n6 = n2 + i * n7 + n7 / 2;
                ((Rectangle2D)float_).setRect(n, n2 + i * n7, n8, n9);
                styleColor.apply(null, sVGMap, (Rectangle2D)float_, null);
                String string = pieSliceInfoArray[i].getName();
                if (string == null) continue;
                Font font = new Font("Dialog", 0, 10);
                int n11 = n2 + n7 * i + n7 - 3;
                sVGMap.drawText(string, (int)((double)n + (double)n4 * 0.2 + 3.0), n11, 0.0, font, Color.black);
            }
        }
        catch (Exception exception) {
            sVGMap.drawText(" * bad style *", 10.0, 10.0, 0.0, new Font("Dialog", 0, 10), Color.black);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (point2D != null) {
            n3 = (int)point2D.getX();
            n4 = (int)point2D.getY();
        } else {
            n3 = (int)shape.getBounds().getCenterX();
            n4 = (int)shape.getBounds().getCenterY();
        }
        int n5 = this.bean.getNumSlices();
        PieSliceInfo[] pieSliceInfoArray = this.bean.getPieSlices();
        double[] dArray = new double[n5];
        Color[] colorArray = new Color[n5];
        String[] stringArray = new String[n5];
        try {
            for (n2 = 0; n2 < dArray.length && n2 < n5; ++n2) {
                dArray[n2] = fieldArray[n2].getShortJavaTypeName().equalsIgnoreCase("string") ? Double.parseDouble(fieldArray[n2].getString()) : fieldArray[n2].getDouble();
                colorArray[n2] = pieSliceInfoArray[n2].getColor();
                stringArray[n2] = pieSliceInfoArray[n2].getName();
                if (stringArray[n2].trim().length() != 0) continue;
                stringArray[n2] = null;
            }
        }
        catch (Exception exception) {
            log.warning("invalid (type of) values for PieChartStyle.");
            return;
        }
        n2 = this.bean.getPieRadius();
        if (styleModifiers != null && styleModifiers instanceof PieChartStyleModifiers) {
            n2 = ((PieChartStyleModifiers)styleModifiers).getPieRadius() * 2;
        }
        sVGMap.drawPieChart(n3, n4, n2, dArray, colorArray, stringArray);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("PieChartStyle not applicable without attribute values.");
        }
        int n2 = this.bean.getNumSlices();
        if (stringArray == null) {
            this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            if (n2 < 1) {
                throw new StyleNotApplicableException("PieChartStyle must have at least one slice.");
            }
            if (stringArray.length < n2) {
                throw new StyleNotApplicableException("Not enough style columns for PieChartStyle.");
            }
            Field[] fieldArray2 = new Field[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                fieldArray2[i] = null;
                String string2 = stringArray[i];
                fieldArray2[i] = Util.getField(string2, fieldArray);
                if (fieldArray2[i] != null) continue;
                throw new StyleNotApplicableException("Unable to find attribute " + string2 + " for PieChartStyle.");
            }
            this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray2, styleModifiers);
        }
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, sVGMap, shape, n, string, null, null, fieldArray, styleModifiers);
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("PieChartStyle not applicable without attribute values.");
        }
        int n2 = this.bean.getNumSlices();
        if (stringArray == null) {
            return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
        }
        if (n2 < 1) {
            throw new StyleNotApplicableException("PieChartStyle must have at least one slice.");
        }
        if (stringArray.length < n2) {
            throw new StyleNotApplicableException("Not enough style columns for PieChartStyle.");
        }
        Field[] fieldArray2 = new Field[n2];
        for (int i = 0; i < stringArray.length; ++i) {
            fieldArray2[i] = null;
            String string4 = stringArray[i];
            fieldArray2[i] = Util.getField(string4, fieldArray);
            if (fieldArray2[i] != null) continue;
            throw new StyleNotApplicableException("Unable to find attribute " + string4 + " for PieChartStyle.");
        }
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray2, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, stringArray2, styleModifiers);
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public boolean ignoreSliceDescriptionName() {
        return this.ignoreSliceDescName;
    }

    public void ignoreSliceDescriptionName(boolean bl) {
        this.ignoreSliceDescName = bl;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        if (this.isPixelUnit(this.bean.getPieRadiusUnit())) {
            return null;
        }
        PieChartStyleModifiers pieChartStyleModifiers = new PieChartStyleModifiers();
        if (visContext == null || Util.isFullExtent(visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMaxX(), visContext.getQueryWindow().getMaxY()) || visContext.getQueryWindow().getWidth() == 0.0 && visContext.getQueryWindow().getHeight() == 0.0) {
            if (this.isPixelUnit(this.bean.getPieRadiusUnit())) {
                pieChartStyleModifiers.setPieRadius(this.bean.getPieRadius());
            }
        } else {
            double d;
            Rectangle2D rectangle2D = visContext.getDeviceWindow();
            Rectangle2D rectangle2D2 = visContext.getQueryWindow();
            double d2 = rectangle2D2.getWidth() / rectangle2D.getWidth();
            double d3 = d = rectangle2D2.getHeight() / rectangle2D.getHeight();
            Double d4 = null;
            if (this.bean.getPieRadiusUnit() != null) {
                d4 = SRS.getDistanceConversionFactor(this.bean.getPieRadiusUnit());
            }
            if (this.isPixelUnit(this.bean.getPieRadiusUnit())) {
                pieChartStyleModifiers.setPieRadius(this.bean.getPieRadius());
            } else if (d4 != null) {
                double d5 = this.bean.getDoublePieRadius() * d4;
                if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                    double d6 = SphereCG.convertRadius(0.0, 0.0, d5);
                    pieChartStyleModifiers.setPieRadius((int)(d6 / d3 + 0.5));
                } else {
                    pieChartStyleModifiers.setPieRadius((int)(d5 / d3 + 0.5));
                }
            }
        }
        return pieChartStyleModifiers;
    }

    private boolean isPixelUnit(String string) {
        return string == null || string.equalsIgnoreCase("px") || string.equalsIgnoreCase("pt");
    }
}

