/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.stylex;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.PieSliceInfo;
import oracle.mapviewer.share.stylex.VariablePieChartStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.stylex.AdvancedStyleModifiers;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.PieChartStyleModifiers;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VariablePieChartStyle
extends BucketStyle {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public VariablePieChartStyle() {
        this.bean = new VariablePieChartStyleModel();
    }

    public VariablePieChartStyle(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public VariablePieChartStyle(Document document) throws StyleException {
        this.bean = new VariablePieChartStyleModel();
        try {
            Node node = XMLDOMParser.getSubElement(document, "AdvancedStyle");
            Node node2 = XMLDOMParser.getSubElement(node, "VariablePieChartStyle");
            String string = XMLDOMParser.getAttribute(node2, "startradius");
            String string2 = XMLDOMParser.getAttribute(node2, "increment");
            SizeDefinition2D sizeDefinition2D = SizeDefinition2D.parse(string, string2);
            if (sizeDefinition2D == null) {
                throw new StyleException("Invalid sizes in VariablePieChart style definition.");
            }
            ((VariablePieChartStyleModel)this.bean).setSizes(sizeDefinition2D);
            ArrayList arrayList = XMLDOMParser.getSubElements(node2, "PieSlice");
            ((VariablePieChartStyleModel)this.bean).setNumSlices(arrayList.size());
            PieSliceInfo[] pieSliceInfoArray = new PieSliceInfo[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                Node node3 = (Node)arrayList.get(i);
                PieSliceInfo pieSliceInfo = new PieSliceInfo();
                pieSliceInfo.setName(XMLDOMParser.getAttribute(node3, "name"));
                try {
                    pieSliceInfo.setColor(StyleUtils.getColor(XMLDOMParser.getAttribute(node3, "color")));
                }
                catch (Exception exception) {
                    pieSliceInfo.setColor(null);
                }
                pieSliceInfoArray[i] = pieSliceInfo;
            }
            ((VariablePieChartStyleModel)this.bean).setPieSlices(pieSliceInfoArray);
            node = XMLDOMParser.getSubElement(node2, "Buckets");
            BucketStyle.fetchBuckets(node, this.bean.getBucketSeries());
        }
        catch (Exception exception) {
            throw new StyleException("Invalid VariablePieChartStyle style definition.");
        }
    }

    public VariablePieChartStyle(BucketSeries bucketSeries, PieSliceInfo[] pieSliceInfoArray, int n, int n2) {
        this.bean = new VariablePieChartStyleModel(bucketSeries);
        ((VariablePieChartStyleModel)this.bean).setStartRadius(n);
        ((VariablePieChartStyleModel)this.bean).setIncrement(n2);
        ((VariablePieChartStyleModel)this.bean).setPieSlices(pieSliceInfoArray);
        if (pieSliceInfoArray != null) {
            ((VariablePieChartStyleModel)this.bean).setNumSlices(pieSliceInfoArray.length);
        }
        this.reset();
    }

    public Object clone() {
        VariablePieChartStyle variablePieChartStyle = (VariablePieChartStyle)super.clone();
        variablePieChartStyle.setModel((StyleModel)this.bean.clone());
        return variablePieChartStyle;
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof VariablePieChartStyleModel)) {
            throw new IllegalArgumentException("Not a VariablePieChartStyleModel instance.");
        }
        this.bean = (VariablePieChartStyleModel)styleModel;
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public void reset() {
        double d = ((VariablePieChartStyleModel)this.bean).getDoubleStartRadius();
        BucketSeries bucketSeries = this.bean.getBucketSeries();
        if (bucketSeries != null) {
            for (int i = 0; i < bucketSeries.size(); ++i) {
                Bucket bucket = bucketSeries.getBucket(i);
                if (bucket.getRenderStyle() != null || bucket.getRenderStyleName() != null) continue;
                PieChartStyle pieChartStyle = new PieChartStyle((int)d, ((VariablePieChartStyleModel)this.bean).getPieSlices());
                pieChartStyle.setPieRadius(d);
                pieChartStyle.setPieRadiusUnit(((VariablePieChartStyleModel)this.bean).getRadiusUnit());
                bucket.setRenderStyle(pieChartStyle);
                d += ((VariablePieChartStyleModel)this.bean).getDoubleIncrement();
            }
        }
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        this.reset();
        return true;
    }

    public int getMaxLegendWidth(Graphics2D graphics2D, int n) {
        return super.getMaxLegendWidth(graphics2D, n);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply VariablePieChartStyle to a point without attribute.");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        BucketSeries bucketSeries = this.bean.getBucketSeries();
        int n = bucketSeries.size();
        try {
            int n2 = ((PieChartStyle)bucketSeries.getBucket(n - 1).getRenderStyle()).getPieRadius() * 2;
            int n3 = ((PieChartStyle)bucketSeries.getBucket(0).getRenderStyle()).getPieRadius() * 2;
            if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers) {
                StyleModifiers styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers("PIECHART_" + (n - 1));
                if (styleModifiers2 != null && styleModifiers2 instanceof PieChartStyleModifiers) {
                    n2 = ((PieChartStyleModifiers)styleModifiers2).getPieRadius() * 2;
                }
                if ((styleModifiers2 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers("PIECHART_0")) != null && styleModifiers2 instanceof PieChartStyleModifiers) {
                    n3 = ((PieChartStyleModifiers)styleModifiers2).getPieRadius() * 2;
                }
            }
            n2 = Math.max(n2, n3);
            double d3 = rectangle2D.getMinX();
            double d4 = rectangle2D.getMinY() + 2.0;
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            for (int i = 0; i < n; ++i) {
                StyleModifiers styleModifiers3 = null;
                Bucket bucket = bucketSeries.getBucket(i);
                PieChartStyle pieChartStyle = (PieChartStyle)bucket.getRenderStyle();
                boolean bl = pieChartStyle.ignoreSliceDescriptionName();
                pieChartStyle.ignoreSliceDescriptionName(true);
                int n4 = pieChartStyle.getPieRadius() * 2;
                int n5 = pieChartStyle.getPieRadius() * 2;
                if (styleModifiers != null && styleModifiers instanceof AdvancedStyleModifiers && (styleModifiers3 = ((AdvancedStyleModifiers)styleModifiers).getStyleModifiers("PIECHART_" + i)) != null && styleModifiers3 instanceof PieChartStyleModifiers) {
                    n4 = ((PieChartStyleModifiers)styleModifiers3).getPieRadius() * 2;
                    n5 = ((PieChartStyleModifiers)styleModifiers3).getPieRadius() * 2;
                }
                double d5 = d3 + (double)(n2 - n4) / 2.0;
                ((Rectangle2D)float_).setRect(d5, d4, d, n5);
                this.drawBucketWithLabel(graphics2D, bucket, float_, (float)((double)n4 / d), 0.0f, styleModifiers3);
                d4 += (double)(n5 + 2);
                pieChartStyle.ignoreSliceDescriptionName(bl);
            }
        }
        catch (Exception exception) {
            graphics2D.drawString(" * bad style *", 10, 10);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (!(shape instanceof Rectangle2D)) {
            throw new StyleNotApplicableException("VariablePieChartStyle not applicable without an attr value.");
        }
        this.apply(null, graphics2D, (Rectangle2D)shape, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("VariablePieChartStyle not applicable without an attr value.");
        }
        double d = 0.0;
        for (int i = 0; i < fieldArray.length; ++i) {
            if (fieldArray[i].getShortJavaTypeName().equalsIgnoreCase("string")) {
                try {
                    d += Double.parseDouble(fieldArray[i].getString());
                    continue;
                }
                catch (Exception exception) {
                    throw new StyleNotApplicableException("VariablePieChartStyle needs numeric attributes.");
                }
            }
            d += fieldArray[i].getDouble();
        }
        Field field = new Field(d);
        BucketStyle.BucketDescription bucketDescription = this.chooseRenderStyle(field, styleModifiers);
        if (bucketDescription.style != null) {
            bucketDescription.style.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, bucketDescription.styleMods);
        } else {
            System.out.println("Pie chart style not found for value: " + d);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("PieChartStyle not applicable without attribute values.");
        }
        int n2 = ((VariablePieChartStyleModel)this.bean).getNumSlices();
        if (stringArray == null) {
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            if (n2 < 1) {
                throw new StyleNotApplicableException("VariablePieChartStyle must have at least one slice.");
            }
            if (stringArray.length < n2) {
                throw new StyleNotApplicableException("Not enough style columns for VariablePieChartStyle.");
            }
            Field[] fieldArray2 = new Field[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                fieldArray2[i] = null;
                String string2 = stringArray[i];
                fieldArray2[i] = Util.getField(string2, fieldArray);
                if (fieldArray2[i] != null) continue;
                throw new StyleNotApplicableException("Unable to find attribute " + string2 + " for VariablePieChartStyle.");
            }
            this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray2, styleModifiers);
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, stringArray, styleModifiers);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("Cannot apply VariablePieChartStyle to a point without attribute.");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        int n = (int)rectangle2D.getCenterX();
        int n2 = (int)rectangle2D.getCenterY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        BucketSeries bucketSeries = this.bean.getBucketSeries();
        int n5 = bucketSeries.size();
        try {
            int n6;
            int n7 = n - n3 / 4;
            int n8 = n6 = n2 - n4 / 2;
            int n9 = 0;
            int n10 = ((PieChartStyle)bucketSeries.getBucket(n5 - 1).getRenderStyle()).getPieRadius() * 2;
            Rectangle2D.Float float_ = new Rectangle2D.Float();
            for (int i = 0; i < n5; ++i) {
                Bucket bucket = bucketSeries.getBucket(i);
                PieChartStyle pieChartStyle = (PieChartStyle)bucket.getRenderStyle();
                int n11 = pieChartStyle.getPieRadius() * 2;
                int n12 = pieChartStyle.getPieRadius() * 2;
                int n13 = n7;
                n8 = n6 + n9;
                n8 += n12 / 2;
                ((Rectangle2D)float_).setRect(n7, n6 + n9, 9.0, 9.0);
                if (pieChartStyle != null) {
                    pieChartStyle.apply(null, sVGMap, (Rectangle2D)float_, null);
                }
                n9 += n12 < 10 ? 10 : n12 + 3;
                String string = bucket.getBucketLabel();
                if (string == null) continue;
                int n14 = n6 + n9 - 3;
                sVGMap.drawText(string, n7 + n10 / 2 + 2, n14, 0.0, new Font("Dialog", 0, 10), Color.black);
            }
        }
        catch (Exception exception) {
            sVGMap.drawText(" * bad style *", 10.0, 10.0, 0.0, new Font("Dialog", 0, 10), Color.black);
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (point2D == null && shape == null) {
            return;
        }
        if (point2D == null) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            point2D = new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        }
        if (fieldArray == null) {
            return;
        }
        int n2 = (int)point2D.getX();
        int n3 = (int)point2D.getY();
        double d = 0.0;
        for (int i = 0; i < fieldArray.length; ++i) {
            if (fieldArray[i].getShortJavaTypeName().equalsIgnoreCase("string")) {
                try {
                    d += Double.parseDouble(fieldArray[i].getString());
                    continue;
                }
                catch (Exception exception) {
                    throw new StyleNotApplicableException("VariablePieChartStyle needs numeric attributes.");
                }
            }
            d += fieldArray[i].getDouble();
        }
        Field field = new Field(d);
        PieChartStyle pieChartStyle = (PieChartStyle)this.chooseStyle(field);
        if (pieChartStyle == null) {
            System.out.println("cannot find a suitable variable pie chart style based on your values [" + fieldArray[0] + "].");
            return;
        }
        int n4 = pieChartStyle.getPieRadius() * 2;
        int n5 = pieChartStyle.getPieRadius() * 2;
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2 - n4 / 2, n3 - n5 / 2, n4, n5);
        pieChartStyle.apply(null, sVGMap, (Rectangle2D)float_, null);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("VariablePieChartStyle not applicable without an attribute value.");
        }
        if (stringArray == null) {
            this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        } else {
            Field[] fieldArray2 = new Field[]{null};
            String string2 = stringArray[0];
            fieldArray2[0] = Util.getField(string2, fieldArray);
            if (fieldArray2[0] == null) {
                throw new StyleNotApplicableException("Unable to find column " + string2 + " for VariablePieChartStyle.");
            }
            this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray2, styleModifiers);
        }
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, sVGMap, shape, n, string, null, null, fieldArray, styleModifiers);
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (fieldArray == null) {
            throw new StyleNotApplicableException("PieChartStyle not applicable without attribute values.");
        }
        int n2 = ((VariablePieChartStyleModel)this.bean).getNumSlices();
        if (stringArray == null) {
            return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
        }
        if (n2 < 1) {
            throw new StyleNotApplicableException("VariablePieChartStyle must have at least one slice.");
        }
        if (stringArray.length < n2) {
            throw new StyleNotApplicableException("Not enough style columns for VariablePieChartStyle.");
        }
        Field[] fieldArray2 = new Field[n2];
        for (int i = 0; i < stringArray.length; ++i) {
            fieldArray2[i] = null;
            String string4 = stringArray[i];
            fieldArray2[i] = Util.getField(string4, fieldArray);
            if (fieldArray2[i] != null) continue;
            throw new StyleNotApplicableException("Unable to find attribute " + string4 + " for VariablePieChartStyle.");
        }
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray2, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, stringArray, styleModifiers);
    }

    public Object getPropertyValue(String string) {
        return null;
    }
}

