/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.svg;

import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;

public class SVGImageTranscoder
extends ImageTranscoder {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    BufferedImage userImage;
    BufferedImage resultImage;

    public SVGImageTranscoder() {
    }

    public SVGImageTranscoder(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            this.userImage = bufferedImage;
        }
    }

    public BufferedImage createImage(int n, int n2) {
        if (this.userImage != null && this.userImage.getWidth() == n && this.userImage.getHeight() == n2) {
            return this.userImage;
        }
        log.finest("creating a new buffered image for transcoding: width=" + n + ", height=" + n2);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        return bufferedImage;
    }

    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        this.resultImage = bufferedImage;
    }

    public BufferedImage getRenderedImage() {
        return this.resultImage;
    }
}

