/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.svg;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.svg.SVGUtil;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;

public class SVGLabelHelper {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final int FLOAT_FACTOR = 10;
    private static final float EXPAND_RATIO = 1.05f;

    public static void labelStyledFeature(SVGMap sVGMap, StyledFeatureI styledFeatureI, Style style, float[] fArray, boolean bl, boolean bl2, Rectangle2D rectangle2D) {
        bl2 = bl2 || styledFeatureI.getFixedSVGLabel();
        String string = styledFeatureI.getLabel();
        if (string == null || string.length() == 0) {
            return;
        }
        Shape shape = null;
        double d = 0.0;
        double d2 = 0.0;
        switch (style.getModel().getType()) {
            case 5: {
                StyleText styleText = (StyleText)style;
                if (styledFeatureI.getGeomType() == 2 || styledFeatureI.getGeomType() == 6) {
                    if (sVGMap.isTiny()) {
                        if (SVGLabelHelper.findTextLabelPointOnLinearFeature(styledFeatureI, fArray, styleText, string, bl || styledFeatureI.getForceLabel(), sVGMap.getCoverLists(), 1.0, rectangle2D) == null) break;
                        styleText.applyToSVG(sVGMap, fArray[0], fArray[1], fArray[2], string, -1, null);
                        break;
                    }
                    sVGMap.drawLabelOnLineString(styleText, styledFeatureI.getSVGId(), string, bl || styledFeatureI.getForceLabel(), bl2);
                    break;
                }
                if (styledFeatureI.getGeomType() == 5) break;
                if (bl2 || sVGMap.isTiny()) {
                    if (styledFeatureI.getGeometry() != null && styledFeatureI.getGeometry().isOrientedPoint()) {
                        int n = (int)styledFeatureI.getPoint().getX();
                        int n2 = (int)styledFeatureI.getPoint().getY();
                        styleText.applyToSVG(sVGMap, n, n2, styledFeatureI.getMarkerStyleOrientation(), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0, string, null);
                        break;
                    }
                    if (SVGLabelHelper.findTextLabelPoint(styledFeatureI, fArray, styleText, string, bl || styledFeatureI.getForceLabel(), sVGMap.getCoverLists(), 1.0, rectangle2D) == null) break;
                    styleText.applyToSVG(sVGMap, (int)fArray[0], (int)fArray[1], fArray[2], string, null);
                    break;
                }
                for (int i = 0; i < sVGMap.getZoomLevels(); ++i) {
                    if (styledFeatureI.getGeometry() != null && styledFeatureI.getGeometry().isOrientedPoint()) {
                        int n = (int)styledFeatureI.getPoint().getX();
                        int n3 = (int)styledFeatureI.getPoint().getY();
                        styleText.applyToSVG(sVGMap, n, n3, styledFeatureI.getMarkerStyleOrientation(), LabelingHints.VALUE_OPOINT_HALIGN_CENTER, 0, string, i, null);
                        continue;
                    }
                    if (SVGLabelHelper.findTextLabelPoint(styledFeatureI, fArray, styleText, string, bl || styledFeatureI.getForceLabel(), sVGMap.getCoverList(i), sVGMap.getScale(i), rectangle2D) == null) continue;
                    styleText.applyToSVG(sVGMap, (int)fArray[0], (int)fArray[1], fArray[2], string, i, null);
                }
                break;
            }
            case 2: {
                StyleMarker styleMarker = (StyleMarker)style;
                d = styleMarker.getDesiredWidth();
                d2 = styleMarker.getDesiredHeight();
                double d3 = d;
                double d4 = d2;
                shape = styledFeatureI.getShape();
                if (bl2 || sVGMap.isTiny()) {
                    if (SVGLabelHelper.findLabelPointOnLinearFeature(shape, fArray, d, d2, bl || styledFeatureI.getForceLabel(), rectangle2D, sVGMap.getCoverLists()) == null) break;
                    Rectangle2D.Float float_ = new Rectangle2D.Float((float)((double)fArray[0] - d / 2.0), (float)((double)fArray[1] - d2 / 2.0), (float)d, (float)d2);
                    try {
                        styleMarker.applyToSVG(null, sVGMap, float_, 3, null, null, string, null, styledFeatureI.getInfoStr(), 0.0, false, null, null);
                    }
                    catch (Exception exception) {
                        log.log(Level.WARNING, exception.getMessage(), exception);
                    }
                    break;
                }
                for (int i = 0; i < sVGMap.getZoomLevels(); ++i) {
                    double d5 = sVGMap.getScale(i);
                    d = d3 / d5;
                    if (SVGLabelHelper.findLabelPointOnLinearFeature(shape, fArray, d, d2 = d4 / d5, bl || styledFeatureI.getForceLabel(), rectangle2D, sVGMap.getCoverList(i)) == null) continue;
                    Rectangle2D.Float float_ = new Rectangle2D.Float((float)((double)fArray[0] - d / 2.0), (float)((double)fArray[1] - d2 / 2.0), (float)d, (float)d2);
                    try {
                        styleMarker.applyToSVG(sVGMap, float_, 3, null, null, string, null, styledFeatureI.getInfoStr(), 0.0, false, null, i, null);
                        sVGMap.getCoverList(i).insert(float_);
                        continue;
                    }
                    catch (Exception exception) {
                        log.log(Level.WARNING, exception.getMessage(), exception);
                    }
                }
                break;
            }
            case 9: {
                if (style instanceof PieChartStyle) {
                    PieChartStyle pieChartStyle = null;
                    try {
                        pieChartStyle = (PieChartStyle)style;
                    }
                    catch (ClassCastException classCastException) {
                        log.severe("this is not a PieChartStyle.");
                    }
                    d2 = d = (double)((int)((double)pieChartStyle.getPieRadius() * 2.5));
                    Point2D point2D = null;
                    shape = styledFeatureI.getShape();
                    point2D = styledFeatureI.getPoint();
                    if (point2D == null && shape != null) {
                        Object object;
                        if (styledFeatureI.getGeomType() == 3 || styledFeatureI.getGeomType() == 7) {
                            object = LabelHelper.findLoc4RectInPolygon(shape, 5.0, 5.0, sVGMap.getCoverLists(), true, true);
                            if (object != null) {
                                point2D = new Point2D.Double(object[0], (double)object[1]);
                            }
                        } else if (styledFeatureI.getGeomType() == 2 || styledFeatureI.getGeomType() == 6) {
                            if (SVGLabelHelper.findLabelPointOnLinearFeature(shape, fArray, 5.0, 5.0, bl || styledFeatureI.getForceLabel(), rectangle2D, sVGMap.getCoverLists()) != null) {
                                point2D = new Point2D.Double(fArray[0], fArray[1]);
                            }
                        } else {
                            object = shape.getBounds();
                            point2D = new Point2D.Double(object.getCenterX(), object.getCenterY());
                        }
                    }
                    if (point2D != null) {
                        try {
                            pieChartStyle.apply(null, sVGMap, null, 0, string, point2D, null, styledFeatureI.getRenderableAttributes(), null);
                        }
                        catch (Exception exception) {
                            log.log(Level.WARNING, exception.getMessage(), exception);
                        }
                        int n = (int)point2D.getX();
                        int n4 = (int)point2D.getY();
                        sVGMap.insertIntoCoverList((int)((double)n - d / 2.0), (int)((double)n4 - d2 / 2.0), d, d2);
                        break;
                    }
                    log.warning("cannot find a suitable place to draw pie-chart.");
                    break;
                }
                if (style instanceof VariableMarkerStyle) {
                    Object object;
                    VariableMarkerStyle variableMarkerStyle = null;
                    try {
                        variableMarkerStyle = (VariableMarkerStyle)style;
                    }
                    catch (ClassCastException classCastException) {
                        log.severe("this is not a VariableMarkerStyle.");
                    }
                    Point2D point2D = null;
                    shape = styledFeatureI.getShape();
                    point2D = styledFeatureI.getPoint();
                    if (point2D == null && shape != null) {
                        if (styledFeatureI.getGeomType() == 3 || styledFeatureI.getGeomType() == 7) {
                            object = LabelHelper.findLoc4RectInPolygon(shape, 5.0, 5.0, sVGMap.getCoverLists(), true, true);
                            if (object != null) {
                                point2D = new Point2D.Double((double)object[0], (double)object[1]);
                            }
                        } else if (styledFeatureI.getGeomType() == 2 || styledFeatureI.getGeomType() == 6) {
                            if (SVGLabelHelper.findLabelPointOnLinearFeature(shape, fArray, 5.0, 5.0, bl || styledFeatureI.getForceLabel(), rectangle2D, sVGMap.getCoverLists()) != null) {
                                point2D = new Point2D.Double(fArray[0], fArray[1]);
                            }
                        } else {
                            object = shape.getBounds();
                            point2D = new Point2D.Double(((RectangularShape)object).getCenterX(), ((RectangularShape)object).getCenterY());
                        }
                    }
                    if (point2D != null) {
                        object = styledFeatureI.getRenderableAttributes();
                        StyleMarker styleMarker = (StyleMarker)variableMarkerStyle.chooseStyle(object[0]);
                        if (styleMarker == null) {
                            log.warning("cannot find a suitable variable marker style based on your values [" + object[0] + "].");
                            break;
                        }
                        try {
                            variableMarkerStyle.apply(null, sVGMap, null, 0, string, point2D, null, styledFeatureI.getRenderableAttributes(), null);
                            int n = styleMarker.getDesiredWidth();
                            int n5 = styleMarker.getDesiredHeight();
                            int n6 = (int)point2D.getX();
                            int n7 = (int)point2D.getY();
                            sVGMap.insertIntoCoverList(n6 - n / 2, n7 - n5 / 2, n, n5);
                        }
                        catch (Exception exception) {
                            log.log(Level.WARNING, exception.getMessage(), exception);
                        }
                        break;
                    }
                    log.warning("cannot find a suitable place to draw variable marker.");
                    break;
                }
                log.severe("only PieChartStyle or VariableMarkerStyle can be a label style among ADVANCED styles.");
            }
        }
    }

    private static float[] findTextLabelPoint(StyledFeatureI styledFeatureI, float[] fArray, StyleText styleText, String string, boolean bl, RectArray[] rectArrayArray, double d, Rectangle2D rectangle2D) {
        switch (styledFeatureI.getGeomType()) {
            case 1: {
                return SVGLabelHelper.findTextLabelPointOnPointFeature(styledFeatureI, fArray, styleText, string, bl, rectArrayArray, d);
            }
            case 2: 
            case 6: {
                return SVGLabelHelper.findTextLabelPointOnLinearFeature(styledFeatureI, fArray, styleText, string, bl, rectArrayArray, d, rectangle2D);
            }
            case 3: 
            case 7: {
                return SVGLabelHelper.findTextLabelPointOnAreaFeature(styledFeatureI, fArray, styleText, string, bl, rectArrayArray, d);
            }
            case 5: {
                return SVGLabelHelper.findTextLabelPointsOnMultiPoint(styledFeatureI, fArray, styleText, string, bl, rectArrayArray, d);
            }
        }
        return SVGLabelHelper.findTextLabelPointOnAreaFeature(styledFeatureI, fArray, styleText, string, bl, rectArrayArray, d);
    }

    private static float[] findTextLabelPoint(StyledFeatureI styledFeatureI, float[] fArray, StyleText styleText, String string, boolean bl, RectArray rectArray, double d, Rectangle2D rectangle2D) {
        RectArray[] rectArrayArray = new RectArray[]{rectArray};
        return SVGLabelHelper.findTextLabelPoint(styledFeatureI, fArray, styleText, string, bl, rectArrayArray, d, rectangle2D);
    }

    private static float[] findTextLabelPointsOnMultiPoint(StyledFeatureI styledFeatureI, float[] fArray, StyleText styleText, String string, boolean bl, RectArray[] rectArrayArray, double d) {
        float[] fArray2;
        Shape shape = styledFeatureI.getShape();
        if (shape == null) {
            return null;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray3 = new float[6];
        Vector<float[]> vector = new Vector<float[]>();
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray3);
            if (n == 0 || n == 1) {
                StyledFeature styledFeature = new StyledFeature();
                styledFeature.setGeomType(1);
                styledFeature.setPoint(new Point2D.Float(fArray3[0], fArray3[1]));
                fArray2 = SVGLabelHelper.findTextLabelPointOnPointFeature(styledFeature, fArray, styleText, string, bl, rectArrayArray, d);
                if (fArray2 != null) {
                    float[] fArray4 = new float[]{fArray2[0], fArray2[1], fArray2[3]};
                    vector.add(fArray4);
                }
            }
            pathIterator.next();
        }
        float[] fArray5 = new float[vector.size() * 3];
        for (int i = 0; i < vector.size(); ++i) {
            fArray2 = (float[])vector.get(i);
            fArray5[i * 3] = fArray2[0];
            fArray5[i * 3 + 1] = fArray2[1];
            fArray5[i * 3 + 2] = fArray2[2];
        }
        return fArray5;
    }

    private static float[] findTextLabelPointOnPointFeature(StyledFeatureI styledFeatureI, float[] fArray, StyleText styleText, String string, boolean bl, RectArray[] rectArrayArray, double d) {
        float f = 0.0f;
        float f2 = 0.0f;
        Rectangle2D rectangle2D = styleText.getVisualBounds(string, null);
        Rectangle2D rectangle2D2 = styledFeatureI.getMBR();
        rectangle2D = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth() / d, rectangle2D.getHeight() / d);
        if (rectangle2D2 == null) {
            rectangle2D2 = new Rectangle2D.Double(0.0, 0.0, 5.0, 3.0);
        }
        rectangle2D2 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() / d, rectangle2D2.getHeight() / d);
        float f3 = (float)rectangle2D.getWidth() * 1.05f;
        float f4 = (float)rectangle2D.getHeight();
        f = (float)styledFeatureI.getPoint().getX();
        f2 = (float)styledFeatureI.getPoint().getY();
        float f5 = (float)(rectangle2D2.getWidth() / 2.0 + 3.0);
        float f6 = (float)(rectangle2D2.getHeight() / 2.0 + 2.0);
        rectangle2D.setRect(f + f5, f2 - f4 / 2.0f, f3, f4);
        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, rectangle2D)) {
            fArray[0] = f + f5;
            fArray[1] = f2 + f4 / 2.0f;
            LabelHelper.insertRectIntoRectArrays(rectArrayArray, rectangle2D);
            return fArray;
        }
        rectangle2D.setRect(f, f2 - f4 / 2.0f + f6, f3, f4);
        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, rectangle2D)) {
            fArray[0] = f;
            fArray[1] = f2 + f4 / 2.0f + f6;
            LabelHelper.insertRectIntoRectArrays(rectArrayArray, rectangle2D);
            return fArray;
        }
        rectangle2D.setRect(f, f2 - f4 / 2.0f - f6, f3, f4);
        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, rectangle2D)) {
            fArray[0] = f;
            fArray[1] = f2 + f4 / 2.0f - f6;
            LabelHelper.insertRectIntoRectArrays(rectArrayArray, rectangle2D);
            return fArray;
        }
        rectangle2D.setRect(f - f5 - f3, f2 - f4 / 2.0f, f3, f4);
        if (!LabelHelper.rectConflictsWithRectArrays(rectArrayArray, rectangle2D)) {
            fArray[0] = f - f5 - f3;
            fArray[1] = f2 + f4 / 2.0f;
            LabelHelper.insertRectIntoRectArrays(rectArrayArray, rectangle2D);
            return fArray;
        }
        if (bl) {
            rectangle2D.setRect(f + f5, f2 - f4 / 2.0f, f3, f4);
            fArray[0] = f + f5;
            fArray[1] = f2 + f4 / 2.0f;
            LabelHelper.insertRectIntoRectArrays(rectArrayArray, rectangle2D);
            return fArray;
        }
        log.finer("could not find a suitable place for point labeling");
        return null;
    }

    private static float[] findTextLabelPointOnAreaFeature(StyledFeatureI styledFeatureI, float[] fArray, StyleText styleText, String string, boolean bl, RectArray[] rectArrayArray, double d) {
        float f;
        Shape shape = styledFeatureI.getShape();
        if (shape == null) {
            return null;
        }
        float f2 = 5.0f;
        Rectangle2D rectangle2D = styleText.getVisualBounds(string, null);
        Rectangle rectangle = shape.getBounds();
        float f3 = (float)(rectangle2D.getMinX() / d);
        float f4 = (float)(rectangle2D.getMinY() / d);
        float f5 = (float)(rectangle2D.getWidth() / d) * 1.05f;
        float[] fArray2 = LabelHelper.findLoc4RectInPolygon(shape, f5, f = (float)(rectangle2D.getHeight() / d), rectArrayArray, bl, true);
        if (fArray2 != null) {
            fArray[2] = fArray2[2];
            fArray[0] = fArray2[0];
            fArray[1] = fArray2[1];
            return fArray;
        }
        return null;
    }

    private static float[] findLabelPointOnLinearFeature(Shape shape, float[] fArray, double d, double d2, boolean bl, Rectangle2D rectangle2D, RectArray rectArray) {
        RectArray[] rectArrayArray = new RectArray[]{rectArray};
        return SVGLabelHelper.findLabelPointOnLinearFeature(shape, fArray, d, d2, bl, rectangle2D, rectArrayArray);
    }

    private static float[] findLabelPointOnLinearFeature(Shape shape, float[] fArray, double d, double d2, boolean bl, Rectangle2D rectangle2D, RectArray[] rectArrayArray) {
        if (shape == null) {
            return null;
        }
        double d3 = ShapeUtil.lengthOf(shape);
        if (d3 < d || d3 < d2) {
            return null;
        }
        if ((shape = ShapeUtil.clipLineString(rectangle2D, shape)) == null || shape.getBounds().getWidth() == 0.0) {
            return null;
        }
        double d4 = 0.75;
        double d5 = 0.098;
        for (int i = 0; i <= 5; ++i) {
            double d6 = d4 + d5 * (double)i;
            ShapeUtil.lrPoint(shape, d6, fArray);
            Rectangle2D.Double double_ = new Rectangle2D.Double((double)fArray[0] - d / 2.0, (double)fArray[1] - d2 / 2.0, d, d2);
            if (rectangle2D.contains(fArray[0], fArray[1]) && (bl || !LabelHelper.rectConflictsWithRectArrays(rectArrayArray, double_))) {
                return fArray;
            }
            if (i == 0) continue;
            d6 = d4 - d5 * (double)i;
            ShapeUtil.lrPoint(shape, d6, fArray);
            if (!rectangle2D.contains(fArray[0], fArray[1]) || !bl && LabelHelper.rectConflictsWithRectArrays(rectArrayArray, double_)) continue;
            return fArray;
        }
        return null;
    }

    private static float[] findTextLabelPointOnLinearFeature(StyledFeatureI styledFeatureI, float[] fArray, StyleText styleText, String string, boolean bl, RectArray[] rectArrayArray, double d, Rectangle2D rectangle2D) {
        Shape shape = styledFeatureI.getShape();
        return SVGLabelHelper.findTextLabelPointOnLinearFeature(shape, fArray, styleText, string, bl, rectArrayArray, d, rectangle2D);
    }

    public static float[] findTextLabelPointOnLinearFeature(Shape shape, float[] fArray, StyleText styleText, String string, boolean bl, RectArray[] rectArrayArray, double d, Rectangle2D rectangle2D) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (shape == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = styleText.getVisualBounds(string, null);
        Rectangle rectangle = shape.getBounds();
        float f = (float)(rectangle2D2.getMinX() / d);
        float f2 = (float)(rectangle2D2.getMinY() / d);
        float f3 = (float)(rectangle2D2.getWidth() / d) * 1.05f;
        float f4 = (float)(rectangle2D2.getHeight() / d);
        if ("COLISEUM AVE".equals(string)) {
            // empty if block
        }
        float[] fArray2 = new float[4];
        PathIterator pathIterator = shape.getPathIterator(null);
        int n = SVGLabelHelper.getCoordinatesNumber(pathIterator);
        pathIterator = shape.getPathIterator(null);
        n = SVGLabelHelper.getCoordinates(pathIterator, nArray4 = new int[n * 2], nArray3 = new int[n * 2], nArray2 = new int[n * 2], nArray = new int[n * 2], rectangle2D);
        if (n < 2) {
            return null;
        }
        int[] nArray5 = new int[2];
        float[] fArray3 = new float[4];
        float f5 = 0.0f;
        int n2 = 0;
        while (n2 < n && SVGLabelHelper.findBaseLinePoints(nArray5, f3, nArray4, nArray3, n, nArray2, n2)) {
            f5 = SVGLabelHelper.shiftBaseLine(nArray5[0], nArray5[1], nArray4, nArray3, (float)((double)f4 / 3.0), fArray3);
            if (string.equals("COLISEUM AVE")) {
                System.out.println("<path stroke=\"green\" fill=\"none\" d=\"M" + fArray3[0] + "," + fArray3[1] + " L" + fArray3[2] + "," + fArray3[3] + "\"/>\n");
            }
            if ((double)f5 > (double)f4 * 2.0 / 3.0) {
                n2 = SVGLabelHelper.findNextStartPoint(n2, (int)f3, nArray, n);
                continue;
            }
            float f6 = fArray3[0];
            float f7 = fArray3[1];
            float f8 = fArray3[2];
            float f9 = fArray3[3];
            boolean bl2 = false;
            float f10 = (float)Math.sqrt((f6 - f8) * (f6 - f8) + (f7 - f9) * (f7 - f9));
            float f11 = (f10 - f3) / (2.0f * f10);
            float f12 = f6 + f11 * (f8 - f6);
            float f13 = f7 + f11 * (f9 - f7);
            float f14 = f8 - f11 * (f8 - f6);
            float f15 = f9 - f11 * (f9 - f7);
            float f16 = (f9 - f7) / (f8 - f6);
            ArrayList arrayList = LabelHelper.getBoundingRectsWithoutConflicts(rectArrayArray, (double)f12, (double)f13, (double)f14, (double)f15, (double)f4);
            if (arrayList == null && f10 > 2.0f * f3 && (arrayList = LabelHelper.getBoundingRectsWithoutConflicts(rectArrayArray, (double)(f12 = f6 + (f11 = (f10 / 2.0f - f3) / (2.0f * f10)) * (f8 - f6)), (double)(f13 = f7 + f11 * (f9 - f7)), (double)(f14 = (f6 + f8) / 2.0f - f11 * (f8 - f6)), (double)(f15 = (f7 + f9) / 2.0f - f11 * (f9 - f7)), (double)f4)) == null) {
                f12 = (f6 + f8) / 2.0f + f11 * (f8 - f6);
                f13 = (f7 + f9) / 2.0f + f11 * (f9 - f7);
                f14 = f8 - f11 * (f8 - f6);
                f15 = f9 - f11 * (f9 - f7);
                arrayList = LabelHelper.getBoundingRectsWithoutConflicts(rectArrayArray, (double)f12, (double)f13, (double)f14, (double)f15, (double)f4);
            }
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    LabelHelper.insertRectIntoRectArrays(rectArrayArray, (Rectangle2D)arrayList.get(i));
                }
                fArray[0] = f12;
                fArray[1] = f13;
                fArray[2] = (float)Math.atan((f9 - f7) / (f8 - f6));
                return fArray;
            }
            n2 = SVGLabelHelper.findNextStartPoint(n2, (int)f3, nArray, n);
        }
        return null;
    }

    private static int findNextStartPoint(int n, int n2, int[] nArray, int n3) {
        int n4;
        int n5 = 0;
        for (n4 = n + 1; n4 < n3; ++n4) {
            n5 = nArray[n4] == 0 ? 0 : (n5 += nArray[n4]);
            if (n5 > n2 / 3) break;
        }
        return n4;
    }

    private static int getCoordinatesNumber(PathIterator pathIterator) {
        if (pathIterator.isDone()) {
            return 0;
        }
        int n = 0;
        while (!pathIterator.isDone()) {
            pathIterator.next();
            ++n;
        }
        return n;
    }

    private static boolean pointInsideRectangle(float f, float f2, float f3, float f4, float f5, float f6) {
        return f5 >= f && f5 <= f3 && f6 >= f2 && f6 <= f4;
    }

    private static int getCoordinates(PathIterator pathIterator, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, Rectangle2D rectangle2D) {
        int n;
        int n2;
        int n3;
        float[] fArray = new float[6];
        int n4 = (int)(rectangle2D.getMinX() * 10.0);
        int n5 = (int)(rectangle2D.getMaxX() * 10.0);
        int n6 = (int)(rectangle2D.getMinY() * 10.0);
        int n7 = (int)(rectangle2D.getMaxY() * 10.0);
        if (pathIterator.isDone()) {
            return 0;
        }
        int n8 = pathIterator.currentSegment(fArray);
        int n9 = n3 = (int)(fArray[0] * 10.0f);
        int n10 = n2 = (int)(fArray[1] * 10.0f);
        pathIterator.next();
        int n11 = 0;
        while (!pathIterator.isDone()) {
            Point2D point2D;
            ArrayList arrayList;
            n = pathIterator.currentSegment(fArray);
            int n12 = (int)(fArray[0] * 10.0f);
            int n13 = (int)(fArray[1] * 10.0f);
            if (SVGLabelHelper.pointInsideRectangle(n4, n6, n5, n7, n3, n2)) {
                nArray[n11] = n3;
                nArray2[n11] = n2;
                nArray3[n11] = n8;
                if (SVGLabelHelper.pointInsideRectangle(n4, n6, n5, n7, n12, n13)) {
                    nArray[++n11] = n12;
                    nArray2[n11] = n13;
                    nArray3[n11] = n;
                } else if (n == 1 && (arrayList = SVGUtil.getIntersectionPoints(n4, n6, n5, n7, n3, n2, n12, n13)).size() > 0) {
                    point2D = (Point2D)arrayList.get(0);
                    nArray[++n11] = (int)point2D.getX();
                    nArray2[n11] = (int)point2D.getY();
                    nArray3[n11] = 1;
                }
            } else if (n == 1 && (arrayList = SVGUtil.getIntersectionPoints(n4, n6, n5, n7, n3, n2, n12, n13)) != null && arrayList.size() > 0) {
                point2D = (Point2D)arrayList.get(0);
                nArray[n11] = (int)point2D.getX();
                nArray2[n11] = (int)point2D.getY();
                nArray3[n11] = 0;
                ++n11;
                if (arrayList.size() == 1) {
                    nArray[n11] = n12;
                    nArray2[n11] = n13;
                } else {
                    point2D = (Point2D)arrayList.get(1);
                    nArray[n11] = (int)point2D.getX();
                    nArray2[n11] = (int)point2D.getY();
                }
                nArray3[n11] = 1;
            }
            n3 = n12;
            n2 = n13;
            n8 = n;
            pathIterator.next();
        }
        nArray4[0] = 0;
        for (n = 1; n <= n11; ++n) {
            nArray4[n] = nArray3[n] == 0 ? 0 : (int)(Math.sqrt((nArray[n] - nArray[n - 1]) * (nArray[n] - nArray[n - 1]) + (nArray2[n] - nArray2[n - 1]) * (nArray2[n] - nArray2[n - 1])) / 10.0);
        }
        return n11 + 1;
    }

    public static boolean findBaseLinePoints(int[] nArray, float f, int[] nArray2, int[] nArray3, int n, int[] nArray4, int n2) {
        float f2 = f * f * 10.0f * 10.0f;
        for (int i = n2; i < n; ++i) {
            if (nArray4[i] == 0) {
                n2 = i;
                continue;
            }
            int n3 = (nArray2[i] - nArray2[n2]) * (nArray2[i] - nArray2[n2]) + (nArray3[i] - nArray3[n2]) * (nArray3[i] - nArray3[n2]);
            if (!(f2 <= (float)n3)) continue;
            nArray[0] = n2;
            nArray[1] = i;
            return true;
        }
        return false;
    }

    public static float shiftBaseLine(int n, int n2, int[] nArray, int[] nArray2, float f, float[] fArray) {
        float f2;
        boolean bl = false;
        float f3 = (float)(1.0 * (double)nArray[n] / 10.0);
        float f4 = (float)(1.0 * (double)nArray[n2] / 10.0);
        float f5 = (float)(1.0 * (double)nArray2[n] / 10.0);
        float f6 = (float)(1.0 * (double)nArray2[n2] / 10.0);
        float f7 = f3;
        float f8 = f5;
        float f9 = f4;
        float f10 = f6;
        float f11 = 0.0f;
        float f12 = 0.0f;
        if (f3 == f4) {
            f11 = f4;
        } else {
            f11 = (f6 - f5) / (f4 - f3);
            f12 = (f4 * f5 - f3 * f6) / (f4 - f3);
        }
        float f13 = 0.0f;
        float f14 = f3;
        float f15 = f5;
        float f16 = 0.0f;
        float f17 = (f3 - f4) * (f3 - f4) + (f5 - f6) * (f5 - f6);
        for (int i = n + 1; i <= n2; ++i) {
            float f18;
            float f19;
            float f20 = (float)(1.0 * (double)nArray[i] / 10.0);
            float f21 = (float)(1.0 * (double)nArray2[i] / 10.0);
            f2 = 0.0f;
            int n3 = 0;
            int n4 = 0;
            if (f3 == f4) {
                if (f20 < f3) {
                    f2 = Math.abs(f3 - f20);
                    f3 = f20;
                    f4 = f20;
                }
                n3 = (int)Math.abs(f3 - f14);
                n4 = (int)Math.abs(f3 - f20);
                f19 = Math.abs(f5 - f21);
                f18 = Math.abs(f21 - f15);
            } else if (f5 == f6) {
                if (f21 < f5) {
                    f2 = Math.abs(f5 - f21);
                    f5 = f21;
                    f6 = f21;
                }
                n3 = (int)Math.abs(f5 - f15);
                n4 = (int)Math.abs(f5 - f21);
                f19 = Math.abs(f3 - f20);
                f18 = Math.abs(f20 - f14);
            } else {
                float f22 = f11 * f20 + f12;
                f18 = (float)Math.sqrt((f20 - f14) * (f20 - f14) + (f21 - f15) * (f21 - f15));
                float f23 = (float)Math.sqrt(f11 * f11 + 1.0f);
                if (f22 > f21) {
                    f2 = Math.abs(f11 * f20 - f21 + f12) / f23;
                    f12 += f21 - f22;
                    float f24 = (f4 - f3) * (f6 - f5) * (f21 - f22) / f17;
                    float f25 = f21 - f22 - (f6 - f5) * (f6 - f5) * (f21 - f22) / f17;
                    f3 -= f24;
                    f5 += f25;
                    f4 -= f24;
                    f6 += f25;
                    n3 = (int)(Math.abs(f11 * f14 - f15 + f12) / f23);
                    n4 = 0;
                } else {
                    n3 = (int)(Math.abs(f11 * f14 - f15 + f12) / f23);
                    n4 = (int)(Math.abs(f11 * f20 - f21 + f12) / f23);
                }
                f19 = f16 + f18;
            }
            f13 += (float)(n3 + n4) * f18 / 2.0f + f16 * f2;
            f16 = f19;
            f14 = f20;
            f15 = f21;
        }
        if (f3 < f4 || f3 == f4 && f5 < f6) {
            fArray[0] = f3;
            fArray[1] = f5;
            fArray[2] = f4;
            fArray[3] = f6;
        } else {
            fArray[0] = f4;
            fArray[1] = f6;
            fArray[2] = f3;
            fArray[3] = f5;
        }
        if (f3 == f4) {
            fArray[0] = fArray[0] + f;
            fArray[2] = fArray[0];
        } else if (f5 == f6) {
            fArray[1] = fArray[1] - f;
            fArray[3] = fArray[1];
        } else {
            float f26 = (float)Math.sqrt(f17);
            f2 = f * Math.abs(f10 - f8) / f26;
            float f27 = f * Math.abs(f9 - f7) / f26;
            if (fArray[3] > fArray[1]) {
                fArray[0] = fArray[0] + f2;
                fArray[2] = fArray[2] + f2;
            } else {
                fArray[0] = fArray[0] - f2;
                fArray[2] = fArray[2] - f2;
            }
            fArray[1] = fArray[1] - f27;
            fArray[3] = fArray[3] - f27;
        }
        return f13 / f16;
    }
}

