/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.svg;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.Bidi;
import java.util.ArrayList;
import oracle.sdovis.SRS;
import oracle.sdovis.Spheroid;

public class SVGUtil {
    private static final double HalfPI = 1.5707963267948966;
    private static FontRenderContext frc = new FontRenderContext(null, true, true);

    public static String getDoubleString(double d) {
        return SVGUtil.getDoubleString(d, 1);
    }

    public static String getDoubleString(double d, int n) {
        if (n < 1 || d == (double)((int)d)) {
            return Integer.toString((int)d);
        }
        String string = Double.toString(d);
        int n2 = string.indexOf(46);
        if (n2 < 0 || string.indexOf(69) > 0) {
            return string;
        }
        if (Math.abs(d) > 1.0) {
            ++n2;
        } else {
            ++n2;
            while (n2 < string.length() && string.charAt(n2) == '0') {
                ++n2;
            }
        }
        int n3 = Math.min(n2 + n, string.length()) - 1;
        while (string.charAt(n3) == '0') {
            --n3;
        }
        if (string.charAt(n3) == '.') {
            --n3;
        }
        return string.substring(0, n3 + 1);
    }

    public static ArrayList getIntersectionPoints(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return SVGUtil.getIntersectionPoints(d, d2, d3, d4, d5, d6, d7, d8, true);
    }

    public static ArrayList getIntersectionPoints(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl) {
        if (d5 == d7 && d6 == d8) {
            return null;
        }
        if (d5 >= d && d5 <= d3 && d6 >= d2 && d6 <= d4 && d7 >= d && d7 <= d3 && d8 >= d2 && d8 <= d4) {
            return null;
        }
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>(2);
        if (d5 == d7) {
            if (d7 < d || d7 > d3 || d8 > d4 && d6 > d4 || d8 < d2 && d6 < d2) {
                return null;
            }
            if (d8 > d4) {
                if (d6 < d2) {
                    arrayList.add(new Point2D.Double(d7, d2));
                    arrayList.add(new Point2D.Double(d7, d4));
                } else {
                    arrayList.add(new Point2D.Double(d7, d4));
                }
            } else if (d8 < d2) {
                if (d6 > d4) {
                    arrayList.add(new Point2D.Double(d7, d4));
                    arrayList.add(new Point2D.Double(d7, d2));
                } else {
                    arrayList.add(new Point2D.Double(d7, d2));
                }
            } else if (d6 < d2) {
                arrayList.add(new Point2D.Double(d7, d2));
            } else if (d6 > d4) {
                arrayList.add(new Point2D.Double(d7, d4));
            }
        } else if (d6 == d8) {
            if (d8 < d2 || d8 > d4 || d7 > d3 && d5 > d3 || d7 < d && d5 < d) {
                return null;
            }
            if (d7 > d3) {
                if (d5 < d) {
                    arrayList.add(new Point2D.Double(d, d8));
                    arrayList.add(new Point2D.Double(d3, d8));
                } else {
                    arrayList.add(new Point2D.Double(d3, d8));
                }
            } else if (d7 < d) {
                if (d5 > d3) {
                    arrayList.add(new Point2D.Double(d3, d8));
                    arrayList.add(new Point2D.Double(d, d8));
                } else {
                    arrayList.add(new Point2D.Double(d, d8));
                }
            } else if (d5 < d) {
                arrayList.add(new Point2D.Double(d, d8));
            } else if (d5 > d3) {
                arrayList.add(new Point2D.Double(d3, d8));
            }
        } else {
            double d9;
            double d10 = (d6 - d8) * 1.0 / (d5 - d7);
            double d11 = (d8 * d5 - d6 * d7) * 1.0 / (d5 - d7);
            double d12 = d10 * d3 + d11;
            Point2D.Double double_ = null;
            Point2D.Double double_2 = null;
            Point2D.Double double_3 = null;
            if (d12 <= d4 && d12 >= d2 && (d12 >= d6 && d12 <= d8 || d12 <= d6 && d12 >= d8)) {
                double_3 = new Point2D.Double(d3, d12);
                if (d5 > d3) {
                    double_ = double_3;
                } else {
                    double_2 = double_3;
                }
            }
            if ((d9 = d10 * d + d11) <= d4 && d9 >= d2 && (d9 >= d6 && d9 <= d8 || d9 <= d6 && d9 >= d8)) {
                double_3 = new Point2D.Double(d, d9);
                if (d5 < d) {
                    double_ = double_3;
                } else {
                    double_2 = double_3;
                }
            }
            if (double_ == null || double_2 == null) {
                double d13;
                double d14 = (d4 - d11) / d10;
                if (d14 <= d3 && d14 >= d && (d14 >= d5 && d14 <= d7 || d14 <= d5 && d14 >= d7)) {
                    if (d6 > d4) {
                        if (double_ == null) {
                            double_ = new Point2D.Double(d14, d4);
                        }
                    } else if (double_2 == null) {
                        double_2 = new Point2D.Double(d14, d4);
                    }
                }
                if ((d13 = (d2 - d11) / d10) <= d3 && d13 >= d && (d13 >= d5 && d13 <= d7 || d13 <= d5 && d13 >= d7)) {
                    if (d6 < d2) {
                        if (double_ == null) {
                            double_ = new Point2D.Double(d13, d2);
                        }
                    } else if (double_2 == null) {
                        double_2 = new Point2D.Double(d13, d2);
                    }
                }
            }
            if (double_ != null) {
                arrayList.add(double_);
            }
            if (double_2 != null) {
                arrayList.add(double_2);
            }
            if (arrayList.size() == 0 && !bl) {
                if (d5 > d3 && d7 > d3 || d5 < d && d7 < d || d6 > d4 && d8 > d4 || d6 < d2 && d8 < d2) {
                    return arrayList;
                }
                if (d12 < d2 && d9 < d2) {
                    if (d5 < d && d6 > d2 || d7 < d && d8 > d2) {
                        arrayList.add(new Point2D.Double(0.0, 0.0));
                    } else if (d5 > d3 && d6 > d2 || d7 > d3 && d8 > d2) {
                        arrayList.add(new Point2D.Double(d3, 0.0));
                    }
                } else if (d12 > d4 && d9 > d4) {
                    if (d5 < d && d6 < d4 || d7 < d && d8 < d4) {
                        arrayList.add(new Point2D.Double(0.0, d4));
                    } else if (d5 > d3 && d6 < d4 || d7 > d3 && d8 < d4) {
                        arrayList.add(new Point2D.Double(d3, d4));
                    }
                }
            }
        }
        return arrayList;
    }

    public static final String getJSDistFunction(SRS sRS) {
        String string = sRS.getUnit();
        boolean bl = sRS.isGeodetic();
        Spheroid spheroid = sRS.getSpheroid();
        Double d = SRS.getDistanceConversionFactor(string);
        if (d == null && !bl) {
            return SVGUtil.getNonGeodeticJSDistFunction(null);
        }
        double d2 = -1.0;
        if (bl) {
            if (spheroid == null) {
                return SVGUtil.getNonGeodeticJSDistFunction(null);
            }
            return SVGUtil.getGeodeticJSDistFunction(spheroid.getSemiMajorAxis(), Math.sqrt(1.0 - spheroid.getEccentricity2()), spheroid.getFlattening());
        }
        return SVGUtil.getNonGeodeticJSDistFunction(d);
    }

    private static String getNonGeodeticJSDistFunction(Double d) {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (d == null) {
            stringBuffer.append("    var useunit=0;\n");
        } else {
            stringBuffer.append("    var useunit=1;\n");
        }
        stringBuffer.append("    function getDistance(x1, y1, x2, y2)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("      var x=x2-x1;y=y2-y1;\n");
        stringBuffer.append("      var dist=Math.sqrt(x*x+y*y);\n");
        if (d == null) {
            stringBuffer.append("      return dist;\n");
        } else {
            stringBuffer.append("      return dist*" + d + ";\n");
        }
        stringBuffer.append("    }\n");
        return stringBuffer.toString();
    }

    private static final String getGeodeticJSDistFunction(double d, double d2, double d3) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("    var useunit=1;\n");
        stringBuffer.append("    function getDistance(x1, y1, x2, y2)\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("      var DEG2RAD=0.017453292519943295,HalfPI=1.5707963267948966;\n");
        stringBuffer.append("      x1=x1*DEG2RAD;x2=x2*DEG2RAD;y1=y1*DEG2RAD;y2=y2*DEG2RAD;\n");
        stringBuffer.append("      var lamm,phim,dphim,cl,d,ce,cyp,ctp,cx,cy;\n");
        stringBuffer.append("      var ct,cd,ca,phi1,phi2;\n");
        stringBuffer.append("      var sphim,cphim,sdphim,cdphim,slamm,sd;\n");
        stringBuffer.append("      if(HalfPI-Math.abs(y1)<1.e-10)\n");
        stringBuffer.append("        phi1=y1;\n");
        stringBuffer.append("      else\n");
        stringBuffer.append("        phi1=Math.atan(" + d2 + "*Math.tan(y1));\n");
        stringBuffer.append("      if(HalfPI-Math.abs(y2)<1.e-10)\n");
        stringBuffer.append("        phi2=y2;\n");
        stringBuffer.append("      else\n");
        stringBuffer.append("        phi2=Math.atan(" + d2 + "*Math.tan(y2));\n");
        stringBuffer.append("      phim=(phi1+phi2)/2.;\n");
        stringBuffer.append("      dphim=(phi1-phi2)/2.;\n");
        stringBuffer.append("      lamm=Math.abs(x1 - x2);\n");
        stringBuffer.append("      if(lamm>Math.PI)\n");
        stringBuffer.append("        lamm=2.*Math.PI-lamm;\n");
        stringBuffer.append("      lamm/=2.;\n");
        stringBuffer.append("      if(lamm<5.e-8&&Math.abs(dphim)<5.e-8)\n");
        stringBuffer.append("        return 0.;\n");
        stringBuffer.append("      else if((HalfPI-lamm<5.e-8&&Math.abs(phim)<5.e-8)||");
        stringBuffer.append("HalfPI-Math.abs(dphim)<5.e-8)\n");
        stringBuffer.append("        return -1.;\n");
        stringBuffer.append("      sphim=Math.sin(phim);\n");
        stringBuffer.append("      cphim=Math.cos(phim);\n");
        stringBuffer.append("      sdphim=Math.sin(dphim);\n");
        stringBuffer.append("      cdphim=Math.cos(dphim);\n");
        stringBuffer.append("      slamm=Math.sin(lamm);\n");
        stringBuffer.append("      cl=sdphim*sdphim+slamm*slamm*(cdphim*cdphim-sphim*sphim);\n");
        stringBuffer.append("      d=Math.acos(1.-2.*cl);\n");
        stringBuffer.append("      sd=Math.sin(d);\n");
        stringBuffer.append("      ce=2.*(1.-2.*cl);\n");
        stringBuffer.append("      cyp=2.*sphim*sphim*cdphim*cdphim/(1.-cl);\n");
        stringBuffer.append("      ctp=2.*sdphim*sdphim*cphim*cphim/cl;\n");
        stringBuffer.append("      cx=cyp+ctp;\n");
        stringBuffer.append("      cy=cyp-ctp;\n");
        stringBuffer.append("      ct=d/sd;\n");
        stringBuffer.append("      cd=4.*ct*ct;\n");
        stringBuffer.append("      ca=cd*ce;\n");
        stringBuffer.append("      return " + d + "*sd*(ct-" + d3 + "*(ct*cx-cy)/4.+" + d3 + "*" + d3 + "*");
        stringBuffer.append("(cx*(ca+(ct-(ca-ce)/2.)*cx)-cy*(2.*cd+ce*cy)+cd*cx*cy)/64.);\n");
        stringBuffer.append("    }\n");
        return stringBuffer.toString();
    }

    public static String UTFEncode(String string, boolean bl) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!SVGUtil.isSafe(c) || c == '&' && !SVGUtil.andSignIsPartOfUTFCode(string, i)) {
                stringBuffer.append("&#" + c + ";");
                continue;
            }
            if (bl && c == '\'') {
                stringBuffer.append("\\'");
                continue;
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    public static String UTFEncode(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!SVGUtil.isSafe(c) || c == '&' && !SVGUtil.andSignIsPartOfUTFCode(string, i)) {
                stringBuffer.append("&#" + c + ";");
                continue;
            }
            stringBuffer.append(c);
        }
        return new String(stringBuffer);
    }

    private static boolean andSignIsPartOfUTFCode(String string, int n) {
        int n2;
        if (string.length() <= n + 3) {
            return false;
        }
        if (string.charAt(n + 1) != '#') {
            return false;
        }
        for (n2 = n + 2; n2 < string.length() && string.charAt(n2) <= '9' && string.charAt(n2) >= '0'; ++n2) {
        }
        return n2 != n + 2 && n2 != string.length() && string.charAt(n2) == ';';
    }

    private static boolean isSafe(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '&' || c == '-' || c == '_' || c == '.' || c == '*' || c == '#' || c == ' ' || c == '\t' || c == ';' || c == '$' || c == ',' || c == ']' || c == '[' || c == '\'';
    }

    public static int getStringLength(String string, Font font) {
        if (font == null) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        if (!Bidi.requiresBidi(cArray, 0, cArray.length)) {
            GlyphVector glyphVector = font.createGlyphVector(frc, string);
            return glyphVector != null ? (int)glyphVector.getVisualBounds().getWidth() : 0;
        }
        TextLayout textLayout = new TextLayout(string, font, frc);
        return (int)textLayout.getBounds().getWidth();
    }
}

