/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.text;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.SRS;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.theme.AnnotationTextThemeProducer;
import oracle.sdovis.util.StringOutputStream;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class AnnotationText
implements Cloneable {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    JGeometry envelope = null;
    AnnotationTextElement[] elements = null;

    public Object clone() {
        try {
            AnnotationText annotationText = (AnnotationText)super.clone();
            if (this.envelope != null) {
                annotationText.envelope = (JGeometry)this.envelope.clone();
            }
            if (this.elements != null) {
                annotationText.elements = new AnnotationTextElement[this.elements.length];
                for (int i = 0; i < this.elements.length; ++i) {
                    annotationText.elements[i] = (AnnotationTextElement)this.elements[i].clone();
                }
            }
            return annotationText;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static final AnnotationText load(STRUCT sTRUCT) throws SQLException {
        Datum[] datumArray;
        ARRAY aRRAY;
        if (sTRUCT == null) {
            return null;
        }
        AnnotationText annotationText = new AnnotationText();
        Datum[] datumArray2 = sTRUCT.getOracleAttributes();
        STRUCT sTRUCT2 = (STRUCT)datumArray2[0];
        if (sTRUCT2 != null) {
            annotationText.envelope = JGeometry.load((STRUCT)sTRUCT2);
        }
        STRUCT sTRUCT3 = (STRUCT)datumArray2[1];
        Datum[] datumArray3 = null;
        if (sTRUCT3 != null && (datumArray3 = sTRUCT3.getOracleAttributes()) != null && (aRRAY = (ARRAY)datumArray3[0]) != null && (datumArray = aRRAY.getOracleArray()) != null) {
            JAXBContext jAXBContext = null;
            Unmarshaller unmarshaller = null;
            Vector<AnnotationTextElement> vector = new Vector<AnnotationTextElement>();
            for (int i = 0; i < datumArray.length; ++i) {
                STRUCT sTRUCT4 = (STRUCT)datumArray[i];
                Datum[] datumArray4 = sTRUCT4.getOracleAttributes();
                if (datumArray4 == null) continue;
                AnnotationTextElement annotationTextElement = new AnnotationTextElement();
                if (datumArray4[0] != null) {
                    annotationTextElement.setValue(datumArray4[0].stringValue());
                }
                if (datumArray4[1] != null) {
                    annotationTextElement.setLocation(JGeometry.load((STRUCT)((STRUCT)datumArray4[1])));
                }
                if (datumArray4[2] != null) {
                    annotationTextElement.setLeaderLine(JGeometry.load((STRUCT)((STRUCT)datumArray4[2])));
                }
                if (datumArray4[3] != null) {
                    try {
                        if (jAXBContext == null) {
                            jAXBContext = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                            unmarshaller = jAXBContext.createUnmarshaller();
                        }
                        StringBuffer stringBuffer = new StringBuffer(datumArray4[3].stringValue());
                        JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(stringBuffer.toString().getBytes()));
                        TextAttributesType textAttributesType = (TextAttributesType)jAXBElement.getValue();
                        annotationTextElement.setAttributes(textAttributesType);
                    }
                    catch (Exception exception) {
                        log.severe(exception.getMessage());
                        log.info("Attributes for text element " + i + " are ignored.");
                    }
                }
                vector.add(annotationTextElement);
            }
            annotationText.setElements(vector);
        }
        return annotationText;
    }

    public STRUCT store(Connection connection, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        STRUCT sTRUCT;
        Object[] objectArray3;
        StructDescriptor structDescriptor = null;
        StructDescriptor structDescriptor2 = null;
        ArrayDescriptor arrayDescriptor = null;
        StructDescriptor structDescriptor3 = null;
        if (objectArray != null && objectArray.length == 4) {
            structDescriptor = (StructDescriptor)objectArray[0];
            structDescriptor2 = (StructDescriptor)objectArray[1];
            arrayDescriptor = (ArrayDescriptor)objectArray[2];
            structDescriptor3 = (StructDescriptor)objectArray[3];
        } else {
            structDescriptor = StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATION_TEXT", (Connection)connection);
            structDescriptor2 = StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATIONTEXTELEMENT_ARRAY", (Connection)connection);
            arrayDescriptor = ArrayDescriptor.createDescriptor((String)"MDSYS.ST_ANNOT_TEXTELEMENT_ARRAY", (Connection)connection);
            structDescriptor3 = StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATIONTEXTELEMENT", (Connection)connection);
        }
        if (structDescriptor == null || structDescriptor2 == null || arrayDescriptor == null || structDescriptor3 == null) {
            throw new SQLException("st_annotation_text descriptors are not defined.");
        }
        STRUCT sTRUCT2 = null;
        if (this.envelope != null) {
            sTRUCT2 = JGeometry.store((JGeometry)this.envelope, (Connection)connection);
        }
        ARRAY aRRAY = null;
        STRUCT[] sTRUCTArray = null;
        if (this.elements != null && this.elements.length > 0) {
            objectArray3 = null;
            sTRUCT = null;
            sTRUCTArray = new STRUCT[this.elements.length];
            objectArray2 = CharacterSet.make((int)-1);
            for (int i = 0; i < this.elements.length; ++i) {
                Object[] objectArray4;
                CHAR cHAR = null;
                if (this.elements[i].getValue() != null) {
                    cHAR = new CHAR(this.elements[i].getValue(), (CharacterSet)objectArray2);
                }
                STRUCT sTRUCT3 = null;
                if (this.elements[i].getLocation() != null) {
                    sTRUCT3 = JGeometry.store((JGeometry)this.elements[i].getLocation(), (Connection)connection);
                }
                STRUCT sTRUCT4 = null;
                if (this.elements[i].getLeaderLine() != null) {
                    sTRUCT4 = JGeometry.store((JGeometry)this.elements[i].getLeaderLine(), (Connection)connection);
                }
                CHAR cHAR2 = null;
                if (this.elements[i].getAttributes() != null) {
                    try {
                        if (objectArray3 == null) {
                            objectArray3 = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                            sTRUCT = objectArray3.createMarshaller();
                            sTRUCT.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
                        }
                        objectArray4 = new StringOutputStream(null);
                        sTRUCT.marshal((Object)new JAXBElement(new QName(null, "textAttributes"), TextAttributesType.class, (Object)this.elements[i].getAttributes()), (OutputStream)objectArray4);
                        cHAR2 = new CHAR(objectArray4.getString(), (CharacterSet)objectArray2);
                    }
                    catch (Exception exception) {
                        log.severe(exception.getMessage());
                        log.info("Unable to marshal attributes for text element " + i + ". Assigning null.");
                    }
                }
                objectArray4 = new Object[]{cHAR, sTRUCT3, sTRUCT4, cHAR2};
                sTRUCTArray[i] = new STRUCT(structDescriptor3, connection, objectArray4);
            }
        }
        aRRAY = new ARRAY(arrayDescriptor, connection, sTRUCTArray);
        objectArray3 = new Object[]{aRRAY};
        sTRUCT = new STRUCT(structDescriptor2, connection, objectArray3);
        objectArray2 = new Object[]{sTRUCT2, sTRUCT};
        return new STRUCT(structDescriptor, connection, objectArray2);
    }

    public static Object[] getDBDescriptors(Connection connection) throws SQLException {
        if (connection == null) {
            return null;
        }
        Object[] objectArray = new Object[]{StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATION_TEXT", (Connection)connection), StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATIONTEXTELEMENT_ARRAY", (Connection)connection), ArrayDescriptor.createDescriptor((String)"MDSYS.ST_ANNOT_TEXTELEMENT_ARRAY", (Connection)connection), StructDescriptor.createDescriptor((String)"MDSYS.ST_ANNOTATIONTEXTELEMENT", (Connection)connection)};
        return objectArray;
    }

    public int getNumberOfElements() {
        if (this.elements == null) {
            return 0;
        }
        return this.elements.length;
    }

    public AnnotationTextElement[] getElements() {
        return this.elements;
    }

    public void setElements(AnnotationTextElement[] annotationTextElementArray) {
        this.elements = annotationTextElementArray;
    }

    public void setElements(Vector vector) {
        this.elements = vector == null || vector.size() == 0 ? null : vector.toArray(new AnnotationTextElement[vector.size()]);
    }

    public boolean addElement(AnnotationTextElement annotationTextElement) {
        if (annotationTextElement == null) {
            return false;
        }
        Vector<AnnotationTextElement> vector = new Vector<AnnotationTextElement>();
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                vector.add(this.elements[i]);
            }
        }
        vector.add(annotationTextElement);
        this.setElements(vector);
        return true;
    }

    public boolean removeElement(int n) {
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (n < 0 || n >= this.elements.length) {
            return false;
        }
        Vector<AnnotationTextElement> vector = new Vector<AnnotationTextElement>();
        for (int i = 0; i < this.elements.length; ++i) {
            if (n == i) continue;
            vector.add(this.elements[i]);
        }
        this.setElements(vector);
        return true;
    }

    public JGeometry getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(JGeometry jGeometry) {
        this.envelope = jGeometry;
    }

    public Rectangle2D getMBR() {
        if (this.envelope == null || this.envelope.getMBR() == null) {
            return null;
        }
        double[] dArray = this.envelope.getMBR();
        Rectangle2D.Double double_ = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        return double_;
    }

    public JGeometry getElementLocation(int n) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (n < 0 || n >= this.elements.length) {
            return null;
        }
        return this.elements[n].getLocation();
    }

    public boolean setElementLocation(int n, JGeometry jGeometry) {
        if (this.elements == null || this.elements.length == 0 || jGeometry == null) {
            return false;
        }
        if (n < 0 || n >= this.elements.length) {
            return false;
        }
        this.elements[n].setLocation(jGeometry);
        return true;
    }

    public JGeometry getElementLeaderLine(int n) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (n < 0 || n >= this.elements.length) {
            return null;
        }
        return this.elements[n].getLeaderLine();
    }

    public boolean setElementLeaderLine(int n, JGeometry jGeometry) {
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (n < 0 || n >= this.elements.length) {
            return false;
        }
        this.elements[n].setLeaderLine(jGeometry);
        return true;
    }

    public TextAttributesType getElementAttributes(int n) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (n < 0 || n >= this.elements.length) {
            return null;
        }
        return this.elements[n].getAttributes();
    }

    public TextAttributesType getOGCElementAttributes(int n, TextAttributesType textAttributesType) {
        TextAttributesType textAttributesType2 = this.getElementAttributes(n);
        if (textAttributesType2 == null) {
            return textAttributesType;
        }
        return textAttributesType2;
    }

    public boolean setElementAttributes(int n, TextAttributesType textAttributesType) {
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (n < 0 || n >= this.elements.length) {
            return false;
        }
        this.elements[n].setAttributes(textAttributesType);
        return true;
    }

    public String getElementValue(int n) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (n < 0 || n >= this.elements.length) {
            return null;
        }
        return this.elements[n].getValue();
    }

    public String getOGCElementValue(int n, String string) {
        String string2 = this.getElementValue(n);
        if (string2 == null) {
            for (int i = n - 1; i > -1 && (string2 = this.getElementValue(i)) == null; --i) {
            }
        }
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public boolean setElementValue(int n, String string) {
        if (this.elements == null || this.elements.length == 0) {
            return false;
        }
        if (n < 0 || n >= this.elements.length) {
            return false;
        }
        this.elements[n].setValue(string);
        return true;
    }

    public AnnotationTextElement getElement(int n) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (n < 0 || n >= this.elements.length) {
            return null;
        }
        return this.elements[n];
    }

    public JGeometry updateEnvelope(String string, double d, TextAttributesType textAttributesType, boolean bl, int n) {
        Rectangle2D rectangle2D = this.getElementsMBR(string, d, textAttributesType, bl);
        if (rectangle2D == null) {
            this.envelope = null;
        } else {
            double d2 = rectangle2D.getMinX();
            double d3 = rectangle2D.getMaxX();
            double d4 = rectangle2D.getMinY();
            double d5 = rectangle2D.getMaxY();
            this.envelope = new JGeometry(d2, d4, d3, d5, n);
        }
        return this.envelope;
    }

    public Rectangle2D getElementsMBR(String string, double d, TextAttributesType textAttributesType, boolean bl) {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Rectangle2D rectangle2D = this.getElementMBR(i, string, d, textAttributesType, bl);
            if (rectangle2D == null) continue;
            if (i == 0) {
                d2 = rectangle2D.getMinX();
                d3 = rectangle2D.getMaxX();
                d4 = rectangle2D.getMinY();
                d5 = rectangle2D.getMaxY();
                continue;
            }
            d2 = Math.min(d2, rectangle2D.getMinX());
            d3 = Math.max(d3, rectangle2D.getMaxX());
            d4 = Math.min(d4, rectangle2D.getMinY());
            d5 = Math.max(d5, rectangle2D.getMaxY());
        }
        if (d2 > d3 || d4 > d5) {
            return null;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
        return double_;
    }

    public Rectangle2D getElementMBR(int n, String string, double d, TextAttributesType textAttributesType, boolean bl) {
        Object object;
        JGeometry jGeometry;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (n < 0 || n >= this.elements.length) {
            return null;
        }
        JGeometry jGeometry2 = this.elements[n].getLocation();
        if (jGeometry2 == null) {
            return null;
        }
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = jGeometry2.getMBR();
        if (dArray != null) {
            d2 = dArray[0];
            d3 = dArray[2];
            d4 = dArray[1];
            d5 = dArray[3];
            d6 = d2 + (d3 - d2) / 2.0;
            d7 = d4 + (d5 - d4) / 2.0;
        }
        if ((jGeometry = this.elements[n].getLeaderLine()) != null && (object = jGeometry.getMBR()) != null) {
            d2 = Math.min(d2, object[0]);
            d3 = Math.max(d3, (double)object[2]);
            d4 = Math.min(d4, (double)object[1]);
            d5 = Math.max(d5, (double)object[3]);
        }
        if ((object = (Object)this.getElementValueMBR(n, string, d, textAttributesType, bl)) != null) {
            d2 = Math.min(d2, ((RectangularShape)object).getMinX());
            d3 = Math.max(d3, ((RectangularShape)object).getMaxX());
            d4 = Math.min(d4, ((RectangularShape)object).getMinY());
            d5 = Math.max(d5, ((RectangularShape)object).getMaxY());
        }
        if (d2 > d3 || d4 > d5) {
            return null;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
        return double_;
    }

    public Rectangle2D getElementValueMBR(int n, String string, double d, TextAttributesType textAttributesType, boolean bl) {
        Rectangle2D.Double double_ = null;
        if (Double.isNaN(d) || d < 1.0) {
            return double_;
        }
        JGeometry jGeometry = this.getElementLocation(n);
        String string2 = this.getOGCElementValue(n, string);
        if (string2 != null && jGeometry != null) {
            StyleText styleText;
            Object object;
            double d2 = 0.0;
            double d3 = 0.0;
            if (jGeometry != null && (object = jGeometry.getMBR()) != null) {
                d2 = object[0] + (object[2] - object[0]) / 2.0;
                d3 = object[3] + (object[3] - object[1]) / 2.0;
            }
            if ((object = (Object)this.getOGCElementAttributes(n, textAttributesType)) != null && (styleText = AnnotationTextThemeProducer.getTextStyle((TextAttributesType)object)) != null && styleText.getFont() != null) {
                double d4;
                Shape shape = StyleText.getStringOutline(string2, (TextStyleModel)styleText.getModel(), null);
                Rectangle2D rectangle2D = shape.getBounds2D();
                double d5 = d4 = d * 0.0254 / (double)SRS.getDPI();
                if (bl) {
                    d5 = SphereCG.convertRadius(0.0, 0.0, d4);
                }
                double d6 = d2;
                double d7 = d3;
                LabelingHints labelingHints = ((TextStyleModel)styleText.getModel()).getLabelingHints();
                Object object2 = labelingHints.get(LabelingHints.KEY_OPOINT_HALIGN);
                Object object3 = labelingHints.get(LabelingHints.KEY_OPOINT_VALIGN);
                if (object2 == null) {
                    object2 = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
                }
                if (object3 == null) {
                    object3 = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
                }
                double d8 = rectangle2D.getWidth() * d5;
                double d9 = rectangle2D.getHeight() * d5;
                double d10 = 0.0;
                double d11 = 0.0;
                d10 = LabelingHints.VALUE_OPOINT_HALIGN_CENTER == object2 ? d6 : (LabelingHints.VALUE_OPOINT_HALIGN_START == object2 ? d6 + d8 / 2.0 : d6 - d8 / 2.0);
                d11 = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE == object3 ? d7 : (LabelingHints.VALUE_OPOINT_VALIGN_TOP == object3 ? d7 - d9 / 2.0 : d7 + d9 / 2.0);
                double_ = new Rectangle2D.Double(d10 - d8 / 2.0, d11 - d9 / 2.0, d8, d9);
                if (jGeometry.isOrientedPoint()) {
                    double[] dArray;
                    JGeometry jGeometry2 = new JGeometry(d10 - d8 / 2.0, d11 - d9 / 2.0, d10 + d8 / 2.0, d11 + d9 / 2.0, jGeometry.getSRID());
                    double[] dArray2 = jGeometry.getOrdinatesArray();
                    int n2 = jGeometry.getDimensions();
                    double d12 = Math.atan2(dArray2[n2 + 1], dArray2[n2]);
                    JGeometry jGeometry3 = Util.rotateGeometry(jGeometry2, d6, d7, d12 = d12 * 180.0 / Math.PI);
                    if (jGeometry3 != null && (dArray = jGeometry3.getMBR()) != null) {
                        double_ = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
                    }
                }
            }
        }
        return double_;
    }

    public Rectangle2D getElementsMBR(String string, TextAttributesType textAttributesType, double d) {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            Rectangle2D rectangle2D = this.getElementMBR(i, string, textAttributesType, d);
            if (rectangle2D == null) continue;
            if (i == 0) {
                d2 = rectangle2D.getMinX();
                d3 = rectangle2D.getMaxX();
                d4 = rectangle2D.getMinY();
                d5 = rectangle2D.getMaxY();
                continue;
            }
            d2 = Math.min(d2, rectangle2D.getMinX());
            d3 = Math.max(d3, rectangle2D.getMaxX());
            d4 = Math.min(d4, rectangle2D.getMinY());
            d5 = Math.max(d5, rectangle2D.getMaxY());
        }
        if (d2 > d3 || d4 > d5) {
            return null;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
        return double_;
    }

    public Rectangle2D getElementMBR(int n, String string, TextAttributesType textAttributesType, double d) {
        Object object;
        JGeometry jGeometry;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (n < 0 || n >= this.elements.length) {
            return null;
        }
        JGeometry jGeometry2 = this.elements[n].getLocation();
        if (jGeometry2 == null) {
            return null;
        }
        double d6 = 0.0;
        double d7 = 0.0;
        double[] dArray = jGeometry2.getMBR();
        if (dArray != null) {
            d2 = dArray[0];
            d3 = dArray[2];
            d4 = dArray[1];
            d5 = dArray[3];
            d6 = d2 + (d3 - d2) / 2.0;
            d7 = d4 + (d5 - d4) / 2.0;
        }
        if ((jGeometry = this.elements[n].getLeaderLine()) != null && (object = jGeometry.getMBR()) != null) {
            d2 = Math.min(d2, object[0]);
            d3 = Math.max(d3, (double)object[2]);
            d4 = Math.min(d4, (double)object[1]);
            d5 = Math.max(d5, (double)object[3]);
        }
        if ((object = (Object)this.getElementValueMBR(n, string, textAttributesType, d)) != null) {
            d2 = Math.min(d2, ((RectangularShape)object).getMinX());
            d3 = Math.max(d3, ((RectangularShape)object).getMaxX());
            d4 = Math.min(d4, ((RectangularShape)object).getMinY());
            d5 = Math.max(d5, ((RectangularShape)object).getMaxY());
        }
        if (d2 > d3 || d4 > d5) {
            return null;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
        return double_;
    }

    public Rectangle2D getElementValueMBR(int n, String string, TextAttributesType textAttributesType, double d) {
        Rectangle2D.Double double_ = null;
        if (Double.isNaN(d) || d <= 0.0) {
            return double_;
        }
        JGeometry jGeometry = this.getElementLocation(n);
        String string2 = this.getOGCElementValue(n, string);
        if (string2 != null && jGeometry != null) {
            StyleText styleText;
            Object object;
            double d2 = 0.0;
            double d3 = 0.0;
            if (jGeometry != null && (object = jGeometry.getMBR()) != null) {
                d2 = object[0] + (object[2] - object[0]) / 2.0;
                d3 = object[3] + (object[3] - object[1]) / 2.0;
            }
            if ((object = (Object)this.getOGCElementAttributes(n, textAttributesType)) != null && (styleText = AnnotationTextThemeProducer.getTextStyle((TextAttributesType)object)) != null && styleText.getFont() != null) {
                Shape shape = StyleText.getStringOutline(string2, (TextStyleModel)styleText.getModel(), null);
                Rectangle2D rectangle2D = shape.getBounds2D();
                double d4 = d2;
                double d5 = d3;
                LabelingHints labelingHints = ((TextStyleModel)styleText.getModel()).getLabelingHints();
                Object object2 = labelingHints.get(LabelingHints.KEY_OPOINT_HALIGN);
                Object object3 = labelingHints.get(LabelingHints.KEY_OPOINT_VALIGN);
                if (object2 == null) {
                    object2 = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
                }
                if (object3 == null) {
                    object3 = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
                }
                double d6 = rectangle2D.getWidth() * d;
                double d7 = rectangle2D.getHeight() * d;
                double d8 = 0.0;
                double d9 = 0.0;
                d8 = LabelingHints.VALUE_OPOINT_HALIGN_CENTER == object2 ? d4 : (LabelingHints.VALUE_OPOINT_HALIGN_START == object2 ? d4 + d6 / 2.0 : d4 - d6 / 2.0);
                d9 = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE == object3 ? d5 : (LabelingHints.VALUE_OPOINT_VALIGN_TOP == object3 ? d5 - d7 / 2.0 : d5 + d7 / 2.0);
                double_ = new Rectangle2D.Double(d8 - d6 / 2.0, d9 - d7 / 2.0, d6, d7);
                if (jGeometry.isOrientedPoint()) {
                    double[] dArray;
                    JGeometry jGeometry2 = new JGeometry(d8 - d6 / 2.0, d9 - d7 / 2.0, d8 + d6 / 2.0, d9 + d7 / 2.0, jGeometry.getSRID());
                    double[] dArray2 = jGeometry.getOrdinatesArray();
                    int n2 = jGeometry.getDimensions();
                    double d10 = Math.atan2(dArray2[n2 + 1], dArray2[n2]);
                    JGeometry jGeometry3 = Util.rotateGeometry(jGeometry2, d4, d5, d10 = d10 * 180.0 / Math.PI);
                    if (jGeometry3 != null && (dArray = jGeometry3.getMBR()) != null) {
                        double_ = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
                    }
                }
            }
        }
        return double_;
    }
}

