/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.jaxb.FontStyle;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.text.jaxb.TextStyle;
import oracle.sdovis.text.jaxb.Textlayout;
import oracle.sdovis.theme.AnnotationTextThemeDefinition;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class AnnotationTextThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected Theme owner = null;
    protected AnnotationTextThemeDefinition def = null;
    private LocalThemeDataProducer features = null;
    private static final int YIELD_COUNT = 20;
    private JAXBContext jc = null;
    private Unmarshaller u = null;
    private Object[] bindingParameters = null;

    public AnnotationTextThemeProducer(Theme theme) {
        this.owner = theme;
        this.def = (AnnotationTextThemeDefinition)theme.getDefinition();
    }

    public AnnotationTextThemeProducer(Theme theme, Object[] objectArray) {
        this.owner = theme;
        this.def = (AnnotationTextThemeDefinition)theme.getDefinition();
        this.bindingParameters = objectArray;
    }

    public void setBindingParameters(Object[] objectArray) {
        this.bindingParameters = objectArray;
    }

    public Object[] getBindingParameters() {
        return this.bindingParameters;
    }

    /*
     * Unable to fully structure code
     */
    public int prepareData(Rectangle2D var1_1, VisContext var2_2) throws DataException {
        block163: {
            block158: {
                block157: {
                    block152: {
                        block153: {
                            block147: {
                                block148: {
                                    block162: {
                                        block142: {
                                            block143: {
                                                this.clearFeatures();
                                                var3_3 = var1_1.getMinX();
                                                var5_4 = var1_1.getMinY();
                                                var7_5 = var1_1.getMaxX();
                                                var9_6 = var1_1.getMaxY();
                                                var11_7 = this.isFullExtent(this.def.getFilterUse(), var3_3, var5_4, var7_5, var9_6);
                                                var12_8 = null;
                                                try {
                                                    var12_8 = DSUtil.getDBConnection(this.def.getDataSourceName(), var2_2);
                                                }
                                                catch (Exception var13_9) {
                                                    AnnotationTextThemeProducer.log.warning(var13_9.getMessage());
                                                    throw new DataException("cannot obtain a connection to database.");
                                                }
                                                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                    try {
                                                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                            if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                                                Util.gotoWorkspaceDate(var12_8, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                                                            } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                                                Util.gotoWorkspaceSavedPoint(var12_8, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                                                            } else {
                                                                Util.gotoWorkspace(var12_8, this.getTheme().getDecorator().getWorkspaceName());
                                                            }
                                                        }
                                                    }
                                                    catch (Exception var13_10) {
                                                        AnnotationTextThemeProducer.log.severe(var13_10.getMessage());
                                                        var14_12 = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                                                        if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                                            var14_12 = var14_12 + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                                                        } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                                            var14_12 = var14_12 + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                                                        }
                                                        throw new DataException(var14_12);
                                                    }
                                                }
                                                var13_11 = DSManager.getSRSCache(this.def.getDataSourceName());
                                                var14_13 = var13_11.get(this.def.getSrid());
                                                AnnotationTextThemeProducer.log.finest("Theme definition SRID: " + this.def.getSrid());
                                                var15_14 = false;
                                                var16_15 = null;
                                                if (var14_13 != null) {
                                                    var15_14 = var14_13.isGeodetic();
                                                    var16_15 = var14_13.getUnit();
                                                } else if (this.def.getSrid() > 0) {
                                                    AnnotationTextThemeProducer.log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                                                }
                                                var17_16 = var3_3;
                                                var19_17 = var7_5;
                                                var21_18 = var5_4;
                                                var23_19 = var9_6;
                                                var25_20 = var2_2.getCurrentScale();
                                                var27_21 = false;
                                                if (var2_2.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != var2_2.getMasterSRID() && this.def.getSrid() != 999999 && var25_20 != Infinity && var25_20 != -Infinity) {
                                                    var28_22 = new double[]{var3_3, var5_4, var7_5, var9_6};
                                                    var29_25 = Util.convertMBR(var28_22, var2_2.getMasterSRID(), this.def.getSrid(), var12_8);
                                                    if (var29_25 != null) {
                                                        var3_3 = var29_25[0];
                                                        var5_4 = var29_25[1];
                                                        var7_5 = var29_25[2];
                                                        var9_6 = var29_25[3];
                                                        var27_21 = true;
                                                    } else {
                                                        AnnotationTextThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01024"));
                                                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                            try {
                                                                Util.gotoWorkspace(var12_8, "LIVE");
                                                            }
                                                            catch (Exception var30_27) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        try {
                                                            if (var12_8 != null) {
                                                                DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                            }
                                                        }
                                                        catch (Exception var30_28) {
                                                            AnnotationTextThemeProducer.log.warning(var30_28.getMessage());
                                                        }
                                                        return 0;
                                                    }
                                                }
                                                if (var25_20 != Infinity && var25_20 != -Infinity) {
                                                    var28_23 = Math.abs(var9_6 - var5_4) / Math.abs(var23_19 - var21_18);
                                                    AnnotationTextThemeProducer.log.finer("[Master scale] " + var25_20 + " [Theme scale factor] " + var28_23);
                                                    var30_29 = var25_20 * var28_23;
                                                    if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                                                        if (var2_2.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != var2_2.getMasterSRID() && var2_2.isTileRequest()) {
                                                            var14_13 = var13_11.get(var2_2.getMasterSRID());
                                                            var32_32 = (var17_16 + var19_17) / 2.0;
                                                            var34_36 = (var21_18 + var23_19) / 2.0;
                                                            var28_23 = 1.0;
                                                        } else {
                                                            var32_32 = (var3_3 + var7_5) / 2.0;
                                                            var34_36 = (var5_4 + var9_6) / 2.0;
                                                        }
                                                        if (var2_2.isTileRequest() && var14_13.isGeodetic()) {
                                                            var32_32 = 0.0;
                                                            var34_36 = 0.0;
                                                        }
                                                        if (var14_13 != null) {
                                                            var30_29 = var14_13.getRatioScale(var25_20 * var28_23, new Point2D.Double(var32_32, var34_36));
                                                            AnnotationTextThemeProducer.log.finer("Ratio scale to compare: " + var30_29);
                                                        } else {
                                                            AnnotationTextThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                                                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                                try {
                                                                    Util.gotoWorkspace(var12_8, "LIVE");
                                                                }
                                                                catch (Exception var36_38) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            try {
                                                                if (var12_8 != null) {
                                                                    DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                                }
                                                            }
                                                            catch (Exception var36_39) {
                                                                AnnotationTextThemeProducer.log.warning(var36_39.getMessage());
                                                            }
                                                            return 0;
                                                        }
                                                    }
                                                    if (!this.getTheme().getDecorator().withinScaleLimits(var30_29)) {
                                                        AnnotationTextThemeProducer.log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                                                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                            try {
                                                                Util.gotoWorkspace(var12_8, "LIVE");
                                                            }
                                                            catch (Exception var32_33) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        try {
                                                            if (var12_8 != null) {
                                                                DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                            }
                                                        }
                                                        catch (Exception var32_34) {
                                                            AnnotationTextThemeProducer.log.warning(var32_34.getMessage());
                                                        }
                                                        return 0;
                                                    }
                                                }
                                                v0 = var28_24 = var15_14 != false && var7_5 - var3_3 > 2.0 && var7_5 - var3_3 < 120.0;
                                                if (var28_24) {
                                                    var3_3 = Math.floor(var3_3);
                                                }
                                                AnnotationTextThemeProducer.log.finest("[ " + this.def.getName() + " ]:  " + var3_3 + "," + var5_4 + "," + var7_5 + "," + var9_6);
                                                var29_26 = false;
                                                if (MapMaker.isSpecial(var3_3, var5_4, var7_5, var9_6) && var2_2.getRotation() != 0.0) {
                                                    AnnotationTextThemeProducer.log.warning("Rotation is currently ignored for full extent.");
                                                } else if (var2_2.getRotation() != 0.0 && !MapMaker.isSpecial(var3_3, var5_4, var7_5, var9_6)) {
                                                    if (var2_2.getRotation() < -360.0 || var2_2.getRotation() > 360.0) {
                                                        AnnotationTextThemeProducer.log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                                                    } else {
                                                        var30_30 = Util.rotateMBR(var3_3, var5_4, var7_5, var9_6, var2_2.getRotation());
                                                        if (var30_30 != null) {
                                                            var3_3 = Math.min(var30_30[0], var3_3);
                                                            var5_4 = Math.min(var30_30[1], var5_4);
                                                            var7_5 = Math.max(var30_30[2], var7_5);
                                                            var9_6 = Math.max(var30_30[3], var9_6);
                                                            AnnotationTextThemeProducer.log.finest("Rotation angle: " + var2_2.getRotation());
                                                            AnnotationTextThemeProducer.log.finest("Search window for rotation: " + var3_3 + "," + var5_4 + "," + var7_5 + "," + var9_6);
                                                            var29_26 = true;
                                                        } else {
                                                            AnnotationTextThemeProducer.log.info("Rotated MBR is null. Rotation ignored.");
                                                        }
                                                    }
                                                }
                                                var30_31 = null;
                                                var31_41 = this.getMetaExpression();
                                                var30_31 = this.def.isPredefined() != false ? this.getPredefinedQuery(var3_3, var5_4, var7_5, var9_6, var31_41) : this.getDynamicQuery(var3_3, var5_4, var7_5, var9_6);
                                                AnnotationTextThemeProducer.log.info("[Annotation Text query]: " + var30_31);
                                                var32_35 = new ArrayList<StyledFeatureI>(128);
                                                var33_42 = 0;
                                                var34_37 = this.getMetadataTextStyle();
                                                if (var34_37 == null) {
                                                    AnnotationTextThemeProducer.log.warning("Metadata text style is null. Set to a default text style.");
                                                    var34_37 = (StyleText)StyleFactory.getDefaultTextStyle();
                                                }
                                                var35_43 = null;
                                                var36_40 = null;
                                                var37_44 = null;
                                                var36_40 = var12_8.prepareStatement(var30_31);
                                                var38_45 = 0;
                                                if (!var11_7) {
                                                    var38_45 = 4;
                                                    var36_40.setDouble(1, var3_3);
                                                    var36_40.setDouble(2, var5_4);
                                                    var36_40.setDouble(3, var7_5);
                                                    var36_40.setDouble(4, var9_6);
                                                }
                                                if (!this.def.isPredefined || this.bindingParameters == null || this.bindingParameters == null) ** GOTO lbl226
                                                var39_47 = this.countBindingVariables(var30_31);
                                                if (var39_47 <= 0 || this.bindingParameters.length >= var39_47) break block142;
                                                AnnotationTextThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01031"));
                                                if (var12_8 != null) {
                                                    try {
                                                        DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                    }
                                                    catch (Exception var40_49) {
                                                        AnnotationTextThemeProducer.log.warning(var40_49.getMessage());
                                                    }
                                                }
                                                var40_50 = 0;
                                                var59_54 = null;
                                                if (this.getTheme().getDecorator().getWorkspaceName() == null) break block143;
                                                try {
                                                    Util.gotoWorkspace(var12_8, "LIVE");
                                                }
                                                catch (Exception var60_59) {
                                                    // empty catch block
                                                }
                                            }
                                            try {
                                                if (var37_44 != null) {
                                                    var37_44.close();
                                                }
                                            }
                                            catch (Exception var60_59) {
                                                AnnotationTextThemeProducer.log.warning(var60_59.getMessage());
                                            }
                                            try {
                                                if (var36_40 != null) {
                                                    var36_40.close();
                                                }
                                            }
                                            catch (Exception var60_59) {
                                                AnnotationTextThemeProducer.log.warning(var60_59.getMessage());
                                            }
                                            try {
                                                if (var12_8 != null) {
                                                    DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                }
                                            }
                                            catch (Exception var60_59) {
                                                // empty catch block
                                            }
                                            if (var35_43 != null) {
                                                throw new DataException(var35_43);
                                            }
                                            return var40_50;
                                        }
                                        if (var39_47 > 0) {
                                            for (var40_51 = 0; var40_51 < var39_47; ++var40_51) {
                                                this.setBindingVariable(var36_40, this.bindingParameters[var40_51], var38_45 + var40_51 + 1);
                                            }
                                        }
lbl226:
                                        // 4 sources

                                        var36_40.setFetchSize(this.owner.getFetchSize());
                                        AnnotationTextThemeProducer.log.finer("Fetch size: " + var36_40.getFetchSize());
                                        var37_44 = var36_40.executeQuery();
                                        var39_48 = var37_44.getMetaData();
                                        var40_51 = 0;
                                        var41_64 = var39_48.getColumnCount();
                                        var42_67 = 0;
                                        var43_69 = 0;
                                        if (!this.def.isPredefined()) break block162;
                                        var43_69 = 2;
                                        if (var31_41 != null) {
                                            var42_67 = 3;
                                            if (var41_64 > 3) {
                                                var40_51 = 1;
                                            }
                                        } else if (var41_64 > 2) {
                                            var40_51 = 1;
                                        }
                                        ** GOTO lbl338
                                    }
                                    var44_70 = this.def.getDefaultTextExpressionColumn();
                                    var45_71 = this.def.getTextColumn();
                                    if (this.def.getBaseColumnAlias() != null) {
                                        var45_71 = this.def.getBaseColumnAlias();
                                    }
                                    for (var46_72 = 0; var46_72 < var41_64; ++var46_72) {
                                        if (var45_71 != null && var39_48.getColumnName(var46_72 + 1).equalsIgnoreCase((String)var45_71)) {
                                            var43_69 = var46_72 + 1;
                                        }
                                        if (var44_70 == null || !var39_48.getColumnName(var46_72 + 1).equalsIgnoreCase(var44_70)) continue;
                                        var42_67 = var46_72 + 1;
                                    }
                                    if (var43_69 != 0) break block147;
                                    AnnotationTextThemeProducer.log.severe("Annotation text column not found [" + this.getTheme().getName() + "].");
                                    var35_43 = "Annotation text column not found [" + this.getTheme().getName() + "].";
                                    var46_72 = 0;
                                    var59_55 = null;
                                    if (this.getTheme().getDecorator().getWorkspaceName() == null) break block148;
                                    try {
                                        Util.gotoWorkspace(var12_8, "LIVE");
                                    }
                                    catch (Exception var60_60) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    if (var37_44 != null) {
                                        var37_44.close();
                                    }
                                }
                                catch (Exception var60_60) {
                                    AnnotationTextThemeProducer.log.warning(var60_60.getMessage());
                                }
                                try {
                                    if (var36_40 != null) {
                                        var36_40.close();
                                    }
                                }
                                catch (Exception var60_60) {
                                    AnnotationTextThemeProducer.log.warning(var60_60.getMessage());
                                }
                                try {
                                    if (var12_8 != null) {
                                        DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                    }
                                }
                                catch (Exception var60_60) {
                                    // empty catch block
                                }
                                if (var35_43 != null) {
                                    throw new DataException(var35_43);
                                }
                                return var46_72;
                            }
                            if (var44_70 == null || var44_70.length() <= 0 || var42_67 != 0) break block152;
                            AnnotationTextThemeProducer.log.severe("Text expression column [" + var44_70 + "] not found" + " [" + this.getTheme().getName() + "].");
                            var35_43 = "Text expression column [" + var44_70 + "] not found" + " [" + this.getTheme().getName() + "].";
                            var46_72 = 0;
                            var59_56 = null;
                            if (this.getTheme().getDecorator().getWorkspaceName() == null) break block153;
                            try {
                                Util.gotoWorkspace(var12_8, "LIVE");
                            }
                            catch (Exception var60_61) {
                                // empty catch block
                            }
                        }
                        try {
                            if (var37_44 != null) {
                                var37_44.close();
                            }
                        }
                        catch (Exception var60_61) {
                            AnnotationTextThemeProducer.log.warning(var60_61.getMessage());
                        }
                        try {
                            if (var36_40 != null) {
                                var36_40.close();
                            }
                        }
                        catch (Exception var60_61) {
                            AnnotationTextThemeProducer.log.warning(var60_61.getMessage());
                        }
                        try {
                            if (var12_8 != null) {
                                DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                            }
                        }
                        catch (Exception var60_61) {
                            // empty catch block
                        }
                        if (var35_43 != null) {
                            throw new DataException(var35_43);
                        }
                        return var46_72;
                    }
                    if (var42_67 > 0 && var41_64 > 2 || var42_67 == 0 && var41_64 > 1) {
                        var40_51 = 1;
                    }
lbl338:
                    // 5 sources

                    var44_70 = this.def.getTextColumn();
                    if (!this.def.isPredefined() && this.def.getBaseColumnAlias() != null) {
                        var44_70 = this.def.getBaseColumnAlias();
                    }
                    var45_71 = new StyleColor(new Color(0, 0, 0, 0));
                    while (var37_44.next()) {
                        var46_73 = null;
                        if (this.def.isPredefined() && this.def.getKeyColumn() != null) {
                            var46_73 = var37_44.getString(this.def.getKeyColumn());
                        }
                        if ((var47_75 = this.loadAnnotation(var46_73, var37_44, var44_70)) == null || (var48_76 = var47_75.getElements()) == null || var48_76.length <= 0) continue;
                        var49_77 = this.def.getMetadataExpression();
                        if (var42_67 > 0) {
                            var49_77 = var37_44.getString(var42_67);
                        }
                        for (var50_78 = 0; var50_78 < var48_76.length; ++var50_78) {
                            var51_79 = var48_76[var50_78].getValue();
                            if (var51_79 == null) {
                                var51_79 = var49_77;
                            } else {
                                var49_77 = var51_79;
                            }
                            if (var51_79 == null) continue;
                            var52_80 = var48_76[var50_78].getLocation();
                            if (var52_80 != null) {
                                var53_81 = AnnotationTextThemeProducer.getTextStyle(var48_76[var50_78].getAttributes());
                                if (var53_81 == null) {
                                    var53_81 = (StyleText)var34_37.clone();
                                }
                                if (!var11_7 && !Double.isNaN(this.def.getMapBaseScale()) && this.def.getMapBaseScale() > 0.0) {
                                    var54_83 = this.def.getMapBaseScale() * 0.0254 / (double)SRS.getDPI();
                                    var56_85 = var53_81.getFont().getSize2D();
                                    var57_86 = new SizeDefinition(var56_85 *= (float)var54_83, "m");
                                    if (var57_86 != null) {
                                        ((TextStyleModel)var53_81.getModel()).setFontSize((float)var57_86.getValue(), var57_86.getUnit());
                                    }
                                }
                                var54_82 = this.getNewStyledFeatureInstance();
                                var55_84 = JSDOGeometry.recast(var52_80);
                                var54_82.setGeometry(var55_84);
                                var54_82.setFeatureStyle((Style)var45_71);
                                var54_82.setLabel(var51_79);
                                var54_82.setLabelStyle((Style)var53_81);
                                var54_82.setForceLabel(true);
                                var54_82.setLabelAsOrientedPoint(true);
                                var54_82.setDataSource(this.def.getDataSourceName());
                                var54_82.setID(var46_73);
                                var54_82.setElementPosition(var50_78);
                                if (var40_51 != 0) {
                                    this.fillAttributes(var54_82, (ResultSetMetaData)var39_48, var37_44, var41_64, var43_69, var42_67);
                                }
                                var32_35.add(var54_82);
                                if (++var33_42 % 20 == 0) {
                                    Thread.currentThread();
                                    Thread.yield();
                                }
                                this.addAnchorLocationFeature(var32_35, var55_84);
                            }
                            if ((var53_81 = var48_76[var50_78].getLeaderLine()) == null) continue;
                            var54_82 = this.getNewStyledFeatureInstance();
                            var54_82.setGeometry(JSDOGeometry.recast((JGeometry)var53_81));
                            var54_82.setFeatureStyleName(this.def.getLeaderLineStyle());
                            var54_82.setDataSource(this.def.getDataSourceName());
                            var54_82.setID(var46_73);
                            var54_82.setElementPosition(var50_78);
                            if (var40_51 != 0) {
                                this.fillAttributes(var54_82, (ResultSetMetaData)var39_48, var37_44, var41_64, var43_69, var42_67);
                            }
                            var32_35.add(var54_82);
                        }
                    }
                    if (MapMaker.isSpecial(var3_3, var5_4, var7_5, var9_6)) {
                        this.loadNewFeatures(var32_35, var34_37, var11_7);
                        break block157;
                    }
                    var46_74 = new Rectangle2D.Double(var3_3, var5_4, var7_5 - var3_3, var9_6 - var5_4);
                    this.loadEditFeatures(var46_74, var32_35, var34_37);
                }
                var59_57 = null;
                if (this.getTheme().getDecorator().getWorkspaceName() == null) break block158;
                try {
                    Util.gotoWorkspace(var12_8, "LIVE");
                }
                catch (Exception var60_62) {
                    // empty catch block
                }
            }
            try {
                if (var37_44 != null) {
                    var37_44.close();
                }
            }
            catch (Exception var60_62) {
                AnnotationTextThemeProducer.log.warning(var60_62.getMessage());
            }
            try {
                if (var36_40 != null) {
                    var36_40.close();
                }
            }
            catch (Exception var60_62) {
                AnnotationTextThemeProducer.log.warning(var60_62.getMessage());
            }
            try {
                if (var12_8 != null) {
                    DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                }
            }
            catch (Exception var60_62) {
                // empty catch block
            }
            if (var35_43 != null) {
                throw new DataException(var35_43);
            }
            break block163;
            {
                catch (Exception var38_46) {
                    AnnotationTextThemeProducer.log.severe(var38_46.getMessage());
                    throw new DataException(var38_46);
                }
            }
            catch (Throwable var58_87) {
                var59_58 = null;
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(var12_8, "LIVE");
                    }
                    catch (Exception var60_63) {
                        // empty catch block
                    }
                }
                try {
                    if (var37_44 != null) {
                        var37_44.close();
                    }
                }
                catch (Exception var60_63) {
                    AnnotationTextThemeProducer.log.warning(var60_63.getMessage());
                }
                try {
                    if (var36_40 != null) {
                        var36_40.close();
                    }
                }
                catch (Exception var60_63) {
                    AnnotationTextThemeProducer.log.warning(var60_63.getMessage());
                }
                try {
                    if (var12_8 != null) {
                        DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                    }
                }
                catch (Exception var60_63) {
                    // empty catch block
                }
                if (var35_43 != null) {
                    throw new DataException(var35_43);
                }
                throw var58_87;
            }
        }
        if (var32_35.size() <= 0) {
            return 0;
        }
        if (var27_21) {
            AnnotationTextThemeProducer.log.info("Transforming styled features SRID " + this.def.getSrid() + " to map SRID " + var2_2.getMasterSRID());
            for (var38_45 = 0; var38_45 < var32_35.size(); ++var38_45) {
                var39_48 = (StyledFeatureI)var32_35.get(var38_45);
                var40_52 = var39_48.getGeometry();
                if (var40_52 == null || var40_52.getSRID() <= 0 || var40_52.getSRID() == var2_2.getMasterSRID()) continue;
                var41_65 = null;
                try {
                    var41_65 = Util.processSRIDConversion(this.owner.getDataSourceName(), var40_52, var2_2.getMasterSRID());
                }
                catch (Exception var42_68) {
                    var41_65 = null;
                }
                if (var41_65 == null) continue;
                var39_48.setGeometry(JSDOGeometry.recast(var41_65));
            }
            AnnotationTextThemeProducer.log.info("End of SRID transformation.");
            var3_3 = var17_16;
            var7_5 = var19_17;
            var5_4 = var21_18;
            var9_6 = var23_19;
        }
        if (var29_26) {
            AnnotationTextThemeProducer.log.info("Rotating styled feature geometries.");
            for (var38_45 = 0; var38_45 < var32_35.size(); ++var38_45) {
                var39_48 = (StyledFeatureI)var32_35.get(var38_45);
                var40_53 = var39_48.getGeometry();
                if (var40_53 == null || (var41_66 = Util.rotateGeometry(var40_53, (var3_3 + var7_5) / 2.0, (var5_4 + var9_6) / 2.0, var2_2.getRotation())) == null || (var40_53 = JSDOGeometry.recast(var41_66)) == null) continue;
                var39_48.setGeometry(JSDOGeometry.recast(var40_53));
            }
        }
        this.setStyledFeatures(var32_35);
        var32_35 = null;
        return this.features.size();
    }

    protected String getDynamicQuery(double d, double d2, double d3, double d4) {
        String string = this.def.getQuery();
        if (string == null) {
            return null;
        }
        if (this.def.passThrough || d == Double.NEGATIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY || d3 == Double.POSITIVE_INFINITY || d4 == Double.POSITIVE_INFINITY) {
            return string;
        }
        String string2 = this.getFilter(this.def.getTextColumn(), this.def.getSrid());
        return "SELECT * FROM ( " + string + " ) mv_antext WHERE " + string2;
    }

    private String getPredefinedQuery(double d, double d2, double d3, double d4, String string) {
        Object object;
        StylingRule[] stylingRuleArray = this.def.getStylingRules();
        String string2 = stylingRuleArray != null && stylingRuleArray.length > 0 ? stylingRuleArray[0].getFeatureCond() : null;
        boolean bl = false;
        String string3 = "";
        if (stylingRuleArray != null && stylingRuleArray.length > 0) {
            object = stylingRuleArray[0].getAttributeColumns();
            if (object != null && object.trim().length() > 0) {
                string3 = "," + stylingRuleArray[0].getAttributeColumns().trim();
            }
            bl = true;
        }
        if (this.def != null && this.def.getIdentifiableColumns() != null) {
            object = this.def.getIdentifiableColumns();
            for (int i = 0; i < ((Field[])object).length; ++i) {
                if (this.columnDefinedInStylingRules(object[i].getName())) continue;
                string3 = string3 + "," + object[i].getName();
            }
        }
        string = string != null ? "," + string : "";
        object = "select " + this.def.getKeyColumn() + ",mv_antext." + this.def.getTextColumn() + string + string3 + " from " + this.def.getBaseTable() + " mv_antext";
        String string4 = null;
        if (!this.def.getFilterUse() && d != Double.NEGATIVE_INFINITY && d2 != Double.NEGATIVE_INFINITY && d3 != Double.POSITIVE_INFINITY && d4 != Double.POSITIVE_INFINITY) {
            string4 = this.getFilter(this.def.getTextColumn(), this.def.getSrid());
        }
        if (string4 != null) {
            object = (String)object + " WHERE " + string4;
            if (string2 != null) {
                object = (String)object + " AND " + string2;
            }
        } else if (string2 != null) {
            object = (String)object + " WHERE " + string2;
        }
        return object;
    }

    private String getMetaExpression() {
        String string;
        if (this.def.isPredefined() && (string = this.def.getMetadataExpression()) != null && string.trim().length() > 0) {
            if (string.startsWith("'") && string.endsWith("'")) {
                return string.trim();
            }
            ArrayList<String> arrayList = this.def.getTableColumns();
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (string.trim().toUpperCase().indexOf(arrayList.get(i).toUpperCase()) <= -1) continue;
                    return string;
                }
                return "'" + string.trim() + "'";
            }
        }
        return null;
    }

    final String getFilter(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string2 = string;
        if (!this.def.isPredefined() && this.def.getBaseColumnAlias() != null) {
            string2 = this.def.getBaseColumnAlias();
        }
        stringBuffer.append("MDSYS.SDO_FILTER(mv_antext." + string2 + ".privateenvelope, " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(?,?,?,?))) = 'TRUE'");
        return stringBuffer.toString();
    }

    public void destroy() {
        if (this.features != null) {
            this.features.destroy();
        }
        this.features = null;
    }

    public void abort() {
    }

    private void clearFeatures() {
        if (this.features != null) {
            this.features.setStyledFeatures((List)null);
        }
    }

    public StyledFeatureI[] getStyledFeatures() {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeatures();
    }

    public StyledFeatureI getStyledFeature(int n) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(n);
    }

    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(rectangle2D, string);
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(rectangle2D);
    }

    public void setStyledFeatures(ArrayList arrayList) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(arrayList);
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(styledFeatureIArray);
    }

    public int size() {
        return this.features != null ? this.features.size() : 0;
    }

    public void postPreparation(VisContext visContext) {
        if (this.features != null) {
            this.features.postPreparation(visContext);
        }
    }

    public Theme getTheme() {
        return this.owner;
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    private boolean isFullExtent(boolean bl, double d, double d2, double d3, double d4) {
        return bl || Double.isInfinite(d) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4);
    }

    private StyleText getMetadataTextStyle() {
        String string = this.def.getMetadataAttributes();
        if (string == null) {
            return null;
        }
        try {
            if (this.jc == null) {
                this.jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                this.u = this.jc.createUnmarshaller();
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            JAXBElement jAXBElement = (JAXBElement)this.u.unmarshal((InputStream)new ByteArrayInputStream(stringBuffer.toString().getBytes()));
            TextAttributesType textAttributesType = (TextAttributesType)jAXBElement.getValue();
            return AnnotationTextThemeProducer.getTextStyle(textAttributesType);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.warning("Unable to build text style for metadata.");
            return null;
        }
    }

    public static StyleText getTextStyle(TextAttributesType textAttributesType) {
        if (textAttributesType == null) {
            return null;
        }
        TextStyle textStyle = textAttributesType.getTextStyle();
        if (textStyle == null) {
            return null;
        }
        String string = textStyle.getFontFamily();
        if (string == null || string.length() == 0) {
            return null;
        }
        float f = textStyle.getFontSize();
        FontStyle fontStyle = textStyle.getFontStyle();
        boolean bl = false;
        if (fontStyle != null && fontStyle.value().equalsIgnoreCase("Italics")) {
            bl = true;
        }
        boolean bl2 = false;
        String string2 = textStyle.getFontWeight();
        if (string2 != null && (string2.equalsIgnoreCase("Bold") || string2.equalsIgnoreCase("400"))) {
            bl2 = true;
        }
        int n = 0;
        if (bl2 && bl) {
            n = 3;
        } else if (bl2) {
            n = 1;
        } else if (bl) {
            n = 2;
        }
        Font font = new Font(string, n, (int)f);
        String string3 = textStyle.getTextDecoration().value();
        String string4 = textStyle.getLetterSpacing();
        float f2 = -1.0f;
        if (string4 != null && !string4.equalsIgnoreCase("normal")) {
            try {
                f2 = Float.parseFloat(string4);
            }
            catch (Exception exception) {
                f2 = -1.0f;
            }
        }
        String string5 = textStyle.getWordSpacing();
        String string6 = textStyle.getFill();
        float f3 = textStyle.getFillOpacity();
        Color color = AnnotationTextThemeProducer.getColor(string6);
        if (color == null) {
            color = Color.black;
        }
        String string7 = textStyle.getStroke();
        float f4 = textStyle.getStrokeWidth();
        float f5 = textStyle.getStrokeOpacity();
        Textlayout textlayout = textAttributesType.getTextlayout();
        String string8 = "start";
        String string9 = "top";
        String string10 = "left";
        float f6 = 0.0f;
        if (textlayout != null) {
            string8 = textlayout.getHorizontalAlignment();
            string9 = textlayout.getVerticalAlignment();
            string10 = textlayout.getMultilineJustification();
            f6 = textlayout.getMultilineSpacing();
        }
        StyleText styleText = new StyleText(font, color, -1.0f);
        if (f2 != -1.0f) {
            ((TextStyleModel)styleText.getModel()).setLetterSpacing(f2);
        }
        Object object = LabelingHints.VALUE_LINE_VALIGN_TOP;
        if (string9 != null && string9.equalsIgnoreCase("center")) {
            object = LabelingHints.VALUE_LINE_VALIGN_MIDDLE;
        } else if (string9 != null && string9.equalsIgnoreCase("baseline")) {
            object = LabelingHints.VALUE_LINE_VALIGN_BASELINE;
        } else if (string9 != null && string9.equalsIgnoreCase("bottom")) {
            object = LabelingHints.VALUE_LINE_VALIGN_BOTTOM;
        }
        LabelingHints labelingHints = ((TextStyleModel)styleText.getModel()).getLabelingHints();
        labelingHints.put(LabelingHints.KEY_LINE_VALIGN, object);
        Object object2 = LabelingHints.VALUE_OPOINT_HALIGN_START;
        if (string8 != null && string8.equalsIgnoreCase("center")) {
            object2 = LabelingHints.VALUE_OPOINT_HALIGN_CENTER;
        } else if (string8 != null && string8.equalsIgnoreCase("end")) {
            object2 = LabelingHints.VALUE_OPOINT_HALIGN_END;
        }
        Object object3 = LabelingHints.VALUE_OPOINT_VALIGN_TOP;
        if (string9 != null && string9.equalsIgnoreCase("center")) {
            object3 = LabelingHints.VALUE_OPOINT_VALIGN_MIDDLE;
        } else if (string9 != null && (string9.equalsIgnoreCase("bottom") || string9.equalsIgnoreCase("baseline"))) {
            object3 = LabelingHints.VALUE_OPOINT_VALIGN_BOTTOM;
        }
        labelingHints.put(LabelingHints.KEY_OPOINT_HALIGN, object2);
        labelingHints.put(LabelingHints.KEY_OPOINT_VALIGN, object3);
        if (textlayout != null) {
            ((TextStyleModel)styleText.getModel()).setMultilineSpacing(f6);
            Object object4 = LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_LEFT;
            if (string10.equalsIgnoreCase("center")) {
                object4 = LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_CENTER;
            } else if (string10.equalsIgnoreCase("right")) {
                object4 = LabelingHints.VALUE_MULTILINE_TEXT_ALIGN_RIGHT;
            }
            labelingHints.put(LabelingHints.KEY_MULTILINE_TEXT_ALIGN, object4);
        }
        ((TextStyleModel)styleText.getModel()).setTextDecoration(string3);
        ((TextStyleModel)styleText.getModel()).setHonorNewline(true);
        return styleText;
    }

    private static Color getColor(String string) {
        Color color = StyleUtils.getColor(string);
        if (color == null) {
            color = StyleUtils.getColorFromRGB(string);
        }
        return color;
    }

    protected void fillAttributes(StyledFeatureI styledFeatureI, ResultSetMetaData resultSetMetaData, ResultSet resultSet, int n, int n2, int n3) throws SQLException, IOException {
        Object object;
        int n4 = 1;
        if (this.def.isPredefined()) {
            n4 = 2;
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = n4; i < n + 1; ++i) {
            if (i == n2 || i == n3) continue;
            object = null;
            String string = resultSetMetaData.getColumnName(i);
            int n5 = resultSetMetaData.getColumnType(i);
            object = Util.getFieldFromResultSet(n5, resultSet, i);
            ((Field)object).setName(string);
            vector.add(object);
        }
        Field[] fieldArray = this.def.getIdentifiableColumns();
        if (fieldArray == null) {
            styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
        } else {
            object = new Field[fieldArray.length];
            block1: for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                String string = field.getName();
                for (int j = 0; j < vector.size(); ++j) {
                    Field field2 = (Field)vector.get(j);
                    if (!string.equalsIgnoreCase(field2.getName())) continue;
                    object[i] = field2;
                    field2.setDisplayName(field.getDisplayName());
                    if (this.columnDefinedInStylingRules(field.getName())) continue block1;
                    vector.remove(j);
                    continue block1;
                }
            }
            styledFeatureI.setIdentifiableAttributes((Field[])object);
            if (vector.size() > 0) {
                styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
            }
        }
    }

    private boolean columnDefinedInStylingRules(String string) {
        StylingRule[] stylingRuleArray = this.def.getStylingRules();
        if (stylingRuleArray == null) {
            return false;
        }
        for (int i = 0; i < stylingRuleArray.length; ++i) {
            String[] stringArray = stylingRuleArray[i].getAttributeColumnsAsArray();
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected AnnotationText loadAnnotation(String string, ResultSet resultSet, String string2) {
        try {
            if (resultSet == null || string2 == null) {
                return null;
            }
            return JDBCUtil.loadAnnotationText(resultSet, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void loadNewFeatures(ArrayList arrayList, StyleText styleText, boolean bl) {
    }

    protected void loadEditFeatures(Rectangle2D rectangle2D, ArrayList arrayList, StyleText styleText) {
    }

    protected void addAnchorLocationFeature(ArrayList arrayList, JSDOGeometry jSDOGeometry) {
    }

    private int countBindingVariables(String string) {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl) {
                int n2;
                if (c == '\'') {
                    bl = true;
                    continue;
                }
                if (c != ':') continue;
                ++n;
                for (n2 = i + 1; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
                }
                while (n2 < string.length() && !Character.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
                i = n2;
                continue;
            }
            if (c != '\'') continue;
            if (i + 1 < string.length() && string.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            bl = false;
        }
        return n;
    }

    private void setBindingVariable(PreparedStatement preparedStatement, Object object, int n) throws SQLException, IllegalArgumentException {
        if (object instanceof String) {
            preparedStatement.setString(n, (String)object);
        } else if (object instanceof Integer) {
            preparedStatement.setInt(n, (Integer)object);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (object instanceof Float) {
            preparedStatement.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (object instanceof Short) {
            preparedStatement.setShort(n, (Short)object);
        } else if (object instanceof Byte) {
            preparedStatement.setByte(n, (Byte)object);
        } else if (object instanceof BigDecimal) {
            preparedStatement.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof byte[]) {
            preparedStatement.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            preparedStatement.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            preparedStatement.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            preparedStatement.setTimestamp(n, (Timestamp)object);
        } else {
            throw new IllegalArgumentException("Binding data type not supported:" + object.getClass().toString());
        }
    }
}

