/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.ext.SDataProvider;
import oracle.mapviewer.share.ext.SDataSet;
import oracle.mapviewer.share.ext.SObject;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SDataProviderMgr;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.ShapefileDataProvider;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.ds.FileDataSource;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class CustomGeomThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected Theme owner = null;
    private CustomGeomThemeDefinition def = null;
    private LocalThemeDataProducer features = null;
    private SDataProvider dataProvider = null;
    private Properties runtimeProperties = null;

    public CustomGeomThemeProducer(Theme theme) {
        this.owner = theme;
        this.def = (CustomGeomThemeDefinition)theme.getDefinition();
        this.refreshProvider();
    }

    public SDataProvider getProvider() {
        return this.dataProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean refreshProvider() {
        this.dataProvider = null;
        if (this.def != null) {
            String string = this.def.getProviderID();
            if (string != null) {
                this.dataProvider = SDataProviderMgr.getProviderInstance(string);
                if (this.dataProvider != null) return true;
                log.severe(RSBundle.getMsg("MAPVIEWER-01026") + " [" + string + "]");
                return false;
            }
            log.severe(RSBundle.getMsg("MAPVIEWER-01027"));
            return false;
        }
        log.warning("Theme definition for producer is null.");
        return false;
    }

    public Theme getTheme() {
        return this.owner;
    }

    public int size() {
        return this.features != null ? this.features.size() : 0;
    }

    public StyledFeatureI getStyledFeature(int n) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(n);
    }

    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    public StyledFeatureI[] getStyledFeatures() {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeatures();
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(rectangle2D, string);
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(rectangle2D);
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(styledFeatureIArray);
    }

    public void setStyledFeatures(ArrayList arrayList) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        int n;
        boolean bl;
        this.clearFeatures();
        if (this.dataProvider == null) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01028"));
            return 0;
        }
        boolean bl2 = MapMaker.isSpecial(rectangle2D);
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        String string = visContext.getMasterDataSourceName();
        if (this.def.getDataSourceName() != null) {
            string = this.def.getDataSourceName();
        }
        if (string == null) {
            log.warning("Theme does not have a datasource. Theme preparation aborted.");
            return 0;
        }
        boolean bl3 = false;
        DataSourceI dataSourceI = DSManager.get(string);
        bl3 = dataSourceI instanceof FileDataSource;
        Connection connection = null;
        try {
            if (!bl3) {
                connection = DSUtil.getDBConnection(string, visContext);
            }
        }
        catch (Exception exception) {
            log.warning("Unable to get connection for data source " + string);
            return 0;
        }
        boolean bl4 = false;
        int n2 = this.def.getSrid();
        SRS sRS = null;
        boolean bl5 = false;
        String string2 = null;
        SRSCache sRSCache = DSManager.getSRSCache(string);
        sRS = sRSCache.get(n2);
        if (sRS != null) {
            bl5 = sRS.isGeodetic();
            string2 = sRS.getUnit();
        } else if (this.def.getSrid() > 0) {
            log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
        }
        double d5 = d;
        double d6 = d3;
        double d7 = d2;
        double d8 = d4;
        double d9 = visContext.getCurrentScale();
        if (visContext.getMasterSRID() > 0 && n2 > 0 && n2 != visContext.getMasterSRID()) {
            if (d9 != Double.POSITIVE_INFINITY && d9 != Double.NEGATIVE_INFINITY) {
                double[] dArray = new double[]{d, d2, d3, d4};
                double[] dArray2 = Util.convertMBR(dArray, visContext.getMasterSRID(), n2, connection);
                if (dArray2 == null) {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01024"));
                    return 0;
                }
                d = dArray2[0];
                d2 = dArray2[1];
                d3 = dArray2[2];
                d4 = dArray2[3];
                bl4 = true;
            } else {
                bl4 = true;
            }
        }
        if (d9 != Double.POSITIVE_INFINITY && d9 != Double.NEGATIVE_INFINITY) {
            double d10 = Math.abs(d4 - d2) / Math.abs(d8 - d7);
            log.finer("[Master scale] " + d9 + " [Theme scale factor] " + d10);
            double d11 = d9 * d10;
            if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                double d12;
                double d13;
                if (visContext.getMasterSRID() > 0 && n2 > 0 && n2 != visContext.getMasterSRID() && visContext.isTileRequest()) {
                    sRS = sRSCache.get(visContext.getMasterSRID());
                    d13 = (d5 + d6) / 2.0;
                    d12 = (d7 + d8) / 2.0;
                    d10 = 1.0;
                } else {
                    d13 = (d + d3) / 2.0;
                    d12 = (d2 + d4) / 2.0;
                }
                if (visContext.isTileRequest() && sRS.isGeodetic()) {
                    d13 = 0.0;
                    d12 = 0.0;
                }
                if (sRS == null) {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                    return 0;
                }
                d11 = sRS.getRatioScale(d9 * d10, new Point2D.Double(d13, d12));
                log.finer("Ratio scale to compare: " + d11);
            }
            if (!this.getTheme().getDecorator().withinScaleLimits(d11)) {
                log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                return 0;
            }
        }
        if (connection != null) {
            DSUtil.closeDBConnection(connection, string);
        }
        boolean bl6 = bl = bl5 && d3 - d > 2.0 && d3 - d < 120.0;
        if (bl) {
            d = Math.floor(d);
            log.finest("jtvpxfmfxed: xl=" + d);
        }
        log.finest("[ " + this.def.getName() + " ]:  " + d + "," + d2 + "," + d3 + "," + d4);
        ArrayList<StyledFeatureI> arrayList = new ArrayList<StyledFeatureI>(128);
        String[] stringArray = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.def.getLabelColumn() != null) {
            arrayList2.add(this.def.getLabelColumn().toUpperCase());
        }
        if (this.def.getKeyColumn() != null && !arrayList2.contains(this.def.getKeyColumn().toUpperCase())) {
            arrayList2.add(this.def.getKeyColumn().toUpperCase());
        }
        if (this.def.getNonSpatialColumns() != null) {
            String[] stringArray2 = this.def.getNonSpatialColumns();
            for (n = 0; n < stringArray2.length; ++n) {
                if (arrayList2.contains(stringArray2[n].toUpperCase())) continue;
                arrayList2.add(stringArray2[n].toUpperCase());
            }
        }
        if (this.def.getIdentifiableColumns() != null) {
            Field[] fieldArray = this.def.getIdentifiableColumns();
            for (n = 0; n < fieldArray.length; ++n) {
                if (arrayList2.contains(fieldArray[n].getName().toUpperCase())) continue;
                arrayList2.add(fieldArray[n].getName().toUpperCase());
            }
        }
        if (arrayList2.size() > 0) {
            stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        n = 0;
        if (bl2 && visContext.getRotation() != 0.0) {
            log.warning("Rotation is currently ignored for full extent.");
        } else if (visContext.getRotation() != 0.0 && !bl2) {
            if (visContext.getRotation() < -360.0 || visContext.getRotation() > 360.0) {
                log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
            } else {
                double[] dArray = Util.rotateMBR(d, d2, d3, d4, visContext.getRotation());
                if (dArray != null) {
                    d = Math.min(dArray[0], d);
                    d2 = Math.min(dArray[1], d2);
                    d3 = Math.max(dArray[2], d3);
                    d4 = Math.max(dArray[3], d4);
                    log.finest("Rotation angle: " + visContext.getRotation());
                    log.finest("Search window for rotation: " + d + "," + d2 + "," + d3 + "," + d4);
                    n = 1;
                    double_ = new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
                } else {
                    log.info("Rotated MBR is null. Rotation ignored.");
                }
            }
        }
        if (this.dataProvider instanceof ShapefileDataProvider) {
            Point2D.Double double_2 = null;
            if (this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0) {
                double d14 = visContext.getDeviceWindow().getWidth();
                double d15 = visContext.getDeviceWindow().getHeight();
                double d16 = (d3 - d) / d14;
                double d17 = (d4 - d2) / d15;
                double_2 = new Point2D.Double();
                ((Point2D)double_2).setLocation(d16 *= (double)this.getTheme().getDecorator().getMinimumFeatureSizePx(), d17 *= (double)this.getTheme().getDecorator().getMinimumFeatureSizePx());
                ((ShapefileDataProvider)this.dataProvider).setFilterResolution(double_2);
            }
        }
        SDataSet sDataSet = null;
        if (this.runtimeProperties == null || this.runtimeProperties.size() == 0) {
            if (this.def.getRuntimeProperties() != null && this.def.getRuntimeProperties().size() > 0) {
                log.finest("Theme runtime properties: " + this.def.getRuntimeProperties().toString());
            }
            log.finest("Calling data provider buildDataSet method.");
            sDataSet = this.dataProvider.buildDataSet(double_, stringArray, this.def.getRuntimeProperties());
        } else {
            log.finest("Runtime properties: " + this.runtimeProperties.toString());
            log.finest("Calling data provider buildDataSet method.");
            sDataSet = this.dataProvider.buildDataSet(double_, stringArray, this.runtimeProperties);
        }
        if (sDataSet == null) {
            log.info("Spatial provider returned a null data set.");
            return 0;
        }
        if (visContext.getMasterSRID() > 0 && bl4) {
            log.info("Feature geometries will have SRID conversion.");
            d = d5;
            d3 = d6;
            d2 = d7;
            d4 = d8;
        }
        if (n != 0) {
            log.info("Feature geometries will be rotated by " + visContext.getRotation() + " degrees.");
        }
        int n3 = 0;
        while (true) {
            block63: {
                StyledFeatureI styledFeatureI;
                block65: {
                    ArrayList<Field> arrayList3;
                    ArrayList<Field> arrayList4;
                    Field[] fieldArray;
                    block66: {
                        block62: {
                            Object object;
                            SObject sObject;
                            block64: {
                                if (n3 >= sDataSet.getSize()) break block62;
                                sObject = sDataSet.getObject(n3);
                                if (sObject == null) break block63;
                                object = sObject.getObject();
                                if (object != null) break block64;
                                log.warning("Object geometry is null for element " + n3 + ". Object ignored.");
                                break block63;
                            }
                            JSDOGeometry jSDOGeometry = null;
                            jSDOGeometry = object instanceof JGeometry ? JSDOGeometry.recast((JGeometry)object) : (JSDOGeometry)sObject.getObject();
                            if (jSDOGeometry == null) break block63;
                            styledFeatureI = this.getNewStyledFeatureInstance();
                            styledFeatureI.setRenderingRules(this.def.getRenderingRules());
                            jSDOGeometry.setSRID(this.def.getSrid());
                            if (visContext.getMasterSRID() > 0 && bl4) {
                                fieldArray = null;
                                if (n3 % 50 == 0) {
                                    log.finer("Transforming geometry " + n3);
                                }
                                try {
                                    fieldArray = Util.processSRIDConversion(string, jSDOGeometry, visContext.getMasterSRID());
                                }
                                catch (Exception exception) {
                                    fieldArray = null;
                                }
                                if (fieldArray != null) {
                                    jSDOGeometry = JSDOGeometry.recast((JGeometry)fieldArray);
                                }
                            }
                            if (n != 0 && (fieldArray = Util.rotateGeometry(jSDOGeometry, (d + d3) / 2.0, (d2 + d4) / 2.0, visContext.getRotation())) != null) {
                                jSDOGeometry = JSDOGeometry.recast((JGeometry)fieldArray);
                            }
                            styledFeatureI.setGeometry(jSDOGeometry);
                            styledFeatureI.setDataSource(string);
                            if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                                styledFeatureI.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                            } else {
                                styledFeatureI.setFeatureStyleName(this.def.getFeatureStyleName());
                            }
                            fieldArray = sObject.getAtttributes();
                            arrayList4 = new ArrayList<Field>();
                            arrayList3 = new ArrayList<Field>();
                            if (fieldArray == null) break block65;
                            break block66;
                        }
                        if (arrayList.size() <= 0) {
                            return 0;
                        }
                        this.setStyledFeatures(arrayList);
                        return this.features.size();
                    }
                    for (int i = 0; i < fieldArray.length; ++i) {
                        Field field;
                        int n4;
                        Object[] objectArray;
                        String string3 = fieldArray[i].getName();
                        if (this.def.getLabelColumn() != null && string3.equalsIgnoreCase(this.def.getLabelColumn())) {
                            styledFeatureI.setLabel(fieldArray[i].getValue().toString());
                            styledFeatureI.setLabelStyleName(this.def.getLabelStyleName());
                        }
                        if (this.def.getKeyColumn() != null && string3.equalsIgnoreCase(this.def.getKeyColumn())) {
                            styledFeatureI.setID(fieldArray[i].getValue().toString());
                        }
                        if (this.def.getNonSpatialColumns() != null) {
                            objectArray = this.def.getNonSpatialColumns();
                            for (n4 = 0; n4 < objectArray.length; ++n4) {
                                if (!string3.equalsIgnoreCase((String)objectArray[n4])) continue;
                                field = (Field)fieldArray[i].clone();
                                arrayList4.add(field);
                            }
                        }
                        if (this.def.getIdentifiableColumns() == null) continue;
                        objectArray = this.def.getIdentifiableColumns();
                        for (n4 = 0; n4 < objectArray.length; ++n4) {
                            if (!string3.equalsIgnoreCase(((Field)objectArray[n4]).getName())) continue;
                            field = (Field)fieldArray[i].clone();
                            field.setDisplayName(((Field)objectArray[n4]).getDisplayName());
                            arrayList3.add(field);
                        }
                    }
                    if (arrayList4.size() > 0) {
                        styledFeatureI.setRenderableAttributes(arrayList4.toArray(new Field[arrayList4.size()]));
                    }
                    if (arrayList3.size() > 0) {
                        styledFeatureI.setIdentifiableAttributes(arrayList3.toArray(new Field[arrayList3.size()]));
                    }
                }
                arrayList.add(styledFeatureI);
            }
            ++n3;
        }
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    public void destroy() {
        if (this.features != null) {
            this.features.destroy();
        }
        this.features = null;
    }

    public void abort() {
    }

    private void clearFeatures() {
        if (this.features != null) {
            this.features.setStyledFeatures((List)null);
        }
    }

    public void postPreparation(VisContext visContext) {
        if (this.features != null) {
            this.features.postPreparation(visContext);
        }
    }

    public void setRuntimeProperties(Properties properties) {
        this.runtimeProperties = properties;
    }

    public Properties getRuntimeProperties() {
        return this.runtimeProperties;
    }
}

