/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import oracle.sdovis.MapMaker;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.stylex.HeatMapStyle;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.VectorThemeDefinition;

public class DynGeomThemeDefinition
extends VectorThemeDefinition {
    protected String mQuery = null;
    protected String mBaseTable = null;
    protected String mSpatialColumn = null;
    protected String mLabelColumn = null;
    protected String mFeatureStyleName = null;
    protected String mLabelStyleName = null;
    protected String mKeyColumn = null;
    private int mBindingVaraiblesNum = 0;
    protected boolean mPassThrough = false;
    protected String mXcolumn = null;
    protected String mYcolumn = null;
    boolean isHeatMapTheme = false;

    public DynGeomThemeDefinition(String string, String string2, String string3, String string4, int n) {
        this.name = string;
        this.dataSource = string2;
        this.mQuery = string3;
        this.mSpatialColumn = string4;
        this.srid = n;
        this.is9i = ((AbstractDBDataSource)DSManager.get(string2)).is9i();
        this.mBindingVaraiblesNum = DynGeomThemeDefinition.countBindingVariables(this.mQuery);
    }

    public DynGeomThemeDefinition() {
    }

    public String getQuery() {
        return this.mQuery;
    }

    public String getBaseTable() {
        return this.mBaseTable;
    }

    public String getSpatialColumn() {
        return this.mSpatialColumn;
    }

    public String getLabelColumn() {
        return this.mLabelColumn;
    }

    public String getFeatureStyleName() {
        return this.mFeatureStyleName;
    }

    public String getLabelStyleName() {
        return this.mLabelStyleName;
    }

    public boolean isPassthrough() {
        return this.mPassThrough;
    }

    public void setQuery(String string) {
        this.mQuery = string;
    }

    public void setBaseTable(String string) {
        this.mBaseTable = string;
    }

    public void setSpatialColumn(String string) {
        this.mSpatialColumn = string;
    }

    public void setLabelColumn(String string) {
        this.mLabelColumn = string;
    }

    public void setFeatureStyleName(String string) {
        this.mFeatureStyleName = string;
        Style style = MapMaker.getStyleWithName(this.mFeatureStyleName, this.dataSource, null);
        this.isHeatMapTheme = style != null && style instanceof HeatMapStyle;
    }

    public void setLabelStyleName(String string) {
        this.mLabelStyleName = string;
    }

    public void setPassthrough(boolean bl) {
        this.mPassThrough = bl;
    }

    public String getThemeType() {
        return "GEOM_DYNAMIC";
    }

    public void setKeyColumn(String string) {
        this.mKeyColumn = string;
    }

    public String getKeyColumn() {
        return this.mKeyColumn;
    }

    public String getXMLDefinition() {
        return "";
    }

    public int getBindingVariablesNumber() {
        return this.mBindingVaraiblesNum;
    }

    public static int countBindingVariables(String string) {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl) {
                int n2;
                if (c == '\'') {
                    bl = true;
                    continue;
                }
                if (c != ':') continue;
                ++n;
                for (n2 = i + 1; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
                }
                i = n2;
                continue;
            }
            if (c != '\'') continue;
            if (i + 1 < string.length() && string.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            bl = false;
        }
        return n;
    }

    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.getBaseTable());
        basicThemeInfo.setType("GEOM_DYNAMIC");
        basicThemeInfo.setKeyColumn(this.getKeyColumn());
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(this.getSpatialColumn());
        return basicThemeInfo;
    }

    public String[] getRenderingStyles() {
        if (this.mFeatureStyleName == null || this.mFeatureStyleName.trim().length() == 0) {
            return null;
        }
        String[] stringArray = new String[]{this.mFeatureStyleName.toUpperCase()};
        return stringArray;
    }

    public String[] getLabelingStyles() {
        if (this.mLabelStyleName == null || this.mLabelStyleName.trim().length() == 0) {
            return null;
        }
        String[] stringArray = new String[]{this.mLabelStyleName.toUpperCase()};
        return stringArray;
    }

    public void setPointColumns(String string, String string2) {
        this.mXcolumn = string;
        this.mYcolumn = string2;
    }

    public String getPointXColumn() {
        return this.mXcolumn;
    }

    public String getPointYColumn() {
        return this.mYcolumn;
    }
}

