/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.ArrayParameter;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.HMPointFeature;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class DynGeomThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected Theme owner;
    private DynGeomThemeDefinition def;
    LocalThemeDataProducer features;
    String dbVersion = null;
    double viewResX = Double.MIN_VALUE;
    double viewResY = Double.MIN_VALUE;
    private Object[] bindingParameters = null;
    private PreparedStatement stmt = null;
    private boolean aborted = false;
    private static final int YIELD_COUNT = 20;

    private DynGeomThemeProducer() {
    }

    public DynGeomThemeProducer(Theme theme) {
        this.owner = theme;
        this.def = (DynGeomThemeDefinition)theme.getDefinition();
    }

    public DynGeomThemeProducer(Theme theme, Object[] objectArray) {
        this.owner = theme;
        this.def = (DynGeomThemeDefinition)theme.getDefinition();
        this.bindingParameters = objectArray;
    }

    public Theme getTheme() {
        return this.owner;
    }

    public int size() {
        return this.features != null ? this.features.size() : 0;
    }

    public StyledFeatureI getStyledFeature(int n) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(n);
    }

    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    public StyledFeatureI[] getStyledFeatures() {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeatures();
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(rectangle2D, string);
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(rectangle2D);
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(styledFeatureIArray);
    }

    public void setStyledFeatures(ArrayList arrayList) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(arrayList);
    }

    /*
     * Loose catch block
     */
    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        ArrayList<StyledFeatureI> arrayList;
        block113: {
            Exception exception722;
            Connection connection;
            ResultSet resultSet;
            block110: {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                boolean bl;
                ResultSetMetaData resultSetMetaData;
                long l;
                long l2;
                String string;
                long l3;
                Proj proj;
                int n8;
                block101: {
                    Exception exception2222;
                    block106: {
                        block100: {
                            Exception exception3222;
                            block102: {
                                block95: {
                                    Exception exception4222;
                                    int n9;
                                    block96: {
                                        this.aborted = false;
                                        if (this.def.getQuery() == null || !Util.isQueryAllowed(this.def.getQuery())) {
                                            log.severe("Invalid or null query string.");
                                            return 0;
                                        }
                                        resultSet = null;
                                        n8 = 0;
                                        proj = visContext.getProjection();
                                        arrayList = new ArrayList<StyledFeatureI>(128);
                                        connection = null;
                                        connection = DSUtil.getDBConnection(this.owner.getDataSourceName(), visContext);
                                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                            if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                                Util.gotoWorkspaceDate(connection, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                                            } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                                Util.gotoWorkspaceSavedPoint(connection, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                                            } else {
                                                Util.gotoWorkspace(connection, this.getTheme().getDecorator().getWorkspaceName());
                                            }
                                        }
                                        l3 = System.currentTimeMillis();
                                        string = this.rewriteQuery(connection, rectangle2D, visContext);
                                        if (string != null) break block95;
                                        try {
                                            if (connection != null) {
                                                DSUtil.closeDBConnection(connection, this.owner.getDataSourceName());
                                            }
                                        }
                                        catch (Exception exception5) {
                                            log.warning(exception5.getMessage());
                                        }
                                        n9 = 0;
                                        Object var45_15 = null;
                                        if (this.getTheme().getDecorator().getWorkspaceName() == null) break block96;
                                        try {
                                            Util.gotoWorkspace(connection, "LIVE");
                                        }
                                        catch (Exception exception4222) {
                                            log.warning(exception4222.getMessage());
                                        }
                                    }
                                    try {
                                        if (resultSet != null) {
                                            resultSet.close();
                                        }
                                    }
                                    catch (Exception exception4222) {
                                        log.warning(exception4222.getMessage());
                                    }
                                    try {
                                        if (this.stmt != null) {
                                            this.stmt.close();
                                        }
                                    }
                                    catch (Exception exception4222) {
                                        log.warning(exception4222.getMessage());
                                    }
                                    try {
                                        if (connection != null) {
                                            DSUtil.closeDBConnection(connection, this.owner.getDataSourceName());
                                        }
                                    }
                                    catch (Exception exception4222) {
                                        log.warning(exception4222.getMessage());
                                    }
                                    return n9;
                                }
                                log.finest("[DynGeomTheme] rewritten query:  " + string);
                                this.stmt = connection.prepareStatement(string);
                                if (this.bindingParameters != null) {
                                    for (int i = 0; i < this.bindingParameters.length; ++i) {
                                        DynGeomThemeProducer.setBindingVariable(connection, this.stmt, this.bindingParameters[i], i + 1);
                                    }
                                }
                                this.stmt.setFetchSize(this.owner.getFetchSize());
                                log.finer("Fetch size: " + this.stmt.getFetchSize());
                                l2 = System.currentTimeMillis();
                                resultSet = this.stmt.executeQuery();
                                l = System.currentTimeMillis();
                                resultSetMetaData = resultSet.getMetaData();
                                bl = false;
                                n7 = 0;
                                n6 = 0;
                                n5 = 0;
                                n4 = resultSetMetaData.getColumnCount();
                                n3 = 0;
                                n2 = 0;
                                Field[] fieldArray = this.def.getIdentifiableColumns();
                                if (fieldArray != null) {
                                    // empty if block
                                }
                                boolean bl2 = false;
                                for (n = 0; n < n4; ++n) {
                                    String string2 = this.def.getSpatialColumn();
                                    if (string2 != null && string2.length() > 0 && !string2.equals("null")) {
                                        if (resultSetMetaData.getColumnName(n + 1).equalsIgnoreCase(string2)) {
                                            n7 = n + 1;
                                        }
                                    } else if (!this.isXYjdbc()) {
                                        String string3 = resultSetMetaData.getColumnTypeName(n + 1);
                                        log.finest("sqlType=" + string3);
                                        if (string3.indexOf("SDO_GEOMETRY") >= 0) {
                                            n7 = n + 1;
                                        }
                                    }
                                    if (this.def.getLabelColumn() != null && resultSetMetaData.getColumnName(n + 1).equalsIgnoreCase(this.def.getLabelColumn())) {
                                        n6 = n + 1;
                                    }
                                    if (this.def.getKeyColumn() != null && resultSetMetaData.getColumnName(n + 1).equalsIgnoreCase(this.def.getKeyColumn())) {
                                        n5 = n + 1;
                                    }
                                    if (this.def.getPointXColumn() != null && resultSetMetaData.getColumnName(n + 1).equalsIgnoreCase(this.def.getPointXColumn())) {
                                        n3 = n + 1;
                                    }
                                    if (this.def.getPointYColumn() == null || !resultSetMetaData.getColumnName(n + 1).equalsIgnoreCase(this.def.getPointYColumn())) continue;
                                    n2 = n + 1;
                                }
                                if (n7 != 0) break block100;
                                if (n3 != 0 && n2 != 0) break block101;
                                log.severe(RSBundle.getMsg("MAPVIEWER-01029") + " [" + this.getTheme().getName() + "].");
                                n = 0;
                                Object var45_16 = null;
                                if (this.getTheme().getDecorator().getWorkspaceName() == null) break block102;
                                try {
                                    Util.gotoWorkspace(connection, "LIVE");
                                }
                                catch (Exception exception3222) {
                                    log.warning(exception3222.getMessage());
                                }
                            }
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (Exception exception3222) {
                                log.warning(exception3222.getMessage());
                            }
                            try {
                                if (this.stmt != null) {
                                    this.stmt.close();
                                }
                            }
                            catch (Exception exception3222) {
                                log.warning(exception3222.getMessage());
                            }
                            try {
                                if (connection != null) {
                                    DSUtil.closeDBConnection(connection, this.owner.getDataSourceName());
                                }
                            }
                            catch (Exception exception3222) {
                                log.warning(exception3222.getMessage());
                            }
                            return n;
                        }
                        if (!this.isXYjdbc() || n3 != 0 && n2 != 0) break block101;
                        log.severe(RSBundle.getMsg("MAPVIEWER-01049") + " [" + this.getTheme().getName() + "].");
                        n = 0;
                        Object var45_17 = null;
                        if (this.getTheme().getDecorator().getWorkspaceName() == null) break block106;
                        try {
                            Util.gotoWorkspace(connection, "LIVE");
                        }
                        catch (Exception exception2222) {
                            log.warning(exception2222.getMessage());
                        }
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2222) {
                        log.warning(exception2222.getMessage());
                    }
                    try {
                        if (this.stmt != null) {
                            this.stmt.close();
                        }
                    }
                    catch (Exception exception2222) {
                        log.warning(exception2222.getMessage());
                    }
                    try {
                        if (connection != null) {
                            DSUtil.closeDBConnection(connection, this.owner.getDataSourceName());
                        }
                    }
                    catch (Exception exception2222) {
                        log.warning(exception2222.getMessage());
                    }
                    return n;
                }
                if (n3 == 0 || n2 == 0) {
                    if (n4 > 2 || n6 == 0 && n4 > 1) {
                        bl = true;
                    }
                } else if (n7 > 0) {
                    if (n4 > 4 || n6 == 0 && n4 > 3) {
                        bl = true;
                    }
                } else if (n4 > 3 || n6 == 0 && n4 > 2) {
                    bl = true;
                }
                n = 0;
                if (visContext.getRotation() != 0.0 && !(visContext.getRotation() < -360.0) && !(visContext.getRotation() > 360.0)) {
                    if (rectangle2D.getWidth() == Double.POSITIVE_INFINITY || rectangle2D.getHeight() == Double.POSITIVE_INFINITY) {
                        log.info("Rotation is currently ignored for full extent.");
                    } else {
                        log.info("Map rotation: " + visContext.getRotation());
                        n = 1;
                    }
                }
                log.finer("Retrieving geometries...");
                boolean bl3 = this.getTheme().getDecorator().isSimplifiedShapes();
                boolean bl4 = this.getTheme().getDecorator().isFastUnpickle();
                boolean bl5 = this.getTheme().getDecorator().allowNakedPoints;
                int n10 = -1;
                double d = 0.0;
                double d2 = 0.0;
                while (!this.aborted && resultSet.next()) {
                    JSDOGeometry jSDOGeometry = null;
                    if (n3 == 0 || n2 == 0) {
                        jSDOGeometry = JDBCUtil.loadGeometry(resultSet, n7, bl4);
                    } else {
                        d = resultSet.getDouble(n3);
                        d2 = resultSet.getDouble(n2);
                        JGeometry jGeometry = new JGeometry(d, d2, this.def.getSrid());
                        if (visContext.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != visContext.getMasterSRID()) {
                            try {
                                jGeometry = Util.processSRIDConversion(this.owner.getDataSourceName(), jGeometry, visContext.getMasterSRID());
                                jSDOGeometry = JSDOGeometry.recast(jGeometry);
                            }
                            catch (Exception exception6) {
                                jSDOGeometry = null;
                            }
                        } else {
                            jSDOGeometry = JSDOGeometry.recast(jGeometry);
                        }
                    }
                    if (jSDOGeometry == null) continue;
                    if (n != 0) {
                        double d3;
                        double d4 = rectangle2D.getMinX();
                        double d5 = rectangle2D.getMinY();
                        double d6 = rectangle2D.getMaxX();
                        JGeometry jGeometry = Util.rotateGeometry(jSDOGeometry, (d4 + d6) / 2.0, (d5 + (d3 = rectangle2D.getMaxY())) / 2.0, visContext.getRotation());
                        if (jGeometry == null || (jSDOGeometry = JSDOGeometry.recast(jGeometry)) == null) continue;
                    }
                    if ((jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null) continue;
                    StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
                    styledFeatureI.setShapeSimplified(bl3);
                    styledFeatureI.setRenderingRules(this.def.getRenderingRules());
                    if (proj != null) {
                        Proj.P2 p2 = proj.getOpposite();
                        if (jSDOGeometry.pointInPolygon(p2.x, p2.y) || (jSDOGeometry = SRS.proj(jSDOGeometry, proj, 0)) == null) continue;
                    }
                    styledFeatureI.setGeometry(jSDOGeometry);
                    styledFeatureI.setDataSource(this.def.getDataSourceName());
                    if (this.def.getRenderingRules() != null && this.def.getRenderingRules().length > 0) {
                        styledFeatureI.setFeatureStyleName(this.def.getRenderingRules()[0].getStyleName());
                    } else {
                        styledFeatureI.setFeatureStyleName(this.def.getFeatureStyleName());
                    }
                    if (n6 > 0) {
                        styledFeatureI.setLabel(resultSet.getString(n6));
                    }
                    styledFeatureI.setLabelStyleName(this.def.getLabelStyleName());
                    styledFeatureI.setResultSetPosition(++n10);
                    if (n5 > 0) {
                        styledFeatureI.setID(resultSet.getString(n5));
                    }
                    if (bl || this.def.identifiableColumns != null) {
                        this.fillAttributes(styledFeatureI, resultSetMetaData, resultSet, n7, n6, styledFeatureI.getLabel(), n5, styledFeatureI.getID(), n4, n3, d, n2, d2);
                    }
                    styledFeatureI.setAllowNakedPoints(bl5);
                    arrayList.add(styledFeatureI);
                    if (++n8 % 20 != 0) continue;
                    Thread.currentThread();
                    Thread.yield();
                }
                log.finer("Read all geometries.");
                long l4 = System.currentTimeMillis();
                log.info("[" + this.def.getName() + "] sql exec time: " + (l - l2) + "ms, total time loading " + n8 + " feature:" + (l4 - l3) + "ms");
                TopThemeQueries.add(l4 - l3, this.getTheme().getName(), this.getTheme().getDataSourceName(), string, "features loaded = " + n8);
                Object var45_18 = null;
                if (this.getTheme().getDecorator().getWorkspaceName() == null) break block110;
                try {
                    Util.gotoWorkspace(connection, "LIVE");
                }
                catch (Exception exception722) {
                    log.warning(exception722.getMessage());
                }
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception722) {
                log.warning(exception722.getMessage());
            }
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception exception722) {
                log.warning(exception722.getMessage());
            }
            try {
                if (connection != null) {
                    DSUtil.closeDBConnection(connection, this.owner.getDataSourceName());
                }
                break block113;
            }
            catch (Exception exception722) {
                log.warning(exception722.getMessage());
            }
            break block113;
            {
                catch (Exception exception8) {
                    if (exception8.getMessage() != null && exception8.getMessage().indexOf("ORA-01013") < 0) {
                        log.log(Level.SEVERE, "Error fetching data.", exception8);
                        throw new DataException(exception8);
                    }
                    throw new DataException("Aborted by user.", exception8);
                }
            }
            catch (Throwable throwable) {
                Exception exception9222;
                Object var45_19 = null;
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(connection, "LIVE");
                    }
                    catch (Exception exception9222) {
                        log.warning(exception9222.getMessage());
                    }
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception9222) {
                    log.warning(exception9222.getMessage());
                }
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                }
                catch (Exception exception9222) {
                    log.warning(exception9222.getMessage());
                }
                try {
                    if (connection != null) {
                        DSUtil.closeDBConnection(connection, this.owner.getDataSourceName());
                    }
                }
                catch (Exception exception9222) {
                    log.warning(exception9222.getMessage());
                }
                throw throwable;
            }
        }
        if (this.aborted) {
            arrayList.clear();
        }
        if (arrayList.size() <= 0) {
            return 0;
        }
        this.setStyledFeatures(arrayList);
        arrayList = null;
        return this.features.size();
    }

    public void postPreparation(VisContext visContext) {
        if (this.features != null) {
            this.features.postPreparation(visContext);
        }
    }

    String getFeatureStyleName() {
        return this.def.getFeatureStyleName();
    }

    String getLabelStyleName() {
        return this.def.getLabelStyleName();
    }

    protected void fillAttributes(StyledFeatureI styledFeatureI, ResultSetMetaData resultSetMetaData, ResultSet resultSet, int n, int n2, String string, int n3, String string2, int n4, int n5, double d, int n6, double d2) throws SQLException, IOException {
        Object object;
        int n7;
        int n8 = n7 = n2 <= 0 ? n4 - 1 : n4 - 2;
        if (n5 > 0 && n6 > 0) {
            n7 = n <= 0 ? (n2 <= 0 ? n4 - 2 : n4 - 3) : (n2 <= 0 ? n4 - 3 : n4 - 4);
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 1; i < n4 + 1; ++i) {
            if (i == n || i == n2 || i == n3 || i == n5 || i == n6) continue;
            object = null;
            String string3 = resultSetMetaData.getColumnName(i);
            int n9 = resultSetMetaData.getColumnType(i);
            object = Util.getFieldFromResultSet(n9, resultSet, i);
            ((Field)object).setName(string3);
            vector.add(object);
        }
        Field[] fieldArray = this.def.getIdentifiableColumns();
        if (fieldArray == null) {
            styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
        } else {
            object = new Field[fieldArray.length];
            block1: for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                String string4 = field.getName();
                if (string4.equalsIgnoreCase(this.def.getLabelColumn())) {
                    Field field2 = new Field(string).setName(string4);
                    field2.setDisplayName(field.getDisplayName());
                    object[i] = field2;
                    continue;
                }
                if (string4.equalsIgnoreCase(this.def.getKeyColumn())) {
                    Field field3 = new Field(string2).setName(string4);
                    field3.setDisplayName(field.getDisplayName());
                    object[i] = field3;
                    continue;
                }
                if (string4.equalsIgnoreCase(this.def.getPointXColumn())) {
                    Field field4 = new Field(d).setName(string4);
                    field4.setDisplayName(field.getDisplayName());
                    object[i] = field4;
                    continue;
                }
                if (string4.equalsIgnoreCase(this.def.getPointYColumn())) {
                    Field field5 = new Field(d2).setName(string4);
                    field5.setDisplayName(field.getDisplayName());
                    object[i] = field5;
                    continue;
                }
                for (int j = 0; j < vector.size(); ++j) {
                    Field field6 = (Field)vector.get(j);
                    if (!string4.equalsIgnoreCase(field6.getName())) continue;
                    field6.setDisplayName(field.getDisplayName());
                    object[i] = field6;
                    if (this.columnDefinedInRenderingRules(field.getName())) continue block1;
                    vector.remove(j);
                    continue block1;
                }
            }
            styledFeatureI.setIdentifiableAttributes((Field[])object);
            if (vector.size() > 0) {
                styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
            }
        }
    }

    private boolean columnDefinedInRenderingRules(String string) {
        RenderingRule[] renderingRuleArray = this.def.getRenderingRules();
        if (renderingRuleArray == null) {
            return false;
        }
        for (int i = 0; i < renderingRuleArray.length; ++i) {
            String[] stringArray;
            String[] stringArray2 = renderingRuleArray[i].getStyleColumns();
            if (stringArray2 != null && stringArray2.length > 0) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!string.equalsIgnoreCase(stringArray2[j])) continue;
                    return true;
                }
            }
            if ((stringArray = renderingRuleArray[i].getSubStyleColumns()) == null || stringArray.length <= 0) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equalsIgnoreCase(stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected String rewriteQuery(Connection var1_1, Rectangle2D var2_2, VisContext var3_3) {
        block71: {
            block66: {
                block69: {
                    block70: {
                        block63: {
                            block68: {
                                var4_4 = var2_2.getMinX();
                                var6_5 = var2_2.getMinY();
                                var8_6 = var2_2.getMaxX();
                                var10_7 = var2_2.getMaxY();
                                var12_8 = false;
                                var13_9 = this.def.getSrid();
                                var14_10 = null;
                                var15_11 = false;
                                var16_12 = null;
                                var17_13 = DSManager.getSRSCache(this.owner.getDataSourceName());
                                var14_10 = var17_13.get(var13_9);
                                if (var14_10 != null) {
                                    var15_11 = var14_10.isGeodetic();
                                    var16_12 = var14_10.getUnit();
                                } else if (this.def.getSrid() > 0) {
                                    DynGeomThemeProducer.log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                                }
                                var18_14 = var4_4;
                                var20_15 = var8_6;
                                var22_16 = var6_5;
                                var24_17 = var10_7;
                                var26_18 = var3_3.getCurrentScale();
                                this.getTheme().setShowLabels(true);
                                if (var3_3.getMasterSRID() <= 0 || var13_9 <= 0 || var13_9 == var3_3.getMasterSRID()) break block68;
                                if (var26_18 == Infinity || var26_18 == -Infinity) ** GOTO lbl37
                                var28_19 = new double[]{var4_4, var6_5, var8_6, var10_7};
                                var29_22 /* !! */  = Util.convertMBR(var28_19, var3_3.getMasterSRID(), var13_9, var1_1);
                                if (var29_22 /* !! */  != null) {
                                    var4_4 = var29_22 /* !! */ [0];
                                    var6_5 = var29_22 /* !! */ [1];
                                    var8_6 = (double)var29_22 /* !! */ [2];
                                    var10_7 = (double)var29_22 /* !! */ [3];
                                    var12_8 = true;
                                } else {
                                    DynGeomThemeProducer.log.severe("Conversion of SRIDs returned null.");
                                    return null;
lbl37:
                                    // 1 sources

                                    var12_8 = true;
                                }
                            }
                            if (var26_18 != Infinity && var26_18 != -Infinity) {
                                var28_20 = Math.abs(var10_7 - var6_5) / Math.abs(var24_17 - var22_16);
                                DynGeomThemeProducer.log.finer("[Master scale] " + var26_18 + " [Theme scale factor] " + var28_20);
                                var30_23 = var26_18 * var28_20;
                                if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                                    if (var3_3.getMasterSRID() > 0 && var13_9 > 0 && var13_9 != var3_3.getMasterSRID() && var3_3.isTileRequest()) {
                                        var14_10 = var17_13.get(var3_3.getMasterSRID());
                                        var32_26 = (var18_14 + var20_15) / 2.0;
                                        var34_29 = (var22_16 + var24_17) / 2.0;
                                        var28_20 = 1.0;
                                    } else {
                                        var32_26 = (var4_4 + var8_6) / 2.0;
                                        var34_29 = (var6_5 + var10_7) / 2.0;
                                    }
                                    if (var3_3.isTileRequest() && var14_10.isGeodetic()) {
                                        var32_26 = 0.0;
                                        var34_29 = 0.0;
                                    }
                                    if (var14_10 != null) {
                                        var30_23 = var14_10.getRatioScale(var26_18 * var28_20, new Point2D.Double(var32_26, var34_29));
                                        DynGeomThemeProducer.log.finer("Ratio scale to compare: " + var30_23);
                                    } else {
                                        DynGeomThemeProducer.log.severe("Theme must have SRS when using ratio scale mode.");
                                        return null;
                                    }
                                }
                                if (!this.getTheme().getDecorator().withinScaleLimits(var30_23)) {
                                    DynGeomThemeProducer.log.finer("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                                    return null;
                                }
                                if (!this.getTheme().getDecorator().withinLabelScaleLimits(var30_23)) {
                                    DynGeomThemeProducer.log.finer("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                                    this.getTheme().setShowLabels(false);
                                }
                            }
                            v0 = var28_21 = var15_11 != false && var8_6 - var4_4 > 2.0 && var8_6 - var4_4 < 120.0;
                            if (var28_21) {
                                var4_4 = Math.floor(var4_4);
                                DynGeomThemeProducer.log.finest("jtvpxfmfxed: xl=" + var4_4);
                            }
                            DynGeomThemeProducer.log.finest("[ " + this.def.getName() + " ]:  " + var4_4 + "," + var6_5 + "," + var8_6 + "," + var10_7);
                            if (var3_3.getRotation() != 0.0 && !this.def.isPassthrough() && var2_2.getWidth() != Infinity && var2_2.getHeight() != Infinity && (var29_22 /* !! */  = (double[])Util.rotateMBR(var4_4, var6_5, var8_6, var10_7, var3_3.getRotation())) != null) {
                                var4_4 = Math.min(var29_22 /* !! */ [0], var4_4);
                                var6_5 = Math.min(var29_22 /* !! */ [1], var6_5);
                                var8_6 = Math.max(var29_22 /* !! */ [2], var8_6);
                                var10_7 = Math.max(var29_22 /* !! */ [3], var10_7);
                                DynGeomThemeProducer.log.finest("Rotation angle: " + var3_3.getRotation());
                                DynGeomThemeProducer.log.finest("Search window for rotation: " + var4_4 + "," + var6_5 + "," + var8_6 + "," + var10_7);
                            }
                            if (this.passThruWithFilterParams((var29_22 /* !! */  = (double[])this.def.getQuery()).toUpperCase())) {
                                return this.substituteFilterParams((String)var29_22 /* !! */ , var4_4, var6_5, var8_6, var10_7);
                            }
                            if (!this.def.isPassthrough() && var2_2.getWidth() != Infinity && var2_2.getHeight() != Infinity) break block69;
                            if (!var12_8 || this.isXYjdbc()) break block70;
                            var30_24 = "select ";
                            var31_34 = "SELECT * FROM ( " + (String)var29_22 /* !! */  + " ) WHERE rownum < 1";
                            var32_27 = null;
                            var33_36 = null;
                            var33_36 = var1_1.prepareStatement(var31_34);
                            if (this.bindingParameters != null) {
                                for (var34_30 = 0; var34_30 < this.bindingParameters.length; ++var34_30) {
                                    DynGeomThemeProducer.setBindingVariable(var1_1, var33_36, this.bindingParameters[var34_30], var34_30 + 1);
                                }
                            }
                            var32_27 = var33_36.executeQuery();
                            var34_31 = var32_27.getMetaData();
                            var35_38 = var34_31.getColumnCount();
                            for (var36_42 = 1; var36_42 <= var35_38; ++var36_42) {
                                if (var36_42 > 1) {
                                    var30_24 = var30_24 + ", ";
                                }
                                var30_24 = (var37_44 = var34_31.getColumnName(var36_42)).equalsIgnoreCase(this.def.getSpatialColumn()) != false ? var30_24 + "sdo_cs.transform(" + this.def.getSpatialColumn() + "," + var3_3.getMasterSRID() + ") " + this.def.getSpatialColumn() : var30_24 + var37_44;
                            }
                            var39_46 = null;
                            try {
                                if (var32_27 != null) {
                                    var32_27.close();
                                }
                            }
                            catch (Exception var40_49) {
                                DynGeomThemeProducer.log.warning(var40_49.getMessage());
                            }
                            try {
                                if (var33_36 != null) {
                                    var33_36.close();
                                }
                                break block63;
                            }
                            catch (Exception var40_49) {
                                DynGeomThemeProducer.log.warning(var40_49.getMessage());
                            }
                            break block63;
                            {
                                catch (Exception var34_32) {
                                    DynGeomThemeProducer.log.warning("Exception while retrieving attribute names: " + var34_32);
                                    var39_47 = null;
                                    try {
                                        if (var32_27 != null) {
                                            var32_27.close();
                                        }
                                    }
                                    catch (Exception var40_50) {
                                        DynGeomThemeProducer.log.warning(var40_50.getMessage());
                                    }
                                    try {
                                        if (var33_36 != null) {
                                            var33_36.close();
                                        }
                                        break block63;
                                    }
                                    catch (Exception var40_50) {
                                        DynGeomThemeProducer.log.warning(var40_50.getMessage());
                                    }
                                }
                            }
                            catch (Throwable var38_52) {
                                var39_48 = null;
                                try {
                                    if (var32_27 != null) {
                                        var32_27.close();
                                    }
                                }
                                catch (Exception var40_51) {
                                    DynGeomThemeProducer.log.warning(var40_51.getMessage());
                                }
                                try {
                                    if (var33_36 != null) {
                                        var33_36.close();
                                    }
                                }
                                catch (Exception var40_51) {
                                    DynGeomThemeProducer.log.warning(var40_51.getMessage());
                                }
                                throw var38_52;
                            }
                        }
                        var30_24 = var30_24 + " FROM ( " + (String)var29_22 /* !! */  + " )";
                        DynGeomThemeProducer.log.finest("Query changed: " + var30_24);
                        return var30_24;
                    }
                    return var29_22 /* !! */ ;
                }
                this.viewResX = var3_3.getDeviceWindow().getWidth();
                this.viewResY = var3_3.getDeviceWindow().getHeight();
                this.dbVersion = Util.getDBVersion(var1_1);
                DynGeomThemeProducer.log.finer("View ResX: " + this.viewResX + " View resY: " + this.viewResY);
                DynGeomThemeProducer.log.finer("Database Version: " + this.dbVersion);
                var30_25 = this.getFilter(this.def.getSpatialColumn(), this.def.getSrid(), var4_4, var6_5, var8_6, var10_7, this.def.is9i(), var15_11);
                if (!var12_8 || this.isXYjdbc()) break block71;
                var31_35 = "select ";
                var32_28 = "SELECT * FROM ( " + (String)var29_22 /* !! */  + " ) WHERE rownum < 1";
                var33_37 = null;
                var34_33 = null;
                var34_33 = var1_1.prepareStatement(var32_28);
                if (this.bindingParameters != null) {
                    for (var35_39 = 0; var35_39 < this.bindingParameters.length; ++var35_39) {
                        DynGeomThemeProducer.setBindingVariable(var1_1, var34_33, this.bindingParameters[var35_39], var35_39 + 1);
                    }
                }
                var33_37 = var34_33.executeQuery();
                var35_40 = var33_37.getMetaData();
                var36_43 = var35_40.getColumnCount();
                for (var37_45 = 1; var37_45 <= var36_43; ++var37_45) {
                    if (var37_45 > 1) {
                        var31_35 = var31_35 + ", ";
                    }
                    var31_35 = (var38_53 = var35_40.getColumnName(var37_45)).equalsIgnoreCase(this.def.getSpatialColumn()) != false ? var31_35 + "sdo_cs.transform(" + this.def.getSpatialColumn() + "," + var3_3.getMasterSRID() + ") " + this.def.getSpatialColumn() : var31_35 + var38_53;
                }
                var42_54 = null;
                try {
                    if (var33_37 != null) {
                        var33_37.close();
                    }
                }
                catch (Exception var43_57) {
                    DynGeomThemeProducer.log.warning(var43_57.getMessage());
                }
                try {
                    if (var34_33 != null) {
                        var34_33.close();
                    }
                    break block66;
                }
                catch (Exception var43_57) {
                    DynGeomThemeProducer.log.warning(var43_57.getMessage());
                }
                break block66;
                {
                    catch (Exception var35_41) {
                        DynGeomThemeProducer.log.warning("Exception while retrieving column names:\n" + var35_41);
                        var42_55 = null;
                        try {
                            if (var33_37 != null) {
                                var33_37.close();
                            }
                        }
                        catch (Exception var43_58) {
                            DynGeomThemeProducer.log.warning(var43_58.getMessage());
                        }
                        try {
                            if (var34_33 != null) {
                                var34_33.close();
                            }
                            break block66;
                        }
                        catch (Exception var43_58) {
                            DynGeomThemeProducer.log.warning(var43_58.getMessage());
                        }
                    }
                }
                catch (Throwable var41_60) {
                    var42_56 = null;
                    try {
                        if (var33_37 != null) {
                            var33_37.close();
                        }
                    }
                    catch (Exception var43_59) {
                        DynGeomThemeProducer.log.warning(var43_59.getMessage());
                    }
                    try {
                        if (var34_33 != null) {
                            var34_33.close();
                        }
                    }
                    catch (Exception var43_59) {
                        DynGeomThemeProducer.log.warning(var43_59.getMessage());
                    }
                    throw var41_60;
                }
            }
            var31_35 = var31_35 + " FROM ( " + (String)var29_22 /* !! */  + " ) WHERE " + var30_25;
            DynGeomThemeProducer.log.finest("[" + this.def.getName() + "] Query changed: " + var31_35);
            return var31_35;
        }
        if (!this.isXYjdbc()) {
            return "SELECT * FROM ( " + (String)var29_22 /* !! */  + " ) WHERE " + var30_25;
        }
        var30_25 = "" + this.def.getPointXColumn() + " >= " + var4_4 + " and " + this.def.getPointXColumn() + " <= " + var8_6 + " and " + this.def.getPointYColumn() + " >= " + var6_5 + " and " + this.def.getPointYColumn() + " <= " + var10_7;
        return "SELECT * FROM ( " + (String)var29_22 /* !! */  + " ) WHERE " + var30_25;
    }

    final String getFilter(String string, int n, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string2 = "'querytype=WINDOW'";
        if (this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0 && (this.dbVersion.indexOf(" 10.2") > 0 || this.dbVersion.indexOf(" 10.1.0.3") > 0 || this.dbVersion.indexOf(" 10.1.0.4") > 0 || this.dbVersion.indexOf(" 11.") > 0)) {
            double d5 = (d3 - d) / this.viewResX;
            double d6 = (d4 - d2) / this.viewResY;
            double d7 = Math.min(d5, d6) * (double)this.getTheme().getDecorator().getMinimumFeatureSizePx();
            if (bl2) {
                double d8 = 6378137.0;
                d7 *= Math.PI * d8 / 180.0;
            }
            string2 = "'min_resolution=" + d7 + " querytype=WINDOW'";
        }
        if (bl && bl2) {
            stringBuffer.append("MDSYS.SDO_FILTER(" + string + ", ");
            stringBuffer.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            stringBuffer.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + "))" + ", " + n + " ), " + string2 + ") = 'TRUE'");
            return stringBuffer.toString();
        }
        stringBuffer.append("MDSYS.SDO_FILTER(" + string + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + ")), " + string2 + ") = 'TRUE'");
        return stringBuffer.toString();
    }

    final boolean passThruWithFilterParams(String string) {
        if (string.indexOf("SDO_ORDINATE_ARRAY") == -1) {
            return false;
        }
        int n = string.indexOf("?");
        if (n == -1) {
            return false;
        }
        try {
            int n2 = string.lastIndexOf("?");
            String string2 = string.substring(n, n2 + 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ", \n\t\r\f");
            if (!stringTokenizer.nextToken().equals("?")) {
                return false;
            }
            if (!stringTokenizer.nextToken().equals("?")) {
                return false;
            }
            if (!stringTokenizer.nextToken().equals("?")) {
                return false;
            }
            if (!stringTokenizer.nextToken().equals("?")) {
                return false;
            }
        }
        catch (Exception exception) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01030"));
            return false;
        }
        return true;
    }

    final String substituteFilterParams(String string, double d, double d2, double d3, double d4) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
        int n = string.indexOf("?");
        if (n == -1) {
            return string;
        }
        int n2 = string.lastIndexOf("?");
        if (n2 == -1) {
            return string;
        }
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append("" + d + ", " + d2 + ", " + d3 + ", " + d4);
        stringBuffer.append(string.substring(n2 + 1));
        return stringBuffer.toString();
    }

    public void destroy() {
        if (this.features != null) {
            this.features.destroy();
        }
        this.features = null;
    }

    public void abort() {
        this.aborted = true;
        try {
            if (this.stmt != null) {
                this.stmt.cancel();
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
    }

    public static void setBindingVariable(Connection connection, PreparedStatement preparedStatement, Object object, int n) throws SQLException, IllegalArgumentException {
        if (object instanceof String) {
            preparedStatement.setString(n, (String)object);
        } else if (object instanceof Integer) {
            preparedStatement.setInt(n, (Integer)object);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (object instanceof Float) {
            preparedStatement.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (object instanceof Short) {
            preparedStatement.setShort(n, (Short)object);
        } else if (object instanceof Byte) {
            preparedStatement.setByte(n, (Byte)object);
        } else if (object instanceof BigDecimal) {
            preparedStatement.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof byte[]) {
            preparedStatement.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            preparedStatement.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            preparedStatement.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            preparedStatement.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof ArrayParameter) {
            preparedStatement.setArray(n, (Array)JDBCUtil.createSQLArray((ArrayParameter)object, connection));
        } else if (object instanceof JGeometry) {
            JGeometry jGeometry = (JGeometry)object;
            int n2 = jGeometry.getSRID();
            if (Util.isGeodetic(n2) && jGeometry != null && jGeometry.isCircle()) {
                jGeometry = Util.linearizeCircle(jGeometry);
            }
            STRUCT sTRUCT = null;
            Object[] objectArray = Util.createDBGeomDescriptors(connection);
            sTRUCT = JGeometry.store((JGeometry)jGeometry, (Connection)connection, (Object[])objectArray);
            preparedStatement.setObject(n, sTRUCT);
        } else {
            throw new IllegalArgumentException("Binding data type not supported:" + object.getClass().toString());
        }
    }

    public void setBindingParameters(Object[] objectArray) {
        this.bindingParameters = objectArray;
    }

    public Object[] getBindingParameters() {
        return this.bindingParameters;
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        if (this.def.isHeatMapTheme) {
            return new HMPointFeature();
        }
        return new StyledFeature();
    }

    public boolean isXYjdbc() {
        return this.def.getPointXColumn() != null && this.def.getPointXColumn().trim().length() >= 1 && this.def.getPointYColumn() != null && this.def.getPointYColumn().trim().length() >= 1;
    }
}

