/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.GeoRasterBitmapMask;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.SRS;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.util.JDBCUtil;

public class GeoRasterThemeDefinition
extends ThemeDefinition {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String query = null;
    boolean preserveScale = true;
    boolean passThrough = true;
    String mGeoRasterColumn = null;
    String mRasterTable = null;
    String mRasterId = null;
    String mBands = null;
    String mRasterPyramid = null;
    int pyramidLevel = 0;
    boolean predefined = false;
    String mBaseTable = null;
    String mKeyColumn = null;
    StylingRule mSRule = null;
    protected String cacheGroupName = null;
    String cacheSubRegionName = null;
    String unit = null;
    double resolution = -1.0;
    float alpha = 1.0f;
    double[] sptResolution = null;
    double lastRasterId = -1.0;
    String lastRdtTable = null;
    JSDOGeometry polygonMask = null;
    String pmaskTable = null;
    String pmaskGeomColumn = null;
    String pmaskQCondition = null;
    String pmaskJoinColumn = null;
    String pmaskJoinGeorColumn = null;
    public static final String LINEARSTRETCH_OPERATION = "LINEARSTRETCH";
    public static final String NORMALIZE_OPERATION = "NORMALIZE";
    public static final String EQUALIZE_OPERATION = "EQUALIZE";
    public static final String PIECEWISE_OPERATION = "PIECEWISELINEARSTRETCH";
    public static final String BRIGHTNESS_OPERATION = "BRIGHTNESS";
    public static final String CONTRAST_OPERATION = "CONTRAST";
    public static final String THRESHOLD_OPERATION = "CHANGETHRESHOLD";
    String[] imageProcessNames = null;
    Hashtable imageProcess = null;
    Hashtable bitmapMasks = null;
    private boolean transpNoData = false;
    private int alphaBand = -1;

    public GeoRasterThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.name = string;
        this.dataSource = string2;
        this.mBaseTable = string3;
        this.mGeoRasterColumn = string4;
        this.mRasterPyramid = string7;
        this.mRasterId = string5;
        this.mRasterTable = string6;
        this.setImageQuery(string8);
        DBDataSource dBDataSource = (DBDataSource)DSManager.get(string2);
        this.is9i = dBDataSource.is9i();
        this.predefined = false;
        if (string7 != null) {
            try {
                this.pyramidLevel = Integer.parseInt(string7);
            }
            catch (Exception exception) {
                log.warning("Invalid pyramid value: 0 will be assumed");
                this.pyramidLevel = 0;
            }
        } else {
            this.pyramidLevel = 0;
        }
    }

    public GeoRasterThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, StylingRule[] stylingRuleArray, int n) {
        String string10 = null;
        try {
            DBDataSource dBDataSource = (DBDataSource)DSManager.get(string2);
            this.is9i = dBDataSource.is9i();
            this.predefined = true;
            this.name = string;
            this.dataSource = string2;
            this.mBaseTable = string3;
            this.mKeyColumn = string5;
            this.mGeoRasterColumn = string4;
            this.passThrough = false;
            this.srid = n;
            if (stylingRuleArray != null) {
                this.mSRule = stylingRuleArray[0];
                this.passThrough = stylingRuleArray[0].isQueryPassThrough();
            }
            this.mBands = string9;
            this.mRasterTable = string6;
            this.mRasterId = string7;
            this.mRasterPyramid = string8;
            this.setImageQuery(string10);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            throw new IllegalArgumentException(exception.getMessage());
        }
        if (string8 != null) {
            try {
                this.pyramidLevel = Integer.parseInt(string8);
            }
            catch (Exception exception) {
                log.warning("Invalid pyramid value: 0 will be assumed");
                this.pyramidLevel = 0;
            }
        } else {
            this.pyramidLevel = 0;
        }
    }

    public void setGeoRasterColumn(String string) {
        this.mGeoRasterColumn = string;
    }

    public void setRasterTable(String string) {
        this.mRasterTable = string;
    }

    public void setRasterId(String string) {
        this.mRasterId = string;
    }

    public void setPyramidLevel(String string) {
        try {
            this.pyramidLevel = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.pyramidLevel = 0;
        }
    }

    public int getPyramidLevel() {
        return this.pyramidLevel;
    }

    public void setBands(String string) {
        this.mBands = string;
    }

    public String getBands() {
        return this.mBands;
    }

    public void setASIS(boolean bl) {
        this.passThrough = bl;
    }

    public void setImageResolution(String string, double d) {
        if (string == null || SRS.distUnitList.get(string.toUpperCase()) == null) {
            throw new IllegalArgumentException("Invalid image resolution unit given.");
        }
        this.unit = string.toUpperCase();
        this.resolution = d;
        log.finest("image resolution: " + d + ", unit: " + string);
    }

    public String getImageResolutionUnit() {
        return this.unit;
    }

    public double getImageResolution() {
        return this.resolution;
    }

    public void setImageQuery(String string) {
        if (string == null) {
            this.query = "select grt." + this.mGeoRasterColumn + " from " + this.mBaseTable + " grt where grt." + this.mGeoRasterColumn + ".rasterid = ?";
            if (this.mRasterTable != null) {
                this.query = this.query + " and grt." + this.mGeoRasterColumn + ".rasterdatatable = ?";
            }
        } else {
            this.query = string;
            this.mRasterId = null;
        }
    }

    public String getImageQuery() {
        return this.query;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public String getThemeType() {
        return "GEORASTER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Could not resolve type clashes
     */
    public double[] getSpatialResolution(int n, double d, String string, Connection connection) {
        Exception exception722;
        double[] dArray;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block43: {
            Object object;
            Object object2;
            double[] dArray2;
            double[] dArray3;
            block40: {
                Exception exception22;
                JSDOGeometry jSDOGeometry;
                block41: {
                    dArray3 = null;
                    if (this.sptResolution != null && this.lastRasterId != -1.0 && this.lastRdtTable != null && d == this.lastRasterId && this.lastRdtTable.equalsIgnoreCase(string)) {
                        dArray3 = new double[]{this.sptResolution[0] * Math.pow(2.0, n), this.sptResolution[1] * Math.pow(2.0, n)};
                        log.finest("Res X: " + dArray3[0] + "   Res Y: " + dArray3[1] + "  Pyramidlevel: " + n);
                        return dArray3;
                    }
                    String string2 = "";
                    if (string != null) {
                        string2 = " and a." + this.mGeoRasterColumn + ".rasterdatatable = ?";
                    }
                    preparedStatement = null;
                    resultSet = null;
                    String string3 = "SELECT sdo_geor.getmodelcoordinate(a." + this.mGeoRasterColumn + ",0,sdo_number_array(?,?)) pt_geom " + "FROM " + this.mBaseTable + " a WHERE a." + this.mGeoRasterColumn + ".rasterid = ?" + string2;
                    preparedStatement = connection.prepareStatement(string3);
                    preparedStatement.setInt(1, 0);
                    preparedStatement.setInt(2, 0);
                    preparedStatement.setDouble(3, d);
                    if (string != null) {
                        preparedStatement.setString(4, string.toUpperCase());
                    }
                    resultSet = preparedStatement.executeQuery();
                    dArray2 = null;
                    if (resultSet != null && resultSet.next()) {
                        object2 = JDBCUtil.loadGeometry(resultSet, 1, false);
                        dArray2 = object2.getPoint();
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception3) {
                            log.warning(exception3.getMessage());
                        }
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception4) {
                            log.warning(exception4.getMessage());
                        }
                    }
                    preparedStatement = connection.prepareStatement(string3);
                    preparedStatement.setInt(1, 0);
                    preparedStatement.setInt(2, 1);
                    preparedStatement.setDouble(3, d);
                    if (string != null) {
                        preparedStatement.setString(4, string.toUpperCase());
                    }
                    resultSet = preparedStatement.executeQuery();
                    object2 = null;
                    if (resultSet != null && resultSet.next()) {
                        object = JDBCUtil.loadGeometry(resultSet, 1, false);
                        object2 = object.getPoint();
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception5) {
                            // empty catch block
                        }
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception6) {
                            // empty catch block
                        }
                    }
                    preparedStatement = connection.prepareStatement(string3);
                    preparedStatement.setInt(1, 1);
                    preparedStatement.setInt(2, 0);
                    preparedStatement.setDouble(3, d);
                    if (string != null) {
                        preparedStatement.setString(4, string.toUpperCase());
                    }
                    resultSet = preparedStatement.executeQuery();
                    object = null;
                    if (resultSet != null && resultSet.next()) {
                        jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 1, false);
                        object = jSDOGeometry.getPoint();
                    }
                    if (dArray2 != null && object2 != null && object != null) break block40;
                    log.severe("Unable to calculate spatial resolution.");
                    jSDOGeometry = null;
                    Object var20_20 = null;
                    if (resultSet == null) break block41;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception22) {
                        log.warning(exception22.getMessage());
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception22) {
                        log.warning(exception22.getMessage());
                    }
                }
                return jSDOGeometry;
            }
            dArray3 = new double[2];
            this.sptResolution = new double[2];
            this.lastRasterId = d;
            this.lastRdtTable = string;
            reference dArray4 = object2[0] - dArray2[0];
            reference var16_28 = object2[1] - dArray2[1];
            dArray3[0] = Math.sqrt((double)(dArray4 * dArray4 + var16_28 * var16_28));
            this.sptResolution[0] = dArray3[0];
            dArray3[0] = dArray3[0] * Math.pow(2.0, n);
            dArray4 = object[0] - dArray2[0];
            var16_28 = object[1] - dArray2[1];
            dArray3[1] = Math.sqrt((double)(dArray4 * dArray4 + var16_28 * var16_28));
            this.sptResolution[1] = dArray3[1];
            dArray3[1] = dArray3[1] * Math.pow(2.0, n);
            log.finest("Res X: " + dArray3[0] + "   Res Y: " + dArray3[1] + "  Pyramidlevel: " + n);
            dArray = dArray3;
            Object var20_21 = null;
            if (resultSet == null) break block43;
            try {
                resultSet.close();
            }
            catch (Exception exception722) {
                log.warning(exception722.getMessage());
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception722) {
                log.warning(exception722.getMessage());
            }
        }
        return dArray;
        catch (Exception exception8) {
            Exception exception9222;
            block45: {
                try {
                    log.severe("Unable to calculate spatial resolution: " + exception8.getMessage());
                    Object var20_22 = null;
                    if (resultSet == null) break block45;
                }
                catch (Throwable throwable) {
                    Exception exception10222;
                    Object var20_23 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception10222) {
                            log.warning(exception10222.getMessage());
                        }
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception10222) {
                            log.warning(exception10222.getMessage());
                        }
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (Exception exception9222) {
                    log.warning(exception9222.getMessage());
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception9222) {
                    log.warning(exception9222.getMessage());
                }
            }
        }
        this.sptResolution = null;
        this.lastRasterId = -1.0;
        this.lastRdtTable = null;
        return null;
    }

    public String getOriginalPyramidLevel() {
        return this.mRasterPyramid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] getCellCoordinate(double var1_1, double var3_2, double var5_3, String var7_4, int var8_5, int var9_6, Connection var10_7) {
        var11_8 = null;
        var12_9 = "null";
        if (var8_5 > 0) {
            var12_9 = String.valueOf(var8_5);
        }
        var13_10 = "SELECT sdo_geor.getCellCoordinate(grt." + this.mGeoRasterColumn + ",?,sdo_geometry(2001," + var12_9 + "," + "sdo_point_type(?,?,null), null,null)) coord " + "FROM " + this.mBaseTable + " grt WHERE grt." + this.mGeoRasterColumn + ".rasterid = ?";
        if (var7_4 != null) {
            var13_10 = var13_10 + " and grt." + this.mGeoRasterColumn + ".rasterdatatable = ?";
        }
        GeoRasterThemeDefinition.log.finest("getCellCoordinate query: " + var13_10);
        var14_11 = null;
        var15_12 = null;
        try {
            var14_11 = var10_7.prepareStatement(var13_10);
            var14_11.setInt(1, var9_6);
            var14_11.setDouble(2, var1_1);
            var14_11.setDouble(3, var3_2);
            var14_11.setDouble(4, var5_3);
            if (var7_4 != null) {
                var14_11.setString(5, var7_4.toUpperCase());
            }
            if ((var15_12 = var14_11.executeQuery()) == null || !var15_12.next()) ** GOTO lbl80
            var16_13 = var15_12.getArray(1);
            var11_8 = new int[2];
            var17_15 = (BigDecimal[])var16_13.getArray();
            var11_8[0] = var17_15[0].intValue();
            var11_8[1] = var17_15[1].intValue();
            GeoRasterThemeDefinition.log.finest("Row:" + var11_8[0] + " Column: " + var11_8[1]);
            var18_16 = var11_8;
            var20_17 = null;
            if (var15_12 == null) ** GOTO lbl72
            ** GOTO lbl67
        }
        catch (Exception var16_14) {
            GeoRasterThemeDefinition.log.log(Level.SEVERE, "Exception in getCellCoordinate.", var16_14);
            var20_19 = null;
            if (var15_12 != null) {
                try {
                    var15_12.close();
                }
                catch (Exception var21_23) {
                    GeoRasterThemeDefinition.log.warning(var21_23.getMessage());
                }
            }
            if (var14_11 == null) return null;
            try {
                var14_11.close();
                return null;
            }
            catch (Exception var21_23) {
                GeoRasterThemeDefinition.log.warning(var21_23.getMessage());
                return null;
            }
        }
        {
            block24: {
                block25: {
                    catch (Throwable var19_25) {
                        block23: {
                            var20_20 = null;
                            if (var15_12 != null) {
                                ** try [egrp 2[TRYBLOCK] [5 : 398->408)] { 
lbl55:
                                // 1 sources

                                var15_12.close();
                                break block23;
lbl57:
                                // 1 sources

                                catch (Exception var21_24) {
                                    GeoRasterThemeDefinition.log.warning(var21_24.getMessage());
                                }
                            }
                        }
                        if (var14_11 == null) throw var19_25;
                        ** try [egrp 3[TRYBLOCK] [6 : 426->436)] { 
lbl62:
                        // 1 sources

                        var14_11.close();
                        throw var19_25;
lbl64:
                        // 1 sources

                        catch (Exception var21_24) {
                            GeoRasterThemeDefinition.log.warning(var21_24.getMessage());
                        }
                        throw var19_25;
                    }
lbl67:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [5 : 398->408)] { 
lbl68:
                    // 1 sources

                    var15_12.close();
                    break block25;
lbl70:
                    // 1 sources

                    catch (Exception var21_21) {
                        GeoRasterThemeDefinition.log.warning(var21_21.getMessage());
                    }
                }
                if (var14_11 == null) return var18_16;
                try {}
                catch (Exception var21_21) {
                    GeoRasterThemeDefinition.log.warning(var21_21.getMessage());
                    return var18_16;
                }
                var14_11.close();
                return var18_16;
lbl80:
                // 1 sources

                var20_18 = null;
                if (var15_12 != null) {
                    ** try [egrp 2[TRYBLOCK] [5 : 398->408)] { 
lbl83:
                    // 1 sources

                    var15_12.close();
                    break block24;
lbl85:
                    // 1 sources

                    catch (Exception var21_22) {
                        GeoRasterThemeDefinition.log.warning(var21_22.getMessage());
                    }
                }
            }
            if (var14_11 == null) return null;
            try {}
            catch (Exception var21_22) {}
            GeoRasterThemeDefinition.log.warning(var21_22.getMessage());
            return null;
            var14_11.close();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double[] getModelCoordinate(int var1_1, int var2_2, double var3_3, String var5_4, int var6_5, Connection var7_6) {
        var8_7 = null;
        var9_8 = "SELECT sdo_geor.getModelCoordinate(grt." + this.mGeoRasterColumn + ",?,sdo_number_array(?,?)) coord " + "FROM " + this.mBaseTable + " grt WHERE grt." + this.mGeoRasterColumn + ".rasterid = ?";
        if (var5_4 != null) {
            var9_8 = var9_8 + " and grt." + this.mGeoRasterColumn + ".rasterdatatable = ?";
        }
        var10_9 = null;
        var11_10 = null;
        try {
            var10_9 = var7_6.prepareStatement(var9_8);
            var10_9.setInt(1, var6_5);
            var10_9.setInt(2, var1_1);
            var10_9.setInt(3, var2_2);
            var10_9.setDouble(4, var3_3);
            if (var5_4 != null) {
                var10_9.setString(5, var5_4.toUpperCase());
            }
            if ((var11_10 = var10_9.executeQuery()) == null || !var11_10.next()) ** GOTO lbl72
            var12_11 = JDBCUtil.loadGeometry(var11_10, 1, false);
            var8_7 = new double[2];
            var13_13 = var8_7 = var12_11.getPoint();
            var15_14 = null;
            if (var11_10 == null) ** GOTO lbl64
            ** GOTO lbl59
        }
        catch (Exception var12_12) {
            GeoRasterThemeDefinition.log.log(Level.WARNING, "Exception in getModelCoordinate.", var12_12);
            var15_16 = null;
            if (var11_10 != null) {
                try {
                    var11_10.close();
                }
                catch (Exception var16_20) {
                    GeoRasterThemeDefinition.log.warning(var16_20.getMessage());
                }
            }
            if (var10_9 == null) return null;
            try {
                var10_9.close();
                return null;
            }
            catch (Exception var16_20) {
                GeoRasterThemeDefinition.log.warning(var16_20.getMessage());
                return null;
            }
        }
        {
            block23: {
                block24: {
                    catch (Throwable var14_22) {
                        block22: {
                            var15_17 = null;
                            if (var11_10 != null) {
                                ** try [egrp 2[TRYBLOCK] [5 : 269->279)] { 
lbl47:
                                // 1 sources

                                var11_10.close();
                                break block22;
lbl49:
                                // 1 sources

                                catch (Exception var16_21) {
                                    GeoRasterThemeDefinition.log.warning(var16_21.getMessage());
                                }
                            }
                        }
                        if (var10_9 == null) throw var14_22;
                        ** try [egrp 3[TRYBLOCK] [6 : 297->307)] { 
lbl54:
                        // 1 sources

                        var10_9.close();
                        throw var14_22;
lbl56:
                        // 1 sources

                        catch (Exception var16_21) {
                            GeoRasterThemeDefinition.log.warning(var16_21.getMessage());
                        }
                        throw var14_22;
                    }
lbl59:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [5 : 269->279)] { 
lbl60:
                    // 1 sources

                    var11_10.close();
                    break block24;
lbl62:
                    // 1 sources

                    catch (Exception var16_18) {
                        GeoRasterThemeDefinition.log.warning(var16_18.getMessage());
                    }
                }
                if (var10_9 == null) return var13_13;
                try {}
                catch (Exception var16_18) {
                    GeoRasterThemeDefinition.log.warning(var16_18.getMessage());
                    return var13_13;
                }
                var10_9.close();
                return var13_13;
lbl72:
                // 1 sources

                var15_15 = null;
                if (var11_10 != null) {
                    ** try [egrp 2[TRYBLOCK] [5 : 269->279)] { 
lbl75:
                    // 1 sources

                    var11_10.close();
                    break block23;
lbl77:
                    // 1 sources

                    catch (Exception var16_19) {
                        GeoRasterThemeDefinition.log.warning(var16_19.getMessage());
                    }
                }
            }
            if (var10_9 == null) return null;
            try {}
            catch (Exception var16_19) {}
            GeoRasterThemeDefinition.log.warning(var16_19.getMessage());
            return null;
            var10_9.close();
            return null;
        }
    }

    public String getRasterId() {
        return this.mRasterId;
    }

    public String getRasterTable() {
        return this.mRasterTable;
    }

    public String getBaseTable() {
        return this.mBaseTable;
    }

    public String getGeoRasterColumn() {
        return this.mGeoRasterColumn;
    }

    public JSDOGeometry getPolygonMask() {
        return this.polygonMask;
    }

    public void setPolygonMask(double[] dArray, int n) {
        this.polygonMask = null;
        this.pmaskTable = null;
        this.pmaskGeomColumn = null;
        this.pmaskQCondition = null;
        this.pmaskJoinColumn = null;
        this.pmaskJoinGeorColumn = null;
        this.polygonMaskChanged();
        if (dArray == null) {
            return;
        }
        this.polygonMask = JSDOGeometry.recast(JSDOGeometry.createLinearPolygon((double[])dArray, (int)2, (int)n));
    }

    public void setPolygonMask(JSDOGeometry jSDOGeometry) {
        this.polygonMask = jSDOGeometry;
        this.pmaskTable = null;
        this.pmaskGeomColumn = null;
        this.pmaskQCondition = null;
        this.pmaskJoinColumn = null;
        this.pmaskJoinGeorColumn = null;
        this.polygonMaskChanged();
    }

    public String getXMLDefinition() {
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(stringBuffer);
        stringBuffer.append(this.getAttributes());
        stringBuffer.append(">\n");
        if (this.mSRule != null && this.mSRule.getFeatureCond() != null) {
            stringBuffer.append("  <rule" + PredGeomThemeDefinition.getRuleAttributes(this.mSRule) + ">\n");
            stringBuffer.append(PredGeomThemeDefinition.getRuleFeatures(this.mSRule));
            stringBuffer.append(PredGeomThemeDefinition.getRuleLabel(this.mSRule));
            stringBuffer.append("  </rule>\n");
        }
        stringBuffer.append("</styling_rules>");
        return stringBuffer.toString();
    }

    public String getAttributes() {
        String string = "";
        if (this.mSRule == null || this.mSRule != null && this.mSRule.getFeatureCond() == null) {
            if (this.mRasterId != null) {
                string = string + " raster_id=\"" + this.mRasterId + "\"";
            }
            if (this.mRasterTable != null) {
                string = string + " raster_table=\"" + this.mRasterTable + "\"";
            }
        }
        if (this.mRasterPyramid != null) {
            string = string + " raster_pyramid=\"" + this.mRasterPyramid + "\"";
        }
        if (this.mBands != null) {
            string = string + " raster_bands=\"" + this.mBands + "\"";
        }
        if (this.polygonMask != null) {
            string = string + " polygon_mask=\"" + this.polygonMask + "\"";
        }
        return string;
    }

    void getCommonAttributes(StringBuffer stringBuffer) {
        String string;
        String string2;
        String string3 = this.getThemeType();
        if (string3 != null && string3.trim().length() > 0) {
            stringBuffer.append(" theme_type=\"" + string3 + "\"");
        }
        if ((string2 = this.mKeyColumn) != null && string2.trim().length() > 0) {
            stringBuffer.append(" key_column=\"" + string2 + "\"");
        }
        if ((string = "normal") != null && string.trim().length() > 0) {
            stringBuffer.append(" caching=\"" + string + "\"");
        }
    }

    public void setImageProcess(String[] stringArray, Hashtable hashtable) {
        this.imageProcessNames = stringArray;
        this.imageProcess = hashtable;
    }

    public void setImageProcessNames(String[] stringArray) {
        this.imageProcessNames = stringArray;
    }

    public String[] getImageProcessNames() {
        return this.imageProcessNames;
    }

    public void setImageProcessParameters(Hashtable hashtable) {
        this.imageProcess = hashtable;
    }

    public Hashtable getImageProcessParameters() {
        return this.imageProcess;
    }

    public boolean addImageProcessOperation(String string) {
        if (string == null) {
            return false;
        }
        if (this.imageProcessNames == null) {
            this.imageProcessNames = new String[1];
            this.imageProcessNames[0] = string;
        } else {
            int n = this.imageProcessNames.length;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                vector.add(this.imageProcessNames[i]);
            }
            if (vector.contains(string)) {
                return true;
            }
            vector.add(string);
            this.imageProcessNames = vector.toArray(new String[vector.size()]);
        }
        return true;
    }

    public boolean addImageProcessParameter(String string, String string2, String string3) {
        Hashtable<String, String> hashtable;
        if (string == null || string2 == null || string3 == null) {
            return false;
        }
        if (this.imageProcess == null) {
            this.imageProcess = new Hashtable();
        }
        if ((hashtable = (Hashtable<String, String>)this.imageProcess.get(string)) == null) {
            hashtable = new Hashtable<String, String>();
            this.imageProcess.put(string, string2);
        }
        hashtable.put(string2, string3);
        this.addImageProcessOperation(string);
        return true;
    }

    public Hashtable getImageProcessParameters(String string) {
        if (string == null) {
            return null;
        }
        if (this.imageProcess != null) {
            return (Hashtable)this.imageProcess.get(string);
        }
        return null;
    }

    public void deleteAllImageProcessOperations() {
        this.imageProcessNames = null;
        this.imageProcess = null;
    }

    public boolean removeImageProcessOperation(String string) {
        if (string == null) {
            return false;
        }
        if (this.imageProcess != null) {
            this.imageProcess.remove(string);
            if (this.imageProcess.size() == 0) {
                this.imageProcess = null;
            }
        }
        if (this.imageProcessNames != null) {
            int n = this.imageProcessNames.length;
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                vector.add(this.imageProcessNames[i]);
            }
            if (!vector.contains(string)) {
                return true;
            }
            vector.remove(string);
            this.imageProcessNames = vector.size() > 0 ? vector.toArray(new String[vector.size()]) : null;
        }
        return true;
    }

    public StylingRule getStylingRule() {
        return this.mSRule;
    }

    public void setStylingRule(StylingRule stylingRule) {
        this.mSRule = stylingRule;
    }

    public Hashtable getBitmapMasks() {
        return this.bitmapMasks;
    }

    public void setBitmapMasks(GeoRasterBitmapMask[] geoRasterBitmapMaskArray) {
        if (geoRasterBitmapMaskArray == null || geoRasterBitmapMaskArray.length == 0) {
            this.bitmapMasks = null;
            return;
        }
        this.bitmapMasks = new Hashtable();
        for (int i = 0; i < geoRasterBitmapMaskArray.length; ++i) {
            int n = geoRasterBitmapMaskArray[i].getRasterId();
            String string = geoRasterBitmapMaskArray[i].getRasterDataTableName();
            this.bitmapMasks.put("" + n + ":" + string.toUpperCase(), geoRasterBitmapMaskArray[i]);
        }
    }

    public GeoRasterBitmapMask getBitmapMask(String string) {
        if (this.bitmapMasks == null || string == null) {
            return null;
        }
        return (GeoRasterBitmapMask)this.bitmapMasks.get(string.toUpperCase());
    }

    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.getBaseTable());
        basicThemeInfo.setType("GEORASTER");
        basicThemeInfo.setKeyColumn(this.mKeyColumn);
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(this.getGeoRasterColumn());
        return basicThemeInfo;
    }

    public String[] getRenderingStyles() {
        return null;
    }

    public String[] getLabelingStyles() {
        return null;
    }

    public boolean isNODATATransparent() {
        return this.transpNoData;
    }

    public void setNODATATransparent(boolean bl) {
        this.transpNoData = bl;
    }

    public int getAlphaBand() {
        return this.alphaBand;
    }

    public void setAlphaBand(int n) {
        this.alphaBand = n < 0 ? -1 : n;
    }

    public void setPolygonMaskFromTable(String string, String string2, String string3, String string4, String string5) {
        if (string == null || string2 == null) {
            return;
        }
        this.pmaskTable = string;
        this.pmaskGeomColumn = string2;
        this.pmaskQCondition = string3;
        if (string3 != null && string3.trim().length() == 0) {
            this.pmaskQCondition = null;
        }
        this.pmaskJoinColumn = string4;
        this.pmaskJoinGeorColumn = string5;
        if (string4 == null || string5 == null) {
            this.pmaskJoinColumn = null;
            this.pmaskJoinGeorColumn = null;
        }
        this.polygonMask = null;
        this.polygonMaskChanged();
    }

    private void polygonMaskChanged() {
        if (this.mRasterId != null) {
            this.query = "select grt." + this.mGeoRasterColumn;
            if (this.pmaskJoinGeorColumn != null) {
                this.query = this.query + ", grt." + this.pmaskJoinGeorColumn;
            }
            this.query = this.query + " from " + this.mBaseTable + " grt where grt." + this.mGeoRasterColumn + ".rasterid = ?";
            if (this.mRasterTable != null) {
                this.query = this.query + " and grt." + this.mGeoRasterColumn + ".rasterdatatable = ?";
            }
        }
    }

    public String getPolygonMaskTable() {
        return this.pmaskTable;
    }

    public String getPolygonMaskGeometryColumn() {
        return this.pmaskGeomColumn;
    }

    public String getPolygonmaskQueryCondition() {
        return this.pmaskQCondition;
    }

    public String getPolygonMaskGeometryJoinColumn() {
        return this.pmaskJoinColumn;
    }

    public String getPolygonMaskGeoRasterJoinColumn() {
        return this.pmaskJoinGeorColumn;
    }

    public boolean hasPolygonMaskJoinColumns() {
        return this.pmaskJoinColumn != null && this.pmaskJoinGeorColumn != null;
    }
}

