/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import oracle.sdovis.SRS;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;

public class ImageThemeDefinition
extends ThemeDefinition {
    String format = "GIF";
    String query = null;
    int width;
    int height;
    boolean preserveScale = true;
    boolean passThrough = true;
    String imageColumn = null;
    String mbrColumn = null;
    boolean predefined = false;
    String mBaseTable = null;
    String mKeyColumn = null;
    StylingRule mSRule = null;
    protected String cacheGroupName = null;
    String cacheSubRegionName = null;
    String unit = null;
    double resolution = -1.0;
    float alpha = 1.0f;

    public ImageThemeDefinition() {
        this.predefined = false;
    }

    public ImageThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, StylingRule[] stylingRuleArray, int n) {
        try {
            this.predefined = true;
            this.name = string;
            this.dataSource = string2;
            DBDataSource dBDataSource = (DBDataSource)DSManager.get(string2);
            this.is9i = dBDataSource.is9i();
            this.mBaseTable = string3;
            this.mKeyColumn = string5;
            this.mbrColumn = string4;
            this.imageColumn = string6;
            this.format = string7;
            this.srid = n;
            this.mSRule = stylingRuleArray[0];
            this.cacheGroupName = string3 + "_" + string6.toUpperCase() + "_PDT_IMG";
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public void setImageQuery(String string) {
        this.query = string;
    }

    public String getImageQuery() {
        return this.query;
    }

    public void setImageFormat(String string) {
        this.format = string;
    }

    public String getImageFormat() {
        return this.format;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public String getBaseTableName() {
        return this.mBaseTable;
    }

    public void setBaseTableName(String string) {
        this.mBaseTable = string;
    }

    public String getImageColumnName() {
        return this.imageColumn;
    }

    public void setImageColumn(String string) {
        this.imageColumn = string;
    }

    public String getMBRColumn() {
        return this.mbrColumn;
    }

    public void setMBRColumn(String string) {
        this.mbrColumn = string;
    }

    public boolean getASIS() {
        return this.passThrough;
    }

    public void setASIS(boolean bl) {
        this.passThrough = bl;
    }

    public void setImageResolution(String string, double d) {
        if (string == null || SRS.distUnitList.get(string.toUpperCase()) == null) {
            throw new IllegalArgumentException("Invalid image resolution unit given.");
        }
        this.unit = string.toUpperCase();
        this.resolution = d;
    }

    public double getImageResolution() {
        return this.resolution;
    }

    public String getImageResolutionUnit() {
        return this.unit;
    }

    public void setImageResolutionUnit(String string) {
        this.unit = string;
    }

    public String getKeyColumn() {
        return this.mKeyColumn;
    }

    public void setKeyColumn(String string) {
        this.mKeyColumn = string;
    }

    public void setPredefined(boolean bl) {
        this.predefined = bl;
    }

    public boolean getPredefined() {
        return this.predefined;
    }

    public String getThemeType() {
        return "IMAGE";
    }

    public String getXMLDefinition() {
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(stringBuffer);
        stringBuffer.append(this.getAttributes());
        stringBuffer.append(">\n");
        if (this.mSRule != null) {
            stringBuffer.append("  <rule" + PredGeomThemeDefinition.getRuleAttributes(this.mSRule) + ">\n");
            stringBuffer.append(PredGeomThemeDefinition.getRuleFeatures(this.mSRule));
            stringBuffer.append(PredGeomThemeDefinition.getRuleLabel(this.mSRule));
            stringBuffer.append("  </rule>\n");
        }
        stringBuffer.append("</styling_rules>");
        return stringBuffer.toString();
    }

    void getCommonAttributes(StringBuffer stringBuffer) {
        String string;
        String string2;
        String string3 = this.getThemeType();
        if (string3 != null && string3.trim().length() > 0) {
            stringBuffer.append(" theme_type=\"" + string3 + "\"");
        }
        if ((string2 = this.mKeyColumn) != null && string2.trim().length() > 0) {
            stringBuffer.append(" key_column=\"" + string2 + "\"");
        }
        if ((string = "normal") != null && string.trim().length() > 0) {
            stringBuffer.append(" caching=\"" + string + "\"");
        }
    }

    public String getAttributes() {
        String string = "";
        if (this.imageColumn != null) {
            string = string + " image_column=\"" + this.imageColumn + "\"";
        }
        if (this.format != null) {
            string = string + " image_format=\"" + this.format + "\"";
        }
        if (this.unit != null) {
            string = string + " image_unit=\"" + this.unit + "\"";
        }
        if (this.resolution != -1.0) {
            string = string + " image_resolution=\"" + this.resolution + "\"";
        }
        if ((double)this.alpha != 1.0) {
            string = string + " image_alpha=\"" + this.alpha + "\"";
        }
        return string;
    }

    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.getBaseTableName());
        basicThemeInfo.setType("IMAGE");
        basicThemeInfo.setKeyColumn(this.getKeyColumn());
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(this.getImageColumnName());
        return basicThemeInfo;
    }

    public String[] getRenderingStyles() {
        return null;
    }

    public String[] getLabelingStyles() {
        return null;
    }
}

