/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.util.LogFactory;
import oracle.ord.im.OrdImage;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.Unpickle81;
import oracle.sdovis.VisContext;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.query.SDOBoxFilter;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.Util;
import oracle.sql.BFILE;
import oracle.sql.BLOB;

public class ImageThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected Theme owner;
    private ImageThemeDefinition def;
    private byte[][] images;
    private double[][] mbrs;
    private PreparedStatement pstmt = null;
    private String currentKey = null;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageThemeProducer(Theme theme) {
        this.owner = theme;
        this.def = (ImageThemeDefinition)theme.getDefinition();
        if (!this.def.predefined) return;
        Connection connection = null;
        connection = DSUtil.getDBConnection(this.def.getDataSourceName(), null);
        this.def.cacheSubRegionName = CacheMgr2.getSubRegionName(connection);
        CacheMgr2.createImageGroup(this.def.cacheSubRegionName, this.def.cacheGroupName);
        this.def.query = this.defineQuery(false);
        Object var5_3 = null;
        if (connection == null) return;
        try {
            DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
            return;
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
        return;
        {
            catch (Exception exception) {
                log.severe(exception.getMessage());
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (connection == null) throw throwable;
            try {
                DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                throw throwable;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            throw throwable;
        }
    }

    public Theme getTheme() {
        return this.owner;
    }

    public int size() {
        return this.images == null ? 0 : this.images.length;
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int prepareData(Rectangle2D var1_1, VisContext var2_2) throws DataException {
        block66: {
            block64: {
                block63: {
                    block60: {
                        block61: {
                            var3_3 = 0;
                            var4_4 = var1_1.getMinX();
                            var6_5 = var1_1.getMinY();
                            var8_6 = var1_1.getMaxX();
                            var10_7 = var1_1.getMaxY();
                            var12_8 = false;
                            if (var4_4 == -Infinity || var6_5 == -Infinity || var8_6 == Infinity || var10_7 == Infinity) {
                                var12_8 = true;
                            }
                            var13_9 = null;
                            try {
                                var13_9 = DSUtil.getDBConnection(this.def.getDataSourceName(), var2_2);
                            }
                            catch (Exception var14_10) {
                                throw new DataException("cannot obtain a connection to database.");
                            }
                            var14_11 = var4_4;
                            var16_12 = var8_6;
                            var18_13 = var6_5;
                            var20_14 = var10_7;
                            var22_15 = var2_2.getCurrentScale();
                            if (var2_2.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != var2_2.getMasterSRID() && var22_15 != Infinity && var22_15 != -Infinity) {
                                var24_16 /* !! */  = new double[]{var4_4, var6_5, var8_6, var10_7};
                                var25_20 = Util.convertMBR(var24_16 /* !! */ , var2_2.getMasterSRID(), this.def.getSrid(), var13_9);
                                if (var25_20 != null) {
                                    var4_4 = (double)var25_20[0];
                                    var6_5 = (double)var25_20[1];
                                    var8_6 = (double)var25_20[2];
                                    var10_7 = (double)var25_20[3];
                                } else {
                                    ImageThemeProducer.log.severe("Conversion of SRIDs returned null.");
                                    return 0;
                                }
                            }
                            if (var22_15 != Infinity && var22_15 != -Infinity) {
                                var24_17 = Math.abs(var10_7 - var6_5) / Math.abs(var20_14 - var18_13);
                                ImageThemeProducer.log.finer("[Master scale] " + var22_15 + " [Scale factor for theme " + this.getTheme().getName() + "] " + var24_17);
                                var26_21 = var22_15 * var24_17;
                                if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                                    var28_23 = DSManager.getSRSCache(this.def.getDataSourceName());
                                    var29_25 = var28_23.get(this.def.getSrid());
                                    if (var2_2.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != var2_2.getMasterSRID() && var2_2.isTileRequest()) {
                                        var29_25 = var28_23.get(var2_2.getMasterSRID());
                                        var30_26 = (var14_11 + var16_12) / 2.0;
                                        var32_27 = (var18_13 + var20_14) / 2.0;
                                        var24_17 = 1.0;
                                    } else {
                                        var30_26 = (var4_4 + var8_6) / 2.0;
                                        var32_27 = (var6_5 + var10_7) / 2.0;
                                    }
                                    if (var2_2.isTileRequest() && var29_25.isGeodetic()) {
                                        var30_26 = 0.0;
                                        var32_27 = 0.0;
                                    }
                                    if (var29_25 != null) {
                                        var26_21 = var29_25.getRatioScale(var22_15 * var24_17, new Point2D.Double(var30_26, var32_27));
                                        ImageThemeProducer.log.finer("Ratio scale to compare: " + var26_21);
                                    } else {
                                        ImageThemeProducer.log.severe("Theme must have SRS when using ratio scale mode.");
                                        try {
                                            if (var13_9 != null) {
                                                DSUtil.closeDBConnection(var13_9, this.def.getDataSourceName());
                                            }
                                        }
                                        catch (Exception var34_28) {
                                            ImageThemeProducer.log.warning(var34_28.getMessage());
                                        }
                                        return 0;
                                    }
                                }
                                if (!this.getTheme().getDecorator().withinScaleLimits(var26_21)) {
                                    ImageThemeProducer.log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                                    try {
                                        if (var13_9 != null) {
                                            DSUtil.closeDBConnection(var13_9, this.def.getDataSourceName());
                                        }
                                    }
                                    catch (Exception var28_24) {
                                        ImageThemeProducer.log.warning(var28_24.getMessage());
                                    }
                                    return 0;
                                }
                            }
                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                try {
                                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                        if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                            Util.gotoWorkspaceDate(var13_9, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                                        } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                            Util.gotoWorkspaceSavedPoint(var13_9, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                                        } else {
                                            Util.gotoWorkspace(var13_9, this.getTheme().getDecorator().getWorkspaceName());
                                        }
                                    }
                                }
                                catch (Exception var24_18) {
                                    var25_20 = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                                    if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                        var25_20 = (String)var25_20 + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                                    } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                        var25_20 = (String)var25_20 + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                                    }
                                    ImageThemeProducer.log.log(Level.SEVERE, (String)var25_20, var24_18);
                                    return 0;
                                }
                            }
                            if (!this.def.passThrough) {
                                if (MapMaker.isSpecial(var4_4, var6_5, var8_6, var10_7) && var2_2.getRotation() != 0.0) {
                                    ImageThemeProducer.log.warning("Rotation is currently ignored for full extent.");
                                } else if (var2_2.getRotation() != 0.0 && !MapMaker.isSpecial(var4_4, var6_5, var8_6, var10_7)) {
                                    if (var2_2.getRotation() < -360.0 && var2_2.getRotation() > 360.0) {
                                        ImageThemeProducer.log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                                    } else {
                                        var24_16 /* !! */  = Util.rotateMBR(var4_4, var6_5, var8_6, var10_7, var2_2.getRotation());
                                        if (var24_16 /* !! */  != null) {
                                            var4_4 = Math.min(var24_16 /* !! */ [0], var4_4);
                                            var6_5 = Math.min(var24_16 /* !! */ [1], var6_5);
                                            var8_6 = Math.max(var24_16 /* !! */ [2], var8_6);
                                            var10_7 = Math.max(var24_16 /* !! */ [3], var10_7);
                                            ImageThemeProducer.log.finest("Rotation angle: " + var2_2.getRotation());
                                            ImageThemeProducer.log.finest("Search window for rotation: " + var4_4 + "," + var6_5 + "," + var8_6 + "," + var10_7);
                                        } else {
                                            ImageThemeProducer.log.info("Rotated MBR is null. Rotation ignored.");
                                        }
                                    }
                                }
                            }
                            if (this.def.predefined) ** GOTO lbl143
                            var24_16 /* !! */  = (double[])new Rectangle2D.Double(var4_4, var6_5, 0.0, 0.0);
                            var24_16 /* !! */ .add(var8_6, var10_7);
                            var25_20 = this.rewriteQuery((Rectangle2D)var24_16 /* !! */ , var12_8);
                            if (Util.isQueryAllowed((String)var25_20)) break block60;
                            ImageThemeProducer.log.severe("Invalid query!");
                            var26_22 = 0;
                            var36_29 = null;
                            if (this.getTheme().getDecorator().getWorkspaceName() == null) break block61;
                            try {
                                Util.gotoWorkspace(var13_9, "LIVE");
                            }
                            catch (Exception var37_33) {
                                ImageThemeProducer.log.warning(var37_33.getMessage());
                            }
                        }
                        if (var13_9 != null) {
                            try {
                                DSUtil.closeDBConnection(var13_9, this.def.getDataSourceName());
                            }
                            catch (Exception var37_33) {
                                ImageThemeProducer.log.warning(var37_33.getMessage());
                            }
                        }
                        return var26_22;
                    }
                    ImageThemeProducer.log.info("[ImageTheme] query:  " + (String)var25_20);
                    var3_3 = this.loadImagesFromDB((String)var25_20, var4_4, var6_5, var8_6, var10_7, var13_9, var2_2);
                    break block63;
lbl143:
                    // 1 sources

                    this.def.query = this.defineQuery(var12_8);
                    var3_3 = this.loadImagesFromDBCached(var4_4, var6_5, var8_6, var10_7, var13_9, var2_2, var12_8);
                }
                var36_30 = null;
                if (this.getTheme().getDecorator().getWorkspaceName() == null) break block64;
                try {
                    Util.gotoWorkspace(var13_9, "LIVE");
                }
                catch (Exception var37_34) {
                    ImageThemeProducer.log.warning(var37_34.getMessage());
                }
            }
            if (var13_9 != null) {
                try {
                    DSUtil.closeDBConnection(var13_9, this.def.getDataSourceName());
                }
                catch (Exception var37_34) {
                    ImageThemeProducer.log.warning(var37_34.getMessage());
                }
            }
            break block66;
            {
                catch (Exception var24_19) {
                    ImageThemeProducer.log.severe(var24_19.getMessage());
                    var3_3 = 0;
                    var36_31 = null;
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(var13_9, "LIVE");
                        }
                        catch (Exception var37_35) {
                            ImageThemeProducer.log.warning(var37_35.getMessage());
                        }
                    }
                    if (var13_9 != null) {
                        try {
                            DSUtil.closeDBConnection(var13_9, this.def.getDataSourceName());
                        }
                        catch (Exception var37_35) {
                            ImageThemeProducer.log.warning(var37_35.getMessage());
                        }
                    }
                }
            }
            catch (Throwable var35_37) {
                var36_32 = null;
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(var13_9, "LIVE");
                    }
                    catch (Exception var37_36) {
                        ImageThemeProducer.log.warning(var37_36.getMessage());
                    }
                }
                if (var13_9 != null) {
                    try {
                        DSUtil.closeDBConnection(var13_9, this.def.getDataSourceName());
                    }
                    catch (Exception var37_36) {
                        ImageThemeProducer.log.warning(var37_36.getMessage());
                    }
                }
                throw var35_37;
            }
        }
        return var3_3;
    }

    public void postPreparation(VisContext visContext) {
    }

    public StyledFeatureI getStyledFeature(int n) {
        return null;
    }

    public double[] getDataMBR() {
        if (this.mbrs == null || this.mbrs.length == 0) {
            return null;
        }
        RectangularShape rectangularShape = null;
        for (int i = 0; i < this.mbrs.length; ++i) {
            double[] dArray = this.mbrs[i];
            if (rectangularShape == null) {
                rectangularShape = new Rectangle2D.Double(dArray[0], dArray[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)rectangularShape).add(dArray[0], dArray[1]);
            }
            ((Rectangle2D)rectangularShape).add(dArray[2], dArray[3]);
        }
        double[] dArray = new double[]{rectangularShape.getMinX(), rectangularShape.getMinY(), rectangularShape.getMaxX(), rectangularShape.getMaxY()};
        return dArray;
    }

    public StyledFeatureI[] getStyledFeatures() {
        return null;
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        return null;
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        return null;
    }

    public byte[][] getImages() {
        return this.images;
    }

    public void setImages(byte[][] byArray) {
        this.images = byArray;
    }

    public double[][] getMBRs() {
        return this.mbrs;
    }

    public void setImageMBRs(double[][] dArray) {
        this.mbrs = dArray;
    }

    public void destroy() {
        int n;
        if (this.images != null) {
            for (n = 0; n < this.images.length; ++n) {
                this.images[n] = null;
            }
        }
        if (this.mbrs != null) {
            for (n = 0; n < this.mbrs.length; ++n) {
                this.mbrs[n] = null;
            }
        }
        this.images = null;
        this.mbrs = null;
        try {
            if (this.def.predefined && this.pstmt != null) {
                this.pstmt.close();
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
    }

    public void abort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int loadImagesFromDB(String string, double d, double d2, double d3, double d4, Connection connection, VisContext visContext) throws SQLException, IOException {
        Exception exception522;
        int n;
        Vector<double[]> vector;
        Vector<byte[]> vector2;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block50: {
            String string2;
            block46: {
                Exception exception2222;
                int n2;
                block47: {
                    preparedStatement = null;
                    resultSet = null;
                    vector2 = new Vector<byte[]>(3);
                    vector = new Vector<double[]>(3);
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setFetchSize(this.owner.getFetchSize());
                    log.finer("Fetch size: " + preparedStatement.getFetchSize());
                    resultSet = preparedStatement.executeQuery();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    string2 = resultSetMetaData.getColumnTypeName(1);
                    if (string2.toUpperCase().indexOf("BLOB") >= 0 || string2.toUpperCase().indexOf("ORDIMAGE") >= 0) break block46;
                    log.severe(RSBundle.getMsg("MAPVIEWER-01042"));
                    n2 = 0;
                    Object var28_19 = null;
                    if (resultSet == null) break block47;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                return n2;
            }
            while (resultSet.next()) {
                Object[] objectArray;
                BLOB bLOB = null;
                OrdImage ordImage = null;
                if (string2.toUpperCase().indexOf("ORDIMAGE") > -1) {
                    ordImage = (OrdImage)((OracleResultSet)resultSet).getCustomDatum(1, OrdImage.getFactory());
                    if (ordImage == null) {
                        log.finest("Image column is null for current row.");
                        continue;
                    }
                } else {
                    bLOB = JDBCUtil.safeCastBLOB(((OracleResultSet)resultSet).getBlob(1));
                    if (bLOB == null) {
                        log.finest("Image column is null for current row.");
                        continue;
                    }
                }
                JSDOGeometry jSDOGeometry = null;
                if (this.getTheme().getDecorator().isFastUnpickle()) {
                    objectArray = ((OracleResultSet)resultSet).getBytes(2);
                    try {
                        jSDOGeometry = Unpickle81.unpickle(objectArray);
                    }
                    catch (Exception exception3) {
                        log.severe(exception3.getMessage());
                    }
                } else {
                    try {
                        jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 2, false);
                    }
                    catch (Exception exception4) {
                        log.log(Level.WARNING, "cannot load geometry due to exception.", exception4);
                    }
                }
                if (jSDOGeometry == null) {
                    log.finest("Null MBR geometry for current row.");
                    continue;
                }
                if (string2.toUpperCase().indexOf("ORDIMAGE") > -1) {
                    objectArray = null;
                    if (!ordImage.isLocal()) {
                        BFILE bFILE = ordImage.getBFILE();
                        long l = bFILE.length();
                        bFILE.open();
                        InputStream inputStream = bFILE.getBinaryStream();
                        objectArray = new byte[(int)l];
                        int n3 = inputStream.read((byte[])objectArray);
                        bFILE.close();
                    } else {
                        objectArray = ordImage.getDataInByteArray();
                    }
                    vector2.add((byte[])objectArray);
                } else {
                    vector2.add(ImageThemeProducer.readBLOB(bLOB));
                    bLOB = null;
                }
                if (visContext.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != visContext.getMasterSRID()) {
                    objectArray = Util.convertMBR(jSDOGeometry.getMBR(), this.def.getSrid(), visContext.getMasterSRID(), connection);
                    vector.add((double[])objectArray);
                    continue;
                }
                vector.add(jSDOGeometry.getMBR());
            }
            this.images = new byte[vector2.size()][];
            this.mbrs = new double[vector.size()][];
            for (n = 0; n < this.images.length; ++n) {
                this.images[n] = (byte[])vector2.get(n);
                this.mbrs[n] = (double[])vector.get(n);
            }
            vector2.clear();
            vector2 = null;
            vector.clear();
            vector = null;
            log.finest("# images loaded: " + this.images.length);
            n = this.images.length;
            Object var28_20 = null;
            if (resultSet == null) break block50;
            try {
                resultSet.close();
            }
            catch (Exception exception522) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception522) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
            }
            catch (Exception exception522) {
                // empty catch block
            }
        }
        return n;
        catch (Exception exception6) {
            Exception exception7222;
            int n4;
            block53: {
                try {
                    log.severe(exception6.getMessage());
                    vector2.clear();
                    vector2 = null;
                    vector.clear();
                    vector = null;
                    n4 = 0;
                    Object var28_21 = null;
                    if (resultSet == null) break block53;
                }
                catch (Throwable throwable) {
                    block56: {
                        Exception exception8222;
                        Object var28_22 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Exception exception8222) {
                                // empty catch block
                            }
                        }
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Exception exception8222) {
                                // empty catch block
                            }
                        }
                        if (connection == null) break block56;
                        try {
                            DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                        }
                        catch (Exception exception8222) {}
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (Exception exception7222) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception7222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                }
                catch (Exception exception7222) {
                    // empty catch block
                }
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int loadImagesFromDBCached(double d, double d2, double d3, double d4, Connection connection, VisContext visContext, boolean bl) throws SQLException, IOException {
        Exception exception5;
        int n;
        Statement statement;
        block35: {
            statement = null;
            ResultSet resultSet = null;
            Vector<byte[]> vector = new Vector<byte[]>(3);
            Vector<double[]> vector2 = new Vector<double[]>(3);
            try {
                this.pstmt = this.prepareImageFetchStmt(connection);
                log.finest("[ImageTheme p] query=" + this.def.getImageQuery());
                statement = connection.prepareStatement(this.def.getImageQuery());
                boolean bl2 = this.def.passThrough;
                if (this.def.mSRule != null) {
                    bl2 = this.def.mSRule.isQueryPassThrough();
                }
                if (!bl2 && !bl) {
                    statement.setDouble(1, d);
                    statement.setDouble(2, d2);
                    statement.setDouble(3, d3);
                    statement.setDouble(4, d4);
                }
                this.pstmt.setFetchSize(this.owner.getFetchSize());
                statement.setFetchSize(this.owner.getFetchSize());
                log.finer("Fetch size: " + statement.getFetchSize());
                resultSet = statement.executeQuery();
                CacheMgr2.createImageGroup(this.def.cacheSubRegionName, this.def.cacheGroupName);
                CacheGroup cacheGroup = CacheMgr2.getGroup(this.def.cacheSubRegionName, this.def.cacheGroupName);
                while (resultSet.next()) {
                    Object[] objectArray;
                    byte[] byArray;
                    this.currentKey = resultSet.getString(1);
                    if (this.currentKey == null || this.currentKey.length() == 0) {
                        log.finest("Key column value is empty for current row");
                        continue;
                    }
                    byte[] byArray2 = byArray = cacheGroup != null ? (byte[])cacheGroup.get(this.currentKey) : null;
                    if (byArray == null && (byArray = this.loadImageBlock(this.currentKey)) != null && cacheGroup != null) {
                        cacheGroup.put(this.currentKey, byArray, byArray.length);
                    }
                    if (byArray == null) {
                        log.warning("cannot load image for key: " + this.currentKey);
                        continue;
                    }
                    JSDOGeometry jSDOGeometry = null;
                    if (this.getTheme().getDecorator().isFastUnpickle()) {
                        objectArray = ((OracleResultSet)resultSet).getBytes(2);
                        try {
                            jSDOGeometry = Unpickle81.unpickle(objectArray);
                        }
                        catch (Exception exception2) {
                            log.severe(exception2.getMessage());
                        }
                    } else {
                        try {
                            jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 2, false);
                        }
                        catch (Exception exception3) {
                            log.severe(exception3.getMessage());
                        }
                    }
                    if (jSDOGeometry == null) {
                        log.warning("null geometry in the current image row.");
                        continue;
                    }
                    vector.add(byArray);
                    if (visContext.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != visContext.getMasterSRID()) {
                        objectArray = Util.convertMBR(jSDOGeometry.getMBR(), this.def.getSrid(), visContext.getMasterSRID(), connection);
                        vector2.add((double[])objectArray);
                        continue;
                    }
                    vector2.add(jSDOGeometry.getMBR());
                }
                this.images = new byte[vector.size()][];
                this.mbrs = new double[vector2.size()][];
                for (n = 0; n < this.images.length; ++n) {
                    this.images[n] = (byte[])vector.get(n);
                    this.mbrs[n] = (double[])vector2.get(n);
                }
                vector.clear();
                vector = null;
                vector2.clear();
                vector2 = null;
                log.finest("# images loaded: " + this.images.length);
                n = this.images.length;
                Object var23_20 = null;
                if (resultSet == null) break block35;
            }
            catch (Throwable throwable) {
                block39: {
                    Exception exception42;
                    Object var23_21 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception42) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception42) {
                            // empty catch block
                        }
                    }
                    if (this.pstmt != null) {
                        try {
                            this.pstmt.close();
                        }
                        catch (Exception exception42) {
                            // empty catch block
                        }
                    }
                    if (connection == null) break block39;
                    try {
                        DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                    }
                    catch (Exception exception42) {}
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (Exception exception5) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception5) {
                // empty catch block
            }
        }
        if (this.pstmt != null) {
            try {
                this.pstmt.close();
            }
            catch (Exception exception5) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
            }
            catch (Exception exception5) {
                // empty catch block
            }
        }
        return n;
    }

    public static byte[] readBLOB(BLOB bLOB) throws SQLException, IOException {
        if (bLOB == null) {
            return null;
        }
        long l = bLOB.length();
        return bLOB.getBytes(1L, (int)l);
    }

    protected String rewriteQuery(Rectangle2D rectangle2D, boolean bl) {
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        if (this.def.passThrough || bl) {
            return this.def.query;
        }
        String string = this.getFilter(this.def.imageColumn, this.def.mbrColumn, this.def.getSrid(), d, d2, d3, d4, this.def.is9i());
        return "SELECT * FROM ( " + this.def.query + " ) WHERE " + string;
    }

    final String getFilter(String string, String string2, int n, double d, double d2, double d3, double d4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(256);
        boolean bl2 = Util.isGeodetic(n);
        if (bl && bl2) {
            stringBuffer.append("MDSYS.SDO_FILTER(" + string2 + ", ");
            stringBuffer.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            stringBuffer.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + "))" + ", " + n + " ), " + "'querytype=WINDOW') = 'TRUE'");
            return stringBuffer.toString();
        }
        stringBuffer.append("MDSYS.SDO_FILTER(" + string2 + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + ")), " + "'querytype=WINDOW') = 'TRUE'");
        return stringBuffer.toString();
    }

    private String defineQuery(boolean bl) {
        String string = SDOBoxFilter.getGenericFilterPredicate(this.def.mbrColumn, this.def.srid, this.def.is9i, null);
        String string2 = "SELECT " + this.def.mKeyColumn + ", " + this.def.mbrColumn + " " + " FROM " + this.def.mBaseTable;
        String string3 = this.def.mSRule != null ? this.def.mSRule.getFeatureCond() : null;
        boolean bl2 = this.def.passThrough;
        if (this.def.mSRule != null) {
            bl2 = this.def.mSRule.isQueryPassThrough();
        }
        if (string != null && !bl2 && !bl) {
            string2 = string2 + " WHERE " + string;
            if (string3 != null) {
                string2 = string2 + " AND " + string3;
            }
        } else if (string3 != null) {
            string2 = string2 + " WHERE " + string3;
        }
        return string2;
    }

    public PreparedStatement prepareImageFetchStmt(Connection connection) throws SQLException {
        return connection.prepareStatement("select " + this.def.imageColumn + " FROM " + this.def.mBaseTable + " WHERE " + this.def.mKeyColumn + "=?");
    }

    public PreparedStatement getImageFetchStmt() {
        return this.pstmt;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    private byte[] loadImageBlock(String string) {
        OracleResultSet oracleResultSet = null;
        try {
            PreparedStatement preparedStatement = this.getImageFetchStmt();
            preparedStatement.setString(1, string);
            oracleResultSet = (OracleResultSet)preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = oracleResultSet.getMetaData();
            String string2 = resultSetMetaData.getColumnTypeName(1);
            if (oracleResultSet.next()) {
                if (string2.toUpperCase().indexOf("ORDIMAGE") > -1) {
                    OrdImage ordImage = (OrdImage)oracleResultSet.getCustomDatum(1, OrdImage.getFactory());
                    if (ordImage == null) {
                        return null;
                    }
                    byte[] byArray = null;
                    if (!ordImage.isLocal()) {
                        BFILE bFILE = ordImage.getBFILE();
                        long l = bFILE.length();
                        bFILE.open();
                        InputStream inputStream = bFILE.getBinaryStream();
                        byArray = new byte[(int)l];
                        int n = inputStream.read(byArray);
                        bFILE.close();
                    } else {
                        byArray = ordImage.getDataInByteArray();
                    }
                    return byArray;
                }
                BLOB bLOB = JDBCUtil.safeCastBLOB(oracleResultSet.getBlob(1));
                return ImageThemeProducer.readBLOB(bLOB);
            }
            return null;
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        return null;
    }
}

