/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.lbs.mapclient.MapViewer;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapCacheTheme;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.theme.ThemeDataProducer;

public class MapCacheThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    MapCacheTheme theme = null;
    Image themeImage = null;
    Rectangle2D window = null;
    Rectangle2D resultWindow = null;
    int mapWidth = 0;
    int mapHeight = 0;
    int responseSrid = 0;

    public MapCacheThemeProducer(MapCacheTheme mapCacheTheme) {
        this.theme = mapCacheTheme;
    }

    public Image getThemeImage() {
        return this.themeImage;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public int size() {
        return this.themeImage == null ? 0 : 1;
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
    }

    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        if (!this.sridsAreSame(this.theme.getSRID(), visContext.getMasterSRID())) {
            return 0;
        }
        if (this.themeImage != null) {
            return 1;
        }
        rectangle2D = visContext.getQueryWindow();
        if (this.theme.getExternalMapViewerURL() == null) {
            this.mapWidth = (int)(visContext.getDeviceWindow().getWidth() * rectangle2D.getWidth() / this.theme.getMapWindow().getWidth());
            this.mapHeight = (int)(visContext.getDeviceWindow().getHeight() * rectangle2D.getHeight() / this.theme.getMapWindow().getHeight());
        } else {
            this.mapWidth = (int)visContext.getDeviceWindow().getWidth();
            this.mapHeight = (int)visContext.getDeviceWindow().getHeight();
        }
        try {
            this.themeImage = this.theme.getExternalMapViewerURL() == null ? this.theme.getCacheInstance().getMap(rectangle2D, this.mapWidth, this.mapHeight) : this.getExternalTileMap(this.theme, rectangle2D, this.mapWidth, this.mapHeight);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Failed to get cached map image for theme " + this.theme.getDefinition().name + "!", exception);
        }
        return 1;
    }

    public void postPreparation(VisContext visContext) {
    }

    public StyledFeatureI getStyledFeature(int n) {
        return null;
    }

    public double[] getDataMBR() {
        return new double[]{this.window.getMinX(), this.window.getMinY(), this.window.getMaxX(), this.window.getMaxY()};
    }

    public StyledFeatureI[] getStyledFeatures() {
        return null;
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        return null;
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        return null;
    }

    public void destroy() {
        if (this.themeImage != null) {
            this.themeImage.flush();
            this.themeImage = null;
        }
    }

    public void abort() {
    }

    private boolean sridsAreSame(int n, int n2) {
        if (n == n2 || n == 0 || n2 == 0) {
            return true;
        }
        return n == 8265 && n2 == 8307 || n == 8307 && n2 == 8265;
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        return null;
    }

    private Image getExternalTileMap(MapCacheTheme mapCacheTheme, Rectangle2D rectangle2D, int n, int n2) throws Exception {
        MapViewer mapViewer = new MapViewer(mapCacheTheme.getExternalMapViewerURL() + "omserver");
        mapViewer.setAntiAliasing(true);
        mapViewer.setBox(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY());
        mapViewer.setDeviceSize(new Dimension(n, n2));
        mapViewer.addMapCacheTheme(mapCacheTheme.getName(), mapCacheTheme.getDataSourceName(), mapCacheTheme.getTileLayerName(), true);
        mapViewer.setImageFormat(9);
        mapViewer.setDataSourceName(mapCacheTheme.getDataSourceName());
        mapViewer.setBackgroundColor(null);
        mapViewer.setBackgroundTransparent(true);
        mapViewer.setIsTileRequest(true);
        mapViewer.run();
        double[] dArray = mapViewer.getMapMBR();
        this.responseSrid = mapViewer.getMapResponse().getSRID();
        this.resultWindow = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        return mapViewer.getGeneratedMapImage();
    }

    public Rectangle2D getMapWindow() {
        return this.resultWindow;
    }

    public int getResonseSrid() {
        return this.responseSrid;
    }
}

