/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.util.Util;

public class NetworkThemeDefinition
extends ThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    boolean passThrough;
    String networkOwner;
    String networkName;
    int networkId;
    int hierachyLevels;
    String networkCategory;
    String geometryType;
    String networkType;
    String lrsTableName;
    String lrsGeomColumn;
    String nodeTableName;
    String nodeGeomColumn;
    String nodeCostColumn;
    String linkTableName;
    String linkGeomColumn;
    String linkDirection;
    String linkCostColumn;
    String pathTableName;
    String pathGeomColumn;
    String pathLinkTableName;
    String linkStyle;
    String nodeStyle;
    String directionStyle;
    String bidirectionStyle;
    SizeDefinition dirStyleSize;
    boolean multipleMarker;
    SizeDefinition nodeStyleSize;
    String[] pathStyles;
    int[] idPaths;
    String linkLabelStyle;
    String linkLabelColumn;
    String nodeLabelStyle;
    String nodeLabelColumn;
    String pathLabelStyle;
    String pathLabelColumn;
    String linkQuery;
    String nodeQuery;
    String[] pathQuery;
    double linkDirectionPosition;
    int networkLevel;
    public static final String DIJKSTRA_ALGORITHM = "DIJKSTRA";
    public static final String ASEARCH_ALGORITHM = "ASEARCH";
    public static final String WITHINCOST_ALGORITHM = "WITHINCOST";
    String spAlgorithm;
    String spStyle;
    int spStartNode;
    int spEndNode;
    String spStartStyle;
    String spEndStyle;
    int[] spIDS;
    double spCost;
    boolean predefined;
    String mBaseTable;
    String mKeyColumn;
    StylingRule mSRule;
    PreparedStatement pstmt;
    String currentKey;
    int cachingMode;
    String cacheSubRegionName;
    String linkCacheGroup;
    String nodeCacheGroup;
    Hashtable sridLinkCache;
    Hashtable sridNodeCache;
    boolean bidirectionAttr;
    String connectionUser;
    String nodeKeyColumn;
    String linkKeyColumn;

    public NetworkThemeDefinition(String string, String string2, String string3, String string4, String string5, double d, int n, String string6, int n2, String string7, String string8, int n3, boolean bl) {
        this.passThrough = true;
        this.networkOwner = null;
        this.networkName = null;
        this.networkId = 0;
        this.hierachyLevels = 1;
        this.networkCategory = null;
        this.geometryType = null;
        this.networkType = null;
        this.lrsTableName = null;
        this.lrsGeomColumn = null;
        this.nodeTableName = null;
        this.nodeGeomColumn = null;
        this.nodeCostColumn = null;
        this.linkTableName = null;
        this.linkGeomColumn = null;
        this.linkDirection = null;
        this.linkCostColumn = null;
        this.pathTableName = null;
        this.pathGeomColumn = null;
        this.pathLinkTableName = null;
        this.linkStyle = null;
        this.nodeStyle = null;
        this.directionStyle = null;
        this.bidirectionStyle = null;
        this.dirStyleSize = new SizeDefinition(8.0, null);
        this.multipleMarker = false;
        this.nodeStyleSize = new SizeDefinition(5.0, null);
        this.pathStyles = null;
        this.idPaths = null;
        this.linkLabelStyle = null;
        this.linkLabelColumn = null;
        this.nodeLabelStyle = null;
        this.nodeLabelColumn = null;
        this.pathLabelStyle = null;
        this.pathLabelColumn = null;
        this.linkQuery = null;
        this.nodeQuery = null;
        this.pathQuery = null;
        this.linkDirectionPosition = 0.85;
        this.networkLevel = 1;
        this.spAlgorithm = null;
        this.spStyle = null;
        this.spStartNode = 0;
        this.spEndNode = 0;
        this.spStartStyle = null;
        this.spEndStyle = null;
        this.spIDS = null;
        this.spCost = 0.0;
        this.predefined = false;
        this.mBaseTable = null;
        this.mKeyColumn = "ROWID";
        this.mSRule = null;
        this.pstmt = null;
        this.currentKey = null;
        this.cachingMode = 1;
        this.cacheSubRegionName = null;
        this.linkCacheGroup = null;
        this.nodeCacheGroup = null;
        this.sridLinkCache = new Hashtable(5);
        this.sridNodeCache = new Hashtable(5);
        this.bidirectionAttr = false;
        this.connectionUser = null;
        this.nodeKeyColumn = null;
        this.linkKeyColumn = null;
        this.name = string;
        this.dataSource = string2;
        DBDataSource dBDataSource = (DBDataSource)DSManager.get(string2);
        if (dBDataSource == null) {
            log.severe("Unable to get data source " + string2);
            return;
        }
        this.is9i = dBDataSource.is9i();
        if (!this.readMetadata(string2, string3)) {
            return;
        }
        this.bidirectionAttr = this.bidirectionAttrExists(string2);
        this.linkStyle = string4;
        this.directionStyle = string5;
        this.linkDirectionPosition = d;
        this.dirStyleSize.setValue(n);
        this.rewriteLinkQuery();
        this.nodeStyle = string6;
        this.nodeStyleSize.setValue(n2);
        this.rewriteNodeQuery();
        this.generatePathQueries(string7, string8);
        this.networkLevel = n3;
        this.passThrough = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public NetworkThemeDefinition(String string, String string2, String string3, int n, StylingRule[] stylingRuleArray, int n2, int n3) {
        block26: {
            this.passThrough = true;
            this.networkOwner = null;
            this.networkName = null;
            this.networkId = 0;
            this.hierachyLevels = 1;
            this.networkCategory = null;
            this.geometryType = null;
            this.networkType = null;
            this.lrsTableName = null;
            this.lrsGeomColumn = null;
            this.nodeTableName = null;
            this.nodeGeomColumn = null;
            this.nodeCostColumn = null;
            this.linkTableName = null;
            this.linkGeomColumn = null;
            this.linkDirection = null;
            this.linkCostColumn = null;
            this.pathTableName = null;
            this.pathGeomColumn = null;
            this.pathLinkTableName = null;
            this.linkStyle = null;
            this.nodeStyle = null;
            this.directionStyle = null;
            this.bidirectionStyle = null;
            this.dirStyleSize = new SizeDefinition(8.0, null);
            this.multipleMarker = false;
            this.nodeStyleSize = new SizeDefinition(5.0, null);
            this.pathStyles = null;
            this.idPaths = null;
            this.linkLabelStyle = null;
            this.linkLabelColumn = null;
            this.nodeLabelStyle = null;
            this.nodeLabelColumn = null;
            this.pathLabelStyle = null;
            this.pathLabelColumn = null;
            this.linkQuery = null;
            this.nodeQuery = null;
            this.pathQuery = null;
            this.linkDirectionPosition = 0.85;
            this.networkLevel = 1;
            this.spAlgorithm = null;
            this.spStyle = null;
            this.spStartNode = 0;
            this.spEndNode = 0;
            this.spStartStyle = null;
            this.spEndStyle = null;
            this.spIDS = null;
            this.spCost = 0.0;
            this.predefined = false;
            this.mBaseTable = null;
            this.mKeyColumn = "ROWID";
            this.mSRule = null;
            this.pstmt = null;
            this.currentKey = null;
            this.cachingMode = 1;
            this.cacheSubRegionName = null;
            this.linkCacheGroup = null;
            this.nodeCacheGroup = null;
            this.sridLinkCache = new Hashtable(5);
            this.sridNodeCache = new Hashtable(5);
            this.bidirectionAttr = false;
            this.connectionUser = null;
            this.nodeKeyColumn = null;
            this.linkKeyColumn = null;
            this.dataSource = string2;
            DBDataSource dBDataSource = (DBDataSource)DSManager.get(string2);
            if (dBDataSource == null) {
                log.severe("Unable to get data source " + string2);
                return;
            }
            Connection connection = null;
            this.is9i = dBDataSource.is9i();
            this.predefined = true;
            this.name = string;
            this.srid = n2;
            this.networkLevel = n;
            this.passThrough = false;
            if (n < 1) {
                this.networkLevel = 1;
                log.warning("Invalid network level (level 1 is assumed).");
            }
            if (!this.readMetadata(string2, string3)) {
                return;
            }
            this.bidirectionAttr = this.bidirectionAttrExists(string2);
            if (stylingRuleArray == null || stylingRuleArray.length < 1) {
                log.warning("There are no styling rules defined for this theme");
                return;
            }
            this.cachingMode = n3;
            if (n3 != 1 && n3 != 1 && n3 != 3) {
                this.cachingMode = 1;
            }
            this.linkCacheGroup = string3 + "_LINK_PDT_NET";
            this.nodeCacheGroup = string3 + "_NODE_PDT_NET";
            boolean bl = this.cachingMode == 2;
            connection = dBDataSource.getConnection();
            this.cacheSubRegionName = CacheMgr2.getSubRegionName(connection);
            if (CacheMgr2.getSubRegion(this.cacheSubRegionName) == null) {
                CacheMgr2.createSubRegion(connection);
            }
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.linkCacheGroup, 0, bl);
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.nodeCacheGroup, 0, bl);
            Object var13_11 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block26;
            }
            catch (Exception exception2) {
                log.warning(exception2.getMessage());
            }
            break block26;
            {
                catch (Exception exception) {
                    log.severe(exception.getMessage());
                    var13_11 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block26;
                    }
                    catch (Exception exception2) {
                        log.warning(exception2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
        if (stylingRuleArray == null) {
            log.warning("Styling rules has not been defined.");
            return;
        }
        this.mSRule = stylingRuleArray[0];
        for (int i = 0; i < stylingRuleArray.length; ++i) {
            if (stylingRuleArray[i].getLinkStyle() != null) {
                if (this.linkQuery != null) {
                    log.warning("Link query already defined on a previous rule.");
                } else {
                    this.linkStyle = stylingRuleArray[i].getLinkStyle();
                    this.directionStyle = stylingRuleArray[i].getDirectionStyle();
                    this.bidirectionStyle = stylingRuleArray[i].getBiDirectionStyle();
                    this.linkDirectionPosition = stylingRuleArray[i].getDirectionPosition();
                    this.dirStyleSize = stylingRuleArray[i].getDirectionStyleSize();
                    this.multipleMarker = stylingRuleArray[i].hasMultipleDirectionMarkers();
                    this.linkLabelStyle = stylingRuleArray[i].getLinkLabelStyle();
                    this.linkLabelColumn = stylingRuleArray[i].getLinkLabelColumn();
                    this.rewriteLinkQuery();
                }
            }
            if (stylingRuleArray[i].getNodeStyle() != null) {
                if (this.nodeQuery != null) {
                    log.warning("Node query already defined on a previous rule.");
                } else {
                    this.nodeStyle = stylingRuleArray[i].getNodeStyle();
                    this.nodeStyleSize = stylingRuleArray[i].getNodeStyleSize();
                    this.nodeLabelStyle = stylingRuleArray[i].getNodeLabelStyle();
                    this.nodeLabelColumn = stylingRuleArray[i].getNodeLabelColumn();
                    this.rewriteNodeQuery();
                }
            }
            if (this.pathQuery != null) {
                log.warning("Path query already defined on a previous rule.");
                continue;
            }
            this.generatePathQueries(stylingRuleArray[i].getPathIds(), stylingRuleArray[i].getPathStyles());
            this.pathLabelStyle = stylingRuleArray[i].getPathLabelStyle();
            this.pathLabelColumn = stylingRuleArray[i].getPathLabelColumn();
            this.rewritePathQueries();
        }
    }

    public NetworkThemeDefinition(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6, String string7, int n3, boolean bl) {
        this.passThrough = true;
        this.networkOwner = null;
        this.networkName = null;
        this.networkId = 0;
        this.hierachyLevels = 1;
        this.networkCategory = null;
        this.geometryType = null;
        this.networkType = null;
        this.lrsTableName = null;
        this.lrsGeomColumn = null;
        this.nodeTableName = null;
        this.nodeGeomColumn = null;
        this.nodeCostColumn = null;
        this.linkTableName = null;
        this.linkGeomColumn = null;
        this.linkDirection = null;
        this.linkCostColumn = null;
        this.pathTableName = null;
        this.pathGeomColumn = null;
        this.pathLinkTableName = null;
        this.linkStyle = null;
        this.nodeStyle = null;
        this.directionStyle = null;
        this.bidirectionStyle = null;
        this.dirStyleSize = new SizeDefinition(8.0, null);
        this.multipleMarker = false;
        this.nodeStyleSize = new SizeDefinition(5.0, null);
        this.pathStyles = null;
        this.idPaths = null;
        this.linkLabelStyle = null;
        this.linkLabelColumn = null;
        this.nodeLabelStyle = null;
        this.nodeLabelColumn = null;
        this.pathLabelStyle = null;
        this.pathLabelColumn = null;
        this.linkQuery = null;
        this.nodeQuery = null;
        this.pathQuery = null;
        this.linkDirectionPosition = 0.85;
        this.networkLevel = 1;
        this.spAlgorithm = null;
        this.spStyle = null;
        this.spStartNode = 0;
        this.spEndNode = 0;
        this.spStartStyle = null;
        this.spEndStyle = null;
        this.spIDS = null;
        this.spCost = 0.0;
        this.predefined = false;
        this.mBaseTable = null;
        this.mKeyColumn = "ROWID";
        this.mSRule = null;
        this.pstmt = null;
        this.currentKey = null;
        this.cachingMode = 1;
        this.cacheSubRegionName = null;
        this.linkCacheGroup = null;
        this.nodeCacheGroup = null;
        this.sridLinkCache = new Hashtable(5);
        this.sridNodeCache = new Hashtable(5);
        this.bidirectionAttr = false;
        this.connectionUser = null;
        this.nodeKeyColumn = null;
        this.linkKeyColumn = null;
        this.name = string;
        this.dataSource = string2;
        if (!this.readMetadata(string2, string3)) {
            return;
        }
        this.spAlgorithm = string4;
        this.spStyle = string5;
        this.spStartNode = n;
        this.spEndNode = n2;
        this.spStartStyle = string6;
        this.spEndStyle = string7;
        this.networkLevel = n3;
        this.passThrough = bl;
    }

    public NetworkThemeDefinition(String string, String string2, String string3, int n, String string4, String string5, double d, int n2, boolean bl) {
        this.passThrough = true;
        this.networkOwner = null;
        this.networkName = null;
        this.networkId = 0;
        this.hierachyLevels = 1;
        this.networkCategory = null;
        this.geometryType = null;
        this.networkType = null;
        this.lrsTableName = null;
        this.lrsGeomColumn = null;
        this.nodeTableName = null;
        this.nodeGeomColumn = null;
        this.nodeCostColumn = null;
        this.linkTableName = null;
        this.linkGeomColumn = null;
        this.linkDirection = null;
        this.linkCostColumn = null;
        this.pathTableName = null;
        this.pathGeomColumn = null;
        this.pathLinkTableName = null;
        this.linkStyle = null;
        this.nodeStyle = null;
        this.directionStyle = null;
        this.bidirectionStyle = null;
        this.dirStyleSize = new SizeDefinition(8.0, null);
        this.multipleMarker = false;
        this.nodeStyleSize = new SizeDefinition(5.0, null);
        this.pathStyles = null;
        this.idPaths = null;
        this.linkLabelStyle = null;
        this.linkLabelColumn = null;
        this.nodeLabelStyle = null;
        this.nodeLabelColumn = null;
        this.pathLabelStyle = null;
        this.pathLabelColumn = null;
        this.linkQuery = null;
        this.nodeQuery = null;
        this.pathQuery = null;
        this.linkDirectionPosition = 0.85;
        this.networkLevel = 1;
        this.spAlgorithm = null;
        this.spStyle = null;
        this.spStartNode = 0;
        this.spEndNode = 0;
        this.spStartStyle = null;
        this.spEndStyle = null;
        this.spIDS = null;
        this.spCost = 0.0;
        this.predefined = false;
        this.mBaseTable = null;
        this.mKeyColumn = "ROWID";
        this.mSRule = null;
        this.pstmt = null;
        this.currentKey = null;
        this.cachingMode = 1;
        this.cacheSubRegionName = null;
        this.linkCacheGroup = null;
        this.nodeCacheGroup = null;
        this.sridLinkCache = new Hashtable(5);
        this.sridNodeCache = new Hashtable(5);
        this.bidirectionAttr = false;
        this.connectionUser = null;
        this.nodeKeyColumn = null;
        this.linkKeyColumn = null;
        this.name = string;
        this.dataSource = string2;
        if (!this.readMetadata(string2, string3)) {
            return;
        }
        this.spAlgorithm = WITHINCOST_ALGORITHM;
        this.spStyle = string5;
        this.spStartNode = n;
        this.spStartStyle = string4;
        this.spCost = d;
        this.networkLevel = n2;
        this.passThrough = bl;
    }

    public void rewriteLinkQuery() {
        String string = "";
        if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
            string = this.networkOwner + ".";
        }
        String string2 = "";
        if (this.predefined) {
            string2 = this.getLinkKeyColumn() + ", ";
        }
        String string3 = "";
        if (this.bidirectionAttr) {
            string3 = ", bidirected";
        }
        this.linkQuery = null;
        if (this.linkStyle != null) {
            this.linkQuery = this.geometryType.equals("SDO_GEOMETRY") ? (this.linkLabelStyle == null || this.linkLabelColumn == null ? "select " + string2 + this.linkGeomColumn + string3 + " from " + string + this.linkTableName : "select " + string2 + this.linkGeomColumn + ", " + this.linkLabelColumn + string3 + " from " + string + this.linkTableName) : (this.geometryType.equals("LRS_GEOMETRY") ? (this.linkLabelStyle == null || this.linkLabelColumn == null ? "select " + string2 + this.lrsGeomColumn + " from " + string + this.lrsTableName : "select " + string2 + this.lrsGeomColumn + ", " + this.linkLabelColumn + " from " + string + this.lrsTableName) : null);
        }
    }

    public void rewriteNodeQuery() {
        String string = "";
        if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
            string = this.networkOwner + ".";
        }
        String string2 = "";
        String string3 = "";
        if (this.predefined) {
            string2 = this.getNodeKeyColumn() + ",";
            string3 = string + this.lrsTableName + "." + this.getNodeKeyColumn() + ",";
        }
        this.nodeQuery = null;
        if (this.nodeStyle != null) {
            this.nodeQuery = this.geometryType.equals("SDO_GEOMETRY") ? (this.nodeLabelStyle == null || this.nodeLabelColumn == null ? "select " + string2 + this.nodeGeomColumn + " from " + string + this.nodeTableName : "select " + string2 + this.nodeGeomColumn + ", " + this.nodeLabelColumn + " from " + string + this.nodeTableName) : (this.geometryType.equals("LRS_GEOMETRY") ? (this.nodeLabelStyle == null || this.nodeLabelColumn == null ? "select " + string3 + this.lrsGeomColumn + ", measure, " + string + this.lrsTableName + ".geom_id from " + string + this.lrsTableName + " inner join " + string + this.nodeTableName + " on " + string + this.lrsTableName + ".geom_id = " + string + this.nodeTableName + ".geom_id" : "select " + string3 + this.lrsGeomColumn + ", measure, " + string + this.lrsTableName + ".geom_id," + string + this.nodeTableName + "." + this.nodeLabelColumn + " from " + string + this.lrsTableName + " inner join " + string + this.nodeTableName + " on " + string + this.lrsTableName + ".geom_id = " + string + this.nodeTableName + ".geom_id") : null);
        }
    }

    public void rewritePathQueries() {
        if (this.idPaths == null) {
            return;
        }
        String string = "";
        if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
            string = this.networkOwner + ".";
        }
        for (int i = 0; i < this.idPaths.length; ++i) {
            if (this.pathQuery[i] == null || this.idPaths[i] == 0) continue;
            if (this.pathLabelStyle == null || this.pathLabelColumn == null) {
                if (this.geometryType.equals("SDO_GEOMETRY")) {
                    this.pathQuery[i] = "select " + this.linkGeomColumn + " from " + string + this.linkTableName + " inner join " + string + this.pathLinkTableName + " on " + string + this.linkTableName + ".link_id = " + string + this.pathLinkTableName + ".link_id where path_id = " + this.idPaths[i] + " order by seq_no";
                    continue;
                }
                if (this.geometryType.equals("LRS_GEOMETRY")) {
                    this.pathQuery[i] = "select mv_lrs_geom.* from (select " + this.lrsGeomColumn + ", link_id, start_measure, " + "end_measure from " + string + this.lrsTableName + " inner join " + string + this.linkTableName + " on " + string + this.lrsTableName + ".geom_id = " + string + this.linkTableName + ".geom_id) mv_lrs_geom inner join " + string + this.pathLinkTableName + " on mv_lrs_geom.link_id = " + string + this.pathLinkTableName + ".link_id where path_id = " + this.idPaths[i] + " order by seq_no";
                    continue;
                }
                this.pathQuery[i] = null;
                continue;
            }
            this.pathQuery[i] = this.geometryType.equals("SDO_GEOMETRY") ? "select " + string + this.linkTableName + "." + this.linkGeomColumn + "," + string + this.pathTableName + "." + this.pathLabelColumn + " from " + string + this.pathTableName + " inner join " + string + this.pathLinkTableName + " on " + string + this.pathTableName + ".path_id = " + string + this.pathLinkTableName + ".path_id inner join " + string + this.linkTableName + " on " + string + this.pathLinkTableName + ".link_id = " + string + this.linkTableName + ".link_id where " + string + this.pathLinkTableName + ".path_id = " + this.idPaths[i] + " order by seq_no" : (this.geometryType.equals("LRS_GEOMETRY") ? "select mv_lrs_geom.*, " + string + this.pathTableName + "." + this.pathLabelColumn + " from " + string + this.pathTableName + " inner join " + string + this.pathLinkTableName + " on " + string + this.pathTableName + ".path_id = " + string + this.pathLinkTableName + ".path_id inner join " + "(select " + this.lrsGeomColumn + ", link_id, start_measure, " + "end_measure from " + string + this.lrsTableName + " inner join " + string + this.linkTableName + " on " + string + this.lrsTableName + ".geom_id = " + string + this.linkTableName + ".geom_id) mv_lrs_geom on " + string + this.pathLinkTableName + ".link_id = mv_lrs_geom.link_id " + "where " + string + this.pathLinkTableName + ".path_id = " + this.idPaths[i] + " order by seq_no" : null);
        }
    }

    private void generatePathQueries(String string, String string2) {
        String string3 = "";
        if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
            string3 = this.networkOwner + ".";
        }
        if (string != null) {
            int n;
            ArrayList arrayList = Util.splitBy(string, ",");
            this.idPaths = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    this.idPaths[i] = Integer.parseInt((String)arrayList.get(i));
                    continue;
                }
                catch (Exception exception) {
                    log.warning("Network Theme with invalid path Id.");
                    this.idPaths[i] = 0;
                }
            }
            ArrayList arrayList2 = Util.splitBy(string2, ",");
            this.pathStyles = new String[arrayList2.size()];
            for (n = 0; n < arrayList2.size(); ++n) {
                this.pathStyles[n] = (String)arrayList2.get(n);
            }
            if (arrayList.size() != arrayList2.size()) {
                log.warning("Each Path ID must have a Path Style.");
            }
            this.pathQuery = new String[arrayList2.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                this.pathQuery[n] = null;
                if (this.idPaths[n] == 0) continue;
                if (this.geometryType.equals("SDO_GEOMETRY")) {
                    if (this.pathStyles[n] == null) continue;
                    this.pathQuery[n] = "select " + this.linkGeomColumn + " from " + string3 + this.linkTableName + " inner join " + string3 + this.pathLinkTableName + " on " + string3 + this.linkTableName + ".link_id = " + string3 + this.pathLinkTableName + ".link_id where path_id = " + this.idPaths[n] + " order by seq_no";
                    continue;
                }
                this.pathQuery[n] = this.geometryType.equals("LRS_GEOMETRY") ? "select mv_lrs_geom.* from (select " + this.lrsGeomColumn + ", link_id, start_measure, " + "end_measure from " + string3 + this.lrsTableName + " inner join " + string3 + this.linkTableName + " on " + string3 + this.lrsTableName + ".geom_id = " + string3 + this.linkTableName + ".geom_id) mv_lrs_geom inner join " + string3 + this.pathLinkTableName + " on mv_lrs_geom.link_id = " + string3 + this.pathLinkTableName + ".link_id where path_id = " + this.idPaths[n] + " order by seq_no" : null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean readMetadata(String string, String string2) {
        block42: {
            Exception exception322;
            ResultSet resultSet;
            Object object;
            Object object2;
            block37: {
                int n;
                block33: {
                    Exception exception2222;
                    boolean bl;
                    block34: {
                        String string3 = "select * from user_sdo_network_metadata where network = '" + string2.toUpperCase() + "'";
                        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.dataSource);
                        if (abstractDBDataSource == null) {
                            log.severe("Unable to get data source: " + string);
                            return false;
                        }
                        this.networkOwner = this.connectionUser = abstractDBDataSource.getUser();
                        n = string2.indexOf(".");
                        if (n > -1) {
                            object2 = string2.substring(0, n);
                            object = string2.substring(n + 1, string2.length());
                            string3 = "select * from all_sdo_network_metadata where network = '" + ((String)object).toUpperCase() + "'" + " and owner = '" + ((String)object2).toUpperCase() + "'";
                        }
                        object2 = null;
                        log.info("[Network Metadata Query] " + string3);
                        object = null;
                        resultSet = null;
                        object2 = abstractDBDataSource.getConnection();
                        object = object2.prepareStatement(string3);
                        resultSet = object.executeQuery();
                        if (resultSet.next()) break block33;
                        log.severe("Unable to load Network " + string2);
                        bl = false;
                        Object var12_11 = null;
                        if (resultSet == null) break block34;
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    if (object2 != null) {
                        try {
                            object2.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                if (n > -1) {
                    this.networkOwner = resultSet.getString("owner");
                }
                this.networkName = resultSet.getString("network");
                this.networkId = resultSet.getInt("network_id");
                this.networkCategory = resultSet.getString("network_category");
                this.geometryType = resultSet.getString("geometry_type");
                this.networkType = resultSet.getString("network_type");
                this.hierachyLevels = resultSet.getInt("no_of_hierarchy_levels");
                this.lrsTableName = resultSet.getString("lrs_table_name");
                this.lrsGeomColumn = resultSet.getString("lrs_geom_column");
                this.nodeTableName = resultSet.getString("node_table_name");
                this.nodeGeomColumn = resultSet.getString("node_geom_column");
                this.nodeCostColumn = resultSet.getString("node_cost_column");
                this.linkTableName = resultSet.getString("link_table_name");
                this.linkGeomColumn = resultSet.getString("link_geom_column");
                this.linkDirection = resultSet.getString("link_direction");
                this.linkCostColumn = resultSet.getString("link_cost_column");
                this.pathTableName = resultSet.getString("path_table_name");
                this.pathGeomColumn = resultSet.getString("path_geom_column");
                this.pathLinkTableName = resultSet.getString("path_link_table_name");
                Object var12_12 = null;
                if (resultSet == null) break block37;
                try {
                    resultSet.close();
                }
                catch (Exception exception322) {
                    // empty catch block
                }
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception322) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception322) {}
            }
            break block42;
            {
                catch (Exception exception4) {
                    Exception exception5222;
                    log.severe("Network load metadata Exception: " + exception4.getMessage());
                    boolean bl = false;
                    Object var12_13 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (object != null) {
                        try {
                            object.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (object2 != null) {
                        try {
                            object2.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Exception exception6222;
                Object var12_14 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception6222) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception6222) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception6222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean bidirectionAttrExists(String var1_1) {
        block40: {
            block39: {
                block33: {
                    block38: {
                        block31: {
                            block32: {
                                if (this.linkTableName == null) {
                                    return false;
                                }
                                var2_2 = "";
                                if (this.connectionUser != null && this.networkOwner != null && !this.connectionUser.equalsIgnoreCase(this.networkOwner)) {
                                    var2_2 = this.networkOwner + ".";
                                }
                                var3_3 = "select * from " + var2_2 + this.linkTableName + " where rownum < 1";
                                var4_4 = (DBDataSource)DSManager.get(var1_1);
                                if (var4_4 == null) {
                                    NetworkThemeDefinition.log.severe("Unable to get data source: " + var1_1);
                                    return false;
                                }
                                var5_5 = null;
                                var6_6 = null;
                                var7_7 = null;
                                try {
                                    try {
                                        var5_5 = var4_4.getConnection();
                                        var6_6 = var5_5.prepareStatement(var3_3);
                                        var7_7 = var6_6.executeQuery();
                                        var8_8 = var7_7.getMetaData();
                                        var9_10 = var8_8.getColumnCount();
                                        for (var10_12 = 0; var10_12 < var9_10; ++var10_12) {
                                            if (!var8_8.getColumnName(var10_12 + 1).equalsIgnoreCase("BIDIRECTED")) continue;
                                            var11_13 = true;
                                            var13_14 = null;
                                            if (var7_7 == null) break block31;
                                            break block32;
                                        }
                                        break block33;
                                    }
                                    catch (Exception var8_9) {
                                        NetworkThemeDefinition.log.severe("Network bidirection check Exception: " + var8_9.getMessage());
                                        var9_11 = false;
                                        var13_16 = null;
                                        if (var7_7 != null) {
                                            try {
                                                var7_7.close();
                                            }
                                            catch (Exception var14_20) {
                                                // empty catch block
                                            }
                                        }
                                        if (var6_6 != null) {
                                            try {
                                                var6_6.close();
                                            }
                                            catch (Exception var14_20) {
                                                // empty catch block
                                            }
                                        }
                                        if (var5_5 == null) return var9_11;
                                        try {
                                            var5_5.close();
                                            return var9_11;
                                        }
                                        catch (Exception var14_20) {
                                            // empty catch block
                                        }
                                        return var9_11;
                                    }
                                }
                                catch (Throwable var12_22) {
                                    block37: {
                                        block36: {
                                            var13_17 = null;
                                            if (var7_7 != null) {
                                                ** try [egrp 2[TRYBLOCK] [6 : 296->306)] { 
lbl60:
                                                // 1 sources

                                                var7_7.close();
                                                break block36;
lbl62:
                                                // 1 sources

                                                catch (Exception var14_21) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (var6_6 != null) {
                                            ** try [egrp 3[TRYBLOCK] [7 : 313->323)] { 
lbl67:
                                            // 1 sources

                                            var6_6.close();
                                            break block37;
lbl69:
                                            // 1 sources

                                            catch (Exception var14_21) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (var5_5 == null) throw var12_22;
                                    ** try [egrp 4[TRYBLOCK] [8 : 330->340)] { 
lbl74:
                                    // 1 sources

                                    var5_5.close();
                                    throw var12_22;
lbl76:
                                    // 1 sources

                                    catch (Exception var14_21) {
                                        // empty catch block
                                    }
                                    throw var12_22;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [6 : 296->306)] { 
lbl81:
                            // 1 sources

                            var7_7.close();
                            break block31;
lbl83:
                            // 1 sources

                            catch (Exception var14_18) {
                                // empty catch block
                            }
                        }
                        if (var6_6 != null) {
                            ** try [egrp 3[TRYBLOCK] [7 : 313->323)] { 
lbl88:
                            // 1 sources

                            var6_6.close();
                            break block38;
lbl90:
                            // 1 sources

                            catch (Exception var14_18) {
                                // empty catch block
                            }
                        }
                    }
                    if (var5_5 == null) return var11_13;
                    ** try [egrp 4[TRYBLOCK] [8 : 330->340)] { 
lbl95:
                    // 1 sources

                    var5_5.close();
                    return var11_13;
lbl97:
                    // 1 sources

                    catch (Exception var14_18) {
                        // empty catch block
                    }
                    return var11_13;
                }
                var13_15 = null;
                if (var7_7 != null) {
                    ** try [egrp 2[TRYBLOCK] [6 : 296->306)] { 
lbl104:
                    // 1 sources

                    var7_7.close();
                    break block39;
lbl106:
                    // 1 sources

                    catch (Exception var14_19) {
                        // empty catch block
                    }
                }
            }
            if (var6_6 != null) {
                ** try [egrp 3[TRYBLOCK] [7 : 313->323)] { 
lbl111:
                // 1 sources

                var6_6.close();
                break block40;
lbl113:
                // 1 sources

                catch (Exception var14_19) {
                    // empty catch block
                }
            }
        }
        if (var5_5 == null) return false;
        try {}
        catch (Exception var14_19) {}
        var5_5.close();
        return false;
        return false;
    }

    public void setNetworkThemeLabels(String string, String string2, String string3, String string4, String string5, String string6) {
        if (this.predefined) {
            return;
        }
        if (string != null && string2 != null) {
            this.linkLabelStyle = string;
            this.linkLabelColumn = string2;
        } else {
            this.linkLabelStyle = null;
            this.linkLabelColumn = null;
        }
        if (string3 != null && string4 != null) {
            this.nodeLabelStyle = string3;
            this.nodeLabelColumn = string4;
        } else {
            this.nodeLabelStyle = null;
            this.nodeLabelColumn = null;
        }
        if (string5 != null && string6 != null) {
            this.pathLabelStyle = string5;
            this.pathLabelColumn = string6;
        } else {
            this.pathLabelStyle = null;
            this.pathLabelColumn = null;
        }
        this.rewriteLinkQuery();
        this.rewriteNodeQuery();
        this.rewritePathQueries();
    }

    public void setASIS(boolean bl) {
        this.passThrough = bl;
    }

    public boolean getASIS() {
        return this.passThrough;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public String getKeyColumn() {
        return this.mKeyColumn;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public String getNetworkOwner() {
        return this.networkOwner;
    }

    public String getNetworkCategory() {
        return this.networkCategory;
    }

    public String getLinkCacheGroup() {
        return this.linkCacheGroup;
    }

    public String getNodeCacheGroup() {
        return this.nodeCacheGroup;
    }

    public String getCacheSubRegion() {
        return this.cacheSubRegionName;
    }

    public String getLinkQuery() {
        return this.linkQuery;
    }

    public String getNodeQuery() {
        return this.nodeQuery;
    }

    public String[] getPathQueries() {
        return this.pathQuery;
    }

    public String[] getPathStyles() {
        return this.pathStyles;
    }

    public int[] getPathIds() {
        return this.idPaths;
    }

    public String getLinkCacheGroup(int n) {
        Integer n2 = new Integer(n);
        Object v = this.sridLinkCache.get(n2);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public String getNodeCacheGroup(int n) {
        Integer n2 = new Integer(n);
        Object v = this.sridNodeCache.get(n2);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public Hashtable getLinkSRidCache() {
        return this.sridLinkCache;
    }

    public Hashtable getNodeSRidCache() {
        return this.sridNodeCache;
    }

    public void createLinkCacheGroup(int n) {
        Integer n2 = new Integer(n);
        if (this.sridLinkCache.get(n2) != null) {
            log.info("Link cache group for SRid " + n + " already exists.");
            return;
        }
        log.finer("Creating a link cache group for SRID: " + n);
        String string = this.networkName + "_" + n + "_LINK_PDT_NET";
        log.finer("Cache group: " + string);
        boolean bl = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, string, 0, bl);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
        this.sridLinkCache.put(n2, string);
    }

    public void createNodeCacheGroup(int n) {
        Integer n2 = new Integer(n);
        if (this.sridNodeCache.get(n2) != null) {
            log.info("Node cache group for SRid " + n + " already exists.");
            return;
        }
        log.finer("Creating a node cache group for SRID: " + n);
        String string = this.networkName + "_" + n + "_NODE_PDT_NET";
        log.finer("Cache group: " + string);
        boolean bl = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, string, 0, bl);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
        this.sridNodeCache.put(n2, string);
    }

    public int getCachingMode() {
        return this.cachingMode;
    }

    public String getLinkStyle() {
        return this.linkStyle;
    }

    public void setLinkStyle(String string) {
        this.linkStyle = string;
        if (this.mSRule != null) {
            this.mSRule.setLinkStyle(string);
        }
    }

    public String getNodeStyle() {
        return this.nodeStyle;
    }

    public void setNodeStyle(String string) {
        this.nodeStyle = string;
        if (this.mSRule != null) {
            this.mSRule.setNodeStyle(string);
        }
    }

    public SizeDefinition getNodeStyleSize() {
        return this.nodeStyleSize;
    }

    public void setNodeStyleSize(SizeDefinition sizeDefinition) {
        this.nodeStyleSize = sizeDefinition == null ? new SizeDefinition(8.0, null) : sizeDefinition;
    }

    public String getDirectionStyle() {
        return this.directionStyle;
    }

    public String getBiDirectionStyle() {
        return this.bidirectionStyle;
    }

    public SizeDefinition getDirectionStyleSize() {
        return this.dirStyleSize;
    }

    public void setDirectionStyleSize(SizeDefinition sizeDefinition) {
        this.dirStyleSize = sizeDefinition == null ? new SizeDefinition(8.0, null) : sizeDefinition;
    }

    public String getLinkDirection() {
        return this.linkDirection;
    }

    public double getLinkDirectionPosition() {
        return this.linkDirectionPosition;
    }

    public String getShortestPathAlgorithm() {
        return this.spAlgorithm;
    }

    public String getShortestPathStyle() {
        return this.spStyle;
    }

    public String getShortestPathStartStyle() {
        return this.spStartStyle;
    }

    public String getShortestPathEndStyle() {
        return this.spEndStyle;
    }

    public int getShortestPathStartNode() {
        return this.spStartNode;
    }

    public int getShortestPathEndNode() {
        return this.spEndNode;
    }

    public String getLRSGeometryColumn() {
        return this.lrsGeomColumn;
    }

    public String getLRSTableName() {
        return this.lrsTableName;
    }

    public String getLinkGeometryColumn() {
        return this.linkGeomColumn;
    }

    public String getNodeGeometryColumn() {
        return this.nodeGeomColumn;
    }

    public String getPathGeometryColumn() {
        return this.pathGeomColumn;
    }

    public String getLinkTableName() {
        return this.linkTableName;
    }

    public String getNodeTableName() {
        return this.nodeTableName;
    }

    public void setShortestPathIds(int[] nArray) {
        this.spIDS = nArray;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public double getShortestPathCost() {
        return this.spCost;
    }

    public String getGeometryType() {
        return this.geometryType;
    }

    public void setNodeQuery(String string) {
        this.nodeQuery = string;
    }

    public String getLinkLabelStyle() {
        return this.linkLabelStyle;
    }

    public void setLinkLabelStyle(String string) {
        this.linkLabelStyle = string;
        if (this.mSRule != null) {
            this.mSRule.setLinkLabelStyle(string);
        }
    }

    public String getLinkLabelColumn() {
        return this.linkLabelColumn;
    }

    public String getNodeLabelStyle() {
        return this.nodeLabelStyle;
    }

    public void setNodeLabelStyle(String string) {
        this.nodeLabelStyle = string;
        if (this.mSRule != null) {
            this.mSRule.setNodeLabelStyle(string);
        }
    }

    public String getNodeLabelColumn() {
        return this.nodeLabelColumn;
    }

    public String getPathLabelStyle() {
        return this.pathLabelStyle;
    }

    public String getPathLabelColumn() {
        return this.pathLabelColumn;
    }

    public String getThemeType() {
        return "NETWORK";
    }

    public String getXMLDefinition() {
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(stringBuffer);
        stringBuffer.append(">\n");
        stringBuffer.append(this.getAttributes());
        if (this.mSRule != null) {
            stringBuffer.append("  <rule>\n");
            stringBuffer.append(this.getRuleFeatures(this.mSRule));
            stringBuffer.append(this.getRuleLabel(this.mSRule));
            stringBuffer.append("  </rule>\n");
        }
        stringBuffer.append("</styling_rules>");
        return stringBuffer.toString();
    }

    void getCommonAttributes(StringBuffer stringBuffer) {
        String string;
        String string2 = this.getThemeType();
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" theme_type=\"" + string2 + "\"");
        }
        if ((string = this.getKeyColumn()) != null && string.trim().length() > 0) {
            stringBuffer.append(" key_column=\"" + string + "\"");
        }
        int n = this.getCachingMode();
        String string3 = "normal";
        if (n == 2) {
            string3 = "all";
        } else if (n == 3) {
            string3 = "none";
        }
        if (string3 != null && string3.trim().length() > 0) {
            stringBuffer.append(" caching=\"" + string3 + "\"");
        }
    }

    public String getAttributes() {
        String string = "";
        if (this.networkName != null) {
            string = string + " network_name=\"" + this.networkName + "\"";
        }
        if (this.networkLevel != 1) {
            string = string + " network_level=\"" + this.networkLevel + "\"";
        }
        return string;
    }

    public String getRuleFeatures(StylingRule stylingRule) {
        String string;
        String string2 = "    <features>\n";
        String string3 = stylingRule.getLinkStyle();
        if (string3 != null) {
            string2 = string2 + "      <link style=\"" + string3 + "\"";
            string = stylingRule.getDirectionStyle();
            if (string != null) {
                string2 = string2 + " direction_style=\"" + string + "\"" + " direction_position=\"" + stylingRule.getDirectionPosition() + "\"" + " direction_markersize=\"" + stylingRule.getDirectionStyleSize() + "\"";
            }
            string2 = string2 + "></link>\n";
        }
        if ((string = stylingRule.getNodeStyle()) != null) {
            string2 = string2 + "      <node style=\"" + string + "\"" + " markersize=\"" + stylingRule.getNodeStyleSize() + "\"></node>\n";
        }
        String string4 = stylingRule.getPathStyles();
        String string5 = stylingRule.getPathIds();
        if (string4 != null) {
            string2 = string2 + "      <path ";
            if (string5 != null) {
                string2 = string2 + " ids=\"" + string5 + "\"";
            }
            string2 = string2 + " styles=\"" + string4 + "\"></path>\n";
        }
        string2 = string2 + "    </features>\n";
        return string2;
    }

    public String getRuleLabel(StylingRule stylingRule) {
        if (!stylingRule.getLabeled()) {
            return "";
        }
        String string = "    <label>\n";
        String string2 = stylingRule.getLinkLabelStyle();
        String string3 = stylingRule.getLinkLabelColumn();
        if (string2 != null) {
            string = string + "      <link";
            if (string3 != null) {
                string = string + " column=\"" + string3 + "\"";
            }
            string = string + " style=\"" + string2 + "\"> 1 </link>\n";
        }
        String string4 = stylingRule.getNodeLabelStyle();
        String string5 = stylingRule.getNodeLabelColumn();
        if (string4 != null) {
            string = string + "      <node";
            if (string5 != null) {
                string = string + " column=\"" + string5 + "\"";
            }
            string = string + " style=\"" + string4 + "\"> 1 </node>\n";
        }
        String string6 = stylingRule.getPathLabelStyle();
        String string7 = stylingRule.getPathLabelColumn();
        if (string6 != null) {
            string = string + "      <path";
            if (string7 != null) {
                string = string + " column=\"" + string7 + "\"";
            }
            string = string + " style=\"" + string6 + "\"> 1 </path>\n";
        }
        string = string + "    </label>\n";
        return string;
    }

    public void setMultipleDirectionMarkers(boolean bl) {
        this.multipleMarker = bl;
    }

    public boolean hasMultipleDirectionMarkers() {
        return this.multipleMarker;
    }

    public void setBiDirectionStyle(String string) {
        this.bidirectionStyle = string;
    }

    public boolean hasBidirectionAttribute() {
        return this.bidirectionAttr;
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.getLinkTableName());
        basicThemeInfo.setType("NETWORK");
        basicThemeInfo.setKeyColumn(this.getKeyColumn());
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(this.getLinkGeometryColumn());
        return basicThemeInfo;
    }

    public String[] getRenderingStyles() {
        if (this.linkStyle == null && this.nodeStyle == null && this.pathStyles == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.linkStyle != null) {
            arrayList.add(this.linkStyle.toUpperCase());
        }
        if (this.nodeStyle != null && !arrayList.contains(this.nodeStyle.toUpperCase())) {
            arrayList.add(this.nodeStyle.toUpperCase());
        }
        if (this.pathStyles != null) {
            for (int i = 0; i < this.pathStyles.length; ++i) {
                if (arrayList.contains(this.pathStyles[i].toUpperCase())) continue;
                arrayList.add(this.pathStyles[i].toUpperCase());
            }
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getLabelingStyles() {
        if (this.linkLabelStyle == null && this.nodeLabelStyle == null && this.pathLabelStyle == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.linkLabelStyle != null) {
            arrayList.add(this.linkLabelStyle.toUpperCase());
        }
        if (this.nodeLabelStyle != null && !arrayList.contains(this.nodeLabelStyle.toUpperCase())) {
            arrayList.add(this.nodeLabelStyle.toUpperCase());
        }
        if (this.pathLabelStyle != null && !arrayList.contains(this.pathLabelStyle.toUpperCase())) {
            arrayList.add(this.pathLabelStyle.toUpperCase());
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getNodeKeyColumn() {
        if (this.nodeKeyColumn == null) {
            return this.getKeyColumn();
        }
        return this.nodeKeyColumn;
    }

    public void setNodeKeyColumn(String string) {
        this.nodeKeyColumn = string;
        this.rewriteNodeQuery();
    }

    public String getLinkKeyColumn() {
        if (this.linkKeyColumn == null) {
            return this.getKeyColumn();
        }
        return this.linkKeyColumn;
    }

    public void setLinkKeyColumn(String string) {
        this.linkKeyColumn = string;
        this.rewriteLinkQuery();
    }
}

