/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ThemeStyleInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.MapMaker;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.PredGeomThemeQueryHelper;
import oracle.sdovis.theme.ThemeUtils;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.util.GeomMetaTable;
import oracle.sdovis.util.Util;
import oracle.spatial.util.RTree;

public class PredGeomThemeDefinition
extends VectorThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected StylingRule[] styleRules = null;
    protected String baseTable;
    protected String spatialColumn;
    protected String keyColumn = "ROWID";
    protected String cacheSubRegionName = null;
    protected String cacheGroupName = null;
    protected int cachingMode = 1;
    protected double mXMin;
    protected double mYMin;
    protected double mXMax;
    protected double mYMax;
    protected Hashtable sridCache = new Hashtable(5);
    protected boolean no_Unpickler = false;
    protected boolean reorient_Lines = true;
    protected RTree styTree = null;
    protected Rectangle2D treeMBR = null;
    protected Vector styFeats = new Vector(100, 100);
    protected boolean mPassThrough = false;
    protected String table_Alias = null;
    protected transient PredGeomThemeQueryHelper queryHelper = null;
    protected String baseColumnType = null;
    boolean isHeatMapTheme = false;

    public PredGeomThemeDefinition(String string, String string2, String string3, String string4, String string5, StylingRule[] stylingRuleArray, int n) {
        this.name = string;
        this.dataSource = string2;
        this.baseTable = string3;
        this.spatialColumn = string4;
        this.keyColumn = string5;
        this.styleRules = stylingRuleArray;
        this.srid = n;
        this.is9i = ((AbstractDBDataSource)DSManager.get(string2)).is9i();
        this.cacheGroupName = string3 + "_" + string4 + "_PDT_GEOM";
        if (stylingRuleArray != null) {
            for (int i = 0; i < stylingRuleArray.length; ++i) {
                StylingRule stylingRule = stylingRuleArray[i];
                if (!stylingRule.isQueryPassThrough()) continue;
                this.mPassThrough = true;
                break;
            }
        }
        this.baseColumnType = Util.getColumnTypeName(string2, string3, string4);
        this.isHeatMapTheme = ThemeUtils.isHeatMapTheme(this, null);
    }

    public boolean isQueryPassThrough() {
        return this.mPassThrough;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(String string) {
        this.baseTable = string;
    }

    public String getGeomColumn() {
        return this.spatialColumn;
    }

    public void setGeomColumn(String string) {
        this.spatialColumn = string;
    }

    public void setKeyColumn(String string) {
        this.keyColumn = string;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getCacheSubRegionName() {
        return this.cacheSubRegionName;
    }

    public void setCacheSubRegionName(String string) {
        this.cacheSubRegionName = string;
    }

    public int getCachingMode() {
        return this.cachingMode;
    }

    public void setCachingMode(int n) {
        this.cachingMode = n;
    }

    public String getCacheGroupName() {
        return this.cacheGroupName;
    }

    public void setCacheGroupName(String string) {
        this.cacheGroupName = string;
    }

    public void setStylingRules(StylingRule[] stylingRuleArray) {
        this.styleRules = stylingRuleArray;
    }

    public StylingRule[] getStylingRules() {
        return this.styleRules;
    }

    public boolean hasTextLabel() {
        if (this.styleRules == null) {
            return false;
        }
        for (int i = 0; i < this.styleRules.length; ++i) {
            StylingRule stylingRule = this.styleRules[i];
            if (stylingRule == null || stylingRule.getLabelStyleName() == null) continue;
            String string = stylingRule.getLabelFunction();
            double d = 0.0;
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(d > 0.0)) continue;
            return true;
        }
        return false;
    }

    public String getThemeType() {
        return "GEOM_PREDEFINED";
    }

    public String getCacheGroupName(int n) {
        Integer n2 = new Integer(n);
        Object v = this.sridCache.get(n2);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public Hashtable getSRidCache() {
        return this.sridCache;
    }

    public boolean createCacheGroup(int n) {
        Integer n2 = new Integer(n);
        if (this.sridCache.get(n2) != null) {
            log.info("Cache group for SRid " + n + " already exists.");
            return false;
        }
        log.finer("Creating a cache group for SRID: " + n);
        String string = this.baseTable + "_" + this.spatialColumn + "_" + n + "_PDT_GEOM";
        log.finer("Cache group: " + string);
        boolean bl = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, string, 0, bl);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return false;
        }
        this.sridCache.put(n2, string);
        return true;
    }

    private void getSpatialMetaData() throws SQLException {
        GeomMetaTable geomMetaTable = new GeomMetaTable(this.dataSource);
        geomMetaTable.query(this.getBaseTable(), this.getGeomColumn());
        this.mXMin = geomMetaTable.getXMin();
        this.mYMin = geomMetaTable.getYMin();
        this.mXMax = geomMetaTable.getXMax();
        this.mYMax = geomMetaTable.getYMax();
        geomMetaTable.closeQuery();
        geomMetaTable = null;
    }

    public Rectangle2D getTreeMBR() {
        return this.treeMBR;
    }

    public RTree getTree() {
        return this.styTree;
    }

    public boolean buildRTree(List list) {
        this.styTree = null;
        this.treeMBR = null;
        int n = list.size();
        if (n == 0) {
            return false;
        }
        this.styTree = new RTree(2, 8, 2);
        double[][][] dArrayArray = new double[n][][];
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[2][];
            dArrayArray[i][0] = new double[2];
            dArrayArray[i][1] = new double[2];
            StyledFeatureI styledFeatureI = (StyledFeatureI)list.get(i);
            double[] dArray = styledFeatureI.getGeomMBR();
            dArrayArray[i][0][0] = dArray[0];
            dArrayArray[i][0][1] = dArray[2];
            dArrayArray[i][1][0] = dArray[1];
            dArrayArray[i][1][1] = dArray[3];
            if (this.treeMBR == null) {
                this.treeMBR = new Rectangle2D.Double(dArray[0], dArray[1], 0.0, 0.0);
            } else {
                this.treeMBR.add(dArray[0], dArray[1]);
            }
            this.treeMBR.add(dArray[2], dArray[3]);
            objectArray[i] = styledFeatureI;
            this.styFeats.add(styledFeatureI);
        }
        long l = System.currentTimeMillis();
        try {
            this.styTree.packTree((double[][][])dArrayArray, objectArray);
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
            this.styTree = null;
            this.treeMBR = null;
            this.styFeats.clear();
            return false;
        }
        log.finer("STR pack tree elapsed time: " + (System.currentTimeMillis() - l) + " mseconds for " + n + " geometries");
        return true;
    }

    public Vector searchStyledFeatures(Rectangle2D rectangle2D) {
        double d;
        double d2;
        double d3;
        Vector<StyledFeatureI> vector = new Vector<StyledFeatureI>(100, 100);
        if (this.styTree == null || this.treeMBR == null) {
            return vector;
        }
        double d4 = rectangle2D.getMinX();
        if (MapMaker.isSpecial(d4, d3 = rectangle2D.getMinY(), d2 = rectangle2D.getMaxX(), d = rectangle2D.getMaxY()) || rectangle2D.contains(this.treeMBR)) {
            for (int i = 0; i < this.styFeats.size(); ++i) {
                StyledFeatureI styledFeatureI = (StyledFeatureI)this.styFeats.get(i);
                styledFeatureI.setShapeToNull();
                vector.add(styledFeatureI);
            }
            return vector;
        }
        if (this.treeMBR.intersects(rectangle2D)) {
            boolean bl = false;
            double[][] dArrayArray = new double[][]{new double[2], new double[2]};
            dArrayArray[0][0] = rectangle2D.getMinX();
            dArrayArray[0][1] = rectangle2D.getMaxX();
            dArrayArray[1][0] = rectangle2D.getMinY();
            dArrayArray[1][1] = rectangle2D.getMaxY();
            ArrayList arrayList = new ArrayList(500);
            arrayList.clear();
            long l = System.currentTimeMillis();
            bl = this.styTree.search((double[][])dArrayArray, arrayList);
            log.finer("Rtree search time: " + (System.currentTimeMillis() - l) + " mseconds" + "   #Features returned: " + arrayList.size());
            if (bl) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    StyledFeatureI styledFeatureI = (StyledFeatureI)arrayList.get(i);
                    styledFeatureI.setShapeToNull();
                    vector.add(styledFeatureI);
                }
            }
        }
        return vector;
    }

    public String getXMLDefinition() {
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(stringBuffer);
        stringBuffer.append(">\n");
        this.getInfoFields(stringBuffer);
        StylingRule[] stylingRuleArray = this.getStylingRules();
        if (stylingRuleArray != null) {
            for (int i = 0; i < stylingRuleArray.length; ++i) {
                StylingRule stylingRule = stylingRuleArray[i];
                stringBuffer.append("  <rule" + PredGeomThemeDefinition.getRuleAttributes(stylingRule) + ">\n");
                stringBuffer.append(PredGeomThemeDefinition.getRuleFeatures(stylingRule));
                stringBuffer.append(PredGeomThemeDefinition.getRuleLabel(stylingRule));
                stringBuffer.append("  </rule>\n");
            }
        }
        stringBuffer.append("</styling_rules>");
        return stringBuffer.toString();
    }

    void getCommonAttributes(StringBuffer stringBuffer) {
        String string;
        String string2 = this.getThemeType();
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" theme_type=\"" + string2 + "\"");
        }
        if ((string = this.getKeyColumn()) != null && string.trim().length() > 0) {
            stringBuffer.append(" key_column=\"" + string + "\"");
        }
        int n = this.getCachingMode();
        String string3 = "normal";
        if (n == 2) {
            string3 = "all";
        } else if (n == 3) {
            string3 = "none";
        }
        if (string3 != null && string3.trim().length() > 0) {
            stringBuffer.append(" caching=\"" + string3 + "\"");
        }
        if (this.table_Alias != null) {
            stringBuffer.append(" table_alias=\"" + this.table_Alias + "\"");
        }
    }

    void getInfoFields(StringBuffer stringBuffer) {
        if (this.identifiableColumns == null || this.identifiableColumns.length == 0) {
            return;
        }
        stringBuffer.append("  <hidden_info>\n");
        for (int i = 0; i < this.identifiableColumns.length; ++i) {
            stringBuffer.append("    <field column=\"" + this.identifiableColumns[i].getName() + "\"" + " name=\"" + this.identifiableColumns[i].getDisplayName() + "\"/>\n");
        }
        stringBuffer.append("  </hidden_info>\n");
    }

    public static String getRuleAttributes(StylingRule stylingRule) {
        Object object;
        String string = "";
        if (stylingRule.getStarColumn()) {
            string = string + " column=\"*\"";
        } else {
            object = stylingRule.getAttributeColumnsAsArray();
            if (object != null) {
                string = string + " column=\"" + object[0];
                for (int i = 1; i < ((String[])object).length; ++i) {
                    string = string + "," + object[i];
                }
                string = string + "\"";
            }
        }
        object = stylingRule.getOrderByColumns();
        if (object != null) {
            string = string + " order_by=\"" + (String)object + "\"";
            String string2 = stylingRule.getSortOrder();
            if (string2 != null) {
                string = string + " sort_order=\"" + string2 + "\"";
            }
        }
        return string;
    }

    public static String getRuleFeatures(StylingRule stylingRule) {
        String string;
        String string2 = "    <features";
        boolean bl = stylingRule.isQueryPassThrough();
        if (bl) {
            string2 = string2 + " asis=\"true\"";
        }
        if ((string = stylingRule.getFeatureStyleName()) != null) {
            string2 = string2 + " style=\"" + string + "\"";
        }
        string2 = string2 + ">";
        String string3 = stylingRule.getFeatureCond();
        if (string3 != null) {
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer = PredGeomThemeDefinition.removeXMLEntities(stringBuffer);
            string2 = string2 + " " + stringBuffer.toString();
        }
        string2 = string2 + " </features>\n";
        return string2;
    }

    public static String getRuleLabel(StylingRule stylingRule) {
        String string;
        String string2;
        if (!stylingRule.getLabeled()) {
            return "";
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(stylingRule.getLabelFunction());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stylingRule.getLabelFunction() == null || d <= 0.0) {
            return "";
        }
        String string3 = "    <label";
        String string4 = stylingRule.getLabelColumn();
        if (string4 != null) {
            string3 = string3 + " column=\"" + string4 + "\"";
        }
        if ((string2 = stylingRule.getLabelStyleName()) != null) {
            string3 = string3 + " style=\"" + string2 + "\">";
        }
        if ((string = stylingRule.getLabelFunction()) != null) {
            string3 = string3 + " " + string;
        }
        string3 = string3 + " </label>\n";
        return string3;
    }

    public static StringBuffer removeXMLEntities(StringBuffer stringBuffer) {
        int n = 0;
        String string = stringBuffer.toString();
        while ((n = string.indexOf("<")) > 0) {
            stringBuffer = stringBuffer.replace(n, n + 1, "&lt;");
            string = stringBuffer.toString();
        }
        while ((n = string.indexOf(">")) > 0) {
            stringBuffer = stringBuffer.replace(n, n + 1, "&gt;");
            string = stringBuffer.toString();
        }
        while ((n = string.indexOf("\"")) > 0) {
            stringBuffer = stringBuffer.replace(n, n + 1, "&quot;");
            string = stringBuffer.toString();
        }
        return stringBuffer;
    }

    public String getTableAlias() {
        return this.table_Alias;
    }

    public void setTableAlias(String string) {
        this.table_Alias = string;
    }

    public void setQueryHelper(PredGeomThemeQueryHelper predGeomThemeQueryHelper) {
        this.queryHelper = predGeomThemeQueryHelper;
    }

    public PredGeomThemeQueryHelper getQueryHelper() {
        return this.queryHelper;
    }

    public ThemeStyleInfo[] getStyleList() {
        Object object;
        Cloneable cloneable;
        if (this.styleRules == null || this.styleRules.length == 0) {
            return null;
        }
        StyleCache styleCache = DSManager.getStyleCache(this.dataSource);
        if (styleCache == null) {
            log.warning("cannot locate the style cache for datasource: " + this.dataSource);
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        String string = this.getHighlightStyleName();
        if (string != null) {
            cloneable = styleCache.get(string);
            if (cloneable == null) {
                log.warning("highlight style cannot be found [" + string + "].");
            } else {
                object = new ThemeStyleInfo(string);
                ((ThemeStyleInfo)object).setRendering(true);
                ((ThemeStyleInfo)object).setHighlighting(true);
                ((ThemeStyleInfo)object).setType(cloneable.getModel().getTypeName());
                ((ThemeStyleInfo)object).setDescription(cloneable.getModel().getDescription());
                vector.add(object);
            }
        }
        cloneable = new ArrayList();
        object = new ArrayList();
        for (int i = 0; i < this.styleRules.length; ++i) {
            RenderingRule[] renderingRuleArray;
            StylingRule stylingRule = this.styleRules[i];
            string = stylingRule.getFeatureStyleName();
            if (string == null || ((ArrayList)cloneable).contains(string.toUpperCase())) continue;
            Style style = styleCache.get(string);
            if (style == null) {
                log.warning("render style cannot be found [" + string + "].");
            } else {
                renderingRuleArray = new ThemeStyleInfo(string);
                renderingRuleArray.setRendering(true);
                renderingRuleArray.setType(style.getModel().getTypeName());
                renderingRuleArray.setDescription(style.getModel().getDescription());
                vector.add(renderingRuleArray);
                ((ArrayList)cloneable).add(string.toUpperCase());
            }
            renderingRuleArray = this.styleRules[i].getRenderingRules();
            if (renderingRuleArray != null) {
                for (int j = 0; j < renderingRuleArray.length; ++j) {
                    string = renderingRuleArray[j].getStyleName();
                    if (string == null || ((ArrayList)cloneable).contains(string.toUpperCase())) continue;
                    style = styleCache.get(string);
                    if (style == null) {
                        log.warning("render style cannot be found [" + string + "].");
                        continue;
                    }
                    ThemeStyleInfo themeStyleInfo = new ThemeStyleInfo(string);
                    themeStyleInfo.setRendering(true);
                    themeStyleInfo.setType(style.getModel().getTypeName());
                    themeStyleInfo.setDescription(style.getModel().getDescription());
                    vector.add(themeStyleInfo);
                    ((ArrayList)cloneable).add(string.toUpperCase());
                }
            }
            if ((string = stylingRule.getLabelStyleName()) == null || ((ArrayList)object).contains(string.toUpperCase())) continue;
            style = styleCache.get(string);
            if (style == null) {
                log.warning("label style cannot be found [" + string + "].");
                continue;
            }
            ThemeStyleInfo themeStyleInfo = new ThemeStyleInfo(string);
            themeStyleInfo = new ThemeStyleInfo(string);
            themeStyleInfo.setLabeling(true);
            themeStyleInfo.setType(style.getModel().getTypeName());
            themeStyleInfo.setDescription(style.getModel().getDescription());
            vector.add(themeStyleInfo);
            ((ArrayList)object).add(string.toUpperCase());
        }
        return vector.toArray(new ThemeStyleInfo[vector.size()]);
    }

    public void setRenderingRules(RenderingRule[][] renderingRuleArray) {
        if (this.styleRules == null || renderingRuleArray == null || this.styleRules.length == 0) {
            return;
        }
        for (int i = 0; i < this.styleRules.length; ++i) {
            if (renderingRuleArray.length <= i) continue;
            this.styleRules[i].setRenderingRules(renderingRuleArray[i]);
        }
    }

    public RenderingRule[] getRenderingRules(int n) {
        if (this.styleRules == null || this.styleRules.length == 0 || n >= this.styleRules.length) {
            return null;
        }
        return this.styleRules[n].getRenderingRules();
    }

    public RenderingRule[] getRenderingRules() {
        if (this.styleRules == null || this.styleRules.length == 0) {
            return null;
        }
        return this.styleRules[0].getRenderingRules();
    }

    public void setRenderingRules(RenderingRule[] renderingRuleArray) {
        if (this.styleRules == null || this.styleRules.length == 0) {
            return;
        }
        this.styleRules[0].setRenderingRules(renderingRuleArray);
    }

    public String getBaseColumnType() {
        return this.baseColumnType;
    }

    public void setBaseColumnType(String string) {
        this.baseColumnType = string;
    }

    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.baseTable);
        basicThemeInfo.setType("GEOMETRY");
        basicThemeInfo.setKeyColumn(this.getKeyColumn());
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(this.getGeomColumn());
        return basicThemeInfo;
    }

    public String[] getRenderingStyles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.styleRules != null) {
            for (int i = 0; i < this.styleRules.length; ++i) {
                RenderingRule[] renderingRuleArray;
                String string = this.styleRules[i].getFeatureStyleName();
                if (string != null && !arrayList.contains(string.toUpperCase())) {
                    arrayList.add(string.toUpperCase());
                }
                if ((renderingRuleArray = this.styleRules[i].getRenderingRules()) == null) continue;
                for (int j = 0; j < renderingRuleArray.length; ++j) {
                    string = renderingRuleArray[j].getStyleName();
                    if (string == null || arrayList.contains(string.toUpperCase())) continue;
                    arrayList.add(string.toUpperCase());
                }
            }
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getLabelingStyles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.styleRules != null) {
            for (int i = 0; i < this.styleRules.length; ++i) {
                String string = this.styleRules[i].getLabelStyleName();
                if (string == null || arrayList.contains(string.toUpperCase())) continue;
                arrayList.add(string.toUpperCase());
            }
        }
        if (arrayList.size() < 1) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

