/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BuiltinStyles;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.DataException;
import oracle.sdovis.Graticule;
import oracle.sdovis.HMPointFeature;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.query.SDOBoxFilter;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.PredGeomThemeQueryHelper;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.I18nUtil;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class PredGeomThemeProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected Theme owner;
    protected PredGeomThemeDefinition def;
    LocalThemeDataProducer features;
    Rectangle2D mDataExtent;
    private Object[] bindingParameters = null;
    private PreparedStatement stmt = null;
    private boolean aborted = false;
    private String resourceClass = null;
    private static final int YIELD_COUNT = 1000;

    private PredGeomThemeProducer() {
    }

    public PredGeomThemeProducer(Theme theme, Object[] objectArray) {
        this.owner = theme;
        this.def = (PredGeomThemeDefinition)theme.getDefinition();
        PredGeomThemeQueryHelper predGeomThemeQueryHelper = this.def.getQueryHelper();
        if (predGeomThemeQueryHelper == null) {
            predGeomThemeQueryHelper = new PredGeomThemeQueryHelper(this.def);
            this.def.setQueryHelper(predGeomThemeQueryHelper);
        }
        this.bindingParameters = objectArray;
        this.resourceClass = this.def.getResourceClassName();
    }

    public Theme getTheme() {
        return this.owner;
    }

    public int size() {
        if (this.features != null) {
            return this.features.size();
        }
        return 0;
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(styledFeatureIArray);
    }

    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        this.aborted = false;
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        List list = null;
        if ((this.def.getSrid() == visContext.getMasterSRID() || visContext.getMasterSRID() == 0) && this.def.getCachingMode() == 2) {
            if (this.def.getTree() == null) {
                try {
                    VisContext visContext2 = new VisContext();
                    visContext2.setMasterSRID(this.def.getSrid());
                    this.pinAll(visContext2);
                }
                catch (Throwable throwable) {
                    log.severe(throwable.getMessage());
                    this.def.setCachingMode(1);
                    return this.prepareData(rectangle2D, visContext);
                }
            }
            list = this.fetchFromInMemoryCache(rectangle2D, visContext);
        } else {
            try {
                list = this.loadFeaturesInWindow(d, d2, d3, d4, visContext);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                if (string != null && string.indexOf("ORA-01013") < 0) {
                    log.log(Level.SEVERE, "*** Exception while querying theme: " + this.def.getName(), exception);
                    throw new DataException("Exception while querying theme: " + this.def.getName(), exception);
                }
                throw new DataException("Aborted by user.", exception);
            }
        }
        return this.setStyledFeatures(list);
    }

    Vector fetchFromInMemoryCache(Rectangle2D rectangle2D, VisContext visContext) {
        Vector vector;
        Object object;
        boolean bl = false;
        Rectangle2D rectangle2D2 = rectangle2D;
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMaxX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxY();
        log.finest("Search window: " + d + "," + d3 + "," + d2 + "," + d4);
        Vector<Object> vector2 = new Vector<Object>(128, 128);
        double d5 = visContext.getCurrentScale();
        this.getTheme().setShowLabels(true);
        if (d5 != Double.POSITIVE_INFINITY && d5 != Double.NEGATIVE_INFINITY) {
            double d6 = d5;
            if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                object = DSManager.getSRSCache(this.def.getDataSourceName());
                SRS sRS = ((SRSCache)object).get(this.def.getSrid());
                if (sRS != null) {
                    d6 = rectangle2D != null ? sRS.getRatioScale(d5, new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY())) : sRS.getRatioScale(d5, null);
                    log.finer("Ratio scale to compare: " + d6);
                } else {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                    return vector2;
                }
            }
            if (!this.getTheme().getDecorator().withinScaleLimits(d6)) {
                log.finer("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                return vector2;
            }
            if (!this.getTheme().getDecorator().withinLabelScaleLimits(d6)) {
                log.finer("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                this.getTheme().setShowLabels(false);
            }
            if (visContext.getRotation() != 0.0) {
                object = Util.rotateMBR(d, d3, d2, d4, visContext.getRotation());
                if (object != null) {
                    d = Math.min((double)object[0], d);
                    d3 = Math.min((double)object[1], d3);
                    d2 = Math.max((double)object[2], d2);
                    d4 = Math.max((double)object[3], d4);
                    log.finest("Rotation angle: " + visContext.getRotation());
                    log.finest("Search window for rotation: " + d + "," + d3 + "," + d2 + "," + d4);
                    bl = true;
                    rectangle2D2 = new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
                } else {
                    log.info("Rotated MBR is null. Rotation ignored.");
                }
            }
        }
        ResourceBundle resourceBundle = null;
        if (this.resourceClass != null && visContext.getUserLanguage() != null) {
            resourceBundle = I18nUtil.getRB(this.resourceClass, visContext.getUserLanguage());
        }
        if ((vector = this.def.searchStyledFeatures(rectangle2D2)) != null) {
            object = visContext.getProjection();
            for (int i = 0; i < vector.size(); ++i) {
                Object object2;
                StyledFeatureI styledFeatureI = (StyledFeatureI)vector.get(i);
                JSDOGeometry jSDOGeometry = styledFeatureI.getGeometry();
                if (bl && ((object2 = Util.rotateGeometry(jSDOGeometry, (d + d2) / 2.0, (d3 + d4) / 2.0, visContext.getRotation())) == null || (jSDOGeometry = JSDOGeometry.recast((JGeometry)object2)) == null) || (jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null) continue;
                if (object != null) {
                    object2 = object.getOpposite();
                    if (jSDOGeometry.pointInPolygon(((Proj.P2)object2).x, ((Proj.P2)object2).y) || (jSDOGeometry = SRS.proj(jSDOGeometry, (Proj)object, 0)) == null) continue;
                }
                object2 = this.getNewStyledFeatureInstance();
                object2.setShapeSimplified(styledFeatureI.isShapeSimplified());
                object2.setID(styledFeatureI.getID());
                object2.setFeatureStyleName(styledFeatureI.getFeatureStyleName());
                object2.setDataSource(styledFeatureI.getDataSource());
                String string = styledFeatureI.getLabel();
                object2.setLabel(styledFeatureI.getLabel());
                if (string != null && resourceBundle != null) {
                    object2.setTranslatedLabel(I18nUtil.getTranslation(string, resourceBundle));
                }
                object2.setLabelStyleName(styledFeatureI.getLabelStyleName());
                object2.setRenderableAttributes(styledFeatureI.getRenderableAttributes());
                object2.setIdentifiableAttributes(styledFeatureI.getIdentifiableAttributes());
                object2.setRenderingRules(styledFeatureI.getRenderingRules());
                object2.setGeometry(jSDOGeometry);
                vector2.addElement(object2);
            }
        }
        return vector2;
    }

    public void postPreparation(VisContext visContext) {
        if (this.features != null) {
            this.features.postPreparation(visContext);
        }
    }

    public StyledFeatureI getStyledFeature(int n) {
        if (this.features != null) {
            return this.features.getStyledFeature(n);
        }
        return null;
    }

    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    public StyledFeatureI[] getStyledFeatures() {
        if (this.features != null) {
            return this.features.getStyledFeatures();
        }
        return null;
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        if (this.features != null) {
            return this.features.getSelectedFeaturesAsTheme(rectangle2D, string);
        }
        return null;
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        if (this.features != null) {
            return this.features.getSelectedFeatures(rectangle2D);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public List loadFeaturesInWindow(double var1_1, double var3_3, double var5_4, double var7_5, VisContext var9_2) throws Exception {
        block91: {
            block86: {
                block87: {
                    block95: {
                        var10_6 = System.currentTimeMillis();
                        var12_7 = new ArrayList<StyledFeatureI>(1000);
                        var13_8 = null;
                        var14_9 = DSManager.getSRSCache(this.def.getDataSourceName());
                        var15_10 = var14_9.get(this.def.getSrid());
                        var16_11 = false;
                        var17_12 = null;
                        if (var15_10 != null) {
                            var16_11 = var15_10.isGeodetic();
                            var17_12 = var15_10.getUnit();
                        } else if (this.def.getSrid() > 0) {
                            PredGeomThemeProducer.log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                        }
                        var18_13 = var1_1;
                        var20_14 = var3_3;
                        var22_15 = var5_4;
                        var24_16 = var7_5;
                        var26_17 = false;
                        var27_18 = null;
                        try {
                            var27_18 = DSUtil.getDBConnection(this.def.getDataSourceName(), var9_2);
                            if (var27_18 == null) {
                                PredGeomThemeProducer.log.log(Level.SEVERE, "Cannot obtain connection for data source: " + this.def.getDataSourceName() + ". Max connection limit reached?");
                                return null;
                            }
                        }
                        catch (Exception var28_19) {
                            PredGeomThemeProducer.log.log(Level.SEVERE, "Exception when obtaining connection for data source: " + this.def.getDataSourceName(), var28_19);
                            return null;
                        }
                        var28_20 = var9_2.getCurrentScale();
                        if (var9_2.getMasterSRID() <= 0 || this.def.getSrid() <= 0 || this.def.getSrid() == var9_2.getMasterSRID()) break block95;
                        if (var28_20 == Infinity || var28_20 == -Infinity) ** GOTO lbl51
                        var30_21 = new double[]{var18_13, var20_14, var22_15, var24_16};
                        PredGeomThemeProducer.log.log(Level.FINEST, "Query box to be transformed from " + var9_2.getMasterSRID() + " to " + this.def.getSrid() + " (" + var18_13 + "," + var20_14 + " " + var22_15 + "," + var24_16 + ")");
                        var31_24 = Util.convertMBR(var30_21, var9_2.getMasterSRID(), this.def.getSrid(), var27_18);
                        if (var31_24 != null) {
                            var18_13 = (double)var31_24[0];
                            var20_14 = (double)var31_24[1];
                            var22_15 = (double)var31_24[2];
                            var24_16 = (double)var31_24[3];
                            PredGeomThemeProducer.log.log(Level.FINEST, "Transformed query box:(" + var18_13 + "," + var20_14 + " " + var22_15 + "," + var24_16 + ")");
                            var26_17 = true;
                        } else {
                            PredGeomThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01024"));
                            try {
                                if (var27_18 != null) {
                                    DSUtil.closeDBConnection(var27_18, this.def.getDataSourceName());
                                }
                            }
                            catch (Exception var32_25) {
                                PredGeomThemeProducer.log.warning(var32_25.getMessage());
                            }
                            return var12_7;
lbl51:
                            // 1 sources

                            var26_17 = true;
                        }
                    }
                    this.getTheme().setShowLabels(true);
                    if (var28_20 != Infinity && var28_20 != -Infinity) {
                        var30_22 = Math.abs(var24_16 - var20_14) / Math.abs(var7_5 - var3_3);
                        PredGeomThemeProducer.log.finer("[Master scale] " + var28_20 + " [Theme scale factor] " + var30_22);
                        var32_26 = var28_20 * var30_22;
                        if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                            if (var9_2.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != var9_2.getMasterSRID() && var9_2.isTileRequest()) {
                                var15_10 = var14_9.get(var9_2.getMasterSRID());
                                var34_28 = (var1_1 + var5_4) / 2.0;
                                var36_31 = (var3_3 + var7_5) / 2.0;
                                var30_22 = 1.0;
                            } else {
                                var34_28 = (var18_13 + var22_15) / 2.0;
                                var36_31 = (var20_14 + var24_16) / 2.0;
                            }
                            if (var9_2.isTileRequest() && var15_10.isGeodetic()) {
                                var34_28 = 0.0;
                                var36_31 = 0.0;
                            }
                            if (var15_10 != null) {
                                var32_26 = var15_10.getRatioScale(var28_20 * var30_22, new Point2D.Double(var34_28, var36_31));
                                PredGeomThemeProducer.log.finer("Ratio scale to compare: " + var32_26);
                            } else {
                                PredGeomThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                                try {
                                    if (var27_18 != null) {
                                        DSUtil.closeDBConnection(var27_18, this.def.getDataSourceName());
                                    }
                                }
                                catch (Exception var38_33) {
                                    PredGeomThemeProducer.log.warning(var38_33.getMessage());
                                }
                                return var12_7;
                            }
                        }
                        if (!this.getTheme().getDecorator().withinScaleLimits(var32_26)) {
                            PredGeomThemeProducer.log.finer("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                            try {
                                if (var27_18 != null) {
                                    DSUtil.closeDBConnection(var27_18, this.def.getDataSourceName());
                                }
                            }
                            catch (Exception var34_29) {
                                PredGeomThemeProducer.log.warning(var34_29.getMessage());
                            }
                            return var12_7;
                        }
                        if (!this.getTheme().getDecorator().withinLabelScaleLimits(var32_26)) {
                            PredGeomThemeProducer.log.finer("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                            this.getTheme().setShowLabels(false);
                        }
                    }
                    v0 = var30_23 = var16_11 != false && var22_15 - var18_13 >= 1.8 && var22_15 - var18_13 < 120.0;
                    if (var30_23) {
                        var18_13 = Math.floor(var18_13);
                        PredGeomThemeProducer.log.finest("ptvpxfmfxed: xl=" + var18_13);
                    }
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        this.gotoWorkspace(var27_18);
                    }
                    var31_24 = null;
                    var32_27 = null;
                    var33_35 = 0;
                    var34_30 = 0L;
                    var36_32 = 0L;
                    var38_34 = 0L;
                    var40_36 = null;
                    var34_30 = System.currentTimeMillis();
                    var41_37 = this.getOrCreateCacheGroup(var26_17, var9_2);
                    var42_39 = MapMaker.isSpecial(var18_13, var20_14, var22_15, var24_16);
                    var43_40 = new SDOBoxFilter(this.def.getDataSourceName(), this.def.getQueryHelper().getGeomColumn());
                    PredGeomThemeProducer.log.finest("[ " + this.def.getName() + " ]:  " + var18_13 + "," + var20_14 + "," + var22_15 + "," + var24_16);
                    var44_41 = false;
                    if (var42_39 && var9_2.getRotation() != 0.0) {
                        PredGeomThemeProducer.log.warning("Rotation is currently ignored for full extent.");
                    } else if (var9_2.getRotation() != 0.0 && !var42_39) {
                        if (var9_2.getRotation() < -360.0 || var9_2.getRotation() > 360.0) {
                            PredGeomThemeProducer.log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                        } else {
                            var45_42 = Util.rotateMBR(var18_13, var20_14, var22_15, var24_16, var9_2.getRotation());
                            if (var45_42 != null) {
                                var18_13 = Math.min((double)var45_42[0], var18_13);
                                var20_14 = Math.min((double)var45_42[1], var20_14);
                                var22_15 = Math.max((double)var45_42[2], var22_15);
                                var24_16 = Math.max((double)var45_42[3], var24_16);
                                PredGeomThemeProducer.log.finest("Rotation angle: " + var9_2.getRotation());
                                PredGeomThemeProducer.log.finest("Search window for rotation: " + var18_13 + "," + var20_14 + "," + var22_15 + "," + var24_16);
                                var44_41 = true;
                            } else {
                                PredGeomThemeProducer.log.info("Rotated MBR is null. Rotation ignored.");
                            }
                        }
                    }
                    var43_40.setFilterBox(var18_13, var20_14, var22_15, var24_16, this.def.getSrid());
                    var45_42 = (AbstractDBDataSource)DSManager.get(this.def.getDataSourceName());
                    var46_43 = var45_42.getDbProductVersion();
                    if (this.getTheme().getDecorator().getMinimumFeatureSizePx() > 0 && (var46_43.indexOf(" 10.2") > 0 || var46_43.indexOf(" 10.1.0.3") > 0 || var46_43.indexOf(" 10.1.0.4") > 0 || var46_43.indexOf(" 11.") > 0)) {
                        var47_44 = var9_2.getDeviceWindow().getWidth();
                        var49_46 = var9_2.getDeviceWindow().getHeight();
                        var51_48 = (var22_15 - var18_13) / var47_44;
                        var53_50 = (var24_16 - var20_14) / var49_46;
                        var55_52 = Math.min(var51_48, var53_50) * (double)this.getTheme().getDecorator().getMinimumFeatureSizePx();
                        if (var16_11) {
                            var57_54 = 6378137.0;
                            var55_52 *= 3.141592653589793 * var57_54 / 180.0;
                        }
                        var43_40.setMinResoultion(var55_52);
                    }
                    var40_36 = var47_45 = this.def.getQueryHelper().buildQueryString(var42_39, var43_40, var9_2);
                    PredGeomThemeProducer.log.finest("Theme query [ " + this.def.name + " ]: " + var47_45);
                    var31_24 = this.def.getQueryHelper().prepare((OracleConnection)var27_18, var47_45, var43_40, this.bindingParameters, var9_2);
                    var31_24.setFetchSize(this.owner.getFetchSize());
                    PredGeomThemeProducer.log.finer("[ " + this.def.getName() + " ] Fetch size: " + var31_24.getFetchSize());
                    var36_32 = System.currentTimeMillis();
                    var32_27 = (OracleResultSet)var31_24.executeQuery();
                    var38_34 = System.currentTimeMillis();
                    if (var32_27 != null) break block86;
                    var48_56 = null;
                    var67_58 = null;
                    if (this.getTheme().getDecorator().getWorkspaceName() == null) break block87;
                    try {
                        Util.gotoWorkspace(var27_18, "LIVE");
                    }
                    catch (Exception var68_61) {
                        PredGeomThemeProducer.log.warning(var68_61.getMessage());
                    }
                }
                var68_62 = System.currentTimeMillis();
                try {
                    if (var32_27 != null) {
                        var32_27.close();
                    }
                }
                catch (Exception var70_67) {
                    PredGeomThemeProducer.log.warning(var70_67.getMessage());
                }
                try {
                    if (var31_24 != null) {
                        var31_24.close();
                    }
                }
                catch (Exception var70_67) {
                    PredGeomThemeProducer.log.warning(var70_67.getMessage());
                }
                try {
                    if (var27_18 != null) {
                        DSUtil.closeDBConnection(var27_18, this.def.getDataSourceName());
                    }
                }
                catch (Exception var70_67) {
                    PredGeomThemeProducer.log.warning(var70_67.getMessage());
                }
                if (this.aborted) {
                    var12_7.clear();
                }
                PredGeomThemeProducer.log.info("[ " + this.def.name + " ] sql exec time: " + (var38_34 - var36_32) + "ms, total time loading " + var33_35 + " features: " + (var68_62 - var10_6) + "ms.");
                TopThemeQueries.add(var68_62 - var10_6, this.getTheme().getName(), this.getTheme().getDataSourceName(), var40_36, "features loaded = " + var33_35);
                return var48_56;
            }
            var48_57 = var32_27.getMetaData();
            var49_47 = var48_57.getColumnCount();
            this.mDataExtent = null;
            var50_70 = var9_2.getProjection();
            var51_49 = this.owner.getDecorator().isReorientLines();
            var52_71 = this.owner.getDecorator().isFastUnpickle();
            var53_51 = this.owner.getDecorator().isSimplifiedShapes();
            var54_72 = this.owner.getDecorator().allowNakedPoints;
            var55_53 = this.buildRenderingRuleHash();
            var56_73 = -1;
            var57_55 = null;
            if (this.resourceClass != null && var9_2.getUserLanguage() != null) {
                var57_55 = I18nUtil.getRB(this.resourceClass, var9_2.getUserLanguage());
            }
            while (!this.aborted && var32_27.next()) {
                var13_8 = this.getNewStyledFeatureInstance();
                var13_8.setShapeSimplified(var53_51);
                var58_74 = var32_27.getString(1);
                var59_75 = null;
                var60_76 = var58_74;
                if (var26_17) {
                    var60_76 = (String)var58_74 + var9_2.getMasterSRID();
                }
                if ((var59_75 = this.loadGeom(var41_37, (ResultSet)var32_27, (String)var60_76, var52_71)) == null) continue;
                if (var44_41) {
                    var61_77 = (var18_13 + var22_15) / 2.0;
                    var63_82 = (var20_14 + var24_16) / 2.0;
                    if (var26_17) {
                        var61_77 = (var1_1 + var5_4) / 2.0;
                        var63_82 = (var3_3 + var7_5) / 2.0;
                    }
                    if ((var65_83 = Util.rotateGeometry((JGeometry)var59_75, var61_77, var63_82, var9_2.getRotation())) == null) {
                        PredGeomThemeProducer.log.finer("Unable to rotate geometry. Key: " + (String)var58_74);
                        continue;
                    }
                    var59_75 = JSDOGeometry.recast(var65_83);
                    if (var59_75 == null) continue;
                }
                if ((var59_75 = var9_2.getSrs().shift((JSDOGeometry)var59_75, var9_2.getQueryWindow())) == null) continue;
                if (var50_70 != null) {
                    var61_78 = var50_70.getOpposite();
                    if (var59_75.pointInPolygon(var61_78.x, var61_78.y) || (var59_75 = SRS.proj((JSDOGeometry)var59_75, var50_70, 0)) == null) continue;
                }
                var61_79 = var59_75.getMBR();
                this.extendMbr(var61_79);
                var13_8.setGeometry((JSDOGeometry)var59_75);
                var13_8.setID((String)var58_74);
                var13_8.setResultSetPosition(++var56_73);
                var13_8.setDataSource(this.def.getDataSourceName());
                var13_8.setFeatureStyleName(var32_27.getString(3));
                if (var32_27.getFloat(6) > 0.0f) {
                    this.loadLabel((ResultSet)var32_27, var13_8, var48_57, var57_55);
                }
                var13_8.setAllowNakedPoints(var54_72);
                if (var49_47 > 7) {
                    this.loadAttributeData((ResultSet)var32_27, var13_8, var49_47, var48_57);
                }
                if (var55_53 != null) {
                    var62_81 = Integer.parseInt(var32_27.getString(7).substring(5));
                    var13_8.setRenderingRules((RenderingRule[])var55_53.get(var13_8.getFeatureStyleName().toUpperCase() + "#" + var62_81));
                }
                var12_7.add(var13_8);
                if (++var33_35 % 1000 == 0) {
                    Thread.currentThread();
                    Thread.yield();
                }
                if (var33_35 % 5000 != 0) continue;
                PredGeomThemeProducer.log.finest("# features loaded so far: " + var33_35);
            }
            if (var42_39) {
                this.loadNewFeatures(var12_7);
            } else {
                var58_74 = new Rectangle2D.Double(var18_13, var20_14, var22_15 - var18_13, var24_16 - var20_14);
                this.loadEditFeatures((Rectangle2D)var58_74, var12_7);
            }
            if (var50_70 != null && var24_16 - var20_14 > 45.0) {
                var58_74 = var50_70.getCenter();
                var59_75 = new Graticule(var50_70, var58_74.x, var58_74.y, 15.0, 3.0, 0);
                var60_76 = var59_75.get();
                var61_80 = Graticule.getStyle();
                for (var62_81 = 0; var62_81 < var60_76.length; ++var62_81) {
                    var13_8 = this.getNewStyledFeatureInstance();
                    var13_8.setGeometry(var60_76[var62_81]);
                    var13_8.setFeatureStyle(var61_80);
                    var12_7.add(var13_8);
                }
            }
            var58_74 = var12_7;
            var67_59 = null;
            if (this.getTheme().getDecorator().getWorkspaceName() == null) break block91;
            try {
                Util.gotoWorkspace(var27_18, "LIVE");
            }
            catch (Exception var68_63) {
                PredGeomThemeProducer.log.warning(var68_63.getMessage());
            }
        }
        var68_64 = System.currentTimeMillis();
        try {
            if (var32_27 != null) {
                var32_27.close();
            }
        }
        catch (Exception var70_68) {
            PredGeomThemeProducer.log.warning(var70_68.getMessage());
        }
        try {
            if (var31_24 != null) {
                var31_24.close();
            }
        }
        catch (Exception var70_68) {
            PredGeomThemeProducer.log.warning(var70_68.getMessage());
        }
        try {
            if (var27_18 != null) {
                DSUtil.closeDBConnection(var27_18, this.def.getDataSourceName());
            }
        }
        catch (Exception var70_68) {
            PredGeomThemeProducer.log.warning(var70_68.getMessage());
        }
        if (this.aborted) {
            var12_7.clear();
        }
        PredGeomThemeProducer.log.info("[ " + this.def.name + " ] sql exec time: " + (var38_34 - var36_32) + "ms, total time loading " + var33_35 + " features: " + (var68_64 - var10_6) + "ms.");
        TopThemeQueries.add(var68_64 - var10_6, this.getTheme().getName(), this.getTheme().getDataSourceName(), var40_36, "features loaded = " + var33_35);
        return var58_74;
        catch (Exception var41_38) {
            try {
                throw var41_38;
            }
            catch (Throwable var66_84) {
                var67_60 = null;
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(var27_18, "LIVE");
                    }
                    catch (Exception var68_65) {
                        PredGeomThemeProducer.log.warning(var68_65.getMessage());
                    }
                }
                var68_66 = System.currentTimeMillis();
                try {
                    if (var32_27 != null) {
                        var32_27.close();
                    }
                }
                catch (Exception var70_69) {
                    PredGeomThemeProducer.log.warning(var70_69.getMessage());
                }
                try {
                    if (var31_24 != null) {
                        var31_24.close();
                    }
                }
                catch (Exception var70_69) {
                    PredGeomThemeProducer.log.warning(var70_69.getMessage());
                }
                try {
                    if (var27_18 != null) {
                        DSUtil.closeDBConnection(var27_18, this.def.getDataSourceName());
                    }
                }
                catch (Exception var70_69) {
                    PredGeomThemeProducer.log.warning(var70_69.getMessage());
                }
                if (this.aborted) {
                    var12_7.clear();
                }
                PredGeomThemeProducer.log.info("[ " + this.def.name + " ] sql exec time: " + (var38_34 - var36_32) + "ms, total time loading " + var33_35 + " features: " + (var68_66 - var10_6) + "ms.");
                TopThemeQueries.add(var68_66 - var10_6, this.getTheme().getName(), this.getTheme().getDataSourceName(), var40_36, "features loaded = " + var33_35);
                throw var66_84;
            }
        }
    }

    void gotoWorkspace(Connection connection) throws DataException {
        try {
            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                    Util.gotoWorkspaceDate(connection, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                    Util.gotoWorkspaceSavedPoint(connection, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                } else {
                    Util.gotoWorkspace(connection, this.getTheme().getDecorator().getWorkspaceName());
                }
            }
        }
        catch (Exception exception) {
            String string = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
            if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                string = string + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
            } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                string = string + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
            }
            log.log(Level.SEVERE, string, exception);
            throw new DataException(string);
        }
    }

    CacheGroup getOrCreateCacheGroup(boolean bl, VisContext visContext) {
        CacheGroup cacheGroup;
        String string = this.def.getCacheGroupName();
        if (bl && (string = this.def.getCacheGroupName(visContext.getMasterSRID())) == null && this.def.cachingMode != 3) {
            if (!this.def.createCacheGroup(visContext.getMasterSRID())) {
                log.severe("Could not create Cache group for SRid = " + visContext.getMasterSRID());
                return null;
            }
            string = this.def.getCacheGroupName(visContext.getMasterSRID());
        }
        if ((cacheGroup = CacheMgr2.getGroup(this.def.getCacheSubRegionName(), string)) == null && this.def.getCachingMode() != 3) {
            CacheMgr2.createGeomGroup(this.def.getCacheSubRegionName(), string, 0, false);
            cacheGroup = CacheMgr2.getGroup(this.def.getCacheSubRegionName(), string);
        }
        return cacheGroup;
    }

    /*
     * Loose catch block
     */
    public void pinAll(VisContext visContext) throws DataException, SQLException {
        block13: {
            if (!CacheMgr2.isReady()) {
                throw new DataException("Cache not available.");
            }
            Connection connection = null;
            try {
                connection = DSUtil.getDBConnection(this.def.getDataSourceName(), visContext);
            }
            catch (Exception exception) {
                log.severe("Cannot obtain connection for data source: " + this.def.getDataSourceName());
                throw new DataException(exception);
            }
            this.def.setCachingMode(1);
            String string = this.def.getQueryHelper().buildQueryString(true, null, visContext);
            log.finest("loading all: " + this.def.getName() + "...");
            this._loadAllFeatures(connection, string);
            this.def.setCachingMode(2);
            Object var6_5 = null;
            try {
                if (connection != null) {
                    DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                }
                break block13;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block13;
            {
                catch (Exception exception) {
                    log.log(Level.SEVERE, "*** Exception while pinning theme: " + this.def.getName(), exception);
                    log.warning("*** Will use normal caching scheme for theme: " + this.def.getName());
                    this.def.setCachingMode(1);
                    CacheMgr2.removeGroup(this.def.getCacheSubRegionName(), this.def.getCacheGroupName());
                    throw new DataException("Exception while pinning theme: " + this.def.getName(), exception);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    log.log(Level.SEVERE, "*** Reached cache memory limit while pinning theme: " + this.def.getName(), outOfMemoryError);
                    log.warning("*** Will use normal caching scheme for theme: " + this.def.getName());
                    this.def.setCachingMode(1);
                    CacheMgr2.removeGroup(this.def.getCacheSubRegionName(), this.def.getCacheGroupName());
                    System.gc();
                    throw new DataException("Exception while pinning theme: " + this.def.getName(), outOfMemoryError);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (connection != null) {
                        DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
    }

    public void destroy() {
        if (this.features != null) {
            this.features.destroy();
        }
        this.features = null;
    }

    public void abort() {
        this.aborted = true;
        try {
            if (this.stmt != null) {
                this.stmt.cancel();
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    public List fetchFeatures(SpatialOp spatialOp, VisContext visContext, boolean bl) throws Exception {
        Object object;
        long l;
        long l2;
        int n;
        OracleResultSet oracleResultSet;
        Connection connection;
        long l3;
        block53: {
            boolean bl2;
            StyledFeatureI styledFeatureI;
            ArrayList<StyledFeatureI> arrayList;
            block48: {
                List list;
                block49: {
                    l3 = System.currentTimeMillis();
                    arrayList = new ArrayList<StyledFeatureI>();
                    styledFeatureI = null;
                    SRSCache sRSCache = DSManager.getSRSCache(this.def.getDataSourceName());
                    SRS sRS = sRSCache.get(this.def.getSrid());
                    boolean bl3 = false;
                    String string = null;
                    if (sRS != null) {
                        bl3 = sRS.isGeodetic();
                        string = sRS.getUnit();
                    } else if (this.def.getSrid() > 0) {
                        log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                    }
                    connection = null;
                    try {
                        connection = DSUtil.getDBConnection(this.def.getDataSourceName(), visContext);
                    }
                    catch (Exception exception) {
                        log.log(Level.SEVERE, "Cannot obtain connection for data source: " + this.def.getDataSourceName(), exception);
                        return null;
                    }
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        this.gotoWorkspace(connection);
                    }
                    this.stmt = null;
                    oracleResultSet = null;
                    n = 0;
                    long l4 = 0L;
                    l2 = 0L;
                    l = 0L;
                    l4 = System.currentTimeMillis();
                    AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.def.getDataSourceName());
                    String string2 = abstractDBDataSource.getDbProductVersion();
                    bl2 = visContext.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != visContext.getMasterSRID();
                    String string3 = this.def.getQueryHelper().buildQueryString(false, spatialOp, visContext);
                    log.finest("Theme SpatialOp query [ " + this.def.name + " ]: " + string3);
                    this.stmt = this.def.getQueryHelper().prepare((OracleConnection)connection, string3, spatialOp, this.bindingParameters, visContext);
                    this.stmt.setFetchSize(this.owner.getFetchSize());
                    log.finer("Fetch size: " + this.stmt.getFetchSize());
                    l2 = System.currentTimeMillis();
                    oracleResultSet = (OracleResultSet)this.stmt.executeQuery();
                    l = System.currentTimeMillis();
                    if (oracleResultSet != null) break block48;
                    list = null;
                    Object var38_25 = null;
                    if (this.getTheme().getDecorator().getWorkspaceName() == null) break block49;
                    try {
                        Util.gotoWorkspace(connection, "LIVE");
                    }
                    catch (Exception exception) {
                        log.warning(exception.getMessage());
                    }
                }
                long l5 = System.currentTimeMillis();
                try {
                    if (oracleResultSet != null) {
                        oracleResultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (connection != null) {
                        DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                log.info("[ " + this.def.name + " ] SpatialOp sql exec time: " + (l - l2) + "ms, total time loading " + n + " features: " + (l5 - l3) + "ms.");
                return list;
            }
            ResultSetMetaData resultSetMetaData = oracleResultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            this.mDataExtent = null;
            Proj proj = visContext.getProjection();
            boolean bl4 = this.owner.getDecorator().isReorientLines();
            boolean bl5 = this.owner.getDecorator().isFastUnpickle();
            boolean bl6 = this.owner.getDecorator().isSimplifiedShapes();
            Hashtable hashtable = this.buildRenderingRuleHash();
            while (oracleResultSet.next()) {
                Object object2;
                styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setShapeSimplified(bl6);
                object = oracleResultSet.getString(1);
                JSDOGeometry jSDOGeometry = null;
                Object object3 = object;
                if (bl2) {
                    object3 = (String)object + visContext.getMasterSRID();
                }
                if ((jSDOGeometry = this.loadGeom((ResultSet)oracleResultSet, bl5)) == null || (jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null) continue;
                if (proj != null) {
                    object2 = proj.getOpposite();
                    if (jSDOGeometry.pointInPolygon(((Proj.P2)object2).x, ((Proj.P2)object2).y) || (jSDOGeometry = SRS.proj(jSDOGeometry, proj, 0)) == null) continue;
                }
                object2 = jSDOGeometry.getMBR();
                if (this.mDataExtent == null) {
                    this.mDataExtent = new Rectangle2D.Double((double)object2[0], (double)object2[1], 0.0, 0.0);
                } else {
                    this.mDataExtent.add((double)object2[0], (double)object2[1]);
                }
                this.mDataExtent.add((double)object2[2], (double)object2[3]);
                styledFeatureI.setGeometry(jSDOGeometry);
                styledFeatureI.setID((String)object);
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                if (!bl) {
                    styledFeatureI.setFeatureStyleName(oracleResultSet.getString(4));
                } else {
                    String string = this.def.getHighlightStyleName();
                    if (string == null) {
                        string = BuiltinStyles.highlightColorStyleName;
                    }
                    styledFeatureI.setFeatureStyleName(string);
                }
                if (oracleResultSet.getFloat(6) > 0.0f) {
                    styledFeatureI.setLabel(oracleResultSet.getString(4));
                    styledFeatureI.setLabelStyleName(oracleResultSet.getString(5));
                }
                if (n2 > 7) {
                    this.loadAttributeData((ResultSet)oracleResultSet, styledFeatureI, n2, resultSetMetaData);
                }
                if (!bl && hashtable != null) {
                    int n3 = Integer.parseInt(oracleResultSet.getString(7).substring(5));
                    styledFeatureI.setRenderingRules((RenderingRule[])hashtable.get(styledFeatureI.getFeatureStyleName().toUpperCase() + "#" + n3));
                }
                arrayList.add(styledFeatureI);
                if (++n % 1000 != 0) continue;
                Thread.currentThread();
                Thread.yield();
            }
            object = arrayList;
            Object var38_26 = null;
            if (this.getTheme().getDecorator().getWorkspaceName() == null) break block53;
            try {
                Util.gotoWorkspace(connection, "LIVE");
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
        }
        long l6 = System.currentTimeMillis();
        try {
            if (oracleResultSet != null) {
                oracleResultSet.close();
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
        try {
            if (connection != null) {
                DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
            }
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
        }
        log.info("[ " + this.def.name + " ] SpatialOp sql exec time: " + (l - l2) + "ms, total time loading " + n + " features: " + (l6 - l3) + "ms.");
        return object;
        catch (Exception exception) {
            try {
                throw exception;
            }
            catch (Throwable throwable) {
                Object var38_27 = null;
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(connection, "LIVE");
                    }
                    catch (Exception exception2) {
                        log.warning(exception2.getMessage());
                    }
                }
                long l7 = System.currentTimeMillis();
                try {
                    if (oracleResultSet != null) {
                        oracleResultSet.close();
                    }
                }
                catch (Exception exception3) {
                    log.warning(exception3.getMessage());
                }
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                }
                catch (Exception exception3) {
                    log.warning(exception3.getMessage());
                }
                try {
                    if (connection != null) {
                        DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                    }
                }
                catch (Exception exception3) {
                    log.warning(exception3.getMessage());
                }
                log.info("[ " + this.def.name + " ] SpatialOp sql exec time: " + (l - l2) + "ms, total time loading " + n + " features: " + (l7 - l3) + "ms.");
                throw throwable;
            }
        }
    }

    protected JSDOGeometry loadGeom(ResultSet resultSet, boolean bl) throws Exception {
        return JDBCUtil.loadGeometry(resultSet, 2, bl);
    }

    protected JSDOGeometry loadGeom(CacheGroup cacheGroup, ResultSet resultSet, String string, boolean bl) throws Exception {
        JSDOGeometry jSDOGeometry = null;
        if (this.def.getCachingMode() != 3 && cacheGroup != null && this.getTheme().getDecorator().getWorkspaceName() == null) {
            jSDOGeometry = (JSDOGeometry)cacheGroup.get(string);
            if (jSDOGeometry == null && (jSDOGeometry = this.loadGeom(resultSet, bl)) != null) {
                cacheGroup.put(string, jSDOGeometry, jSDOGeometry.getSize());
            }
        } else {
            jSDOGeometry = this.loadGeom(resultSet, bl);
        }
        return jSDOGeometry;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _loadAllFeatures(Connection var1_1, String var2_2) throws Exception {
        block32: {
            block31: {
                block26: {
                    block30: {
                        block29: {
                            block25: {
                                PredGeomThemeProducer.log.finest("[" + this.def.name + " loadAll Query] " + var2_2);
                                var4_3 = null;
                                var5_4 = null;
                                var6_5 = 0;
                                var7_6 = 0L;
                                var9_7 = 0L;
                                var11_8 = 0L;
                                var13_9 = new ArrayList<StyledFeatureI>(1024);
                                try {
                                    var7_6 = System.currentTimeMillis();
                                    var4_3 = this.def.getQueryHelper().prepare((OracleConnection)var1_1, var2_2, null, this.bindingParameters, null);
                                    var4_3.setFetchSize(this.owner.getFetchSize());
                                    PredGeomThemeProducer.log.finer("Fetch size: " + var4_3.getFetchSize());
                                    var9_7 = System.currentTimeMillis();
                                    var5_4 = (OracleResultSet)var4_3.executeQuery();
                                    var14_10 = var5_4.getMetaData();
                                    var15_12 = var14_10.getColumnCount();
                                    var11_8 = System.currentTimeMillis();
                                    if (var5_4 == null) {
                                        var26_13 = null;
                                        break block25;
                                    }
                                    var16_22 = CacheMgr2.getGroup(this.def.cacheSubRegionName, this.def.getCacheGroupName());
                                    if (var16_22 == null) {
                                        CacheMgr2.createGeomGroup(this.def.cacheSubRegionName, this.def.getCacheGroupName(), 0, true);
                                    }
                                    var17_23 = this.owner.getDecorator().isReorientLines();
                                    var18_24 = this.owner.getDecorator().isFastUnpickle();
                                    var19_25 = this.owner.getDecorator().isSimplifiedShapes();
                                    var20_26 = this.buildRenderingRuleHash();
                                    while (var5_4.next()) {
                                        var21_27 = var5_4.getString(1);
                                        var22_28 = this.loadGeom((ResultSet)var5_4, var18_24);
                                        if (var22_28 == null) continue;
                                        var16_22.put(var21_27, var22_28, var22_28.getSize());
                                        var23_29 = this.getNewStyledFeatureInstance();
                                        var23_29.setShapeSimplified(var19_25);
                                        var23_29.setGeometry(var22_28);
                                        var23_29.setID(var21_27);
                                        var23_29.setDataSource(this.def.getDataSourceName());
                                        var23_29.setFeatureStyleName(var5_4.getString(3));
                                        if (var5_4.getFloat(6) > 0.0f) {
                                            var23_29.setLabel(var5_4.getString(4));
                                            var23_29.setLabelStyleName(var5_4.getString(5));
                                        }
                                        if (var15_12 > 7) {
                                            this.loadAttributeData((ResultSet)var5_4, var23_29, var15_12, var14_10);
                                        }
                                        if (var20_26 != null) {
                                            var24_30 = Integer.parseInt(var5_4.getString(7).substring(5));
                                            var23_29.setRenderingRules((RenderingRule[])var20_26.get(var23_29.getFeatureStyleName().toUpperCase() + "#" + var24_30));
                                        }
                                        var13_9.add(var23_29);
                                        if (++var6_5 % 1000 != 0) continue;
                                        Thread.currentThread();
                                        Thread.yield();
                                    }
                                    break block26;
                                }
                                catch (Throwable var25_31) {
                                    var26_15 = null;
                                    var27_18 = System.currentTimeMillis();
                                    try {
                                        if (var5_4 != null) {
                                            var5_4.close();
                                        }
                                    }
                                    catch (Exception var29_21) {
                                        PredGeomThemeProducer.log.warning(var29_21.getMessage());
                                    }
                                    try {
                                        if (var4_3 != null) {
                                            var4_3.close();
                                        }
                                    }
                                    catch (Exception var29_21) {
                                        PredGeomThemeProducer.log.warning(var29_21.getMessage());
                                    }
                                    PredGeomThemeProducer.log.info("[ " + this.def.name + ".loadAll ] sql exec time: " + (var11_8 - var9_7) + "ms, total time loading " + var6_5 + " features: " + (var27_18 - var7_6) + "ms.");
                                    TopThemeQueries.add(var27_18 - var7_6, this.getTheme().getName() + "#loadAll", this.getTheme().getDataSourceName(), var2_2, "features loaded = " + var6_5);
                                    throw var25_31;
                                }
                            }
                            var27_16 = System.currentTimeMillis();
                            ** try [egrp 2[TRYBLOCK] [5 : 589->604)] { 
lbl85:
                            // 1 sources

                            if (var5_4 != null) {
                                var5_4.close();
                            }
                            break block29;
lbl88:
                            // 1 sources

                            catch (Exception var29_19) {
                                PredGeomThemeProducer.log.warning(var29_19.getMessage());
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [6 : 617->632)] { 
lbl92:
                        // 1 sources

                        if (var4_3 != null) {
                            var4_3.close();
                        }
                        break block30;
lbl95:
                        // 1 sources

                        catch (Exception var29_19) {
                            PredGeomThemeProducer.log.warning(var29_19.getMessage());
                        }
                    }
                    PredGeomThemeProducer.log.info("[ " + this.def.name + ".loadAll ] sql exec time: " + (var11_8 - var9_7) + "ms, total time loading " + var6_5 + " features: " + (var27_16 - var7_6) + "ms.");
                    TopThemeQueries.add(var27_16 - var7_6, this.getTheme().getName() + "#loadAll", this.getTheme().getDataSourceName(), var2_2, "features loaded = " + var6_5);
                    return;
                }
                var26_14 = null;
                var27_17 = System.currentTimeMillis();
                ** try [egrp 2[TRYBLOCK] [5 : 589->604)] { 
lbl106:
                // 1 sources

                if (var5_4 != null) {
                    var5_4.close();
                }
                break block31;
lbl109:
                // 1 sources

                catch (Exception var29_20) {
                    PredGeomThemeProducer.log.warning(var29_20.getMessage());
                }
            }
            ** try [egrp 3[TRYBLOCK] [6 : 617->632)] { 
lbl113:
            // 1 sources

            if (var4_3 != null) {
                var4_3.close();
            }
            break block32;
lbl116:
            // 1 sources

            catch (Exception var29_20) {
                PredGeomThemeProducer.log.warning(var29_20.getMessage());
            }
        }
        PredGeomThemeProducer.log.info("[ " + this.def.name + ".loadAll ] sql exec time: " + (var11_8 - var9_7) + "ms, total time loading " + var6_5 + " features: " + (var27_17 - var7_6) + "ms.");
        TopThemeQueries.add(var27_17 - var7_6, this.getTheme().getName() + "#loadAll", this.getTheme().getDataSourceName(), var2_2, "features loaded = " + var6_5);
        if (var13_9.size() > 0) {
            this.def.buildRTree(var13_9);
        }
    }

    public void loadAttributeData(ResultSet resultSet, StyledFeatureI styledFeatureI, int n, ResultSetMetaData resultSetMetaData) throws SQLException, IOException {
        Object object;
        Vector<Object> vector = new Vector<Object>(n - 7);
        for (int i = 8; i < n + 1; ++i) {
            object = null;
            String string = resultSetMetaData.getColumnName(i);
            int n2 = resultSetMetaData.getColumnType(i);
            object = Util.getFieldFromResultSet(n2, resultSet, i);
            ((Field)object).setName(string);
            vector.add(object);
        }
        Field[] fieldArray = this.def.getIdentifiableColumns();
        if (fieldArray == null) {
            styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
        } else {
            object = new Field[fieldArray.length];
            block1: for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                String string = field.getName();
                for (int j = 0; j < vector.size(); ++j) {
                    Field field2 = (Field)vector.get(j);
                    if (!string.equalsIgnoreCase(field2.getName())) continue;
                    object[i] = field2;
                    field2.setDisplayName(field.getDisplayName());
                    if (this.columnDefinedInStylingRules(field.getName())) continue block1;
                    vector.remove(j);
                    continue block1;
                }
            }
            styledFeatureI.setIdentifiableAttributes((Field[])object);
            if (vector.size() > 0) {
                styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
            }
        }
    }

    protected void loadLabel(ResultSet resultSet, StyledFeatureI styledFeatureI, ResultSetMetaData resultSetMetaData, ResourceBundle resourceBundle) throws SQLException {
        String string = resultSet.getString(4);
        styledFeatureI.setLabel(string);
        styledFeatureI.setLabelStyleName(resultSet.getString(5));
        if (string != null && resourceBundle != null) {
            styledFeatureI.setTranslatedLabel(I18nUtil.getTranslation(string, resourceBundle));
        }
    }

    public void createCacheGroup(int n) {
        Integer n2 = new Integer(n);
        if (this.def.getSRidCache().get(n2) != null) {
            log.info("Cache group for SRid " + n + " already exists.");
            return;
        }
        log.finer("Creating a cache group for SRID: " + n);
        String string = this.def.getBaseTable() + "_" + this.def.getGeomColumn() + "_" + n + "_PDT_GEOM#" + this.def.getDataSourceName();
        log.finer("Cache group: " + string);
        boolean bl = this.def.getCachingMode() == 2;
        try {
            CacheMgr2.createGeomGroup(this.def.getCacheSubRegionName(), string, 0, bl);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "error creating geom cache group.", exception);
        }
        this.def.getSRidCache().put(n2, string);
    }

    public int setStyledFeatures(List list) {
        this.features = new LocalThemeDataProducer(this.owner);
        this.features.setStyledFeatures(list);
        return list != null ? list.size() : 0;
    }

    protected boolean columnDefinedInStylingRules(String string) {
        StylingRule[] stylingRuleArray = this.def.getStylingRules();
        if (stylingRuleArray == null) {
            return false;
        }
        for (int i = 0; i < stylingRuleArray.length; ++i) {
            String[] stringArray = stylingRuleArray[i].getAttributeColumnsAsArray();
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equalsIgnoreCase(stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void setBindingParameters(Object[] objectArray) {
        this.bindingParameters = objectArray;
    }

    public Object[] getBindingParameters() {
        return this.bindingParameters;
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        if (this.def.isHeatMapTheme) {
            return new HMPointFeature();
        }
        return new StyledFeature();
    }

    private void extendMbr(double[] dArray) {
        if (this.mDataExtent == null) {
            this.mDataExtent = new Rectangle2D.Double(dArray[0], dArray[1], 0.0, 0.0);
        } else {
            this.mDataExtent.add(dArray[0], dArray[1]);
        }
        if (dArray.length == 4) {
            this.mDataExtent.add(dArray[2], dArray[3]);
        } else {
            this.mDataExtent.add(dArray[3], dArray[4]);
        }
    }

    private Hashtable buildRenderingRuleHash() {
        if (this.def.getStylingRules() == null) {
            return null;
        }
        StylingRule[] stylingRuleArray = this.def.getStylingRules();
        if (stylingRuleArray.length == 0) {
            return null;
        }
        Hashtable<String, RenderingRule[]> hashtable = new Hashtable<String, RenderingRule[]>();
        for (int i = 0; i < stylingRuleArray.length; ++i) {
            String string = stylingRuleArray[i].getFeatureStyleName();
            RenderingRule[] renderingRuleArray = stylingRuleArray[i].getRenderingRules();
            if (string == null || renderingRuleArray == null) continue;
            hashtable.put(string.toUpperCase() + "#" + i, renderingRuleArray);
        }
        if (hashtable.size() == 0) {
            return null;
        }
        return hashtable;
    }

    protected void loadNewFeatures(List list) {
    }

    protected void loadEditFeatures(Rectangle2D rectangle2D, List list) {
    }
}

