/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ext.NSDataSet;
import oracle.mapviewer.share.ext.NSRow;
import oracle.mapviewer.share.ext.NsDpInfo;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.query.SDOBoxFilter;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.DynGeomThemeProducer;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.util.Util;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class PredGeomThemeQueryHelper {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    transient PredGeomThemeDefinition def = null;
    String baseQuery = null;
    boolean is9i = false;
    boolean isPassThrough = false;
    int mSrid = 0;
    String mTable = null;
    String mGeomColumn = null;
    String mKeyColumn = null;
    int[] bindingVaraiblesNumArray = null;
    int totalBindingVariablesNum = 0;
    boolean isSTgeometry = false;
    static String NSDPFilter = " AND #NSDPCOL# IN (select * from TABLE (:NSDPVLIST) )";

    public PredGeomThemeQueryHelper(PredGeomThemeDefinition predGeomThemeDefinition) {
        this.def = predGeomThemeDefinition;
        this.is9i = predGeomThemeDefinition.is9i();
        this.isPassThrough = predGeomThemeDefinition.isQueryPassThrough();
        this.mSrid = predGeomThemeDefinition.getSrid();
        this.mTable = predGeomThemeDefinition.getBaseTable();
        this.mGeomColumn = predGeomThemeDefinition.getGeomColumn();
        this.mKeyColumn = predGeomThemeDefinition.getKeyColumn();
        if (predGeomThemeDefinition.getTableAlias() != null) {
            this.mTable = this.mTable + " " + predGeomThemeDefinition.getTableAlias();
            if (this.mGeomColumn.toUpperCase().indexOf("MDSYS.") == -1) {
                this.mGeomColumn = predGeomThemeDefinition.getTableAlias() + "." + this.mGeomColumn;
            }
        }
        this.isSTgeometry = Util.isSTGeometryType(predGeomThemeDefinition.getBaseColumnType());
        if (this.isSTgeometry && predGeomThemeDefinition.getTableAlias() == null) {
            this.mTable = predGeomThemeDefinition.getBaseTable() + " " + "st_mv_table";
            if (this.mGeomColumn.toUpperCase().indexOf("MDSYS.") == -1) {
                this.mGeomColumn = "st_mv_table." + predGeomThemeDefinition.getGeomColumn();
            }
        }
        this.createBaseQuery();
    }

    public boolean isPassThrough() {
        return this.isPassThrough;
    }

    public String getGeomColumn() {
        return this.mGeomColumn;
    }

    public String getBaseQuery() {
        return this.baseQuery;
    }

    public void createBaseQuery() {
        int n;
        Object object;
        if (this.def == null) {
            throw new IllegalArgumentException("theme definition is null.");
        }
        StylingRule[] stylingRuleArray = this.def.getStylingRules();
        String string = "";
        if (stylingRuleArray[0].getOrderByColumns() != null) {
            string = " ORDER BY " + stylingRuleArray[0].getOrderByColumns() + " ";
            if (stylingRuleArray[0].getSortOrder() != null) {
                string = string + stylingRuleArray[0].getSortOrder() + " ";
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(8);
        if (stylingRuleArray != null) {
            for (int i = 0; i < stylingRuleArray.length; ++i) {
                RenderingRule[] renderingRuleArray;
                String[] stringArray = stylingRuleArray[i].getAttributeColumnsAsArray();
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string2 = stringArray[j].toUpperCase();
                        if (arrayList.contains(string2)) continue;
                        arrayList.add(string2);
                    }
                }
                if ((renderingRuleArray = stylingRuleArray[i].getRenderingRules()) == null) continue;
                for (int j = 0; j < renderingRuleArray.length; ++j) {
                    Object object2;
                    object = renderingRuleArray[j].getStyleColumns();
                    if (object != null) {
                        for (int k = 0; k < ((String[])object).length; ++k) {
                            object2 = object[k].toUpperCase();
                            if (arrayList.contains(object2)) continue;
                            arrayList.add(object2);
                        }
                    }
                    String string3 = renderingRuleArray[j].getSubStyleName();
                    object2 = renderingRuleArray[j].getSubStyleColumns();
                    if (object2 == null) continue;
                    for (int k = 0; k < ((String[])object2).length; ++k) {
                        String string4 = object2[k].toUpperCase();
                        if (arrayList.contains(string4)) continue;
                        arrayList.add(string4);
                    }
                }
            }
        }
        if (this.def != null && this.def.getIdentifiableColumns() != null) {
            Field[] fieldArray = this.def.getIdentifiableColumns();
            for (int i = 0; i < fieldArray.length; ++i) {
                int n2 = arrayList.indexOf(fieldArray[i].getName());
                if (n2 >= 0) continue;
                arrayList.add(fieldArray[i].getName());
            }
        }
        String string5 = "";
        for (n = 0; n < arrayList.size(); ++n) {
            string5 = string5 + ", " + arrayList.get(n);
        }
        if (stylingRuleArray == null || stylingRuleArray.length < 1) {
            this.baseQuery = "SELECT " + this.mKeyColumn + ", " + "#GEOMCOL#" + ", null, null, null, -1," + "'rule#" + "-1'" + string5 + " FROM " + this.mTable;
            this.baseQuery = this.baseQuery + " WHERE #SDOOP#";
            this.bindingVaraiblesNumArray = new int[1];
            this.bindingVaraiblesNumArray[0] = 0;
            this.totalBindingVariablesNum = 0;
            log.finest("base-query: " + this.baseQuery);
            return;
        }
        this.baseQuery = "";
        this.bindingVaraiblesNumArray = new int[stylingRuleArray.length];
        this.totalBindingVariablesNum = 0;
        for (n = 0; n < stylingRuleArray.length; ++n) {
            this.bindingVaraiblesNumArray[n] = 0;
            StylingRule stylingRule = stylingRuleArray[n];
            String string6 = "SELECT " + this.mKeyColumn + ", " + "#GEOMCOL#" + ", '" + stylingRule.getFeatureStyleName() + "', " + stylingRule.getLabelColumn() + ", '" + stylingRule.getLabelStyleName() + "', " + stylingRule.getLabelFunction() + ", 'rule#" + n + "'" + string5 + " FROM " + this.mTable;
            string6 = string6 + " WHERE #SDOOP# #NSDPFLTROP#";
            object = stylingRuleArray[n].getFeatureCond();
            if (object != null) {
                string6 = string6 + " AND " + (String)object;
                this.bindingVaraiblesNumArray[n] = DynGeomThemeDefinition.countBindingVariables((String)object);
                this.totalBindingVariablesNum += this.bindingVaraiblesNumArray[n];
            }
            if (stylingRuleArray.length == 1) {
                this.baseQuery = string6;
                continue;
            }
            if (n > 0) {
                this.baseQuery = this.baseQuery + " UNION ALL ";
            }
            this.baseQuery = this.baseQuery + string6;
        }
        this.baseQuery = this.baseQuery + string;
        log.finest("Theme base-query [" + this.def.getName() + "]: " + this.baseQuery);
    }

    public String buildQueryString(boolean bl, SpatialOp spatialOp, VisContext visContext) {
        String string;
        if (this.isPassThrough) {
            bl = true;
        }
        String string2 = this.baseQuery;
        boolean bl2 = false;
        if (this.def.getSrid() > 0 && visContext.getMasterSRID() > 0 && this.def.getSrid() != visContext.getMasterSRID()) {
            bl2 = true;
        }
        boolean bl3 = this.def.getCachingMode() == 2;
        String string3 = "";
        if (this.isSTgeometry) {
            string3 = ".geom";
        }
        if (!bl2) {
            string2 = bl3 ? string2.replaceAll("#GEOMCOL#", "null") : string2.replaceAll("#GEOMCOL#", this.mGeomColumn + string3);
        } else {
            string = "sdo_cs.transform(" + this.mGeomColumn + "," + visContext.getMasterSRID() + ")";
            string2 = string2.replaceAll("#GEOMCOL#", string);
        }
        if (bl) {
            string2 = string2.replaceAll("#SDOOP#", SDOBoxFilter.TRUE4EVER);
            string = this.buildNSDPFilter(visContext);
            string2 = string2.replaceAll("#NSDPFLTROP#", string);
            return string2;
        }
        if (spatialOp != null) {
            string = spatialOp.getSpatialPredicate();
            string2 = string2.replaceAll("#SDOOP#", string);
        } else {
            string2 = string2.replaceAll("#SDOOP#", SDOBoxFilter.TRUE4EVER);
        }
        if (this.isSTgeometry && spatialOp != null) {
            string2 = string2.replaceAll(", 'querytype=WINDOW'", "");
        }
        string = this.buildNSDPFilter(visContext);
        string2 = string2.replaceAll("#NSDPFLTROP#", string);
        return string2;
    }

    public PreparedStatement prepare(OracleConnection oracleConnection, String string, SpatialOp spatialOp, Object[] objectArray, VisContext visContext) throws SQLException, IllegalArgumentException {
        StylingRule[] stylingRuleArray;
        if (string == null) {
            throw new IllegalArgumentException("query string is null!");
        }
        if (objectArray == null && this.totalBindingVariablesNum > 0 || objectArray != null && objectArray.length < this.totalBindingVariablesNum) {
            throw new IllegalArgumentException("Not enough binding variables!");
        }
        boolean bl = false;
        NsDpHandler nsDpHandler = this.getNsdpHandler(visContext);
        if (nsDpHandler != null && string.indexOf(":NSDPVLIST") >= 0) {
            bl = true;
        }
        if (bl && nsDpHandler.getData() == null) {
            throw new SQLException("NSDP contains no data. Theme query will not be executed for " + this.def.getName() + ".");
        }
        PreparedStatement preparedStatement = oracleConnection.prepareStatement(string);
        if (spatialOp != null && !this.isPassThrough) {
            spatialOp.prepare(preparedStatement);
        }
        if (bl) {
            this.bindNsdpData(preparedStatement, nsDpHandler, oracleConnection);
        }
        if ((stylingRuleArray = this.def.getStylingRules()) != null && stylingRuleArray.length > 0) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < stylingRuleArray.length; ++i) {
                if (spatialOp != null && !this.isPassThrough) {
                    n += spatialOp.getNumBindingVariables();
                }
                if (bl) {
                    ++n;
                }
                for (int j = 0; j < this.bindingVaraiblesNumArray[i]; ++j) {
                    DynGeomThemeProducer.setBindingVariable((Connection)oracleConnection, preparedStatement, objectArray[n2++], ++n);
                }
            }
        }
        return preparedStatement;
    }

    private NsDpHandler getNsdpHandler(VisContext visContext) {
        if (visContext == null) {
            return null;
        }
        Vector vector = visContext.getNsDpHandlers();
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            NsDpHandler nsDpHandler = (NsDpHandler)vector.get(i);
            NsDpInfo nsDpInfo = nsDpHandler.getDef();
            String string = nsDpInfo.getTheme();
            if (string == null || !string.equalsIgnoreCase(this.def.name)) continue;
            return nsDpHandler;
        }
        return null;
    }

    private String buildNSDPFilter(VisContext visContext) {
        boolean bl;
        NsDpHandler nsDpHandler = this.getNsdpHandler(visContext);
        if (nsDpHandler == null) {
            return "";
        }
        NsDpInfo nsDpInfo = nsDpHandler.getDef();
        if (nsDpInfo == null) {
            return "";
        }
        boolean bl2 = nsDpInfo.isShowUnmatched();
        if (bl2) {
            return "";
        }
        NSDataSet nSDataSet = nsDpHandler.getData();
        boolean bl3 = bl = nSDataSet != null && nSDataSet.size() > 0;
        if (!bl) {
            log.warning("Your NSDP data set contains no data yet; no DB filtering will be done!");
            return "";
        }
        String string = NSDPFilter;
        string = string.replaceAll("#NSDPCOL#", nsDpInfo.getJoinColumnSpatial());
        return string;
    }

    private void bindNsdpData(PreparedStatement preparedStatement, NsDpHandler nsDpHandler, OracleConnection oracleConnection) {
        NSDataSet nSDataSet = nsDpHandler.getData();
        NSRow[] nSRowArray = nSDataSet.getRows();
        NSRow nSRow = nSRowArray[0];
        ARRAY aRRAY = null;
        try {
            OraclePreparedStatement oraclePreparedStatement;
            Field field = nSRow.getKeyAttribute();
            String string = null;
            int n = field.getType();
            if (n == 8) {
                StringBuffer stringBuffer;
                string = "string";
                oraclePreparedStatement = new String[nSRowArray.length];
                for (int i = 0; i < nSRowArray.length; ++i) {
                    oraclePreparedStatement[i] = nSRowArray[i].getKeyAttribute().getString();
                }
                Level level = log.getLevel();
                if (level == Level.FINEST) {
                    stringBuffer = new StringBuffer("NSDP keys begin: \n");
                    for (int i = 0; i < nSRowArray.length; ++i) {
                        stringBuffer.append(oraclePreparedStatement[i]).append("\n");
                    }
                    stringBuffer.append("NSDP keys end.");
                    log.finest(stringBuffer.toString());
                }
                stringBuffer = DSUtil.getArrayDescriptor((Connection)oracleConnection, "string", false);
                aRRAY = new ARRAY((ArrayDescriptor)stringBuffer, (Connection)oracleConnection, (Object)oraclePreparedStatement);
            } else if (n == 3) {
                string = "number";
                oraclePreparedStatement = (OraclePreparedStatement)new int[nSRowArray.length];
                for (int i = 0; i < nSRowArray.length; ++i) {
                    oraclePreparedStatement[i] = (String)nSRowArray[i].getKeyAttribute().getInt();
                }
                ArrayDescriptor arrayDescriptor = DSUtil.getArrayDescriptor((Connection)oracleConnection, "number", false);
                aRRAY = new ARRAY(arrayDescriptor, (Connection)oracleConnection, (Object)oraclePreparedStatement);
            } else if (n == 4) {
                string = "number";
                oraclePreparedStatement = (OraclePreparedStatement)new long[nSRowArray.length];
                for (int i = 0; i < nSRowArray.length; ++i) {
                    oraclePreparedStatement[i] = (String)nSRowArray[i].getKeyAttribute().getLong();
                }
                ArrayDescriptor arrayDescriptor = DSUtil.getArrayDescriptor((Connection)oracleConnection, "number", false);
                aRRAY = new ARRAY(arrayDescriptor, (Connection)oracleConnection, (Object)oraclePreparedStatement);
            } else if (n == 6) {
                string = "number";
                oraclePreparedStatement = (OraclePreparedStatement)new double[nSRowArray.length];
                for (int i = 0; i < nSRowArray.length; ++i) {
                    oraclePreparedStatement[i] = (String)nSRowArray[i].getKeyAttribute().getDouble();
                }
                ArrayDescriptor arrayDescriptor = DSUtil.getArrayDescriptor((Connection)oracleConnection, "number", false);
                aRRAY = new ARRAY(arrayDescriptor, (Connection)oracleConnection, (Object)oraclePreparedStatement);
            } else if (n == 5) {
                string = "number";
                oraclePreparedStatement = (OraclePreparedStatement)new float[nSRowArray.length];
                for (int i = 0; i < nSRowArray.length; ++i) {
                    oraclePreparedStatement[i] = (String)nSRowArray[i].getKeyAttribute().getFloat();
                }
                ArrayDescriptor arrayDescriptor = DSUtil.getArrayDescriptor((Connection)oracleConnection, "number", false);
                aRRAY = new ARRAY(arrayDescriptor, (Connection)oracleConnection, (Object)oraclePreparedStatement);
            } else if (n == 10) {
                string = "date";
                oraclePreparedStatement = new Date[nSRowArray.length];
                for (int i = 0; i < nSRowArray.length; ++i) {
                    long l = nSRowArray[i].getKeyAttribute().getDate();
                    oraclePreparedStatement[i] = new Date(l);
                }
                ArrayDescriptor arrayDescriptor = DSUtil.getArrayDescriptor((Connection)oracleConnection, "date", false);
                aRRAY = new ARRAY(arrayDescriptor, (Connection)oracleConnection, (Object)oraclePreparedStatement);
            } else {
                log.warning("NSDP key-column data type not supported: " + n + ".");
            }
            if (aRRAY != null) {
                oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
                oraclePreparedStatement.setARRAYAtName("NSDPVLIST", aRRAY);
            }
        }
        catch (Exception exception) {
            log.warning("error binding NSDP data to a theme: " + exception.getMessage());
        }
    }
}

