/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.Group;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.Object3d;
import oracle.sdovis.raytracing.Plane;
import oracle.sdovis.raytracing.RTRenderer;
import oracle.sdovis.raytracing.TextureMap;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeProducer;
import oracle.sdovis.theme.ShadedReliefThemeDefinition;

public class ShadedReliefThemeProducer
extends GeoRasterThemeProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected ShadedReliefThemeDefinition srdef;
    HashMap srRenderedImages = new HashMap();

    public ShadedReliefThemeProducer(Theme theme) {
        this.owner = theme;
        this.srdef = (ShadedReliefThemeDefinition)theme.getDefinition();
        this.def = (GeoRasterThemeDefinition)this.srdef.getGeorDef();
    }

    public ShadedReliefThemeProducer(Theme theme, Object[] objectArray) {
        this.owner = theme;
        this.srdef = (ShadedReliefThemeDefinition)theme.getDefinition();
        this.def = (GeoRasterThemeDefinition)this.srdef.getGeorDef();
        super.setBindingParameters(objectArray);
    }

    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        Rectangle2D rectangle2D2 = visContext.getDeviceWindow();
        int n = super.prepareData(rectangle2D, visContext);
        int n2 = (int)rectangle2D2.getWidth();
        int n3 = (int)rectangle2D2.getHeight();
        int n4 = this.srdef.getBounces();
        int n5 = this.srdef.getWeight();
        Camera camera = this.srdef.getCamera();
        double[][] dArray = super.getMBRs();
        RTRenderer rTRenderer = new RTRenderer();
        rTRenderer.setCamera(camera);
        rTRenderer.setBackgroundColor(this.srdef.getBackgroundColor());
        rTRenderer.setAmbientLight(this.srdef.getAmbientLight());
        rTRenderer.setLights(this.srdef.getLights());
        for (int i = 0; i < n; ++i) {
            RenderedImage renderedImage = this.getRenderedImage(i);
            Raster raster = renderedImage.getData();
            double[][] dArray2 = this.getDEMData(raster);
            Vector3d vector3d = new Vector3d(0.75, 0.75, 0.75);
            Vector3d vector3d2 = new Vector3d(0.0, 0.0, 0.0);
            Vector3d vector3d3 = new Vector3d(0.0, 0.0, 0.0);
            Vector3d vector3d4 = new Vector3d(0.0, 0.0, 0.0);
            double d = 0.0;
            double d2 = 1.0;
            TextureMap textureMap = new TextureMap(vector3d, vector3d2, d2, vector3d4, vector3d3, d, dArray2, raster.getNumBands(), raster.getWidth(), raster.getHeight());
            Material[] materialArray = new Material[]{textureMap};
            rTRenderer.setMaterials(materialArray);
            Object3d[] object3dArray = new Object3d[1];
            Vector3d vector3d5 = new Vector3d(0.0, 1.0, 0.0);
            double d3 = -1.0;
            object3dArray[0] = new Plane(vector3d5, d3, materialArray[0], camera);
            Group group = new Group(object3dArray);
            rTRenderer.setGroup(group);
            int[] nArray = new int[]{0, 1, 2};
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(5, n2, n3, 3, 3 * n2, nArray);
            Point point = new Point((int)rectangle2D2.getMinX(), (int)rectangle2D2.getMinY());
            WritableRaster writableRaster = WritableRaster.createWritableRaster(componentSampleModel, point);
            RenderedImage renderedImage2 = rTRenderer.doRendering(writableRaster, n4, n5, n2, n3);
            this.srRenderedImages.put(String.valueOf(i), renderedImage2);
        }
        return n;
    }

    public double[][] getDEMData(Raster raster) {
        int n = raster.getNumBands();
        int n2 = raster.getMinX();
        int n3 = raster.getMinY();
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = n2 + n4 - 1;
        int n7 = n3 + n5 - 1;
        boolean bl = false;
        boolean bl2 = false;
        int n8 = 0;
        int n9 = 0;
        boolean bl3 = false;
        double[][] dArray = new double[n5][n4 * n];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n; ++k) {
                    dArray[n8][n9] = raster.getSampleDouble(j, i, k);
                    ++n9;
                }
            }
            n9 = 0;
            ++n8;
        }
        return dArray;
    }

    public void destroy() {
        super.destroy();
        if (this.srRenderedImages.size() > 0) {
            Object[] objectArray = this.srRenderedImages.values().toArray();
            this.renderImages.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof BufferedImage) {
                    BufferedImage bufferedImage = (BufferedImage)objectArray[i];
                    bufferedImage.flush();
                }
                objectArray[i] = null;
            }
            objectArray = null;
        }
    }

    public HashMap getShadedReliefRenderedImages() {
        return this.srRenderedImages;
    }

    public RenderedImage getShadedReliefRenderedImage(int n) {
        if (this.srRenderedImages == null) {
            return null;
        }
        if (n < 0 || n > this.srRenderedImages.size() - 1) {
            return null;
        }
        return (RenderedImage)this.srRenderedImages.get(String.valueOf(n));
    }

    public void abort() {
    }
}

