/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.EPSG2SDO;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.cache.CacheGroup;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WfsCapabilities;
import oracle.sdovis.util.WfsFeatureType;

public class WFSThemeDefinition
extends VectorThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String url = null;
    private String srsName = null;
    private String featureName = null;
    private String spatialColumn = null;
    private String renderStyle = null;
    private String labelColumn = null;
    private String labelStyle = null;
    private String[] attributeList = null;
    private String[] renderStyleAttributes = null;
    private String queryCondition = null;
    private String[] featureIds = null;
    private boolean isPredefined = false;
    private String getFeatureFormat = "GML2";
    private String keyColumn = "fid";
    private WfsCapabilities capabilities = new WfsCapabilities();
    private WfsFeatureType featureType = null;

    public WFSThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String string10) {
        this.createCacheGroup();
        this.setName(string);
        this.dataSource = string2;
        this.url = string3;
        this.setSRS(string4);
        this.featureName = string5;
        this.spatialColumn = string6;
        this.renderStyle = string7;
        this.labelColumn = string8;
        this.labelStyle = string9;
        this.attributeList = stringArray;
        this.renderStyleAttributes = stringArray2;
        this.queryCondition = string10;
    }

    public WFSThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.createCacheGroup();
        this.setName(string);
        this.dataSource = string2;
        this.url = string3;
        this.setSRS(string4);
        this.featureName = string5;
        this.spatialColumn = string6;
        this.renderStyle = string7;
        this.labelColumn = string8;
        this.labelStyle = string9;
        this.attributeList = stringArray;
        this.renderStyleAttributes = stringArray2;
        this.featureIds = stringArray3;
    }

    public WFSThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, StylingRule[] stylingRuleArray, String[] stringArray, String string7) {
        this.createCacheGroup();
        this.isPredefined = true;
        this.setName(string);
        this.dataSource = string2;
        this.url = string3;
        this.setSRS(string4);
        this.featureName = string5;
        this.spatialColumn = string6;
        this.featureIds = stringArray;
        if (string7 != null) {
            this.keyColumn = string7;
        }
        if (stylingRuleArray == null) {
            return;
        }
        StylingRule stylingRule = stylingRuleArray[0];
        this.renderStyle = stylingRule.getFeatureStyleName();
        this.labelColumn = stylingRule.getLabelColumn();
        this.labelStyle = stylingRule.getLabelStyleName();
        this.queryCondition = stylingRule.getFeatureCond();
        this.attributeList = stylingRule.getAttributeColumnsAsArray();
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String string) {
        this.keyColumn = string == null ? "fid" : string;
    }

    public String getURL() {
        return this.url;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getSpatialColumn() {
        return this.spatialColumn;
    }

    public String getLabelColumn() {
        return this.labelColumn;
    }

    public String[] getFeatureAttributes() {
        return this.attributeList;
    }

    public String getRenderStyle() {
        return this.renderStyle;
    }

    public String getLabelStyle() {
        return this.labelStyle;
    }

    public String[] getFeatureIds() {
        return this.featureIds;
    }

    public String getXMLDefinition() {
        return "";
    }

    public String getThemeType() {
        return "WFS";
    }

    public String getSRS() {
        return this.srsName;
    }

    public void setSRS(String string) {
        int n;
        if (this.srsName != null && string != null && this.srsName.equalsIgnoreCase(string)) {
            return;
        }
        this.srsName = string;
        if (string != null && (string.indexOf("epsg.xml") > -1 || string.indexOf("#") > -1) && (n = string.indexOf("#")) > -1) {
            this.srsName = "EPSG:" + string.substring(n + 1, string.length());
        }
        String string2 = "";
        if (this.srsName != null) {
            string2 = this.srsName;
            int n2 = this.srsName.indexOf(":");
            if (n2 > -1) {
                string2 = this.srsName.substring(n2 + 1, this.srsName.length());
            }
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return;
            }
            if (this.srsName.toUpperCase().indexOf("EPSG:") == -1) {
                this.srid = n3;
            } else {
                if (this.dataSource == null) {
                    return;
                }
                int n4 = 0;
                String string3 = EPSG2SDO.EPSGtoSDO(String.valueOf(n3));
                n4 = string3 != null ? Integer.parseInt(string3) : Util.EPSGsrid_To_Oraclesrid(this.dataSource, n3);
                if (n4 > 0) {
                    this.srid = n4;
                    log.info("Theme SRID set to " + this.srid + " for EPSG " + n3);
                } else if (Util.existsOracleSRID(this.dataSource, n3)) {
                    this.srid = n3;
                    log.info("Theme SRID set to " + this.srid);
                } else {
                    log.warning("Unable to find an equivalent SDO SRID for EPSG " + n3);
                    this.srid = 0;
                }
            }
        }
    }

    public String getQueryCondition() {
        return this.queryCondition;
    }

    public String[] getRenderStyleAttributes() {
        return this.renderStyleAttributes;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public String getFeatureFormat() {
        return this.getFeatureFormat;
    }

    public void setFeatureFormat(String string) {
        this.getFeatureFormat = string;
    }

    public boolean readCapabilities(long l) {
        if (this.url == null) {
            return false;
        }
        WfsCapabilities wfsCapabilities = null;
        CacheGroup cacheGroup = CacheMgr2.getGroup("WFS_URL", "WFS_CAPABILITIES");
        if (cacheGroup != null) {
            wfsCapabilities = (WfsCapabilities)cacheGroup.get(this.url);
        }
        if (wfsCapabilities != null) {
            this.capabilities = wfsCapabilities;
        } else {
            this.capabilities = new WfsCapabilities();
            if (!this.capabilities.readUsingHttpGet(this.url, l)) {
                log.warning("Unable to get Capabilities for url: " + this.url);
                return false;
            }
            cacheGroup.put(this.url, this.capabilities, 0L);
        }
        this.featureType = this.capabilities.getFeatureType(this.featureName);
        if (this.featureType != null) {
            this.setSRS(this.featureType.getSRS());
            if (this.featureType.getAttributeTypes() == null) {
                String string = this.capabilities.describeFeatureTypeGetURL();
                String string2 = this.capabilities.describeFeatureTypePostURL();
                if (string != null) {
                    this.featureType.readAttributesWithTypesUsingHttpGet(string, l);
                } else if (string2 == null) {
                    log.warning("Null describeFeatureType URLs.");
                } else {
                    this.featureType.readAttributesWithTypesUsingHttpPost(string2, l);
                }
                if (this.featureType.getAttributeTypes() == null) {
                    log.warning("Feature attribute types are null.");
                }
            }
            this.adjustAttributeNames();
        } else {
            log.warning("Unable to get information for feature: " + this.featureName);
        }
        return true;
    }

    public WfsCapabilities getCapabilities() {
        return this.capabilities;
    }

    public WfsFeatureType getFeatureType() {
        return this.featureType;
    }

    private void adjustAttributeNames() {
        String string = null;
        string = this.getRealAttributeName(this.spatialColumn);
        if (string != null) {
            this.spatialColumn = string;
        }
        if ((string = this.getRealAttributeName(this.labelColumn)) != null) {
            this.labelColumn = string;
        }
        if (this.attributeList != null) {
            for (int i = 0; i < this.attributeList.length; ++i) {
                string = this.getRealAttributeName(this.attributeList[i]);
                if (string == null) continue;
                this.attributeList[i] = string;
            }
        }
        if (!this.keyColumn.equalsIgnoreCase("fid")) {
            string = this.getRealAttributeName(this.keyColumn);
            if (string != null) {
                this.keyColumn = string;
            } else {
                log.warning("Specified key column " + this.keyColumn + " is not a feature attribute. Using default \"fid\".");
                this.keyColumn = "fid";
            }
        }
    }

    public String getRealAttributeName(String string) {
        if (string == null) {
            return null;
        }
        if (this.featureType == null) {
            return null;
        }
        Hashtable hashtable = this.featureType.getAttributeTypes();
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return string2;
        }
        return null;
    }

    private void createCacheGroup() {
        CacheMgr2.createSubRegion("WFS_URL");
        CacheMgr2.createWFSGroup("WFS_URL", "WFS_CAPABILITIES");
    }

    public void clearCapabilitiesFromCache() {
        if (this.url == null) {
            return;
        }
        CacheGroup cacheGroup = CacheMgr2.getGroup("WFS_URL", "WFS_CAPABILITIES");
        if (cacheGroup == null) {
            return;
        }
        cacheGroup.remove(this.url);
    }

    public String getCacheSubRegion() {
        return "WFS_URL";
    }

    public String getCacheGroup() {
        return "WFS_CAPABILITIES";
    }

    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.url);
        basicThemeInfo.setType("WFS");
        basicThemeInfo.setKeyColumn(this.getKeyColumn());
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(this.spatialColumn);
        return basicThemeInfo;
    }

    public String[] getRenderingStyles() {
        if (this.renderStyle == null) {
            return null;
        }
        String[] stringArray = new String[]{this.renderStyle.toUpperCase()};
        return stringArray;
    }

    public String[] getLabelingStyles() {
        if (this.labelStyle == null) {
            return null;
        }
        String[] stringArray = new String[]{this.labelStyle.toUpperCase()};
        return stringArray;
    }
}

