/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.LocalThemeDataProducer;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.WFSThemeDefinition;
import oracle.sdovis.util.HttpConnection;
import oracle.sdovis.util.TopThemeQueries;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.WfsFeatureType;
import oracle.sdovis.util.WhereClause;
import oracle.sdovis.util.XMLDOMParser;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GML;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WFSThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private Theme owner = null;
    private WFSThemeDefinition def = null;
    private double xl;
    private double yl;
    private double xh;
    private double yh;
    private LocalThemeDataProducer features = null;

    public WFSThemeProducer(Theme theme) {
        this.owner = theme;
        this.def = (WFSThemeDefinition)theme.getDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        boolean bl;
        String string2;
        Hashtable hashtable;
        String string3;
        boolean bl2;
        double d;
        double d2;
        double d3;
        double d4;
        boolean bl3;
        String string4;
        String string5;
        String string6;
        long l;
        block106: {
            int n;
            String[] stringArray;
            block108: {
                Object object5;
                Field[] fieldArray;
                String string7;
                boolean bl4;
                WfsFeatureType wfsFeatureType;
                l = System.currentTimeMillis();
                this.clearFeatures();
                this.xl = rectangle2D.getMinX();
                this.yl = rectangle2D.getMinY();
                this.xh = rectangle2D.getMaxX();
                this.yh = rectangle2D.getMaxY();
                if (this.def.getURL() == null) {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01046") + " [" + this.owner.getName() + "]");
                    return 0;
                }
                if (!this.def.readCapabilities(this.getTheme().getDecorator().getRequestTimeout())) {
                    return 0;
                }
                if (this.def.getSRS() == null) {
                    log.severe("Theme definition has no SRS information. Must read Capabilities.");
                    return 0;
                }
                String string8 = this.def.getSRS();
                if (string8.indexOf(":") < 0) {
                    string8 = "SDO:" + this.def.getSRS();
                }
                if ((wfsFeatureType = this.def.getFeatureType()) == null) {
                    log.severe("Wfs feature Type is null.");
                    return 0;
                }
                string6 = this.def.getCapabilities().getFeaturePostURL();
                string5 = this.def.getCapabilities().getFeatureGetURL();
                if (string6 == null && string5 == null) {
                    log.warning("GetFeature POST and GET URLs are null.");
                    return 0;
                }
                string4 = "";
                if (string5 != null) {
                    string4 = string5;
                    if (string4.lastIndexOf(63) > -1) {
                        if (!string4.endsWith("?") && !string4.endsWith("&")) {
                            string4 = string4 + "&";
                        }
                    } else if (!string4.endsWith("&")) {
                        string4 = string4 + "?";
                    }
                    string4 = string4 + "VERSION=1.0.0&SERVICE=WFS&REQUEST=GetFeature";
                }
                bl3 = false;
                SRS sRS = null;
                boolean bl5 = false;
                String string9 = null;
                SRSCache sRSCache = DSManager.getSRSCache(this.owner.getDataSourceName());
                sRS = sRSCache.get(this.def.getSrid());
                if (sRS != null) {
                    bl5 = sRS.isGeodetic();
                    string9 = sRS.getUnit();
                } else if (this.def.getSrid() > 0) {
                    log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                }
                d4 = this.xl;
                d3 = this.xh;
                d2 = this.yl;
                d = this.yh;
                double d5 = visContext.getCurrentScale();
                this.getTheme().setShowLabels(true);
                if (visContext.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != visContext.getMasterSRID()) {
                    Connection connection;
                    block105: {
                        connection = null;
                        try {
                            connection = DSUtil.getDBConnection(this.owner.getDataSourceName(), visContext);
                        }
                        catch (Exception exception) {
                            log.info("Unbale to get datasource connection to convert SRID");
                            return 0;
                        }
                        if (d5 != Double.POSITIVE_INFINITY && d5 != Double.NEGATIVE_INFINITY) {
                            double[] dArray = new double[]{this.xl, this.yl, this.xh, this.yh};
                            double[] dArray2 = Util.convertMBR(dArray, visContext.getMasterSRID(), this.def.getSrid(), connection);
                            if (dArray2 != null) {
                                this.xl = dArray2[0];
                                this.yl = dArray2[1];
                                this.xh = dArray2[2];
                                this.yh = dArray2[3];
                                bl3 = true;
                                break block105;
                            } else {
                                log.severe(RSBundle.getMsg("MAPVIEWER-01024"));
                                try {
                                    DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                                    return 0;
                                }
                                catch (Exception exception) {
                                    log.warning(exception.getMessage());
                                }
                                return 0;
                            }
                        }
                        bl3 = true;
                    }
                    try {
                        DSUtil.closeDBConnection(connection, this.def.getDataSourceName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (d5 != Double.POSITIVE_INFINITY && d5 != Double.NEGATIVE_INFINITY) {
                    double d6 = Math.abs(this.yh - this.yl) / Math.abs(d - d2);
                    log.finer("[Master scale] " + d5 + " [Theme scale factor] " + d6);
                    double d7 = d5 * d6;
                    if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                        double d8;
                        double d9;
                        if (visContext.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != visContext.getMasterSRID() && visContext.isTileRequest()) {
                            sRS = sRSCache.get(visContext.getMasterSRID());
                            d9 = (d4 + d3) / 2.0;
                            d8 = (d2 + d) / 2.0;
                            d6 = 1.0;
                        } else {
                            d9 = (this.xl + this.xh) / 2.0;
                            d8 = (this.yl + this.yh) / 2.0;
                        }
                        if (visContext.isTileRequest() && sRS.isGeodetic()) {
                            d9 = 0.0;
                            d8 = 0.0;
                        }
                        if (sRS == null) {
                            log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                            return 0;
                        }
                        d7 = sRS.getRatioScale(d5 * d6, new Point2D.Double(d9, d8));
                        log.finer("Ratio scale to compare: " + d7);
                    }
                    if (!this.getTheme().getDecorator().withinScaleLimits(d7)) {
                        log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                        return 0;
                    }
                    if (!this.getTheme().getDecorator().withinLabelScaleLimits(d7)) {
                        log.info("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
                        this.getTheme().setShowLabels(false);
                    }
                }
                boolean bl6 = bl4 = bl5 && this.xh - this.xl > 2.0 && this.xh - this.xl < 120.0;
                if (bl4) {
                    this.xl = Math.floor(this.xl);
                    log.finest("jtvpxfmfxed: xl=" + this.xl);
                }
                log.finest("[ " + this.def.getName() + " ]:  " + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
                bl2 = false;
                if (MapMaker.isSpecial(this.xl, this.yl, this.xh, this.yh) && visContext.getRotation() != 0.0) {
                    log.warning("Rotation is currently ignored for full extent.");
                } else if (visContext.getRotation() != 0.0 && !MapMaker.isSpecial(this.xl, this.yl, this.xh, this.yh)) {
                    if (visContext.getRotation() < -360.0 || visContext.getRotation() > 360.0) {
                        log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                    } else {
                        double[] dArray = Util.rotateMBR(this.xl, this.yl, this.xh, this.yh, visContext.getRotation());
                        if (dArray != null) {
                            this.xl = Math.min(dArray[0], this.xl);
                            this.yl = Math.min(dArray[1], this.yl);
                            this.xh = Math.max(dArray[2], this.xh);
                            this.yh = Math.max(dArray[3], this.yh);
                            log.finest("Rotation angle: " + visContext.getRotation());
                            log.finest("Search window for rotation: " + this.xl + "," + this.yl + "," + this.xh + "," + this.yh);
                            bl2 = true;
                        } else {
                            log.info("Rotated MBR is null. Rotation ignored.");
                        }
                    }
                }
                string3 = this.def.getFeatureName();
                hashtable = null;
                hashtable = this.def.getFeatureType().getAttributeTypes();
                String string10 = "";
                String string11 = "";
                String string12 = "";
                if (wfsFeatureType.getNameSpaceAlias() != null && wfsFeatureType.getNameSpaceAliasURL() != null) {
                    string10 = "   xmlns:" + wfsFeatureType.getNameSpaceAlias() + "=\"" + wfsFeatureType.getNameSpaceAliasURL() + "\"\n";
                    string11 = wfsFeatureType.getNameSpaceAlias() + ":";
                    string12 = wfsFeatureType.getNameSpaceAlias() + "/";
                }
                if ((string7 = this.def.getFeatureFormat()) == null) {
                    string7 = "GML2";
                }
                String string13 = string11 + this.def.getSpatialColumn();
                String string14 = string12 + this.def.getSpatialColumn();
                if (this.def.getSpatialColumn().indexOf("gml:") > -1) {
                    string13 = this.def.getSpatialColumn();
                    string14 = this.def.getSpatialColumn();
                }
                string2 = "<?xml version=\"1.0\" ?>\n<wfs:GetFeature\n   service=\"WFS\"\n   version=\"1.0.0\"\n   outputFormat=\"" + string7.toUpperCase() + "\"\n" + "   xmlns:wfs=\"http://www.opengis.net/wfs\"\n" + "   xmlns:ogc=\"http://www.opengis.net/ogc\"\n" + "   xmlns:gml=\"http://www.opengis.net/gml\"\n" + string10 + "   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + "   xsi:schemaLocation=\"http://www.opengis.net/wfs\n" + "                      http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd\">\n" + "   <wfs:Query typeName=\"" + string11 + wfsFeatureType.getName() + "\">\n" + "      <ogc:PropertyName>" + string13 + "</ogc:PropertyName>\n";
                string4 = string4 + "&TYPENAME=" + wfsFeatureType.getName();
                string4 = string4 + "&PROPERTYNAME=" + string14;
                bl = false;
                string = this.def.getKeyColumn();
                if (this.def.getLabelColumn() != null && !this.def.getLabelColumn().equalsIgnoreCase("dummy")) {
                    string2 = string2 + "      <ogc:PropertyName>" + string11 + this.def.getLabelColumn() + "</ogc:PropertyName>\n";
                    string4 = string4 + "," + string12 + this.def.getLabelColumn();
                    if (!bl && string != null && !string.equalsIgnoreCase("fid") && string.equalsIgnoreCase(this.def.getLabelColumn())) {
                        bl = true;
                    }
                }
                String[] stringArray2 = this.def.getFeatureAttributes();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (stringArray2 != null) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (this.def.getLabelColumn() != null && this.def.getLabelColumn().equalsIgnoreCase(stringArray2[i]) || arrayList.contains(stringArray2[i].toUpperCase())) continue;
                        String string15 = string11 + stringArray2[i];
                        string2 = string2 + "      <ogc:PropertyName>" + string15 + "</ogc:PropertyName>\n";
                        string4 = string4 + "," + string12 + stringArray2[i];
                        if (!bl && string != null && !string.equalsIgnoreCase("fid") && string.equalsIgnoreCase(stringArray2[i])) {
                            bl = true;
                        }
                        arrayList.add(stringArray2[i].toUpperCase());
                    }
                }
                if ((fieldArray = this.def.getIdentifiableColumns()) != null) {
                    for (int i = 0; i < fieldArray.length; ++i) {
                        void var45_64;
                        object5 = fieldArray[i];
                        object4 = this.def.getRealAttributeName(((Field)object5).getName());
                        if (object4 == null || this.def.getLabelColumn() != null && this.def.getLabelColumn().equalsIgnoreCase(((Field)object5).getName())) continue;
                        if (stringArray2 == null) {
                            object3 = string11 + (String)object4;
                            string2 = string2 + "      <ogc:PropertyName>" + (String)object3 + "</ogc:PropertyName>\n";
                            string4 = string4 + "," + string12 + (String)object4;
                            if (bl || string == null || string.equalsIgnoreCase("fid") || !string.equalsIgnoreCase((String)object4)) continue;
                            bl = true;
                            continue;
                        }
                        boolean bl7 = false;
                        boolean bl8 = false;
                        while (var45_64 < stringArray2.length) {
                            if (stringArray2[var45_64].equalsIgnoreCase(((Field)object5).getName())) {
                                bl7 = true;
                                break;
                            }
                            ++var45_64;
                        }
                        if (bl7) continue;
                        String string16 = string11 + (String)object4;
                        string2 = string2 + "      <ogc:PropertyName>" + string16 + "</ogc:PropertyName>\n";
                        string4 = string4 + "," + string12 + (String)object4;
                        if (bl || string == null || string.equalsIgnoreCase("fid") || !string.equalsIgnoreCase((String)object4)) continue;
                        bl = true;
                    }
                }
                if (string != null && !string.equalsIgnoreCase("fid") && !bl) {
                    String string17 = this.def.getRealAttributeName(string);
                    object5 = string11 + string17;
                    string2 = string2 + "      <ogc:PropertyName>" + (String)object5 + "</ogc:PropertyName>\n";
                    string4 = string4 + "," + string12 + string17;
                    bl = true;
                }
                if ((stringArray = this.def.getFeatureIds()) != null) break block108;
                n = 0;
                object4 = this.def.getQueryCondition();
                object3 = null;
                String string18 = "";
                if (object4 != null) {
                    object4 = ((String)object4).trim();
                    object3 = new WhereClause();
                    ((WhereClause)object3).parse((String)object4);
                    if (((WhereClause)object3).getRootOperator() != null) {
                        n = 1;
                    } else {
                        log.warning("Unable to parse query condition (it is ignored).");
                    }
                }
                if (!this.isFullExtent(this.xl, this.yl, this.xh, this.yh)) {
                    object2 = "        <ogc:BBOX>\n          <ogc:PropertyName>" + string11 + wfsFeatureType.getName() + "/" + string13 + "</ogc:PropertyName>\n" + "          <gml:Box srsName=\"" + string8 + "\" xmlns:gml=\"http://www.opengis.net/gml\">\n" + "               <gml:coordinates decimal=\".\" cs=\",\" ts=\" \">" + this.xl + "," + this.yl + " " + this.xh + "," + this.yh + "</gml:coordinates>\n" + "          </gml:Box>\n" + "        </ogc:BBOX>         \n";
                    object = "<BBOX><PropertyName>" + string14 + "</PropertyName><Box srsName=\"" + string8 + "\">" + "<coordinates>" + this.xl + "," + this.yl + " " + this.xh + "," + this.yh + "</coordinates>" + "</Box></BBOX>";
                    if (n == 0) {
                        string2 = string2 + "      <ogc:Filter>\n" + (String)object2 + "      </ogc:Filter>\n";
                        string4 = string4 + "&FILTER=<Filter>" + (String)object + "</Filter>";
                        break block106;
                    } else {
                        string2 = string2 + "    <ogc:Filter>\n";
                        string2 = string2 + "      <ogc:And>\n" + ((WhereClause)object3).getAsWFSxml(8, wfsFeatureType.getName(), wfsFeatureType.getNameSpaceAlias()) + (String)object2 + "      </ogc:And>\n" + "    </ogc:Filter>\n";
                        string4 = string4 + "&FILTER=<Filter><And>" + ((WhereClause)object3).getAsWFSstring() + (String)object + "</And></Filter>";
                    }
                    break block106;
                } else if (n != 0) {
                    string2 = string2 + "      <ogc:Filter>\n" + ((WhereClause)object3).getAsWFSxml(8, wfsFeatureType.getName(), wfsFeatureType.getNameSpaceAlias()) + "      </ogc:Filter>\n";
                    string4 = string4 + "&FILTER=<Filter>" + ((WhereClause)object3).getAsWFSstring() + " </Filter>";
                }
                break block106;
            }
            string2 = string2 + "      <ogc:Filter>\n";
            string4 = string4 + "&FEATUREID=";
            for (n = 0; n < stringArray.length; ++n) {
                string2 = string2 + "<ogc:FeatureId fid=\"" + stringArray[n] + "\"/>\n";
                string4 = n == 0 ? string4 + stringArray[n] : string4 + "," + stringArray[n];
            }
            string2 = string2 + "      </ogc:Filter>\n";
        }
        string2 = string2 + "   </wfs:Query>\n</wfs:GetFeature>";
        log.info("WFS POST XML: " + string2);
        ArrayList<StyledFeatureI> arrayList = new ArrayList<StyledFeatureI>(128);
        try {
            try {
                Node node;
                int n;
                NodeList nodeList;
                object4 = new HttpConnection();
                ((HttpConnection)object4).connect(string6);
                ((HttpConnection)object4).sendXMLRequest("", string2);
                log.info("Waiting XML response for POST request...");
                object3 = ((HttpConnection)object4).getXMLResponse();
                log.info("Processing XML POST response...");
                if (object3 != null && ((String)object3).indexOf("srsName=\"http://www.opengis.net/gml/srs/epsg.xml#") > -1) {
                    object3 = ((String)object3).replaceAll("srsName=\"http://www.opengis.net/gml/srs/epsg.xml#", "srsName=\"EPSG:");
                }
                DOMParser dOMParser = new DOMParser();
                dOMParser.setValidationMode(0);
                dOMParser.setPreserveWhitespace(false);
                object2 = new StringReader((String)object3);
                dOMParser.parse((Reader)object2);
                object = dOMParser.getDocument();
                ((StringReader)object2).close();
                Node node2 = object.getFirstChild();
                if (node2 == null) {
                    log.info("Invalid XML response. Root node not found.");
                    return 0;
                }
                String string19 = WFSThemeProducer.normalize(node2.getNodeName());
                if (!string19.equalsIgnoreCase("ServiceExceptionReport") && !string19.equalsIgnoreCase("FeatureCollection")) {
                    nodeList = object.getChildNodes();
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        node = nodeList.item(n);
                        if (node.getNodeName().indexOf("ServiceExceptionReport") <= -1 && node.getNodeName().indexOf("FeatureCollection") <= -1) continue;
                        node2 = node;
                        string19 = WFSThemeProducer.normalize(node2.getNodeName());
                        break;
                    }
                }
                if (string19.equalsIgnoreCase("ServiceExceptionReport")) {
                    log.info("WFS error response for POST request: " + (String)object3);
                    if (string5 != null) {
                        log.info("Trying WFS GET request: " + string4);
                        object3 = Util.issueHttpGetRequest(string4);
                        log.info("Processing GET response...");
                        DOMParser dOMParser2 = new DOMParser();
                        dOMParser2.setValidationMode(0);
                        dOMParser2.setPreserveWhitespace(false);
                        object2 = new StringReader((String)object3);
                        dOMParser2.parse((Reader)object2);
                        object = dOMParser2.getDocument();
                        ((StringReader)object2).close();
                        node2 = object.getFirstChild();
                        if (node2 == null) {
                            log.info("Invalid XML response. Root node not found.");
                            return 0;
                        }
                        string19 = WFSThemeProducer.normalize(node2.getNodeName());
                        if (!string19.equalsIgnoreCase("ServiceExceptionReport") && !string19.equalsIgnoreCase("FeatureCollection")) {
                            nodeList = object.getChildNodes();
                            for (n = 0; n < nodeList.getLength(); ++n) {
                                node = nodeList.item(n);
                                if (node.getNodeName().indexOf("ServiceExceptionReport") <= -1 && node.getNodeName().indexOf("FeatureCollection") <= -1) continue;
                                node2 = node;
                                string19 = WFSThemeProducer.normalize(node2.getNodeName());
                                break;
                            }
                        }
                        if (string19.equalsIgnoreCase("ServiceExceptionReport")) {
                            log.info("WFS error response for GET request: " + (String)object3);
                        }
                    }
                }
                if (string19.equalsIgnoreCase("FeatureCollection") && (nodeList = node2.getChildNodes()) != null) {
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        String string20;
                        node = nodeList.item(n);
                        if (!WFSThemeProducer.normalize(node.getNodeName()).equalsIgnoreCase("featuremember")) continue;
                        NodeList nodeList2 = node.getChildNodes();
                        Node node3 = null;
                        for (int i = 0; i < nodeList2.getLength(); ++i) {
                            string20 = WFSThemeProducer.normalize(nodeList2.item(i).getNodeName());
                            if (!string20.equalsIgnoreCase(string3)) continue;
                            node3 = nodeList2.item(i);
                            break;
                        }
                        StyledFeatureI styledFeatureI = null;
                        if (node3 != null) {
                            string20 = XMLDOMParser.getAttribute(node3, "fid");
                            NodeList nodeList3 = node3.getChildNodes();
                            if (nodeList3 != null) {
                                Object object6;
                                String string21;
                                String[] stringArray;
                                Object object7;
                                for (int i = 0; i < nodeList3.getLength(); ++i) {
                                    object7 = nodeList3.item(i);
                                    String string22 = WFSThemeProducer.normalize(object7.getNodeName());
                                    if (object7.getNodeName().indexOf("gml:") > -1) {
                                        string22 = object7.getNodeName();
                                    }
                                    if (!string22.equalsIgnoreCase(this.def.getSpatialColumn())) continue;
                                    stringArray = this.getGeometryNode((Node)object7);
                                    if (stringArray == null || (string21 = GML.fromNodeToGeometry((Node)stringArray)) == null) break;
                                    styledFeatureI = this.getNewStyledFeatureInstance();
                                    if (!bl) {
                                        styledFeatureI.setID(string20);
                                    }
                                    object6 = JSDOGeometry.recast((JGeometry)string21);
                                    object6.setSRID(this.def.getSrid());
                                    styledFeatureI.setGeometry((JSDOGeometry)object6);
                                    styledFeatureI.setDataSource(this.def.getDataSourceName());
                                    styledFeatureI.setFeatureStyleName(this.def.getRenderStyle());
                                    break;
                                }
                                if (styledFeatureI != null) {
                                    if (this.def.getLabelColumn() != null && this.def.getLabelColumn().equalsIgnoreCase("dummy")) {
                                        styledFeatureI.setLabel("dummy");
                                        styledFeatureI.setLabelStyleName(this.def.getLabelStyle());
                                    }
                                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                                    object7 = new Vector();
                                    for (int i = 0; i < nodeList3.getLength(); ++i) {
                                        Object object8;
                                        Object object9;
                                        Object object10;
                                        stringArray = nodeList3.item(i);
                                        string21 = WFSThemeProducer.normalize(stringArray.getNodeName());
                                        if (stringArray.getNodeName().indexOf("gml:") > -1) {
                                            string21 = stringArray.getNodeName();
                                        }
                                        if (string21.equalsIgnoreCase(this.def.getSpatialColumn()) || (object6 = stringArray.getFirstChild()) == null) continue;
                                        String string23 = object6.getNodeValue();
                                        if (this.def.getLabelColumn() != null && this.def.getLabelColumn().equalsIgnoreCase(string21)) {
                                            styledFeatureI.setLabel(string23);
                                            styledFeatureI.setLabelStyleName(this.def.getLabelStyle());
                                            if (this.isOnAttributeList(string21)) {
                                                object10 = (String)hashtable.get(string21);
                                                object9 = Field.createField(string23, (String)object10);
                                                ((Field)object9).setName(string21);
                                                hashtable2.put(string21, object9);
                                            }
                                            if ((object10 = this.getInfoColumn(string21)) != null && hashtable != null) {
                                                object9 = (String)hashtable.get(string21);
                                                object8 = Field.createField(string23, (String)object9);
                                                ((Field)object8).setName(((Field)object10).getName());
                                                ((Field)object8).setDisplayName(((Field)object10).getDisplayName());
                                                ((Vector)object7).add(object8);
                                            }
                                            if (!bl || !string21.equalsIgnoreCase(string)) continue;
                                            styledFeatureI.setID(string23);
                                            continue;
                                        }
                                        if (hashtable == null || (object10 = (String)hashtable.get(string21)) == null) continue;
                                        if (this.isOnAttributeList(string21)) {
                                            object9 = Field.createField(string23, (String)object10);
                                            ((Field)object9).setName(string21);
                                            hashtable2.put(string21, object9);
                                        }
                                        if ((object9 = this.getInfoColumn(string21)) != null) {
                                            object8 = (String)hashtable.get(string21);
                                            Field field = Field.createField(string23, (String)object8);
                                            field.setName(((Field)object9).getName());
                                            field.setDisplayName(((Field)object9).getDisplayName());
                                            ((Vector)object7).add(field);
                                        }
                                        if (!bl || !string21.equalsIgnoreCase(string)) continue;
                                        styledFeatureI.setID(string23);
                                    }
                                    if (hashtable2.size() > 0 && hashtable != null) {
                                        Vector<Object> vector = new Vector<Object>();
                                        stringArray = this.def.getFeatureAttributes();
                                        for (int i = 0; i < stringArray.length; ++i) {
                                            object6 = (Field)hashtable2.get(stringArray[i]);
                                            if (object6 == null) continue;
                                            vector.add(object6);
                                        }
                                        if (vector.size() > 0) {
                                            styledFeatureI.setRenderableAttributes(vector.toArray(new Field[vector.size()]));
                                        }
                                    }
                                    if (((Vector)object7).size() > 0) {
                                        styledFeatureI.setIdentifiableAttributes(((Vector)object7).toArray(new Field[((Vector)object7).size()]));
                                    }
                                }
                            }
                        }
                        if (styledFeatureI == null) continue;
                        arrayList.add(styledFeatureI);
                    }
                }
            }
            catch (Exception exception) {
                log.info("Exception: " + exception.getMessage());
                return 0;
            }
        }
        catch (Throwable throwable) {
            Object var70_86 = null;
            throw throwable;
        }
        Object var70_84 = null;
        if (arrayList.size() <= 0) {
            return 0;
        }
        if (visContext.getMasterSRID() > 0 && bl3) {
            log.info("Transforming styled features SRID " + this.def.getSrid() + " to map SRID " + visContext.getMasterSRID());
            for (int i = 0; i < arrayList.size(); ++i) {
                object3 = (StyledFeatureI)arrayList.get(i);
                JSDOGeometry jSDOGeometry = object3.getGeometry();
                if (jSDOGeometry == null || jSDOGeometry.getSRID() <= 0 || jSDOGeometry.getSRID() == visContext.getMasterSRID()) continue;
                object2 = null;
                try {
                    object2 = Util.processSRIDConversion(this.owner.getDataSourceName(), jSDOGeometry, visContext.getMasterSRID());
                }
                catch (Exception exception) {
                    object2 = null;
                }
                if (object2 == null) continue;
                object3.setGeometry(JSDOGeometry.recast((JGeometry)object2));
            }
            log.info("End of SRID transformation.");
            this.xl = d4;
            this.xh = d3;
            this.yl = d2;
            this.yh = d;
        }
        if (bl2) {
            log.info("Rotating styled feature geometries.");
            for (int i = 0; i < arrayList.size(); ++i) {
                JSDOGeometry jSDOGeometry;
                object3 = (StyledFeatureI)arrayList.get(i);
                JSDOGeometry jSDOGeometry2 = object3.getGeometry();
                if (jSDOGeometry2 == null || (object2 = Util.rotateGeometry(jSDOGeometry2, (this.xl + this.xh) / 2.0, (this.yl + this.yh) / 2.0, visContext.getRotation())) == null || (jSDOGeometry = JSDOGeometry.recast((JGeometry)object2)) == null) continue;
                object3.setGeometry(JSDOGeometry.recast(jSDOGeometry));
            }
        }
        this.setStyledFeatures(arrayList);
        int n = arrayList.size();
        arrayList = null;
        long l2 = System.currentTimeMillis();
        TopThemeQueries.add(l2 - l, this.getTheme().getName(), this.getTheme().getDataSourceName(), string2, "WFS features loaded = " + n);
        return this.features.size();
    }

    private Field getInfoColumn(String string) {
        if (string == null) {
            return null;
        }
        Field[] fieldArray = this.def.getIdentifiableColumns();
        if (fieldArray == null) {
            return null;
        }
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!field.getName().equalsIgnoreCase(string)) continue;
            return field;
        }
        return null;
    }

    private boolean isOnAttributeList(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = this.def.getFeatureAttributes();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private String getGeometryString(JSDOGeometry jSDOGeometry) {
        if (jSDOGeometry == null) {
            return null;
        }
        int n = jSDOGeometry.getType();
        if (n < 1 || n > 7) {
            return null;
        }
        double[] dArray = jSDOGeometry.getPoint();
        String string = "null";
        if (dArray != null) {
            string = "MDSYS.SDO_POINT(" + dArray[0] + "," + dArray[1] + ",";
            string = dArray.length > 2 ? (dArray[2] != Double.NaN ? string + dArray[2] + ")" : string + "null)") : string + "null)";
        }
        int n2 = jSDOGeometry.getSRID();
        int n3 = 2000 + n;
        String string2 = "null";
        int[] nArray = jSDOGeometry.getElemInfo();
        if (nArray != null) {
            string2 = "MDSYS.SDO_ELEM_INFO_ARRAY(" + nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                string2 = string2 + "," + nArray[i];
            }
            string2 = string2 + ")";
        }
        String string3 = "null";
        double[] dArray2 = jSDOGeometry.getOrdinatesArray();
        if (dArray2 != null) {
            string3 = "MDSYS.SDO_ORDINATE_ARRAY(" + dArray2[0];
            for (int i = 1; i < dArray2.length; ++i) {
                string3 = string3 + "," + dArray2[i];
            }
            string3 = string3 + ")";
        }
        String string4 = "MDSYS.SDO_GEOMETRY(" + n3 + "," + n2 + "," + string + "," + string2 + "," + string3 + ")";
        System.out.println("Geom str: " + string4);
        return string4;
    }

    public static String normalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") >= 0) {
            return string.substring(string.indexOf(":") + 1);
        }
        return string;
    }

    private boolean isFullExtent(double d, double d2, double d3, double d4) {
        return Double.isInfinite(d) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4);
    }

    private Node getGeometryNode(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = WFSThemeProducer.normalize(node2.getNodeName()).toUpperCase();
            if (!string.equals("POINT") && !string.equals("LINESTRING") && !string.equals("POLYGON") && !string.equals("SURFACE") && !string.equals("MULTIPOINT") && !string.equals("MULTILINESTRING") && !string.equals("BOX") && !string.equals("LINEARRING") && !string.equals("MULTIPOLYGON") && !string.equals("MULTIGEOMETRY")) continue;
            return node2;
        }
        return null;
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }

    public void destroy() {
        this.clearFeatures();
    }

    public void abort() {
    }

    private void clearFeatures() {
        if (this.features != null) {
            this.features.setStyledFeatures((List)null);
        }
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeatures(rectangle2D);
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        if (this.features == null) {
            return null;
        }
        return this.features.getSelectedFeaturesAsTheme(rectangle2D, string);
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(styledFeatureIArray);
    }

    public void setStyledFeatures(ArrayList arrayList) {
        this.features = new LocalThemeDataProducer(this.getTheme());
        this.features.setStyledFeatures(arrayList);
    }

    public Theme getTheme() {
        return this.owner;
    }

    public StyledFeatureI[] getStyledFeatures() {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeatures();
    }

    public StyledFeatureI getStyledFeature(int n) {
        if (this.features == null) {
            return null;
        }
        return this.features.getStyledFeature(n);
    }

    public double[] getDataMBR() {
        if (this.features == null) {
            return null;
        }
        return this.features.getDataMBR();
    }

    public void postPreparation(VisContext visContext) {
        if (this.features != null) {
            this.features.postPreparation(visContext);
        }
    }

    public int size() {
        return this.features != null ? this.features.size() : 0;
    }
}

