/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.logging.Logger;
import oracle.mapviewer.share.util.EPSG2SDO;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.util.Util;

public class WMSMapThemeDefinition
extends ThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String serverUrlPrefix;
    String wmtVersion;
    String srs;
    String format;
    String bgColor;
    String exceptions;
    boolean transparent;
    String[] layers;
    String[] styles;
    String[][] vsps;
    String capabilitiesUrlPrefix = null;

    public WMSMapThemeDefinition() {
        this.wmtVersion = "1.1.1";
        this.format = "image/png";
        this.transparent = false;
        this.bgColor = "0xffffff";
        this.exceptions = "application/vnd.ogc.se_xml";
    }

    public WMSMapThemeDefinition(String string, String string2, String string3, String[] stringArray, String[] stringArray2, String string4, String string5, boolean bl, String string6, String string7, String[][] stringArray3) {
        int n;
        this.serverUrlPrefix = string2.endsWith("?") ? string2.substring(0, string2.length() - 1) : string2;
        this.setName(string);
        this.wmtVersion = string3;
        this.transparent = bl;
        this.setSrs(string4);
        this.bgColor = string6;
        this.format = string5 == null ? "image/png" : string5.toLowerCase();
        if (stringArray != null) {
            this.layers = new String[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                this.layers[n] = new String(stringArray[n]);
            }
        } else {
            this.layers = null;
        }
        if (stringArray2 != null) {
            this.styles = new String[stringArray2.length];
            for (n = 0; n < stringArray2.length; ++n) {
                this.styles[n] = new String(stringArray2[n]);
            }
        } else {
            this.styles = null;
        }
        this.exceptions = string7 == null ? "application/vnd.ogc.se_xml" : string7;
        if (stringArray3 != null && stringArray3.length == 2) {
            this.vsps = stringArray3;
        } else {
            this.vsps = null;
            log.finer("No VSPs");
        }
    }

    public void setServerUrlPrefix(String string) {
        this.serverUrlPrefix = string;
    }

    public String getServerUrlPrefix() {
        return this.serverUrlPrefix;
    }

    public void setWmtVersion(String string) {
        this.wmtVersion = string;
    }

    public String getWmtVersion() {
        return this.wmtVersion;
    }

    public void setSrs(String string) {
        int n;
        if (this.srs != null && string != null && this.srs.equalsIgnoreCase(string)) {
            return;
        }
        this.srs = string;
        if (string != null && (string.indexOf("epsg.xml") > -1 || string.indexOf("#") > -1) && (n = string.indexOf("#")) > -1) {
            this.srs = "EPSG:" + string.substring(n + 1, string.length());
        }
        String string2 = "";
        if (this.srs != null) {
            string2 = this.srs;
            int n2 = this.srs.indexOf(":");
            if (n2 > -1) {
                string2 = this.srs.substring(n2 + 1, this.srs.length());
            }
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return;
            }
            if (this.srs.toUpperCase().indexOf("EPSG:") == -1) {
                this.srid = n3;
            } else {
                int n4 = 0;
                String string3 = EPSG2SDO.EPSGtoSDO(String.valueOf(n3));
                if (string3 != null) {
                    n4 = Integer.parseInt(string3);
                } else if (this.dataSource != null) {
                    n4 = Util.EPSGsrid_To_Oraclesrid(this.dataSource, n3);
                }
                if (n4 > 0) {
                    this.srid = n4;
                    log.info("Theme SRID set to " + this.srid + " for EPSG " + n3);
                } else if (Util.existsOracleSRID(this.dataSource, n3)) {
                    this.srid = n3;
                    log.info("Theme SRID set to " + this.srid);
                } else {
                    log.warning("Unable to find an equivalent SDO SRID for EPSG " + n3);
                    this.srid = 0;
                }
            }
        }
    }

    public String getSrs() {
        return this.srs;
    }

    public String getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(String string) {
        if (string != null) {
            this.exceptions = string;
        }
    }

    public void setFormat(String string) {
        this.format = string == null ? "image/png" : string.toLowerCase();
    }

    public String getFormat() {
        return this.format;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(String string) {
        this.bgColor = string;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setLayers(String[] stringArray) {
        if (stringArray != null) {
            this.layers = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.layers[i] = new String(stringArray[i]);
            }
        } else {
            this.layers = null;
        }
    }

    public String[] getLayers() {
        return this.layers;
    }

    public void setStyles(String[] stringArray) {
        if (stringArray != null) {
            this.styles = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.styles[i] = new String(stringArray[i]);
            }
        } else {
            this.styles = null;
        }
    }

    public String[] getStyles() {
        return this.styles;
    }

    public void setVsps(String[][] stringArray) {
        if (stringArray != null) {
            this.vsps = new String[2][stringArray[0].length];
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray[i].length; ++j) {
                    this.vsps[i][j] = new String(stringArray[i][j]);
                }
            }
        } else {
            this.vsps = null;
        }
    }

    public String[][] getVsps() {
        return this.vsps;
    }

    public String getThemeType() {
        return "WMS";
    }

    public String getXMLDefinition() {
        return "";
    }

    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.serverUrlPrefix);
        basicThemeInfo.setType("WMS");
        basicThemeInfo.setKeyColumn(null);
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(null);
        return basicThemeInfo;
    }

    public String[] getRenderingStyles() {
        return null;
    }

    public String[] getLabelingStyles() {
        return null;
    }

    public void setCapabilitiesUrlPrefix(String string) {
        this.capabilitiesUrlPrefix = string;
    }

    public String getCapabilitiesUrlPrefix() {
        return this.capabilitiesUrlPrefix;
    }
}

