/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import oracle.mapviewer.share.LabelingHints;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.style.TextPath;
import oracle.sdovis.util.BestFitInfo;
import oracle.sdovis.util.RectArray;
import oracle.sdovis.util.ShapeUtil;

public class BestFitText {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final FontRenderContext frc = new FontRenderContext(null, true, false);

    public Shape putTextOnBestFitLine(TextPath textPath, Graphics2D graphics2D, Shape shape, String string, double d, RectArray rectArray, boolean bl, boolean bl2, boolean bl3) {
        TextStyleModel textStyleModel;
        Font font;
        int n;
        boolean bl4 = false;
        GeneralPath generalPath = new GeneralPath();
        CandidateRuns1[] candidateRuns1Array = this.getCandidates(shape, d, textPath);
        block0: for (int i = 0; !(i >= candidateRuns1Array.length || bl4 && bl2); ++i) {
            CandidateRuns1 candidateRuns1 = candidateRuns1Array[i];
            if (candidateRuns1.size <= 1 || candidateRuns1.len < d) continue;
            n = -1;
            for (int j = 0; j < 3; ++j) {
                int n2 = candidateRuns1.indexes[j];
                if (n2 < 0 || n2 == n) continue;
                Shape shape2 = this.putTextOnBestFitLine(textPath, graphics2D, candidateRuns1.x, candidateRuns1.y, n2, candidateRuns1.numPoints[j], string, rectArray, bl, bl3);
                if (shape2 != null) {
                    generalPath.append(shape2, false);
                    bl4 = true;
                    continue block0;
                }
                n = n2;
            }
        }
        if (bl4 || !bl) {
            return generalPath;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        int n3 = (int)rectangle2D.getCenterX();
        n = (int)rectangle2D.getCenterY();
        double[] dArray = ShapeUtil.getEndPoints(shape);
        double d2 = 0.0;
        if (dArray != null) {
            if (!bl3 && dArray[2] < dArray[0]) {
                double d3 = dArray[0];
                double d4 = dArray[1];
                dArray[0] = dArray[2];
                dArray[1] = dArray[3];
                dArray[2] = d3;
                dArray[3] = d4;
            }
            d2 = Math.atan2(dArray[3] - dArray[1], dArray[2] - dArray[0]);
        }
        if ((font = (textStyleModel = textPath.getBean()).getFont()) != null && textPath.getTextStyleModifiers() != null) {
            font = new Font(font.getFamily(), font.getStyle(), textPath.getTextStyleModifiers().getFontSize());
        }
        GlyphVectorInfo glyphVectorInfo = new GlyphVectorInfo();
        glyphVectorInfo.txt = string;
        GlyphVector glyphVector = font.createGlyphVector(frc, string);
        glyphVector.performDefaultLayout();
        glyphVectorInfo.visualBounds = glyphVector.getVisualBounds();
        glyphVectorInfo.avgGW = glyphVectorInfo.visualBounds.getWidth() / (double)glyphVector.getNumGlyphs();
        glyphVectorInfo.visualCenterY = glyphVectorInfo.visualBounds.getCenterY();
        Point2D point2D = glyphVector.getGlyphPosition(0);
        glyphVectorInfo.ngx = point2D.getX();
        glyphVectorInfo.ngy = point2D.getY();
        Object object = textStyleModel.getLabelingHint(LabelingHints.KEY_LINE_VALIGN);
        if (object == null) {
            object = LabelingHints.VALUE_LINE_VALIGN_BASELINE;
        }
        double[] dArray2 = this.getGlyphOffset(glyphVectorInfo, 0.0, object);
        return StyleText.getLayout(graphics2D, string, n3, n, LabelingHints.VALUE_OPOINT_HALIGN_CENTER, d2, (int)dArray2[1], textStyleModel, textPath.getTextStyleModifiers());
    }

    private double[] getGlyphOffset(GlyphVectorInfo glyphVectorInfo, double d, Object object) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (object == LabelingHints.VALUE_LINE_VALIGN_MIDDLE) {
            d2 = 0.0;
            d3 = 0.0;
        } else if (object == LabelingHints.VALUE_LINE_VALIGN_BASELINE) {
            double d4 = glyphVectorInfo.visualCenterY - glyphVectorInfo.ngy;
            d2 = -d4 * Math.sin(d);
            d3 = d4 * Math.cos(d);
        } else if (object == LabelingHints.VALUE_LINE_VALIGN_BOTTOM) {
            double d5 = glyphVectorInfo.visualBounds.getHeight() / 2.0 + 1.0;
            d2 = d5 * Math.sin(d);
            d3 = -d5 * Math.cos(d);
        } else if (object == LabelingHints.VALUE_LINE_VALIGN_TOP) {
            double d6 = glyphVectorInfo.visualBounds.getHeight() / 2.0 + 1.0;
            d2 = -d6 * Math.sin(d);
            d3 = d6 * Math.cos(d);
        }
        return new double[]{d2, d3};
    }

    public Shape putTextOnBestFitLine(TextPath textPath, Graphics graphics, float[] fArray, float[] fArray2, int n, int n2, String string, RectArray rectArray, boolean bl, boolean bl2) {
        Object[] objectArray;
        Object object;
        Object object2;
        int n3;
        double d = 5.0;
        TextStyleModel textStyleModel = textPath.getBean();
        Font font = textStyleModel.getFont();
        if (textPath.getTextStyleModifiers() != null) {
            font = new Font(textStyleModel.getFont().getFamily(), textStyleModel.getFont().getStyle(), textPath.getTextStyleModifiers().getFontSize());
        }
        FontRenderContext fontRenderContext = textPath.getFrc();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        glyphVector.performDefaultLayout();
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        double d2 = rectangle2D.getCenterY();
        Point2D point2D = glyphVector.getGlyphPosition(0);
        textStyleModel.setLabelingHint(LabelingHints.KEY_LINE_HALIGN, LabelingHints.VALUE_LINE_HALIGN_CENTER);
        textPath.setBean(textStyleModel);
        float[] fArray3 = new float[n2];
        float[] fArray4 = new float[n2];
        int n4 = n;
        for (int i = 0; i < n2; ++i) {
            fArray3[i] = fArray[n4];
            fArray4[i] = fArray2[n4];
            ++n4;
        }
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl3 = false;
        double d3 = rectangle2D.getWidth();
        Shape shape = null;
        for (n3 = 0; n3 < fArray3.length; ++n3) {
            object2 = this.getLongestSegment(fArray3, fArray4, vector);
            int n5 = (Integer)((Vector)object2).elementAt(0);
            double d4 = (Double)((Vector)object2).elementAt(1);
            if (d4 + 2.0 * d >= rectangle2D.getWidth()) {
                float[] fArray5 = new float[]{fArray3[n5], fArray3[n5 + 1]};
                float[] fArray6 = new float[]{fArray4[n5], fArray4[n5 + 1]};
                float[] fArray7 = this.calcMidPoint(fArray5, fArray6);
                double d5 = (double)(fArray6[1] - fArray6[0]) / d4 * (d3 / 2.0);
                double d6 = (double)(fArray5[1] - fArray5[0]) / d4 * (d3 / 2.0);
                object = new float[]{(float)((double)fArray7[0] - d6), (float)((double)fArray7[0] + d6)};
                objectArray = new float[]{(float)((double)fArray7[1] - d5), (float)((double)fArray7[1] + d5)};
                boolean bl4 = rectArray.conflicts((double)object[0], objectArray[0], (double)(object[1] - object[0] + 1.0f), objectArray[1] - objectArray[0] + 1.0f);
                if (!bl4) {
                    bl3 = true;
                    shape = this.placeText((float[])object, (float[])objectArray, string, textStyleModel, graphics, textPath.getTextStyleModifiers(), bl2);
                    break;
                }
            }
            vector.addElement(new Integer(n5));
        }
        if (!bl3) {
            Object object3;
            Object object4;
            Object object5;
            n3 = 0;
            object2 = new double[fArray3.length];
            double[] dArray = new double[fArray4.length];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object2[i] = 1.0;
                dArray[i] = 1.0;
            }
            Hashtable hashtable = new Hashtable();
            double[] dArray2 = this.lsfit(fArray3, fArray4, (double[])object2, dArray, fArray3.length);
            double d7 = dArray2[1];
            double d8 = dArray2[0];
            float f = (float)(d7 * (double)fArray3[0] + d8);
            float f2 = (float)(d7 * (double)fArray3[fArray3.length - 1] + d8);
            Line2D.Float float_ = new Line2D.Float(fArray3[0], f, fArray3[fArray3.length - 1], f2);
            object = new Vector<BestFitInfo>();
            objectArray = this.getAngles(fArray3, fArray4);
            BestFitInfo bestFitInfo = new BestFitInfo(n3, fArray3, fArray4, (double[])objectArray, float_);
            double d9 = Math.abs(Math.toDegrees(bestFitInfo.avg_angle) - 180.0);
            ((Vector)object).addElement(bestFitInfo);
            Vector<BestFitInfo> vector2 = new Vector<BestFitInfo>();
            vector2.addElement(bestFitInfo);
            hashtable.put(new Double(d9), vector2);
            while (((Vector)object).size() > 0) {
                Vector<BestFitInfo> vector3;
                Double d10;
                double d11;
                double d12;
                BestFitInfo bestFitInfo2;
                Object object6;
                Object object7;
                int n6;
                int n7;
                BestFitInfo bestFitInfo3 = (BestFitInfo)((Vector)object).elementAt(0);
                object5 = bestFitInfo3.x;
                float[] fArray8 = bestFitInfo3.y;
                double[] dArray3 = bestFitInfo3.angles;
                int n8 = bestFitInfo3.id;
                int n9 = 0;
                n9 = this.getWorstAnglePt(dArray3);
                float[] fArray9 = new float[n9 + 1];
                object4 = new float[n9 + 1];
                object3 = new double[n9 - 1];
                int n10 = 0;
                for (n7 = 0; n7 <= n9; ++n7) {
                    fArray9[n7] = (float)object5[n10];
                    object4[n7] = fArray8[n10];
                    ++n10;
                }
                int n11 = 0;
                for (n6 = 0; n6 < ((Object)object3).length; ++n6) {
                    object3[n6] = dArray3[n11];
                    ++n11;
                }
                ++n11;
                float[] fArray10 = new float[((Object)object5).length - n9];
                float[] fArray11 = new float[fArray8.length - n9];
                double[] dArray4 = new double[((Object)object5).length - n9 - 2];
                n10 = n9;
                for (n7 = 0; n7 < fArray10.length; ++n7) {
                    fArray10[n7] = (float)object5[n10];
                    fArray11[n7] = fArray8[n10];
                    ++n10;
                }
                n6 = 0;
                while (n11 < dArray3.length) {
                    dArray4[n6] = dArray3[n11];
                    ++n6;
                    ++n11;
                }
                float f3 = 0.0f;
                float f4 = 0.0f;
                double d13 = 0.0;
                double d14 = 0.0;
                if (fArray9.length > 2) {
                    if (string.trim().toUpperCase().compareTo("HOSMER ST") == 0) {
                        System.out.println("lsfit a");
                    }
                    object7 = this.lsfit(fArray9, (float[])object4, (double[])object2, dArray, fArray9.length);
                    d13 = object7[1];
                    d14 = object7[0];
                    f3 = (float)(d13 * (double)fArray9[0] + d14);
                    f4 = (float)(d13 * (double)fArray9[fArray9.length - 1] + d14);
                } else {
                    f3 = object4[0];
                    f4 = object4[1];
                    d13 = (f4 - f3) / (fArray9[0] - fArray9[1]);
                    d14 = (double)f3 - d13 * (double)fArray9[0];
                }
                object7 = new Line2D.Float(fArray9[0], f3, fArray9[fArray9.length - 1], f4);
                double d15 = this.calcVariance(fArray9, (float[])object4, (Line2D.Float)object7, d13, d14);
                float f5 = 0.0f;
                float f6 = 0.0f;
                double d16 = 0.0;
                double d17 = 0.0;
                if (fArray10.length > 2) {
                    if (string.trim().toUpperCase().compareTo("HOSMER ST") == 0) {
                        System.out.println("lsfit b");
                    }
                    object6 = this.lsfit(fArray10, fArray11, (double[])object2, dArray, fArray10.length);
                    d16 = object6[1];
                    d17 = object6[0];
                    f5 = (float)(d16 * (double)fArray10[0] + d17);
                    f6 = (float)(d16 * (double)fArray10[fArray10.length - 1] + d17);
                } else {
                    f5 = fArray11[0];
                    f6 = fArray11[1];
                    d16 = (f6 - f5) / (fArray10[0] - fArray10[fArray10.length - 1]);
                    d17 = (double)f5 - d16 * (double)fArray10[0];
                }
                object6 = new Line2D.Float(fArray10[0], f5, fArray10[fArray10.length - 1], f6);
                double d18 = this.calcVariance(fArray10, fArray11, (Line2D.Float)object6, d16, d17);
                ((Vector)object).removeElementAt(0);
                double d19 = this.calcLen(fArray9[0], f3, fArray9[fArray9.length - 1], f4);
                double d20 = this.calcLen(fArray10[0], f5, fArray10[fArray10.length - 1], f6);
                if (d19 + 2.0 * d >= rectangle2D.getWidth()) {
                    bestFitInfo2 = new BestFitInfo(++n3, fArray9, (float[])object4, (double[])object3, (Line2D.Float)object7);
                    ((Vector)object).addElement(bestFitInfo2);
                    d12 = bestFitInfo2.avg_angle;
                    d11 = Math.abs(Math.toDegrees(d12) - 180.0);
                    d10 = new Double(d11);
                    vector3 = (Vector<BestFitInfo>)hashtable.get(d10);
                    if (vector3 != null) {
                        vector3.addElement(bestFitInfo2);
                        hashtable.put(d10, vector3);
                    } else {
                        vector3 = new Vector<BestFitInfo>();
                        vector3.addElement(bestFitInfo2);
                        hashtable.put(d10, vector3);
                    }
                }
                if (!(d20 + 2.0 * d >= rectangle2D.getWidth())) continue;
                bestFitInfo2 = new BestFitInfo(++n3, fArray10, fArray11, dArray4, (Line2D.Float)object6);
                ((Vector)object).addElement(bestFitInfo2);
                d12 = bestFitInfo2.avg_angle;
                d11 = Math.abs(Math.toDegrees(d12) - 180.0);
                d10 = new Double(d11);
                vector3 = (Vector<BestFitInfo>)hashtable.get(d10);
                if (vector3 != null) {
                    vector3.addElement(bestFitInfo2);
                    hashtable.put(d10, vector3);
                    continue;
                }
                vector3 = new Vector<BestFitInfo>();
                vector3.addElement(bestFitInfo2);
                hashtable.put(d10, vector3);
            }
            boolean bl5 = true;
            while (hashtable.size() != 0) {
                object5 = hashtable.keys();
                double d21 = (Double)object5.nextElement();
                while (object5.hasMoreElements()) {
                    double d22 = (Double)object5.nextElement();
                    if (!(d22 < d21)) continue;
                    d21 = d22;
                }
                Double d23 = new Double(d21);
                Vector vector4 = (Vector)hashtable.get(d23);
                for (int i = 0; i < vector4.size(); ++i) {
                    object4 = (BestFitInfo)vector4.elementAt(i);
                    object3 = object4.line;
                    float[] fArray12 = new float[]{(float)((Line2D.Float)object3).getX1(), (float)((Line2D.Float)object3).getX2()};
                    float[] fArray13 = new float[]{(float)((Line2D.Float)object3).getY1(), (float)((Line2D.Float)object3).getY2()};
                    float[] fArray14 = this.calcMidPoint(fArray12, fArray13);
                    double d24 = this.calcLen(fArray12[0], fArray13[0], fArray12[1], fArray13[1]);
                    double d25 = (double)(fArray13[1] - fArray13[0]) / d24 * (d3 / 2.0);
                    double d26 = (double)(fArray12[1] - fArray12[0]) / d24 * (d3 / 2.0);
                    float[] fArray15 = new float[]{(float)((double)fArray14[0] - d26), (float)((double)fArray14[0] + d26)};
                    float[] fArray16 = new float[]{(float)((double)fArray14[1] - d25), (float)((double)fArray14[1] + d25)};
                    bl5 = rectArray.conflicts(fArray15[0], fArray16[0], fArray15[1] - fArray15[0] + 1.0f, fArray16[1] - fArray16[0] + 1.0f);
                    if (bl5) continue;
                    shape = this.placeText(fArray15, fArray16, string, textStyleModel, graphics, textPath.getTextStyleModifiers(), bl2);
                    break;
                }
                if (!bl5) break;
                hashtable.remove(d23);
            }
        }
        return shape;
    }

    public void drawStreet(float[] fArray, float[] fArray2, Graphics graphics) {
        graphics.setColor(Color.yellow);
        for (int i = 0; i < fArray.length - 1; ++i) {
            graphics.drawLine((int)fArray[i], (int)fArray2[i], (int)fArray[i + 1], (int)fArray2[i + 1]);
        }
    }

    public double[] lsfit(float[] fArray, float[] fArray2, double[] dArray, double[] dArray2, int n) {
        double[] dArray3 = new double[4];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (dArray2 != null) {
            for (int i = 0; i < n; ++i) {
                d += 1.0 / (dArray2[i] * dArray2[i]);
                d2 += (double)fArray[i] / (dArray2[i] * dArray2[i]);
                d3 += (double)fArray2[i] / (dArray2[i] * dArray2[i]);
                d4 += (double)(fArray[i] * fArray[i]) / (dArray2[i] * dArray2[i]);
                d5 += (double)(fArray[i] * fArray2[i]) / (dArray2[i] * dArray2[i]);
            }
        } else {
            d = fArray.length;
            for (int i = 0; i < n; ++i) {
                d2 += (double)fArray[i];
                d3 += (double)fArray2[i];
                d4 += (double)(fArray[i] * fArray[i]);
                d5 += (double)(fArray[i] * fArray2[i]);
            }
        }
        double d6 = d * d4 - d2 * d2;
        dArray3[0] = (d4 * d3 - d2 * d5) / d6;
        dArray3[1] = (d * d5 - d2 * d3) / d6;
        dArray3[2] = d4 / d6;
        dArray3[3] = d / d6;
        return dArray3;
    }

    public double calcVariance(float[] fArray, float[] fArray2, Line2D.Float float_, double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < fArray2.length; ++i) {
            double d4 = d * (double)fArray[i] + d2;
            d3 += Math.pow((double)fArray2[i] - d4, 2.0) / (double)(fArray2.length - 2);
        }
        return d3;
    }

    public int getWorstAnglePt(double[] dArray) {
        double d = dArray[0];
        double d2 = Math.abs(Math.toDegrees(dArray[0]) - 180.0);
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            double d3 = Math.abs(Math.toDegrees(dArray[i]) - 180.0);
            if (!(d3 > d2)) continue;
            d2 = d3;
            n = i;
        }
        return n + 1;
    }

    public double[] getAngles(float[] fArray, float[] fArray2) {
        double[] dArray = new double[fArray.length - 2];
        for (int i = 0; i < fArray.length - 2; ++i) {
            double d = fArray[i];
            double d2 = fArray[i + 1];
            double d3 = fArray[i + 2];
            double d4 = fArray2[i];
            double d5 = fArray2[i + 1];
            double d6 = fArray2[i + 2];
            Vector2d vector2d = new Vector2d(d2 - d, d5 - d4);
            Vector2d vector2d2 = new Vector2d(d3 - d2, d6 - d5);
            dArray[i] = vector2d.angle(vector2d2);
        }
        return dArray;
    }

    public double calcLen(float f, float f2, float f3, float f4) {
        double d = Math.sqrt(Math.pow(Math.abs(f3 - f), 2.0) + Math.pow(Math.abs(f4 - f2), 2.0));
        return d;
    }

    public Vector getLongestSegment(float[] fArray, float[] fArray2, Vector vector) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < fArray.length - 1; ++i) {
            float f = fArray[i];
            float f2 = fArray2[i];
            float f3 = fArray[i + 1];
            float f4 = fArray2[i + 1];
            double d2 = this.calcLen(f, f2, f3, f4);
            if (!(d2 > d)) continue;
            boolean bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                if (i != (Integer)vector.elementAt(j)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            d = d2;
            n = i;
        }
        Vector<Number> vector2 = new Vector<Number>();
        vector2.addElement(new Integer(n));
        vector2.addElement(new Double(d));
        return vector2;
    }

    public float[] calcMidPoint(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[]{(fArray[0] + fArray[1]) / 2.0f, (fArray2[0] + fArray2[1]) / 2.0f};
        return fArray3;
    }

    private CandidateRuns1[] getCandidates(Shape shape, double d, TextPath textPath) {
        Vector<CandidateRuns1> vector = null;
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        double d2 = 0.0;
        int n = 0;
        CandidateRuns1 candidateRuns1 = new CandidateRuns1();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f = fArray[0];
                    f2 = fArray[1];
                    if (n == 0) {
                        candidateRuns1.append(f, f2, d, textPath);
                        break;
                    }
                    if (f == f3 && f2 == f4) break;
                    candidateRuns1.setStartingIndexes(d);
                    if (vector == null) {
                        vector = new Vector<CandidateRuns1>(1);
                    }
                    vector.add(candidateRuns1);
                    candidateRuns1 = new CandidateRuns1();
                    candidateRuns1.append(f, f2, d, textPath);
                    break;
                }
                case 1: {
                    f3 = fArray[0];
                    f4 = fArray[1];
                    candidateRuns1.append(f3, f4, d, textPath);
                }
            }
            ++n;
            pathIterator.next();
        }
        candidateRuns1.setStartingIndexes(d);
        if (vector == null) {
            return new CandidateRuns1[]{candidateRuns1};
        }
        vector.add(candidateRuns1);
        return vector.toArray(new CandidateRuns1[vector.size()]);
    }

    private Shape placeText(float[] fArray, float[] fArray2, String string, TextStyleModel textStyleModel, Graphics graphics, StyleModifiers styleModifiers, boolean bl) {
        Shape shape = null;
        float f = fArray[0];
        float f2 = fArray2[0];
        float f3 = fArray[1];
        float f4 = fArray2[1];
        if (!bl && f > f3) {
            f = fArray[1];
            f2 = fArray2[1];
            f3 = fArray[0];
            f4 = fArray2[0];
        }
        if (null != (shape = StyleText.getStringOutline(string, textStyleModel, styleModifiers))) {
            double d = Math.atan2(f4 - f2, f3 - f);
            shape = AffineTransform.getRotateInstance(d).createTransformedShape(shape);
            shape = AffineTransform.getTranslateInstance(f, f2).createTransformedShape(shape);
        }
        return shape;
    }

    class CandidateRuns1 {
        float[] x;
        float[] y;
        int[] indexes = new int[3];
        int[] numPoints;
        int size;
        double len;

        public CandidateRuns1() {
            this.indexes[0] = -1;
            this.indexes[1] = -1;
            this.indexes[2] = 0;
            this.numPoints = new int[3];
            this.numPoints[0] = 0;
            this.numPoints[1] = 0;
            this.numPoints[2] = 0;
            this.size = 0;
        }

        public CandidateRuns1(int n) {
            this();
            this.x = new float[n];
            this.y = new float[n];
        }

        public void append(float f, float f2, double d, TextPath textPath) {
            double d2 = textPath.getAscent();
            if (this.size >= 1) {
                double d3 = Point2D.distance(this.x[this.size - 1], this.y[this.size - 1], f, f2);
                if (d3 < d2 * 0.5) {
                    this.x[this.size - 1] = f;
                    this.y[this.size - 1] = f2;
                    return;
                }
                if (d3 > d) {
                    double d4 = (double)(f - this.x[this.size - 1]) / d3;
                    double d5 = (double)(f2 - this.y[this.size - 1]) / d3;
                    double d6 = (d3 - d) / 2.0;
                    float f3 = (float)((double)this.x[this.size - 1] + d4 * (d6 - 2.0));
                    float f4 = (float)((double)this.y[this.size - 1] + d5 * (d6 - 2.0));
                    this.ensureCapacity(this.size + 1, textPath.getGROW_SIZE());
                    this.indexes[0] = this.size;
                    this.numPoints[0] = 2;
                    this.x[this.size] = f3;
                    this.y[this.size++] = f4;
                }
            }
            this.ensureCapacity(this.size + 1, textPath.getGROW_SIZE());
            this.x[this.size] = f;
            this.y[this.size++] = f2;
        }

        public double getLength() {
            if (this.size == 0) {
                return 0.0;
            }
            this.len = 0.0;
            float f = this.x[0];
            float f2 = this.y[0];
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int i = 1; i < this.size; ++i) {
                f3 = this.x[i];
                f4 = this.y[i];
                this.len += Point2D.distance(f, f2, f3, f4);
                f = f3;
                f2 = f4;
            }
            return this.len;
        }

        public void ensureCapacity(int n, int n2) {
            if (this.x != null && this.x.length > n) {
                return;
            }
            float[] fArray = new float[n + n2];
            if (this.x != null) {
                System.arraycopy(this.x, 0, fArray, 0, this.size);
            }
            this.x = fArray;
            fArray = new float[n + n2];
            if (this.y != null) {
                System.arraycopy(this.y, 0, fArray, 0, this.size);
            }
            this.y = fArray;
        }

        public void setStartingIndexes(double d) {
            if (this.x == null || this.y == null) {
                this.indexes[1] = -1;
                return;
            }
            if (this.len <= 0.0) {
                this.getLength();
            }
            if (this.len < d) {
                this.indexes[1] = -1;
                return;
            }
            double d2 = (this.len - d) / 2.0;
            this.indexes[1] = this.findStartVertexForOffset(d2);
            this.numPoints[1] = this.findEndVertexForOffset(d2 + d) - this.indexes[1] + 1;
            this.numPoints[2] = this.findEndVertexForOffset(d) + 1;
        }

        private int findStartVertexForOffset(double d) {
            if (this.x == null || this.y == null) {
                return -1;
            }
            double d2 = 0.0;
            float f = this.x[0];
            float f2 = this.y[0];
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int i = 1; i < this.size; ++i) {
                f3 = this.x[i];
                f4 = this.y[i];
                if ((d2 += Point2D.distance(f, f2, f3, f4)) > d) {
                    return i - 1;
                }
                if (d2 == d) {
                    return i;
                }
                f = f3;
                f2 = f4;
            }
            return -1;
        }

        private int findEndVertexForOffset(double d) {
            double d2 = 0.0;
            float f = this.x[0];
            float f2 = this.y[0];
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int i = 1; i < this.size; ++i) {
                f3 = this.x[i];
                f4 = this.y[i];
                if ((d2 += Point2D.distance(f, f2, f3, f4)) >= d) {
                    return i;
                }
                f = f3;
                f2 = f4;
            }
            return this.size - 1;
        }
    }

    class GlyphVectorInfo {
        String txt = null;
        Rectangle2D visualBounds;
        double visualCenterY = 0.0;
        int ngi;
        double ngx;
        double ngy;
        double avgGW;

        GlyphVectorInfo() {
        }
    }
}

