/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.sdovis.util.CRC32;

class ChunkStream
extends DataOutputStream
implements DataOutput {
    private byte[] type = null;
    private ByteArrayOutputStream baos = null;

    public ChunkStream(String string) throws IOException {
        super(new ByteArrayOutputStream());
        if (string.length() != 4) {
            throw new IllegalArgumentException("Chunk type improper length");
        }
        for (int i = 0; i < 4; ++i) {
            if ((byte)string.charAt(i) >= 65 && (byte)string.charAt(i) <= 122) continue;
            throw new IllegalArgumentException("Chunk type contains non-letter");
        }
        if ((byte)string.charAt(2) < 65 || (byte)string.charAt(2) > 90) {
            throw new IllegalArgumentException("Chunk type contains illegal reserved value");
        }
        this.baos = (ByteArrayOutputStream)this.out;
        this.type = new byte[4];
        this.type[0] = (byte)string.charAt(0);
        this.type[1] = (byte)string.charAt(1);
        this.type[2] = (byte)string.charAt(2);
        this.type[3] = (byte)string.charAt(3);
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        this.flush();
        this.baos.flush();
        byte[] byArray = this.baos.toByteArray();
        int n = byArray.length;
        dataOutputStream.writeInt(n);
        dataOutputStream.write(this.type);
        dataOutputStream.write(byArray, 0, n);
        int n2 = -1;
        n2 = CRC32.updateCRC(n2, this.type, 0, 4);
        n2 = CRC32.updateCRC(n2, byArray, 0, n);
        dataOutputStream.writeInt(~n2);
    }
}

