/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.Quantizer;

public class GIFMaker {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final boolean DEBUG = false;
    private OutputStream output = null;
    private final char[] MAGIC_ID = new char[]{'G', 'I', 'F', '8', '7', 'a'};
    private final int GIF_IMG_CODE = 44;
    private final int GIF_END_CODE = 59;
    private int width = 0;
    private int height = 0;
    private int initialCodeSize = 0;
    private int clearCode = 0;
    private int endCode = 0;
    private int codeSize = 0;
    private int numCodes = 0;
    private byte[] lzwByteDict = null;
    private int[] lzwParentDict = null;
    private int[] lzwHash = null;
    private final int NO_PIXEL = -1;
    private final int HASH_FREE = 65535;
    private final int HASH_ROOT = 65535;
    private final int HASH_SIZE = 9973;
    private final int HASH_STEP = 2039;
    private final int MAX_BITS = 12;
    private final int MAX_STR = 4096;
    private byte[] bitStore = null;
    private int bitStoreOff = 0;
    private int bitOffset = 0;
    private int pixrX = 0;
    private int pixrY = 0;
    private int pixrMinX = 0;
    private int pixrMinY = 0;
    private Raster pixrSrc = null;
    private final int[] maxCode = new int[]{0, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4095};
    private final int[] bitOffsetMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127};

    public GIFMaker(OutputStream outputStream) {
        this.output = outputStream;
    }

    private RenderedImage prepare(RenderedImage renderedImage, Color color) {
        BufferedImage bufferedImage = (BufferedImage)renderedImage;
        if (bufferedImage.getType() == 1) {
            if (color == null) {
                return Quantizer.rgb24to8(renderedImage);
            }
            return Quantizer.rgb24to8(renderedImage, color);
        }
        return renderedImage;
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        this.encode(renderedImage, null);
    }

    public void encode(RenderedImage renderedImage, Color color) throws IOException {
        long l = System.currentTimeMillis();
        renderedImage = this.prepare(renderedImage, color);
        long l2 = System.currentTimeMillis();
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            n2 = indexColorModel.getMapSize();
            while (n2 > 1 << n) {
                ++n;
            }
            n3 = (int)Math.pow(2.0, n);
            if (n3 > 256) {
                throw new RuntimeException("Palette too large for GIF encoding");
            }
            byArray = new byte[n3];
            byArray2 = new byte[n3];
            byArray3 = new byte[n3];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
        } else if (sampleModel.getNumBands() == 1) {
            n = sampleModel.getSampleSize()[0];
            n3 = n2 = (int)Math.pow(2.0, n);
            byArray = new byte[n3];
            byArray2 = new byte[n3];
            byArray3 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray[i] = (byte)i;
                byArray2[i] = (byte)i;
                byArray3[i] = (byte)i;
            }
        } else {
            throw new RuntimeException("Non-encodable rendered image");
        }
        this.writeHeader(n);
        this.writeColorTable(byArray, byArray2, byArray3);
        this.writeLocalHeader();
        this.initialCodeSize = n < 2 ? 2 : n;
        this.encodeRaster(renderedImage);
        this.output.write(59);
        long l3 = System.currentTimeMillis();
        log.finest("Time spent on quantitizing map image:" + (l2 - l) + "ms");
        log.finest("Time spent on generating GIF image:" + (l3 - l2) + "ms");
    }

    private void writeHeader(int n) throws IOException {
        int n2;
        for (n2 = 0; n2 < this.MAGIC_ID.length; ++n2) {
            this.output.write((byte)this.MAGIC_ID[n2]);
        }
        this.writeUB2(this.width);
        this.writeUB2(this.height);
        n2 = 0x80 | n - 1 << 4 | n - 1;
        this.output.write(n2);
        this.output.write(0);
        this.output.write(0);
    }

    private void writeColorTable(byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            this.output.write(byArray[i]);
            this.output.write(byArray2[i]);
            this.output.write(byArray3[i]);
        }
    }

    private void writeLocalHeader() throws IOException {
        this.output.write(44);
        this.writeUB2(0);
        this.writeUB2(0);
        this.writeUB2(this.width);
        this.writeUB2(this.height);
        int n = 0;
        this.output.write(n);
    }

    private void encodeRaster(RenderedImage renderedImage) throws IOException {
        this.initLZWEncoder();
        this.output.write(this.initialCodeSize);
        this.initBitStreamer();
        this.initPixelReader(renderedImage);
        this.writeCode(this.clearCode);
        int n = 65535;
        int n2 = 0;
        while ((n2 = this.getNextPixelVal()) != -1) {
            int n3 = this.searchDictionary((byte)n2, n);
            if (n3 != 65535) {
                n = n3;
                continue;
            }
            this.writeCode(n);
            if (this.addCode((byte)n2, n) == this.maxCode[this.codeSize]) {
                if (this.codeSize == 12) {
                    this.writeCode(this.clearCode);
                    this.initLZWDictionary();
                } else {
                    ++this.codeSize;
                }
            }
            n = n2;
        }
        if (n != 65535) {
            this.writeCode(n);
        }
        this.writeCode(this.endCode);
        this.flushBitStreamer();
    }

    private void initLZWEncoder() {
        this.clearCode = 1 << this.initialCodeSize;
        this.endCode = this.clearCode + 1;
        this.lzwByteDict = new byte[4096];
        this.lzwParentDict = new int[4096];
        this.lzwHash = new int[9973];
        this.initLZWDictionary();
    }

    private void initLZWDictionary() {
        int n;
        this.numCodes = 0;
        this.codeSize = this.initialCodeSize + 1;
        for (n = 0; n < this.lzwHash.length; ++n) {
            this.lzwHash[n] = 65535;
        }
        for (n = 0; n <= this.endCode; ++n) {
            this.addCode((byte)n, 65535);
        }
    }

    private void initBitStreamer() {
        this.bitStore = new byte[257];
        this.bitStoreOff = 0;
        this.bitOffset = 0;
    }

    private void initPixelReader(RenderedImage renderedImage) {
        this.pixrMinX = renderedImage.getMinX();
        this.pixrMinY = renderedImage.getMinY();
        this.pixrX = this.pixrMinX + this.width;
        this.pixrY = this.pixrMinY - 1;
        this.pixrSrc = renderedImage instanceof BufferedImage ? ((BufferedImage)renderedImage).getRaster() : renderedImage.getData(new Rectangle(this.pixrMinX, this.pixrMinY, this.width, this.height));
    }

    private int getNextPixelVal() {
        if (++this.pixrX >= this.pixrMinX + this.width) {
            this.pixrX = this.pixrMinX;
            ++this.pixrY;
            if (this.pixrY >= this.pixrMinY + this.height) {
                return -1;
            }
        }
        return this.pixrSrc.getSample(this.pixrX, this.pixrY, 0);
    }

    private void writeCode(int n) throws IOException {
        int n2 = n << this.bitOffset | this.bitStore[this.bitStoreOff] & this.bitOffsetMask[this.bitOffset];
        int n3 = this.codeSize + this.bitOffset;
        this.bitOffset = n3 % 8;
        while (n3 > 0) {
            this.bitStore[this.bitStoreOff] = (byte)(0xFF & n2);
            n2 >>= 8;
            if ((n3 -= 8) < 0) continue;
            ++this.bitStoreOff;
        }
        if (this.bitStoreOff > 254) {
            this.output.write(255);
            this.output.write(this.bitStore, 0, 255);
            this.bitStoreOff -= 255;
            n3 = this.bitStoreOff * 8 + this.bitOffset;
            if (n3 > 0) {
                this.bitStore[0] = this.bitStore[255];
            }
            if (n3 > 8) {
                this.bitStore[1] = this.bitStore[256];
            }
        }
    }

    private void flushBitStreamer() throws IOException {
        if (this.bitOffset != 0) {
            ++this.bitStoreOff;
        }
        if (this.bitStoreOff != 0) {
            this.output.write(this.bitStoreOff);
            this.output.write(this.bitStore, 0, this.bitStoreOff);
        }
        this.output.write(0);
    }

    private int addCode(byte by, int n) {
        if (this.numCodes >= 4096) {
            return 65535;
        }
        int n2 = this.hash(by, n);
        while (this.lzwHash[n2] != 65535) {
            n2 = (n2 + 2039) % 9973;
        }
        this.lzwHash[n2] = this.numCodes;
        this.lzwByteDict[this.numCodes] = by;
        this.lzwParentDict[this.numCodes] = n;
        return this.numCodes++;
    }

    private int searchDictionary(byte by, int n) {
        int n2 = this.hash(by, n);
        int n3 = 0;
        while ((n3 = this.lzwHash[n2]) != 65535) {
            if (this.lzwParentDict[n3] == n && this.lzwByteDict[n3] == by) {
                return n3;
            }
            n2 = (n2 + 2039) % 9973;
        }
        return 65535;
    }

    private int hash(byte by, int n) {
        return ((by << 8 ^ n) & 0xFFFF) % 9973;
    }

    private void writeUB2(int n) throws IOException {
        this.output.write(n & 0xFF);
        this.output.write((n & 0xFF00) >> 8);
    }
}

