/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;

public class HttpConnection {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private HttpURLConnection mHttp = null;
    private String sURL = null;
    private URL mURL = null;

    public URL getURL() {
        return this.mURL;
    }

    public boolean connect(String string) {
        if (string == null) {
            return false;
        }
        this.sURL = string;
        try {
            this.mURL = new URL(string);
        }
        catch (Exception exception) {
            return false;
        }
        try {
            this.mHttp = (HttpURLConnection)this.mURL.openConnection();
            this.mHttp.setDoOutput(true);
            this.mHttp.setDoInput(true);
            this.mHttp.setUseCaches(false);
            this.mHttp.setRequestMethod("POST");
            this.mHttp.setRequestProperty("Content-Type", "application/xml");
        }
        catch (IOException iOException) {
            this.mHttp = null;
            return false;
        }
        return true;
    }

    public void setContentTypeProperty(String string) {
        if (string == null) {
            return;
        }
        if (this.mHttp != null) {
            this.mHttp.setRequestProperty("Content-Type", string);
        }
    }

    public void disConnect() {
        try {
            if (this.mHttp != null) {
                this.mHttp.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendXMLRequest(String string, String string2) throws Exception {
        if (this.sURL == null) {
            throw new Exception("Null url.");
        }
        this.connect(this.sURL);
        if (this.mHttp == null) {
            throw new Exception("mHttp is null.");
        }
        OutputStream outputStream = this.mHttp.getOutputStream();
        if (string != null && string.trim().length() > 0) {
            outputStream.write((string.trim() + "=").getBytes());
        }
        outputStream.write(string2.getBytes("UTF8"));
        outputStream.flush();
        outputStream.close();
        outputStream = null;
    }

    public String getXMLResponse() throws Exception {
        InputStream inputStream = this.mHttp.getInputStream();
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        return string;
    }
}

