/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;

public class I18nUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static Hashtable rbCache = new Hashtable(100);

    public static final String getTranslation(String string, String string2, String string3) {
        ResourceBundle resourceBundle = I18nUtil.getRB(string2, string3);
        return I18nUtil.getTranslation(string, resourceBundle);
    }

    public static final String getTranslation(String string, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return string;
        }
        try {
            String string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (Exception exception) {
            log.finer("Cannot find translated text for '" + string + "'.");
            return string;
        }
    }

    public static ResourceBundle getRB(String string, String string2) {
        String string3 = null;
        int n = string2.indexOf("-");
        if (n >= 0) {
            string3 = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        }
        Locale locale = string3 == null ? new Locale(string2) : new Locale(string2, string3);
        return I18nUtil.getRB(string, locale);
    }

    private static ResourceBundle getRB(String string, Locale locale) {
        String string2;
        ResourceBundle resourceBundle;
        String string3 = locale.getCountry();
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if ((resourceBundle = (ResourceBundle)rbCache.get(string2 = string + "_" + locale.getLanguage() + (string3 == null ? "" : "_" + string3))) != null) {
            return resourceBundle;
        }
        try {
            resourceBundle = ResourceBundle.getBundle(string, locale);
            if (resourceBundle != null) {
                rbCache.put(string2, resourceBundle);
            }
            return resourceBundle;
        }
        catch (MissingResourceException missingResourceException) {
            log.log(Level.WARNING, "Exception loading translated resources.", missingResourceException);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        Locale locale = new Locale("zh", "cn");
        String string = locale.getCountry();
        System.out.println("locale lang: " + locale.getLanguage());
        System.out.println("locale country: " + locale.getCountry());
        System.out.println("country is empty:" + (string.length() == 0));
    }
}

